/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.languagetool.gui.CategoryNode;
import org.languagetool.gui.RuleNode;

class TreeListener
implements KeyListener,
MouseListener {
    private static final Dimension checkBoxDimension = new JCheckBox().getPreferredSize();
    private final JTree tree;

    static void install(JTree tree) {
        TreeListener listener = new TreeListener(tree);
        tree.addMouseListener(listener);
        tree.addKeyListener(listener);
    }

    private TreeListener(JTree tree) {
        this.tree = tree;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        TreePath[] paths;
        if (e.getKeyCode() == 32 && (paths = this.tree.getSelectionPaths()) != null) {
            for (TreePath path : paths) {
                this.handle(path);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
        if (path != null && path.getPathCount() > 0 && this.isValidNode(path.getLastPathComponent()) && this.isOverCheckBox(e.getX(), e.getY(), path)) {
            this.handle(path);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void handle(TreePath path) {
        if (path != null && path.getPathCount() > 0) {
            DefaultMutableTreeNode node;
            DefaultTreeModel model;
            if (path.getLastPathComponent() instanceof CategoryNode) {
                model = (DefaultTreeModel)this.tree.getModel();
                ((CategoryNode)node).setEnabled(!((CategoryNode)(node = (CategoryNode)path.getLastPathComponent())).isEnabled());
                model.nodeChanged(node);
                for (int i = 0; i < node.getChildCount(); ++i) {
                    RuleNode child = (RuleNode)node.getChildAt(i);
                    if (child.isEnabled() == ((CategoryNode)node).isEnabled()) continue;
                    child.setEnabled(((CategoryNode)node).isEnabled());
                    model.nodeChanged(child);
                }
            }
            if (path.getLastPathComponent() instanceof RuleNode) {
                model = (DefaultTreeModel)this.tree.getModel();
                ((RuleNode)node).setEnabled(!((RuleNode)(node = (RuleNode)path.getLastPathComponent())).isEnabled());
                model.nodeChanged(node);
                if (((RuleNode)node).isEnabled()) {
                    CategoryNode parent = (CategoryNode)node.getParent();
                    parent.setEnabled(true);
                }
                model.nodeChanged(node.getParent());
            }
        }
    }

    private boolean isOverCheckBox(int x, int y, TreePath path) {
        int offset = this.tree.getPathBounds((TreePath)path).x + TreeListener.checkBoxDimension.width;
        return x <= offset;
    }

    private boolean isValidNode(Object c) {
        return c instanceof CategoryNode || c instanceof RuleNode;
    }
}

