/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.IOException;
import opennlp.tools.cmdline.parser.ModelUpdaterTool;
import opennlp.tools.cmdline.parser.ParserTrainerTool;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.maxent.GIS;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.chunking.ParserEventStream;
import opennlp.tools.util.ObjectStream;

public final class BuildModelUpdaterTool
extends ModelUpdaterTool {
    @Override
    public String getShortDescription() {
        return "trains and updates the build model in a parser model";
    }

    @Override
    protected ParserModel trainAndUpdate(ParserModel originalModel, ObjectStream<Parse> parseSamples, ModelUpdaterTool.ModelUpdaterParams parameters) throws IOException {
        Dictionary mdict = ParserTrainerTool.buildDictionary(parseSamples, originalModel.getHeadRules(), 5);
        parseSamples.reset();
        System.out.println("Training builder");
        ParserEventStream bes = new ParserEventStream(parseSamples, originalModel.getHeadRules(), ParserEventTypeEnum.BUILD, mdict);
        GIS trainer = new GIS();
        MaxentModel buildModel = trainer.train(bes);
        parseSamples.close();
        return originalModel.updateBuildModel(buildModel);
    }
}

