package Lire::ChartTypes::Pie;

use strict;

use base qw/Lire::ChartType/;

use Locale::TextDomain 'lire';

=pod

=head1 NAME

Lire::ChartTypes::Pie - Wrapper for the Ploticus pie prefab.

=head1 SYNOPSIS

  my $type = $chart_cfg->get( 'type' )->as_value();
  $type->write_chart( $chart_cfg, $subreport );

=head1 DESCRIPTION

This Lire::ChartType wraps the Ploticus pie prefab.

=cut

sub name {
    return 'pie';
}

sub title {
    return 'Pie chart';
}

sub description {
    return '<para>' . __( 'Pie chart' ) . '</para>';
}

sub prefab {
    return '-prefab pie'
}

sub get_vars {
    my ( $self, $chart_cfg ) = @_;

    return [ $chart_cfg->get( 'type' )->get_properties()->get( 'values' )->as_value() ];
}

sub write_parameters {
    my ( $self, $chart_cfg, $fh ) = @_;

    $self->SUPER::write_parameters( $chart_cfg, $fh );

    print $fh <<EOF;
#set labels = 1
#set values = 2
EOF
    return;
}

# keep perl happy
1;

__END__

=pod

=head1 SEE ALSO

 Lire::PluginManager(3pm) Lire::ChartType(3pm), ploticus(1)

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=head1 VERSION

$Id: Pie.pm,v 1.2 2006/07/23 13:16:30 vanbaal Exp $

=head1 COPYRIGHT

Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut

