var createWrapper = require('./createWrapper');

/** Used to compose bitmasks for wrapper metadata. */
var BIND_FLAG = 1;

/**
 * The base implementation of `_.bindAll` without support for individual
 * method name arguments.
 *
 * @private
 * @param {Object} object The object to bind and assign the bound methods to.
 * @param {string[]} methodNames The object method names to bind.
 * @returns {Object} Returns `object`.
 */
function baseBindAll(object, methodNames) {
  var index = -1,
      length = methodNames.length;

  while (++index < length) {
    var key = methodNames[index];
    object[key] = createWrapper(object[key], BIND_FLAG, object);
  }
  return object;
}

module.exports = baseBindAll;
