/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Modify/Bevel/Tests/BevelTest05.js
// Timestamp   : 2011-07-27 16:08:33
// Description : 

include('scripts/Pro/Developer/TestingDashboard/TdbTest.js');

function BevelTest05() {
    TdbTest.call(this, 'scripts/Modify/Bevel/Tests/BevelTest05.js');
}

BevelTest05.prototype = new TdbTest();

BevelTest05.prototype.test00 = function() {
    qDebug('running BevelTest05.test00()...');
    this.setUp();
    this.importFile('scripts/Modify/Bevel/Tests/data/1line_1arc.dxf');
    TdbTest.clickOnWidget('MainWindow::CadToolBar::MainToolsPanel::ModifyToolsPanelButton');
    TdbTest.clickOnWidget('MainWindow::CadToolBar::ModifyToolsPanel::BevelButton');
    this.setToolOption('Bevel/Trim', 'true');
    this.setToolOption('Bevel/Length1',  [ 10, 0 ] );
    this.setToolOption('Bevel/Length2',  [ 16, 0 ] );
    this.updateToolOptions();
    this.setZoom(20.146341463414636, new RVector(-0.909806, -10.2536, 0) );
    var p = new RVector(14.609564, 12.785109);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(20.146341463414636, new RVector(-0.909806, -10.2536, 0) );
    var p = new RVector(8.007869, 17.401332);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.verifyDrawing('BevelTest05_000.dxf');
    this.tearDown();
    qDebug('finished BevelTest05.test00()');
};

