/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.generator.java.bcel;

import com.baselet.generator.java.Field;
import com.baselet.generator.java.JavaClass;
import com.baselet.generator.java.Method;
import com.baselet.generator.java.bcel.BcelField;
import com.baselet.generator.java.bcel.BcelMethod;
import java.io.IOException;
import org.apache.bcel.classfile.ClassParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcelJavaClass
implements JavaClass {
    private static final Logger log = LoggerFactory.getLogger(BcelJavaClass.class);
    private final org.apache.bcel.classfile.JavaClass clazz;
    private String className;

    public BcelJavaClass(String filename) throws IOException {
        ClassParser parser = new ClassParser(filename);
        this.clazz = parser.parse();
    }

    @Override
    public String getName() {
        String nameWithPackage = this.clazz.getClassName();
        this.className = nameWithPackage.substring(nameWithPackage.lastIndexOf(".") + 1, nameWithPackage.length());
        return this.className;
    }

    @Override
    public Field[] getFields() {
        org.apache.bcel.classfile.Field[] fields = this.clazz.getFields();
        Field[] newFields = new BcelField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            newFields[i] = new BcelField(fields[i]);
        }
        return newFields;
    }

    @Override
    public Method[] getMethods() {
        org.apache.bcel.classfile.Method[] methods = this.clazz.getMethods();
        Method[] newMethods = new BcelMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            newMethods[i] = new BcelMethod(methods[i], this.className);
        }
        return newMethods;
    }

    @Override
    public JavaClass.ClassRole getRole() {
        if (this.clazz.isInterface()) {
            return JavaClass.ClassRole.INTERFACE;
        }
        if (this.clazz.isAbstract()) {
            return JavaClass.ClassRole.ABSTRACT;
        }
        return JavaClass.ClassRole.CLASS;
    }

    @Override
    public String getPackage() {
        return this.clazz.getPackageName();
    }
}

