/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fr_CA extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "heure d\u2019Afrique centrale",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "heure normale de Moscou",
               "MSK",
               "heure avanc\u00e9e de Moscou",
               "MSD",
               "heure de Moscou",
               "MT",
            };
        final String[] Japan = new String[] {
               "heure normale du Japon",
               "JST",
               "heure avanc\u00e9e du Japon",
               "JDT",
               "heure du Japon",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "heure normale du Pakistan",
               "PKT",
               "heure avanc\u00e9e du Pakistan",
               "PKST",
               "heure du Pakistan",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "heure normale de Taipei",
               "CST",
               "heure avanc\u00e9e de Taipei",
               "CDT",
               "heure de Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "heure normale de Hovd",
               "HOVT",
               "heure avanc\u00e9e de Hovd",
               "HOVST",
               "heure de Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "heure normale de Magadan",
               "MAGT",
               "heure avanc\u00e9e de Magadan",
               "MAGST",
               "heure de Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "heure normale du centre-ouest de l\u2019Australie",
               "ACWST",
               "heure avanc\u00e9e du centre-ouest de l\u2019Australie",
               "ACWDT",
               "heure du centre-ouest de l\u2019Australie",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "heure normale d\u2019Europe centrale",
               "CET",
               "heure avanc\u00e9e d\u2019Europe centrale",
               "CEST",
               "heure d\u2019Europe centrale",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "heure normale de Sakhaline",
               "SAKT",
               "heure avanc\u00e9e de Sakhaline",
               "SAKST",
               "heure de Sakhaline",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "heure normale du Paraguay",
               "PYT",
               "heure avanc\u00e9e du Paraguay",
               "PYST",
               "heure du Paraguay",
               "PYT",
            };
        final String[] Acre = new String[] {
               "heure normale de l\u2019Acre",
               "ACT",
               "heure avanc\u00e9e de l\u2019Acre",
               "ACST",
               "heure de l\u2019Acre",
               "ACT",
            };
        final String[] America_Eastern = new String[] {
               "heure normale de l\u2019Est",
               "HNE",
               "heure avanc\u00e9e de l\u2019Est",
               "HAE",
               "heure de l\u2019Est",
               "HE",
            };
        final String[] Lord_Howe = new String[] {
               "heure normale de Lord Howe",
               "LHST",
               "heure avanc\u00e9e de Lord Howe",
               "LHDT",
               "heure de Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "heure normale de la Nouvelle-Z\u00e9lande",
               "NZST",
               "heure avanc\u00e9e de la Nouvelle-Z\u00e9lande",
               "NZDT",
               "heure de la Nouvelle-Z\u00e9lande",
               "NZT",
            };
        final String[] Yakutsk = new String[] {
               "heure normale de Iakoutsk",
               "YAKT",
               "heure avanc\u00e9e de Iakoutsk",
               "YAKST",
               "heure de Iakoutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "heure normale de Maurice",
               "MUT",
               "heure avanc\u00e9e de Maurice",
               "MUST",
               "heure de Maurice",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Heure d\u2019Afrique orientale",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] Europe_Eastern = new String[] {
               "heure normale d\u2019Europe de l\u2019Est",
               "EET",
               "heure avanc\u00e9e d\u2019Europe de l\u2019Est",
               "EEST",
               "heure d\u2019Europe de l\u2019Est",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "heure normale de Terre-Neuve",
               "HNT",
               "heure avanc\u00e9e de Terre-Neuve",
               "HAT",
               "heure de Terre-Neuve",
               "HT",
            };
        final String[] Hong_Kong = new String[] {
               "heure normale de Hong Kong",
               "HKT",
               "heure avanc\u00e9e de Hong Kong",
               "HKST",
               "heure de Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "heure normale de l\u2019Ouest argentin",
               "ART",
               "heure avanc\u00e9e de l\u2019Ouest argentin",
               "ARST",
               "heure de l\u2019Ouest argentin",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "heure normale de l\u2019Atlantique",
               "AST",
               "heure avanc\u00e9e de l\u2019Atlantique",
               "ADT",
               "heure de l\u2019Atlantique",
               "AT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "heure normale de Saint-Pierre-et-Miquelon",
               "PMST",
               "heure avanc\u00e9e de Saint-Pierre-et-Miquelon",
               "PMDT",
               "heure de Saint-Pierre-et-Miquelon",
               "PMT",
            };
        final String[] Yekaterinburg = new String[] {
               "heure normale d\u2019Ekaterinbourg",
               "YEKT",
               "heure avanc\u00e9e d\u2019Ekaterinbourg",
               "YEKST",
               "heure d\u2019Ekaterinbourg",
               "YEKT",
            };
        final String[] Israel = new String[] {
               "heure normale d\u2019Isra\u00ebl",
               "IST",
               "heure avanc\u00e9e d\u2019Isra\u00ebl",
               "IDT",
               "heure d\u2019Isra\u00ebl",
               "IT",
            };
        final String[] Africa_Southern = new String[] {
               "heure normale d\u2019Afrique du Sud",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Uzbekistan = new String[] {
               "heure normale de l\u2019Ouzb\u00e9kistan",
               "UZT",
               "heure avanc\u00e9e de l\u2019Ouzb\u00e9kistan",
               "UZST",
               "heure de l\u2019Ouzb\u00e9kistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "heure normale de Omsk",
               "OMST",
               "heure avanc\u00e9e de Omsk",
               "OMSST",
               "heure de Omsk",
               "OMST",
            };
        final String[] Uruguay = new String[] {
               "heure normale de l\u2019Uruguay",
               "UYT",
               "heure avanc\u00e9e de l\u2019Uruguay",
               "UYST",
               "heure de l\u2019Uruguay",
               "UYT",
            };
        final String[] Mongolia = new String[] {
               "heure normale d\u2019Oulan-Bator",
               "ULAT",
               "heure avanc\u00e9e d\u2019Oulan-Bator",
               "ULAST",
               "heure d\u2019Oulan-Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "heure normale du Centre",
               "HNC",
               "heure avanc\u00e9e du Centre",
               "HAC",
               "heure du Centre",
               "HC",
            };
        final String[] Falkland = new String[] {
               "heure normale des \u00eeles Malouines",
               "FKT",
               "heure avanc\u00e9e des \u00eeles Malouines",
               "FKST",
               "heure des \u00eeles Malouines",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "heure normale du Vanuatu",
               "VUT",
               "heure avanc\u00e9e de Vanuatu",
               "VUST",
               "heure du Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "heure normale de Novossibirsk",
               "NOVT",
               "heure avanc\u00e9e de Novossibirsk",
               "NOVST",
               "heure de Novossibirsk",
               "NOVT",
            };
        final String[] Azores = new String[] {
               "heure normale des A\u00e7ores",
               "AZOT",
               "heure avanc\u00e9e des A\u00e7ores",
               "AZOST",
               "heure des A\u00e7ores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "heure normale d\u2019Apia",
               "WSST",
               "heure avanc\u00e9e d\u2019Apia",
               "WSDT",
               "heure d\u2019Apia",
               "WST",
            };
        final String[] Krasnoyarsk = new String[] {
               "heure normale de Krasno\u00efarsk",
               "KRAT",
               "heure avanc\u00e9e de Krasno\u00efarsk",
               "KRAST",
               "heure de Krasno\u00efarsk",
               "KRAT",
            };
        final String[] Amazon = new String[] {
               "heure normale de l\u2019Amazonie",
               "AMT",
               "heure avanc\u00e9e de l\u2019Amazonie",
               "AMST",
               "heure de l\u2019Amazonie",
               "AMT",
            };
        final String[] Fiji = new String[] {
               "heure normale des \u00eeles Fidji",
               "FJT",
               "heure avanc\u00e9e des \u00eeles Fidji",
               "FJST",
               "heure des \u00eeles Fidji",
               "FJT",
            };
        final String[] Chatham = new String[] {
               "heure normale des \u00celes Chatham",
               "CHAST",
               "heure avanc\u00e9e des \u00celes Chatham",
               "CHADT",
               "heure des \u00eeles Chatham",
               "CHAT",
            };
        final String[] Argentina = new String[] {
               "heure normale d\u2019Argentine",
               "ART",
               "heure avanc\u00e9e de l\u2019Argentine",
               "ARST",
               "heure de l\u2019Argentine",
               "ART",
            };
        final String[] Kamchatka = new String[] {
               "heure normale de Petropavlovsk-Kamchatski",
               "PETT",
               "heure avanc\u00e9e de Petropavlovsk-Kamchatski",
               "PETST",
               "heure de Petropavlovsk-Kamchatski",
               "PETT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "heure normale d\u2019Hawa\u00ef-Al\u00e9outiennes",
               "HAST",
               "heure avanc\u00e9e d\u2019Hawa\u00ef-Al\u00e9outiennes",
               "HADT",
               "heure d\u2019Hawa\u00ef-Al\u00e9outiennes",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "heure normale du centre de l\u2019Australie",
               "ACST",
               "heure avanc\u00e9e du centre de l\u2019Australie",
               "ACDT",
               "heure du centre de l\u2019Australie",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "heure normale du Pacifique",
               "HNP",
               "heure avanc\u00e9e du Pacifique",
               "HAP",
               "heure du Pacifique",
               "HP",
            };
        final String[] Turkmenistan = new String[] {
               "heure normale du Turkm\u00e9nistan",
               "TMT",
               "heure avanc\u00e9e du Turkm\u00e9nistan",
               "TMST",
               "heure du Turkm\u00e9nistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "heure normale d\u2019Europe de l\u2019Ouest",
               "WET",
               "heure avanc\u00e9e d\u2019Europe de l\u2019Ouest",
               "WEST",
               "heure d\u2019Europe de l\u2019Ouest",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "heure normale du Cap-Vert",
               "CVT",
               "heure avanc\u00e9e du Cap-Vert",
               "CVST",
               "heure du Cap-Vert",
               "CVT",
            };
        final String[] Samoa = new String[] {
               "heure normale des Samoa",
               "SST",
               "heure avanc\u00e9e des Samoa",
               "SDT",
               "heure des Samoa",
               "ST",
            };
        final String[] Azerbaijan = new String[] {
               "heure normale de l\u2019Azerba\u00efdjan",
               "AZT",
               "heure avanc\u00e9e d\u2019Azerba\u00efdjan",
               "AZST",
               "heure de l\u2019Azerba\u00efdjan",
               "AZT",
            };
        final String[] Mexico_Pacific = new String[] {
               "heure normale du Pacifique mexicain",
               "MST",
               "heure avanc\u00e9e du Pacifique mexicain",
               "MDT",
               "heure du Pacifique mexicain",
               "MT",
            };
        final String[] Cuba = new String[] {
               "heure normale de Cuba",
               "CST",
               "heure avanc\u00e9e de Cuba",
               "CDT",
               "heure de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "heure normale d\u2019Afrique de l\u2019Ouest",
               "WAT",
               "heure avanc\u00e9e d\u2019Afrique de l\u2019Ouest",
               "WAST",
               "heure d\u2019Afrique de l\u2019Ouest",
               "WAT",
            };
        final String[] Philippines = new String[] {
               "heure normale des Philippines",
               "PHT",
               "heure avanc\u00e9e des Philippines",
               "PHST",
               "heure des Philippines",
               "PHT",
            };
        final String[] New_Caledonia = new String[] {
               "heure normale de la Nouvelle-Cal\u00e9donie",
               "NCT",
               "heure avanc\u00e9e de Nouvelle-Cal\u00e9donie",
               "NCST",
               "heure de la Nouvelle-Cal\u00e9donie",
               "NCT",
            };
        final String[] Iran = new String[] {
               "heure normale d\u2019Iran",
               "IRST",
               "heure avanc\u00e9e d\u2019Iran",
               "IRDT",
               "heure de l\u2019Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "heure normale de l\u2019\u00eele de P\u00e2ques",
               "EAST",
               "heure avanc\u00e9e de l\u2019\u00eele de P\u00e2ques",
               "EASST",
               "heure de l\u2019\u00eele de P\u00e2ques",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "heure normale du Nord-Ouest du Mexique",
               "PST",
               "heure avanc\u00e9e du Nord-Ouest du Mexique",
               "PDT",
               "heure du Nord-Ouest du Mexique",
               "PT",
            };
        final String[] Tonga = new String[] {
               "heure normale des Tonga",
               "TOT",
               "heure avanc\u00e9e de Tonga",
               "TOST",
               "heure des Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "heure normale du Bangladesh",
               "BDT",
               "heure avanc\u00e9e du Bangladesh",
               "BDST",
               "heure du Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "heure normale du P\u00e9rou",
               "PET",
               "heure avanc\u00e9e du P\u00e9rou",
               "PEST",
               "heure du P\u00e9rou",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "heure normale de l\u2019Ouest du Groenland",
               "WGT",
               "heure avanc\u00e9e de l\u2019Ouest du Groenland",
               "WGST",
               "heure de l\u2019Ouest du Groenland",
               "WGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "heure normale de l\u2019Est du Groenland",
               "EGT",
               "heure avanc\u00e9e de l\u2019Est du Groenland",
               "EGST",
               "heure de l\u2019Est du Groenland",
               "EGT",
            };
        final String[] Korea = new String[] {
               "heure normale de la Cor\u00e9e",
               "KST",
               "heure avanc\u00e9e de Cor\u00e9e",
               "KDT",
               "heure de la Cor\u00e9e",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "heure normale de l\u2019Ouest de l\u2019Australie",
               "AWST",
               "heure avanc\u00e9e de l\u2019Ouest de l\u2019Australie",
               "AWDT",
               "heure de l\u2019Ouest de l\u2019Australie",
               "AWT",
            };
        final String[] Australia_Eastern = new String[] {
               "heure normale de l\u2019Est de l\u2019Australie",
               "AEST",
               "heure avanc\u00e9e de l\u2019Est de l\u2019Australie",
               "AEDT",
               "heure de l\u2019Est de l\u2019Australie",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "heure de Guyane fran\u00e7aise",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "heure normale de Colombie",
               "COT",
               "heure avanc\u00e9e de Colombie",
               "COST",
               "heure de Colombie",
               "COT",
            };
        final String[] Chile = new String[] {
               "heure normale du Chili",
               "CLT",
               "heure avanc\u00e9e du Chili",
               "CLST",
               "heure du Chili",
               "CLT",
            };
        final String[] America_Mountain = new String[] {
               "heure normale des Rocheuses",
               "HNR",
               "heure avanc\u00e9e des Rocheuses",
               "HAR",
               "heure des Rocheuses",
               "HR",
            };
        final String[] Arabian = new String[] {
               "heure normale de l\u2019Arabie",
               "AST",
               "heure avanc\u00e9e de l\u2019Arabie",
               "ADT",
               "heure de l\u2019Arabie",
               "AT",
            };
        final String[] Alaska = new String[] {
               "heure normale de l\u2019Alaska",
               "AKST",
               "heure avanc\u00e9e de l\u2019Alaska",
               "AKDT",
               "heure de l\u2019Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "heure normale de Vladivostok",
               "VLAT",
               "heure avanc\u00e9e de Vladivostok",
               "VLAST",
               "heure de Vladivostok",
               "VLAT",
            };
        final String[] Irkutsk = new String[] {
               "heure normale d\u2019Irkoutsk",
               "IRKT",
               "heure avanc\u00e9e d\u2019Irkoutsk",
               "IRKST",
               "heure d\u2019Irkoutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "heure normale de la G\u00e9orgie",
               "GET",
               "heure avanc\u00e9e de G\u00e9orgie",
               "GEST",
               "heure de la G\u00e9orgie",
               "GET",
            };
        final String[] Noronha = new String[] {
               "heure normale de Fernando de Noronha",
               "FNT",
               "heure avanc\u00e9e de Fernando de Noronha",
               "FNST",
               "heure de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "heure normale de Choibalsan",
               "CHOT",
               "heure avanc\u00e9e de Choibalsan",
               "CHOST",
               "heure de Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "heure normale de Brasilia",
               "BRT",
               "heure avanc\u00e9e de Brasilia",
               "BRST",
               "heure de Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "heure normale de Chine",
               "CST",
               "heure avanc\u00e9e de Chine",
               "CDT",
               "heure de Chine",
               "CT",
            };
        final String[] Armenia = new String[] {
               "heure normale de l\u2019Arm\u00e9nie",
               "AMT",
               "heure avanc\u00e9e d\u2019Arm\u00e9nie",
               "AMST",
               "heure de l\u2019Arm\u00e9nie",
               "AMT",
            };
        final String[] Cook = new String[] {
               "heure normale des \u00eeles Cook",
               "CKT",
               "heure avanc\u00e9e des \u00eeles Cook",
               "CKHST",
               "heure des \u00eeles Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/El_Salvador", America_Central },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "heure avanc\u00e9e britannique",
                    "BST",
                    "British Time",
                    "BT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Africa/Kigali", Africa_Central },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Indian/Comoro", Africa_Eastern },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/Curacao", Atlantic },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Kralendijk", Atlantic },
            { "America/Antigua", Atlantic },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "America/Mazatlan", Mexico_Pacific },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "heure avanc\u00e9e irlandaise",
                    "IST",
                    "Irish Time",
                    "IT",
                }
            },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Europe/Andorra", Europe_Central },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Europe/Bratislava", Europe_Central },
            { "America/Argentina/Tucuman", Argentina },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Ust-Nera", Vladivostok },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
