/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.colt.function.LongObjectProcedure;
import cern.colt.function.LongProcedure;
import cern.colt.list.LongArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractLongObjectMap
extends AbstractMap {
    protected AbstractLongObjectMap() {
    }

    public boolean containsKey(final long l) {
        return !this.forEachKey(new LongProcedure(){

            public boolean apply(long l2) {
                return l != l2;
            }
        });
    }

    public boolean containsValue(final Object object) {
        return !this.forEachPair(new LongObjectProcedure(){

            public boolean apply(long l, Object object2) {
                return object != object2;
            }
        });
    }

    public AbstractLongObjectMap copy() {
        return (AbstractLongObjectMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractLongObjectMap)) {
            return false;
        }
        final AbstractLongObjectMap abstractLongObjectMap = (AbstractLongObjectMap)object;
        if (abstractLongObjectMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new LongObjectProcedure(){

            public boolean apply(long l, Object object) {
                return abstractLongObjectMap.containsKey(l) && abstractLongObjectMap.get(l) == object;
            }
        }) && abstractLongObjectMap.forEachPair(new LongObjectProcedure(){

            public boolean apply(long l, Object object) {
                return AbstractLongObjectMap.this.containsKey(l) && AbstractLongObjectMap.this.get(l) == object;
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public boolean forEachPair(final LongObjectProcedure longObjectProcedure) {
        return this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                return longObjectProcedure.apply(l, AbstractLongObjectMap.this.get(l));
            }
        });
    }

    public abstract Object get(long var1);

    public long keyOf(final Object object) {
        final long[] lArray = new long[1];
        boolean bl = this.forEachPair(new LongObjectProcedure(){

            public boolean apply(long l, Object object2) {
                boolean bl;
                boolean bl2 = bl = object == object2;
                if (bl) {
                    lArray[0] = l;
                }
                return !bl;
            }
        });
        if (bl) {
            return Long.MIN_VALUE;
        }
        return lArray[0];
    }

    public LongArrayList keys() {
        LongArrayList longArrayList = new LongArrayList(this.size());
        this.keys(longArrayList);
        return longArrayList;
    }

    public void keys(final LongArrayList longArrayList) {
        longArrayList.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                longArrayList.add(l);
                return true;
            }
        });
    }

    public void keysSortedByValue(LongArrayList longArrayList) {
        this.pairsSortedByValue(longArrayList, new ObjectArrayList(this.size()));
    }

    public void pairsMatching(final LongObjectProcedure longObjectProcedure, final LongArrayList longArrayList, final ObjectArrayList objectArrayList) {
        longArrayList.clear();
        objectArrayList.clear();
        this.forEachPair(new LongObjectProcedure(){

            public boolean apply(long l, Object object) {
                if (longObjectProcedure.apply(l, object)) {
                    longArrayList.add(l);
                    objectArrayList.add(object);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(LongArrayList longArrayList, ObjectArrayList objectArrayList) {
        this.keys(longArrayList);
        longArrayList.sort();
        objectArrayList.setSize(longArrayList.size());
        int n = longArrayList.size();
        while (--n >= 0) {
            objectArrayList.setQuick(n, this.get(longArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(LongArrayList longArrayList, ObjectArrayList objectArrayList) {
        this.keys(longArrayList);
        this.values(objectArrayList);
        final long[] lArray = longArrayList.elements();
        final Object[] objectArray = objectArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                Object object = objectArray[n];
                objectArray[n] = objectArray[n2];
                objectArray[n2] = object;
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                int n3 = ((Comparable)objectArray[n]).compareTo((Comparable)objectArray[n2]);
                return n3 < 0 ? -1 : (n3 > 0 ? 1 : (lArray[n] < lArray[n2] ? -1 : (lArray[n] == lArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, longArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(long var1, Object var3);

    public abstract boolean removeKey(long var1);

    public String toString() {
        LongArrayList longArrayList = this.keys();
        longArrayList.sort();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = longArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            long l = longArrayList.get(i);
            stringBuffer.append(String.valueOf(l));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(l)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        LongArrayList longArrayList = new LongArrayList();
        this.keysSortedByValue(longArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = longArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            long l = longArrayList.get(i);
            stringBuffer.append(String.valueOf(l));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(l)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public ObjectArrayList values() {
        ObjectArrayList objectArrayList = new ObjectArrayList(this.size());
        this.values(objectArrayList);
        return objectArrayList;
    }

    public void values(final ObjectArrayList objectArrayList) {
        objectArrayList.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                objectArrayList.add(AbstractLongObjectMap.this.get(l));
                return true;
            }
        });
    }
}

