/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VolatileNullableLazyValue<T>
extends NullableLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("VolatileNullableLazyValue");
    private volatile boolean myComputed;
    @Nullable
    private volatile T myValue;

    @Override
    @Nullable
    protected abstract T compute();

    @Override
    @Nullable
    public T getValue() {
        T value = this.myValue;
        if (!this.myComputed) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            value = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value;
                this.myComputed = true;
            }
        }
        return value;
    }

    @NotNull
    public static <T> VolatileNullableLazyValue<T> createValue(final @NotNull Factory<T> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/VolatileNullableLazyValue", "createValue"));
        }
        VolatileNullableLazyValue volatileNullableLazyValue = new VolatileNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.create();
            }
        };
        if (volatileNullableLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/VolatileNullableLazyValue", "createValue"));
        }
        return volatileNullableLazyValue;
    }
}

