/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceListStubImpl
extends StubBase<PsiReferenceList>
implements PsiClassReferenceListStub {
    private final String[] myNames;
    private PsiClassType[] myTypes;

    public PsiClassReferenceListStubImpl(@NotNull JavaClassReferenceListElementType type2, StubElement parent2, @NotNull String[] names2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        if (names2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "<init>"));
        }
        super(parent2, type2);
        ObjectUtils.assertAllElementsNotNull(names2);
        this.myNames = names2;
    }

    @Override
    @NotNull
    public PsiClassType[] getReferencedTypes() {
        if (this.myTypes != null) {
            if (this.myTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedTypes"));
            }
            return this.myTypes;
        }
        if (this.myNames.length == 0) {
            this.myTypes = PsiClassType.EMPTY_ARRAY;
            if (this.myTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedTypes"));
            }
            return this.myTypes;
        }
        PsiClassType[] types = new PsiClassType[this.myNames.length];
        boolean compiled = ((JavaClassReferenceListElementType)this.getStubType()).isCompiled(this);
        if (compiled) {
            for (int i = 0; i < types.length; ++i) {
                types[i] = new PsiClassReferenceType(new ClsJavaCodeReferenceElementImpl((PsiElement)this.getPsi(), this.myNames[i]), null);
            }
        } else {
            PsiElementFactory factory2 = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            int nullCount = 0;
            PsiReferenceList psi = (PsiReferenceList)this.getPsi();
            for (int i = 0; i < types.length; ++i) {
                try {
                    PsiJavaCodeReferenceElement ref = factory2.createReferenceFromText(this.myNames[i], psi);
                    ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(1);
                    types[i] = factory2.createType(ref);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    types[i] = null;
                    ++nullCount;
                }
            }
            if (nullCount > 0) {
                PsiClassType[] newTypes = new PsiClassType[types.length - nullCount];
                int cnt = 0;
                for (PsiClassType type2 : types) {
                    if (type2 == null) continue;
                    newTypes[cnt++] = type2;
                }
                types = newTypes;
            }
        }
        this.myTypes = types;
        PsiClassType[] psiClassTypeArray = (PsiClassType[])types.clone();
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedTypes"));
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public String[] getReferencedNames() {
        String[] stringArray = (String[])this.myNames.clone();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getReferencedNames"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public PsiReferenceList.Role getRole() {
        PsiReferenceList.Role role = JavaClassReferenceListElementType.elementTypeToRole(this.getStubType());
        if (role == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl", "getRole"));
        }
        return role;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiRefListStub[").append((Object)this.getRole()).append(':');
        for (int i = 0; i < this.myNames.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.myNames[i]);
        }
        builder.append(']');
        return builder.toString();
    }
}

