/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0014\u0010\u001f\u001a\u00020\u0006*\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/utils/LibraryUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MANIFEST_PATH", "", "META_INF", "getMETA_INF", "()Ljava/lang/String;", "TITLE_KOTLIN_JAVASCRIPT_STDLIB", "checkAttributeValue", "", "library", "Ljava/io/File;", "expected", "attributeName", "Ljava/util/jar/Attributes$Name;", "getJarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "classesRoots", "", "jarName", "getManifestFromDirectory", "Ljava/util/jar/Manifest;", "getManifestFromJar", "getManifestFromJarOrDirectory", "getManifestMainAttributesFromJarOrDirectory", "Ljava/util/jar/Attributes;", "isKotlinJavascriptLibrary", "isKotlinJavascriptStdLibrary", "getPropertyOrFail", "Ljava/util/Properties;", "propName", "util"})
public final class LibraryUtils {
    private static final Logger LOG;
    private static String TITLE_KOTLIN_JAVASCRIPT_STDLIB;
    @NotNull
    private static final String META_INF = "META-INF/";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final LibraryUtils INSTANCE;

    @NotNull
    public final String getMETA_INF() {
        return META_INF;
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile getJarFile(@NotNull List<? extends VirtualFile> classesRoots, @NotNull String jarName) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull(classesRoots, "classesRoots");
            Intrinsics.checkParameterIsNotNull(jarName, "jarName");
            Iterable $receiver$iv = classesRoots;
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                if (!Intrinsics.areEqual(it.getName(), jarName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptLibrary(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Collection collection = KotlinJavascriptMetadataUtils.loadMetadata(library);
        return !collection.isEmpty();
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptStdLibrary(@NotNull File library) {
        Intrinsics.checkParameterIsNotNull(library, "library");
        Attributes.Name name = Attributes.Name.IMPLEMENTATION_TITLE;
        Intrinsics.checkExpressionValueIsNotNull(name, "Attributes.Name.IMPLEMENTATION_TITLE");
        return INSTANCE.checkAttributeValue(library, TITLE_KOTLIN_JAVASCRIPT_STDLIB, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromJar(File library) {
        if (!library.canRead()) {
            return null;
        }
        try {
            Closeable closeable = new JarFile(library);
            Throwable throwable = null;
            try {
                JarFile jarFile = (JarFile)closeable;
                Manifest manifest2 = jarFile.getManifest();
                return manifest2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Manifest getManifestFromDirectory(File library) {
        if (!library.canRead() || !library.isDirectory()) {
            return null;
        }
        File manifestFile = new File(library, MANIFEST_PATH);
        if (!manifestFile.exists()) {
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(manifestFile);
            try {
                Manifest manifest2 = new Manifest(inputStream);
                return manifest2;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException ignored) {
            LOG.warn("IOException " + ignored);
            return null;
        }
    }

    private final Manifest getManifestFromJarOrDirectory(File library) {
        return library.isDirectory() ? this.getManifestFromDirectory(library) : this.getManifestFromJar(library);
    }

    private final Attributes getManifestMainAttributesFromJarOrDirectory(File library) {
        Manifest manifest2 = this.getManifestFromJarOrDirectory(library);
        return manifest2 != null ? manifest2.getMainAttributes() : null;
    }

    private final boolean checkAttributeValue(File library, String expected, Attributes.Name attributeName) {
        Attributes attributes;
        Attributes attributes2 = attributes = this.getManifestMainAttributesFromJarOrDirectory(library);
        String value = attributes2 != null ? attributes2.getValue(attributeName) : null;
        return value != null && Intrinsics.areEqual(value, expected);
    }

    private final String getPropertyOrFail(@NotNull Properties $receiver, String propName) {
        String value = $receiver.getProperty(propName);
        if (value == null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            $receiver.list(new PrintStream(bytes));
            LOG.error("" + propName + " not found.\n " + bytes);
        }
        String string = value;
        Intrinsics.checkExpressionValueIsNotNull(string, "value");
        return string;
    }

    private LibraryUtils() {
    }

    static {
        LibraryUtils libraryUtils;
        INSTANCE = libraryUtils = new LibraryUtils();
        LOG = Logger.getInstance(LibraryUtils.class);
        META_INF = META_INF;
        MANIFEST_PATH = "" + META_INF + "MANIFEST.MF";
        String jsStdLib = "";
        InputStream manifestProperties = LibraryUtils.class.getResourceAsStream("/kotlinManifest.properties");
        if (manifestProperties != null) {
            try {
                Properties properties2 = new Properties();
                properties2.load(manifestProperties);
                jsStdLib = libraryUtils.getPropertyOrFail(properties2, "manifest.impl.title.kotlin.javascript.stdlib");
            }
            catch (IOException e) {
                LOG.error(e);
            }
        } else {
            LOG.error("Resource 'kotlinManifest.properties' not found.");
        }
        TITLE_KOTLIN_JAVASCRIPT_STDLIB = jsStdLib;
    }
}

