/*
 Leaflet 0.8-dev, a JS library for interactive maps. http://leafletjs.com
 (c) 2010-2015 Vladimir Agafonkin, (c) 2010-2011 CloudMade
*/
!function(t,e,i){function n(){var e=t.L;s.noConflict=function(){return t.L=e,this},t.L=s}var s={version:"0.8-dev"};"object"==typeof module&&"object"==typeof module.exports?module.exports=s:"function"==typeof define&&define.amd&&define(s),"undefined"!=typeof t&&n(),s.Log={log:function(t,e,i,n){n||(n=Date.now()),this._logs||(this._logs=[]),t=t.replace(/(\r\n|\n|\r)/gm," "),this._logs.push({msg:t,direction:e,coords:i,time:n})},_getEntries:function(){this._logs.sort(function(t,e){return t.time<e.time?-1:t.time>e.time?1:0});for(var t="",e=0;e<this._logs.length;e++)t+=this._logs[e].time+"."+this._logs[e].direction+"."+this._logs[e].msg+"."+this._logs[e].coords,t+="\n";return t},print:function(){},save:function(){var i=new Blob([this._getEntries()],{type:"text/csv"}),n=e.createEvent("MouseEvents"),s=e.createElement("a");s.download=Date.now()+".csv",s.href=t.URL.createObjectURL(i),s.dataset.downloadurl=["text/csv",s.download,s.href].join(":"),n.initMouseEvent("click",!0,!1,t,0,0,0,0,0,!1,!1,!1,!1,0,null),s.dispatchEvent(n)},clear:function(){this._logs=[]}},s.INCOMING="INCOMING",s.OUTGOING="OUTGOING",s.Util={extend:function(t){var e,i,n,s;for(i=1,n=arguments.length;n>i;i++){s=arguments[i];for(e in s)t[e]=s[e]}return t},create:Object.create||function(){function t(){}return function(e){return t.prototype=e,new t}}(),bind:function(t,e){var i=Array.prototype.slice;if(t.bind)return t.bind.apply(t,i.call(arguments,1));var n=i.call(arguments,2);return function(){return t.apply(e,n.length?n.concat(i.call(arguments)):arguments)}},stamp:function(t){return t._leaflet_id=t._leaflet_id||++s.Util.lastId,t._leaflet_id},lastId:0,throttle:function(t,e,i){var n,s,o,a;return a=function(){n=!1,s&&(o.apply(i,s),s=!1)},o=function(){n?s=arguments:(t.apply(i,arguments),setTimeout(a,e),n=!0)}},wrapNum:function(t,e,i){var n=e[1],s=e[0],o=n-s;return t===n&&i?t:((t-s)%o+o)%o+s},falseFn:function(){return!1},formatNum:function(t,e){var i=Math.pow(10,e||5);return Math.round(t*i)/i},trim:function(t){return t.trim?t.trim():t.replace(/^\s+|\s+$/g,"")},splitWords:function(t){return s.Util.trim(t).split(/\s+/)},setOptions:function(t,e){t.hasOwnProperty("options")||(t.options=t.options?s.Util.create(t.options):{});for(var i in e)t.options[i]=e[i];return t.options},getParamString:function(t,e,i){var n=[];for(var s in t)n.push(encodeURIComponent(i?s.toUpperCase():s)+"="+encodeURIComponent(t[s]));return(e&&-1!==e.indexOf("?")?"&":"?")+n.join("&")},round:function(t,e){if(!e)return Math.round(t);var i=1/e;return Math.round(t*i)*e},template:function(t,e){return t.replace(s.Util.templateRe,function(t,n){var s=e[n];if(s===i)throw new Error("No value provided for variable "+t);return"function"==typeof s&&(s=s(e)),s})},templateRe:/\{ *([\w_]+) *\}/g,isArray:Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)},emptyImageUrl:"data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs="},function(){function e(e){return t["webkit"+e]||t["moz"+e]||t["ms"+e]}function i(e){var i=+new Date,s=Math.max(0,16-(i-n));return n=i+s,t.setTimeout(e,s)}var n=0,o=t.requestAnimationFrame||e("RequestAnimationFrame")||i,a=t.cancelAnimationFrame||e("CancelAnimationFrame")||e("CancelRequestAnimationFrame")||function(e){t.clearTimeout(e)};s.Util.requestAnimFrame=function(e,n,a){return a&&o===i?void e.call(n):o.call(t,s.bind(e,n))},s.Util.cancelAnimFrame=function(e){e&&a.call(t,e)}}(),s.extend=s.Util.extend,s.bind=s.Util.bind,s.stamp=s.Util.stamp,s.setOptions=s.Util.setOptions,s.round=s.Util.round,s.LOUtil={darkColors:[[198,146,0],[6,70,162],[87,157,28],[105,43,157],[197,0,11],[0,128,128],[140,132,0],[53,85,107],[209,118,0]],startSpinner:function(t,e){var i;t.width=50,t.height=50;var n=t.getContext("2d");n.lineWidth=8,n.strokeStyle="grey";var s=t.width/2,o=t.height/2,a=o-n.lineWidth/2;return i=setInterval(function(){n.clearRect(0,0,2*s,2*o),n.translate(s,o),n.rotate(e*Math.PI/180),n.translate(-s,-o),n.beginPath(),n.arc(s,o,a,0,1.3*Math.PI),n.stroke()},1)},getViewIdColor:function(t){var e=this.darkColors[(t+1)%this.darkColors.length];return e[2]|e[1]<<8|e[0]<<16},rgbToHex:function(t){return"#"+("000000"+t.toString(16)).slice(-6)}},s.Class=function(){},s.Class.extend=function(t){var e=function(){this.initialize&&this.initialize.apply(this,arguments),this.callInitHooks()},i=e.__super__=this.prototype,n=s.Util.create(i);n.constructor=e,e.prototype=n;for(var o in this)this.hasOwnProperty(o)&&"prototype"!==o&&(e[o]=this[o]);return t.statics&&(s.extend(e,t.statics),delete t.statics),t.includes&&(s.Util.extend.apply(null,[n].concat(t.includes)),delete t.includes),n.options&&(t.options=s.Util.extend(s.Util.create(n.options),t.options)),s.extend(n,t),n._initHooks=[],n.callInitHooks=function(){if(!this._initHooksCalled){i.callInitHooks&&i.callInitHooks.call(this),this._initHooksCalled=!0;for(var t=0,e=n._initHooks.length;e>t;t++)n._initHooks[t].call(this)}},e},s.Class.include=function(t){s.extend(this.prototype,t)},s.Class.mergeOptions=function(t){s.extend(this.prototype.options,t)},s.Class.addInitHook=function(t){var e=Array.prototype.slice.call(arguments,1),i="function"==typeof t?t:function(){this[t].apply(this,e)};this.prototype._initHooks=this.prototype._initHooks||[],this.prototype._initHooks.push(i)},s.Evented=s.Class.extend({on:function(t,e,i){if("object"==typeof t)for(var n in t)this._on(n,t[n],e);else{t=s.Util.splitWords(t);for(var o=0,a=t.length;a>o;o++)this._on(t[o],e,i)}return this},off:function(t,e,i){if(t)if("object"==typeof t)for(var n in t)this._off(n,t[n],e);else{t=s.Util.splitWords(t);for(var o=0,a=t.length;a>o;o++)this._off(t[o],e,i)}else delete this._events;return this},_on:function(t,e,i){var n=this._events=this._events||{},o=i&&i!==this&&s.stamp(i);if(o){var a=t+"_idx",r=t+"_len",l=n[a]=n[a]||{},h=s.stamp(e)+"_"+o;l[h]||(l[h]={fn:e,ctx:i},n[r]=(n[r]||0)+1)}else n[t]=n[t]||[],n[t].push({fn:e})},_off:function(t,e,i){var n=this._events,o=t+"_idx",a=t+"_len";if(n){if(!e)return delete n[t],delete n[o],void delete n[a];var r,l,h,d,u,c=i&&i!==this&&s.stamp(i);if(c)u=s.stamp(e)+"_"+c,r=n[o],r&&r[u]&&(d=r[u],delete r[u],n[a]--);else if(r=n[t])for(l=0,h=r.length;h>l;l++)if(r[l].fn===e){d=r[l],r.splice(l,1);break}d&&(d.fn=s.Util.falseFn)}},fire:function(t,e,i){if(!this.listens(t,i))return this;var n=s.Util.extend({},e,{type:t,target:this}),o=this._events;if(o){var a,r,l,h,d=o[t+"_idx"];if(o[t])for(l=o[t].slice(),a=0,r=l.length;r>a;a++)l[a].fn.call(this,n);for(h in d)d[h].fn.call(d[h].ctx,n)}return i&&this._propagateEvent(n),this},listens:function(t,e){var i=this._events;if(i&&(i[t]||i[t+"_len"]))return!0;if(e)for(var n in this._eventParents)if(this._eventParents[n].listens(t,e))return!0;return!1},once:function(t,e,i){if("object"==typeof t){for(var n in t)this.once(n,t[n],e);return this}var o=s.bind(function(){this.off(t,e,i).off(t,o,i)},this);return this.on(t,e,i).on(t,o,i)},addEventParent:function(t){return this._eventParents=this._eventParents||{},this._eventParents[s.stamp(t)]=t,this},removeEventParent:function(t){return this._eventParents&&delete this._eventParents[s.stamp(t)],this},_propagateEvent:function(t){for(var e in this._eventParents)this._eventParents[e].fire(t.type,s.extend({layer:t.target},t),!0)}});var o=s.Evented.prototype;o.addEventListener=o.on,o.removeEventListener=o.clearAllEventListeners=o.off,o.addOneTimeEventListener=o.once,o.fireEvent=o.fire,o.hasEventListeners=o.listens,s.Mixin={Events:o},s.Socket=s.Class.extend({ProtocolVersionNumber:"0.1",initialize:function(t){this._map=t;try{t.options.permission&&(t.options.docParams.permission=t.options.permission),this.socket=new WebSocket(t.options.server+"/lool/"+encodeURIComponent(t.options.doc+"?"+$.param(t.options.docParams))+"/ws"),this.socket.onerror=s.bind(this._onSocketError,this),this.socket.onclose=s.bind(this._onSocketClose,this),this.socket.onopen=s.bind(this._onSocketOpen,this),this.socket.onmessage=s.bind(this._onMessage,this),this.socket.binaryType="arraybuffer"}catch(e){return this._map.fire("error",{msg:_("Oops, there is a problem connecting to LibreOffice Online : "+e),cmd:"socket",kind:"failed",id:3}),null}if(t.options.docParams.access_token&&parseInt(t.options.docParams.access_token_ttl)){var i=9e5;clearTimeout(this._accessTokenExpireTimeout),this._accessTokenExpireTimeout=setTimeout(s.bind(this._sessionExpiredWarning,this),parseInt(t.options.docParams.access_token_ttl)-Date.now()-i)}this._msgQueue=[]},_sessionExpiredWarning:function(){clearTimeout(this._accessTokenExpireTimeout);var t=errorMessages.sessionexpiry;parseInt(this._map.options.docParams.access_token_ttl)-Date.now()<=0&&(t=errorMessages.sessionexpired);var e=$.timeago(parseInt(this._map.options.docParams.access_token_ttl)).replace(" ago","");this._map.fire("warn",{msg:t.replace("%time",e)}),this._accessTokenExpireTimeout=setTimeout(s.bind(this._sessionExpiredWarning,this),12e4)},close:function(){this.socket.onerror=function(){},this.socket.onclose=function(){},this.socket.onmessage=function(){},this.socket.close(),clearTimeout(this._accessTokenExpireTimeout)},connected:function(){return this.socket&&1===this.socket.readyState},sendMessage:function(t,e){if((t.startsWith("useractive")||t.startsWith("userinactive")||this._map._active)&&!this._map._fatal){var i=this.socket.readyState;(2===i||3===i)&&this.initialize(this._map),1===i?(this.socket.send(t),"string"==typeof t&&(s.Log.log(t,s.OUTGOING,e),this._map._docLayer&&this._map._docLayer._debug&&console.log(+new Date+" %cOUTGOING%c: "+t.concat(" ").replace(" ","%c "),"background:#fbb;color:black","color:red","color:black"))):this._msgQueue.push({msg:t,coords:e})}},_doSend:function(t,e){"string"==typeof t&&(s.Log.log(t,s.OUTGOING,e),this._map._docLayer&&this._map._docLayer._debug&&console.log(+new Date+" %cOUTGOING%c: "+t.concat(" ").replace(" ","%c "),"background:#fbb;color:black","color:red","color:black")),this.socket.send(t)},_onSocketOpen:function(){this._doSend("loolclient "+this.ProtocolVersionNumber);var t="load url="+encodeURIComponent(this._map.options.doc);if(this._map._docLayer&&(this._reconnecting=!0,t+=" part="+this._map.getCurrentPartNumber()),this._map.options.timestamp&&(t+=" timestamp="+this._map.options.timestamp),this._map._docPassword&&(t+=" password="+this._map._docPassword),String.locale&&(t+=" lang="+String.locale),this._map.options.renderingOptions){var e={rendering:this._map.options.renderingOptions};t+=" options="+JSON.stringify(e)}this._doSend(t),this._doSend("partpagerectangles");for(var i=0;i<this._msgQueue.length;i++)this._doSend(this._msgQueue[i].msg,this._msgQueue[i].coords);this._msgQueue=[],this._map._activate()},_utf8ToString:function(t){for(var e="",i=0;i<t.length;i++)e+=String.fromCharCode(t[i]);return e},_onMessage:function(e){var n,o,a;if("string"==typeof e.data)a=e.data;else if("object"==typeof e.data){for(n=new Uint8Array(e.data),o=0;o<n.length&&10!==n[o];)o++;a=String.fromCharCode.apply(null,n.subarray(0,o))}this._map._docLayer&&this._map._docLayer._debug&&console.log(+new Date+" %cINCOMING%c: "+a.concat(" ").replace(" ","%c "),"background:#ddf;color:black","color:blue","color:black");var r=this.parseServerCmd(a);if(a.startsWith("loolserver ")){var l=JSON.parse(a.substring(a.indexOf("{"))),h=l.Hash;parseInt(h,16).toString(16)===h.toLowerCase().replace(/^0+/,"")?(h='<a target="_blank" href="https://gerrit.libreoffice.org/gitweb?p=online.git;a=log;h='+h+'">'+h+"</a>",$("#loolwsd-version").html(l.Version+" (git hash: "+h+")")):$("#loolwsd-version").text(l.Version),l.Protocol!==this.ProtocolVersionNumber&&this._map.fire("error",{msg:_("Unsupported server version.")})}else if(a.startsWith("lokitversion ")){var d=JSON.parse(a.substring(a.indexOf("{"))),h=d.BuildId.substring(0,7);parseInt(h,16).toString(16)===h.toLowerCase().replace(/^0+/,"")&&(h='<a target="_blank" href="https://gerrit.libreoffice.org/gitweb?p=core.git;a=log;h='+h+'">'+h+"</a>"),$("#lokit-version").html(d.ProductName+" "+d.ProductVersion+d.ProductExtension.replace(".10.","-")+" (git hash: "+h+")")}else{if(a.startsWith("perm:")){var u=a.substring("perm:".length);return this._map.options.permission="readonly",void this._map.setPermission(u)}if(a.startsWith("wopi: ")){var c=JSON.parse(a.substring(a.indexOf("{")));return void this._map.fire("wopiprops",c)}if(a.startsWith("close: ")){if(a=a.substring("close: ".length),b="","ownertermination"===a)b=_("Session terminated by document owner");else if("shuttingdown"===a)b=_("Server is shutting down for maintenance (auto-saving)");else if("recycling"===a){b=_("Server is recycling and will be available shortly"),this._map._active=!1;var p=5e3,m=1e4,g=Math.floor(Math.random()*(m-p)+p);socket=this,map=this._map,vex.timer=setInterval(function(){if(socket.connected()){if(clearTimeout(vex.timer),vex.dialogID>0){var t=vex.dialogID;vex.dialogID=-1,vex.close(t)}}else try{socket.initialize(map)}catch(e){}},g)}if(vex.dialogID>0){var f=vex.dialogID;vex.dialogID=-1,vex.close(f)}var v=$.extend({},vex.defaultOptions,{contentCSS:{background:"rgba(0, 0, 0, 0)","font-size":"xx-large",color:"#fff","text-align":"center"},content:b});return v.id=vex.globalID,vex.dialogID=v.id,vex.globalID+=1,v.$vex=$("<div>").addClass(vex.baseClassNames.vex).addClass(v.className).css(v.css).data({vex:v}),v.$vexOverlay=$("<div>").addClass(vex.baseClassNames.overlay).addClass(v.overlayClassName).css(v.overlayCSS).data({vex:v}),v.$vex.append(v.$vexOverlay),v.$vexContent=$("<div>").addClass(vex.baseClassNames.content).addClass(v.contentClassName).css(v.contentCSS).text(v.content).data({vex:v}),v.$vex.append(v.$vexContent),$(v.appendLocation).append(v.$vex),vex.setupBodyClassName(v.$vex),"shuttingdown"!==a&&this._map.fire("postMessage",{msgId:"Session_Closed"}),void("ownertermination"===a&&this._map.remove())}if(a.startsWith("error:")&&"storage"===r.errorCmd)return void("savediskfull"===r.errorKind?this._map.fire("error",{msg:errorMessages.storage.savediskfull}):"savefailed"===r.errorKind&&this._map.fire("warn",{msg:errorMessages.storage.savefailed}));if(a.startsWith("error:")&&"internal"===r.errorCmd)return this._map._fatal=!0,"diskfull"===r.errorKind?this._map.fire("error",{msg:errorMessages.diskfull}):"unauthorized"===r.errorKind&&this._map.fire("error",{msg:errorMessages.unauthorized}),this._map._docLayer&&this._map._docLayer.removeAllViews(),void this.close();if(a.startsWith("error:")&&"load"===r.errorCmd){this.close();var y=r.errorKind,w=!1;if(y.startsWith("passwordrequired")){w=!0;var b="",C=y.split(":")[1];"to-view"===C?b+=_("Document requires password to view."):"to-modify"===C&&(b+=_("Document requires password to modify."),b+=" ",b+=_("Hit Cancel to open in view-only mode."))}else y.startsWith("wrongpassword")?(w=!0,b=_("Wrong password provided. Please try again.")):y.startsWith("faileddocloading")&&(this._map._fatal=!0,this._map.fire("error",{msg:errorMessages.faileddocloading}));if(w)return void vex.dialog.open({message:b,input:'<input name="password" type="password" required />',callback:s.bind(function(t){t?(this._map._docPassword=t.password,this.initialize(this._map)):"to-modify"===C?(this._map._docPassword="",this.initialize(this._map)):this._map.hideBusy()},this)})}else if(a.startsWith("error:")&&!this._map._docLayer)a=a.substring(6),"limitreached"===r.errorKind?(this._map._fatal=!0,a=errorMessages.limitreached,a=a.replace(/%0/g,r.params[0]),a=a.replace(/%1/g,r.params[1]),a=a.replace(/%2/g,"undefined"!=typeof brandProductName?brandProductName:"LibreOffice Online"),a=a.replace(/%3/g,"undefined"!=typeof brandProductFAQURL?brandProductFAQURL:"https://wiki.documentfoundation.org/Development/LibreOffice_Online")):"serviceunavailable"===r.errorKind&&(this._map._fatal=!0,a=errorMessages.serviceunavailable),this._map.fire("error",{msg:a});else if(a.startsWith("pong ")&&this._map._docLayer&&this._map._docLayer._debug){var x=this._map._docLayer._debugTimePING,P=this._map._docLayer._debugSetTimes(x,+new Date-this._map._docLayer._debugPINGQueue.shift());this._map._docLayer._debugData.ping.setPrefix("Server ping time: "+P+". Rendered tiles: "+r.rendercount+", last: "+(r.rendercount-this._map._docLayer._debugRenderCount)),this._map._docLayer._debugRenderCount=r.rendercount}else if(a.startsWith("statusindicator:"))this._map.showBusy(_("Connecting..."),!1);else if(a.startsWith("tile:")||a.startsWith("renderfont:")){for(var L=n.subarray(o+1),T="",S=0;S<L.length;S++)T+=String.fromCharCode(L[S]);var D="data:image/png;base64,"+t.btoa(T)}else{if(s.Log.log(a,s.INCOMING),n!==i)try{a=String.fromCharCode.apply(null,n)}catch(M){a=this._utf8ToString(n)}"object"==typeof e.data&&(a=decodeURIComponent(t.escape(a)))}}if(a.startsWith("status:")&&!this._map._docLayer){var k=this._map.options.tileWidthTwips,E=this._map.options.tileHeightTwips;if(this._map.options.zoom!==this._map.options.defaultZoom){var I=this._map.options.crs.scale(this._map.options.defaultZoom-this._map.options.zoom);k=Math.round(k*I),E=Math.round(E*I)}var U=null;if("text"===r.type)U=new s.WriterTileLayer("",{permission:this._map.options.permission,tileWidthTwips:k,tileHeightTwips:E,docType:r.type});else if("spreadsheet"===r.type)U=new s.CalcTileLayer("",{permission:this._map.options.permission,tileWidthTwips:k,tileHeightTwips:E,docType:r.type});else{if("presentation"===r.type&&this._map.options.defaultZoom===this._map.options.zoom){var O=this._map.getSize().y/256;k=Math.round(r.height/O),E=Math.round(r.height/O)}U=new s.ImpressTileLayer("",{permission:this._map.options.permission,tileWidthTwips:k,tileHeightTwips:E,docType:r.type})}this._map._docLayer=U,this._map.addLayer(U),this._map.fire("doclayerinit")}else a.startsWith("status:")&&this._reconnecting&&(this._reconnecting=!1,this._map._docLayer._onMessage("invalidatetiles: EMPTY",null),this._map.fire("statusindicator",{statusType:"reconnected"}),this._map.setPermission(this._map.options.permission));if(a.startsWith("statusindicatorstart:"))return void this._map.fire("statusindicator",{statusType:"start"});if(a.startsWith("statusindicatorsetvalue:")){var B=a.match(/\d+/g)[0];return void this._map.fire("statusindicator",{statusType:"setvalue",value:B})}return a.startsWith("statusindicatorfinish:")?(this._map.fire("statusindicator",{statusType:"finish"}),void this._map._fireInitComplete("statusindicatorfinish")):void(this._map._docLayer&&this._map._docLayer._onMessage(a,D))},_onSocketError:function(){this._map.hideBusy()},_onSocketClose:function(t){var e=this._map._active;this._map.hideBusy(),this._map._active=!1,this._map._docLayer&&this._map._docLayer.removeAllViews(),e&&this._map.fire("error",{msg:_("Well, this is embarrassing, we cannot connect to your document. Please try again."),cmd:"socket",kind:"closed",id:4}),this._map.wopi.resetAppLoaded(),this._reconnecting||(this._reconnecting=!0,this._map._activate())},parseServerCmd:function(t){for(var e=t.split(/[ \n]+/),i={},n=0;n<e.length;n++)"tileposx="===e[n].substring(0,9)?i.x=parseInt(e[n].substring(9)):"tileposy="===e[n].substring(0,9)?i.y=parseInt(e[n].substring(9)):"x="===e[n].substring(0,2)?i.x=parseInt(e[n].substring(2)):"y="===e[n].substring(0,2)?i.y=parseInt(e[n].substring(2)):"tilewidth="===e[n].substring(0,10)?i.tileWidth=parseInt(e[n].substring(10)):"tileheight="===e[n].substring(0,11)?i.tileHeight=parseInt(e[n].substring(11)):"width="===e[n].substring(0,6)?i.width=parseInt(e[n].substring(6)):"height="===e[n].substring(0,7)?i.height=parseInt(e[n].substring(7)):"part="===e[n].substring(0,5)?i.part=parseInt(e[n].substring(5)):"parts="===e[n].substring(0,6)?i.parts=parseInt(e[n].substring(6)):"current="===e[n].substring(0,8)?i.selectedPart=parseInt(e[n].substring(8)):"id="===e[n].substring(0,3)?i.id=e[n].substring(3).replace(/(\r\n|\n|\r)/gm,""):"type="===e[n].substring(0,5)?i.type=e[n].substring(5).replace(/(\r\n|\n|\r)/gm,""):"prefetch="===e[n].substring(0,9)?i.preFetch=e[n].substring(9):"cmd="===e[n].substring(0,4)?i.errorCmd=e[n].substring(4):"code="===e[n].substring(0,5)?i.errorCode=e[n].substring(5):"kind="===e[n].substring(0,5)?i.errorKind=e[n].substring(5):"jail="===e[n].substring(0,5)?i.jail=e[n].substring(5):"dir="===e[n].substring(0,4)?i.dir=e[n].substring(4):"name="===e[n].substring(0,5)?i.name=e[n].substring(5):"port="===e[n].substring(0,5)?i.port=e[n].substring(5):"font="===e[n].substring(0,5)?i.font=e[n].substring(5):"char="===e[n].substring(0,5)?i["char"]=e[n].substring(5):"viewid="===e[n].substring(0,7)?i.viewid=e[n].substring(7):"params="===e[n].substring(0,7)?i.params=e[n].substring(7).split(","):"renderid="===e[n].substring(0,9)?i.renderid=e[n].substring(9):"rendercount="===e[n].substring(0,12)&&(i.rendercount=parseInt(e[n].substring(12)));if(i.tileWidth&&i.tileHeight&&this._map._docLayer){var s=this._map.options.zoom,o=i.tileWidth/this._map._docLayer.options.tileWidthTwips;i.zoom=Math.round(s-Math.log(o)/Math.log(1.2))}return i}}),s.socket=function(t){return new s.Socket(t)},function(){var i=navigator.userAgent.toLowerCase(),n=e.documentElement,o="ActiveXObject"in t,a=-1!==i.indexOf("webkit"),r=-1!==i.indexOf("phantom"),l=-1!==i.search("android [23]"),h=-1!==i.indexOf("chrome"),d=-1!==i.indexOf("gecko")&&!a&&!t.opera&&!o,u=0===navigator.platform.indexOf("Win"),c="undefined"!=typeof orientation||-1!==i.indexOf("mobile"),p=!t.PointerEvent&&t.MSPointerEvent,_=t.PointerEvent&&navigator.pointerEnabled&&navigator.maxTouchPoints||p,m=o&&"transition"in n.style,g="WebKitCSSMatrix"in t&&"m11"in new t.WebKitCSSMatrix&&!l,f="MozPerspective"in n.style,v="OTransition"in n.style,y=!t.L_NO_TOUCH&&(_||"ontouchstart"in t||t.DocumentTouch&&e instanceof t.DocumentTouch);s.Browser={ie:o,ielt9:o&&!e.addEventListener,edge:"msLaunchUri"in navigator&&!("documentMode"in e),webkit:a,gecko:d,android:-1!==i.indexOf("android"),android23:l,chrome:h,safari:!h&&-1!==i.indexOf("safari"),win:u,ie3d:m,webkit3d:g,gecko3d:f,opera12:v,any3d:!t.L_DISABLE_3D&&(m||g||f)&&!v&&!r,mobile:c,mobileWebkit:c&&a,mobileWebkit3d:c&&g,mobileOpera:c&&t.opera,mobileGecko:c&&d,touch:!!y,msPointer:!!p,pointer:!!_,retina:(t.devicePixelRatio||t.screen.deviceXDPI/t.screen.logicalXDPI)>1}}(),s.Point=function(t,e,i){this.x=i?Math.round(t):t,this.y=i?Math.round(e):e},s.Point.prototype={clone:function(){return new s.Point(this.x,this.y)},add:function(t){return this.clone()._add(s.point(t))},_add:function(t){return this.x+=t.x,this.y+=t.y,this},subtract:function(t){return this.clone()._subtract(s.point(t))},_subtract:function(t){return this.x-=t.x,this.y-=t.y,this},divideBy:function(t){return this.clone()._divideBy(t)},_divideBy:function(t){return this.x/=t,this.y/=t,this},multiplyBy:function(t){return this.clone()._multiplyBy(t)},_multiplyBy:function(t){return this.x*=t,this.y*=t,this},round:function(){return this.clone()._round()},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},floor:function(){return this.clone()._floor()},_floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.clone()._ceil()},_ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},distanceTo:function(t){t=s.point(t);var e=t.x-this.x,i=t.y-this.y;return Math.sqrt(e*e+i*i)},equals:function(t){return t=s.point(t),t.x===this.x&&t.y===this.y},contains:function(t){return t=s.point(t),Math.abs(t.x)<=Math.abs(this.x)&&Math.abs(t.y)<=Math.abs(this.y)},toString:function(){return"Point("+s.Util.formatNum(this.x)+", "+s.Util.formatNum(this.y)+")"}},s.point=function(t,e,n){return t instanceof s.Point?t:s.Util.isArray(t)?new s.Point(t[0],t[1]):t===i||null===t?t:new s.Point(t,e,n)},s.Bounds=function(t,e){if(t)for(var i=e?[t,e]:t,n=0,s=i.length;s>n;n++)this.extend(i[n])},s.Bounds.prototype={extend:function(t){return t=s.point(t),this.min||this.max?(this.min.x=Math.min(t.x,this.min.x),this.max.x=Math.max(t.x,this.max.x),this.min.y=Math.min(t.y,this.min.y),this.max.y=Math.max(t.y,this.max.y)):(this.min=t.clone(),this.max=t.clone()),this},getCenter:function(t){return new s.Point((this.min.x+this.max.x)/2,(this.min.y+this.max.y)/2,t)},getBottomLeft:function(){return new s.Point(this.min.x,this.max.y)},getTopRight:function(){return new s.Point(this.max.x,this.min.y)},getSize:function(){return this.max.subtract(this.min)},contains:function(t){var e,i;return t="number"==typeof t[0]||t instanceof s.Point?s.point(t):s.bounds(t),t instanceof s.Bounds?(e=t.min,i=t.max):e=i=t,e.x>=this.min.x&&i.x<=this.max.x&&e.y>=this.min.y&&i.y<=this.max.y},intersects:function(t){t=s.bounds(t);var e=this.min,i=this.max,n=t.min,o=t.max,a=o.x>=e.x&&n.x<=i.x,r=o.y>=e.y&&n.y<=i.y;return a&&r},isValid:function(){return!(!this.min||!this.max)}},s.bounds=function(t,e){return!t||t instanceof s.Bounds?t:new s.Bounds(t,e)},s.Transformation=function(t,e,i,n){this._a=t,this._b=e,this._c=i,this._d=n},s.Transformation.prototype={transform:function(t,e){return this._transform(t.clone(),e)},_transform:function(t,e){return e=e||1,t.x=e*(this._a*t.x+this._b),t.y=e*(this._c*t.y+this._d),t},untransform:function(t,e){return e=e||1,new s.Point((t.x/e-this._b)/this._a,(t.y/e-this._d)/this._c)}},s.DomUtil={get:function(t){return"string"==typeof t?e.getElementById(t):t},getStyle:function(t,i){var n=t.style[i]||t.currentStyle&&t.currentStyle[i];if((!n||"auto"===n)&&e.defaultView){var s=e.defaultView.getComputedStyle(t,null);n=s?s[i]:null}return"auto"===n?null:n},setStyle:function(t,e,i){t.style[e]=i},create:function(t,i,n){var s=e.createElement(t);return s.className=i,n&&n.appendChild(s),s},remove:function(t){var e=t.parentNode;e&&e.removeChild(t)},empty:function(t){for(;t.firstChild;)t.removeChild(t.firstChild)},toFront:function(t){t.parentNode.appendChild(t)},toBack:function(t){var e=t.parentNode;e.insertBefore(t,e.firstChild)},hasClass:function(t,e){if(t.classList!==i)return t.classList.contains(e);var n=s.DomUtil.getClass(t);return n.length>0&&new RegExp("(^|\\s)"+e+"(\\s|$)").test(n)},addClass:function(t,e){if(t.classList!==i)for(var n=s.Util.splitWords(e),o=0,a=n.length;a>o;o++)t.classList.add(n[o]);else if(!s.DomUtil.hasClass(t,e)){var r=s.DomUtil.getClass(t);s.DomUtil.setClass(t,(r?r+" ":"")+e)}},removeClass:function(t,e){t.classList!==i?t.classList.remove(e):s.DomUtil.setClass(t,s.Util.trim((" "+s.DomUtil.getClass(t)+" ").replace(" "+e+" "," ")))},setClass:function(t,e){t.className.baseVal===i?t.className=e:t.className.baseVal=e},getClass:function(t){return t.className.baseVal===i?t.className:t.className.baseVal},setOpacity:function(t,e){"opacity"in t.style?t.style.opacity=e:"filter"in t.style&&s.DomUtil._setOpacityIE(t,e)},_setOpacityIE:function(t,e){var i=!1,n="DXImageTransform.Microsoft.Alpha";try{i=t.filters.item(n)}catch(s){if(1===e)return}e=Math.round(100*e),i?(i.Enabled=100!==e,i.Opacity=e):t.style.filter+=" progid:"+n+"(opacity="+e+")"},testProp:function(t){for(var i=e.documentElement.style,n=0;n<t.length;n++)if(t[n]in i)return t[n];return!1},setTransform:function(t,e,i){var n=e||new s.Point(0,0);t.style[s.DomUtil.TRANSFORM]="translate3d("+n.x+"px,"+n.y+"px,0)"+(i?" scale("+i+")":"")},setPosition:function(t,e,i){t._leaflet_pos=e,s.Browser.any3d&&!i?s.DomUtil.setTransform(t,e):(t.style.left=e.x+"px",t.style.top=e.y+"px")},getPosition:function(t){return t._leaflet_pos}},function(){s.DomUtil.TRANSFORM=s.DomUtil.testProp(["transform","WebkitTransform","OTransform","MozTransform","msTransform"]);var i=s.DomUtil.TRANSITION=s.DomUtil.testProp(["webkitTransition","transition","OTransition","MozTransition","msTransition"]);if(s.DomUtil.TRANSITION_END="webkitTransition"===i||"OTransition"===i?i+"End":"transitionend","onselectstart"in e)s.DomUtil.disableTextSelection=function(){s.DomEvent.on(t,"selectstart",s.DomEvent.preventDefault)},s.DomUtil.enableTextSelection=function(){s.DomEvent.off(t,"selectstart",s.DomEvent.preventDefault)};else{var n=s.DomUtil.testProp(["userSelect","WebkitUserSelect","OUserSelect","MozUserSelect","msUserSelect"]);s.DomUtil.disableTextSelection=function(){if(n){var t=e.documentElement.style;this._userSelect=t[n],t[n]="none"}},s.DomUtil.enableTextSelection=function(){n&&(e.documentElement.style[n]=this._userSelect,delete this._userSelect)}}s.DomUtil.disableImageDrag=function(){s.DomEvent.on(t,"dragstart",s.DomEvent.preventDefault)},s.DomUtil.enableImageDrag=function(){s.DomEvent.off(t,"dragstart",s.DomEvent.preventDefault)},s.DomUtil.preventOutline=function(e){s.DomUtil.restoreOutline(),this._outlineElement=e,this._outlineStyle=e.style.outline,e.style.outline="none",s.DomEvent.on(t,"keydown",s.DomUtil.restoreOutline,this)},s.DomUtil.restoreOutline=function(){this._outlineElement&&(this._outlineElement.style.outline=this._outlineStyle,delete this._outlineElement,delete this._outlineStyle,s.DomEvent.off(t,"keydown",s.DomUtil.restoreOutline,this))}}(),s.LatLng=function(t,e,n){if(isNaN(t)||isNaN(e))throw new Error("Invalid LatLng object: ("+t+", "+e+")");this.lat=+t,this.lng=+e,n!==i&&(this.alt=+n)},s.LatLng.prototype={equals:function(t,e){if(!t)return!1;t=s.latLng(t);var n=Math.max(Math.abs(this.lat-t.lat),Math.abs(this.lng-t.lng));return(e===i?1e-9:e)>=n},toString:function(t){return"LatLng("+s.Util.formatNum(this.lat,t)+", "+s.Util.formatNum(this.lng,t)+")"},distanceTo:function(t){return s.CRS.Earth.distance(this,s.latLng(t))},wrap:function(){return s.CRS.Earth.wrapLatLng(this)},toBounds:function(t){var e=180*t/40075017,i=e/Math.cos(Math.PI/180*this.lat);return s.latLngBounds([this.lat-e,this.lng-i],[this.lat+e,this.lng+i])}},s.latLng=function(t,e,n){return t instanceof s.LatLng?t:s.Util.isArray(t)&&"object"!=typeof t[0]?3===t.length?new s.LatLng(t[0],t[1],t[2]):2===t.length?new s.LatLng(t[0],t[1]):null:t===i||null===t?t:"object"==typeof t&&"lat"in t?new s.LatLng(t.lat,"lng"in t?t.lng:t.lon,t.alt):e===i?null:new s.LatLng(t,e,n)},s.LatLngBounds=function(t,e){if(t)for(var i=e?[t,e]:t,n=0,s=i.length;s>n;n++)this.extend(i[n])},s.LatLngBounds.prototype={extend:function(t){var e,i,n=this._southWest,o=this._northEast;if(t instanceof s.LatLng)e=t,i=t;else{if(!(t instanceof s.LatLngBounds))return t?this.extend(s.latLng(t)||s.latLngBounds(t)):this;if(e=t._southWest,i=t._northEast,!e||!i)return this}return n||o?(n.lat=Math.min(e.lat,n.lat),n.lng=Math.min(e.lng,n.lng),o.lat=Math.max(i.lat,o.lat),o.lng=Math.max(i.lng,o.lng)):(this._southWest=new s.LatLng(e.lat,e.lng),this._northEast=new s.LatLng(i.lat,i.lng)),this},pad:function(t){var e=this._southWest,i=this._northEast,n=Math.abs(e.lat-i.lat)*t,o=Math.abs(e.lng-i.lng)*t;return new s.LatLngBounds(new s.LatLng(e.lat-n,e.lng-o),new s.LatLng(i.lat+n,i.lng+o))},getCenter:function(){return new s.LatLng((this._southWest.lat+this._northEast.lat)/2,(this._southWest.lng+this._northEast.lng)/2)},getSouthWest:function(){return this._southWest},getNorthEast:function(){return this._northEast},getNorthWest:function(){return new s.LatLng(this.getNorth(),this.getWest())},getSouthEast:function(){return new s.LatLng(this.getSouth(),this.getEast())},getWest:function(){return this._southWest.lng},getSouth:function(){return this._southWest.lat},getEast:function(){return this._northEast.lng},getNorth:function(){return this._northEast.lat},contains:function(t){t="number"==typeof t[0]||t instanceof s.LatLng?s.latLng(t):s.latLngBounds(t);var e,i,n=this._southWest,o=this._northEast;return t instanceof s.LatLngBounds?(e=t.getSouthWest(),i=t.getNorthEast()):e=i=t,e.lat>=n.lat&&i.lat<=o.lat&&e.lng>=n.lng&&i.lng<=o.lng},intersects:function(t){t=s.latLngBounds(t);var e=this._southWest,i=this._northEast,n=t.getSouthWest(),o=t.getNorthEast(),a=o.lat>=e.lat&&n.lat<=i.lat,r=o.lng>=e.lng&&n.lng<=i.lng;return a&&r},toBBoxString:function(){return[this.getWest(),this.getSouth(),this.getEast(),this.getNorth()].join(",")},equals:function(t){return t?(t=s.latLngBounds(t),this._southWest.equals(t.getSouthWest())&&this._northEast.equals(t.getNorthEast())):!1},isValid:function(){return!(!this._southWest||!this._northEast)}},s.LatLngBounds.createDefault=function(){return new s.LatLngBounds(new s.LatLng(0,0),new s.LatLng(0,0))},s.latLngBounds=function(t,e){return!t||t instanceof s.LatLngBounds?t:new s.LatLngBounds(t,e)},s.Projection={},s.Projection.LonLat={project:function(t){
return new s.Point(t.lng,t.lat)},unproject:function(t){return new s.LatLng(t.y,t.x)},bounds:s.bounds([-180,-90],[180,90])},s.Projection.SphericalMercator={R:6378137,project:function(t){var e=Math.PI/180,i=1-1e-15,n=Math.max(Math.min(Math.sin(t.lat*e),i),-i);return new s.Point(this.R*t.lng*e,this.R*Math.log((1+n)/(1-n))/2)},unproject:function(t){var e=180/Math.PI;return new s.LatLng((2*Math.atan(Math.exp(t.y/this.R))-Math.PI/2)*e,t.x*e/this.R)},bounds:function(){var t=6378137*Math.PI;return s.bounds([-t,-t],[t,t])}()},s.CRS={latLngToPoint:function(t,e){var i=this.projection.project(t),n=this.scale(e);return this.transformation._transform(i,n)},pointToLatLng:function(t,e){var i=this.scale(e),n=this.transformation.untransform(t,i);return this.projection.unproject(n)},project:function(t){return this.projection.project(t)},unproject:function(t){return this.projection.unproject(t)},scale:function(t){return 256*Math.pow(2,t)},getProjectedBounds:function(t){if(this.infinite)return null;var e=this.projection.bounds,i=this.scale(t),n=this.transformation.transform(e.min,i),o=this.transformation.transform(e.max,i);return s.bounds(n,o)},wrapLatLng:function(t){var e=this.wrapLng?s.Util.wrapNum(t.lng,this.wrapLng,!0):t.lng,i=this.wrapLat?s.Util.wrapNum(t.lat,this.wrapLat,!0):t.lat;return s.latLng(i,e)}},s.CRS.Simple=s.extend({},s.CRS,{projection:s.Projection.LonLat,transformation:new s.Transformation(1,0,-1,0),scale:function(t){return Math.pow(1.2,t)},distance:function(t,e){var i=e.lng-t.lng,n=e.lat-t.lat;return Math.sqrt(i*i+n*n)},infinite:!0}),s.CRS.Earth=s.extend({},s.CRS,{wrapLng:[-180,180],R:6378137,distance:function(t,e){var i=Math.PI/180,n=t.lat*i,s=e.lat*i,o=Math.sin(n)*Math.sin(s)+Math.cos(n)*Math.cos(s)*Math.cos((e.lng-t.lng)*i);return this.R*Math.acos(Math.min(o,1))}}),s.CRS.EPSG3857=s.extend({},s.CRS.Earth,{code:"EPSG:3857",projection:s.Projection.SphericalMercator,transformation:function(){var t=.5/(Math.PI*s.Projection.SphericalMercator.R);return new s.Transformation(t,.5,-t,.5)}()}),s.CRS.EPSG900913=s.extend({},s.CRS.EPSG3857,{code:"EPSG:900913"}),s.CRS.EPSG4326=s.extend({},s.CRS.Earth,{code:"EPSG:4326",projection:s.Projection.LonLat,transformation:new s.Transformation(1/180,1,-1/180,.5)}),s.Map=s.Evented.extend({options:{crs:s.CRS.Simple,center:[0,0],zoom:10,minZoom:1,maxZoom:20,fadeAnimation:!1,trackResize:!0,markerZoomAnimation:!0,defaultZoom:10,tileWidthTwips:3840,tileHeightTwips:3840,urlPrefix:"lool"},lastActiveTime:Date.now(),initialize:function(e,n){if(n=s.setOptions(this,n),this.options.documentContainer&&(this.options.documentContainer=s.DomUtil.get(this.options.documentContainer)),this._initContainer(e),this._initLayout(),this._onResize=s.bind(this._onResize,this),this._initEvents(),n.maxBounds&&this.setMaxBounds(n.maxBounds),n.zoom!==i&&(this._zoom=this._limitZoom(n.zoom)),n.center&&n.zoom!==i&&this.setView(s.latLng(n.center),n.zoom,{reset:!0}),s.Cursor.imagePath=n.cursorURL||s.Cursor.getCursorURL("cursors"),n.webserver===i){var o="file:"===t.location.protocol?"https:":t.location.protocol;n.webserver=n.server.replace(/^(ws|wss):/i,o)}n.webserver=n.webserver.replace(/\/*$/,""),this._handlers=[],this._layers={},this._zoomBoundLayers={},this._sizeChanged=!0,this._bDisableKeyboard=!1,this._active=!0,this._fatal=!1,this._enabled=!0,vex.dialogID=-1,this.callInitHooks(),this.options.imagePath&&(s.Icon.Default.imagePath=this.options.imagePath),this._addLayers(this.options.layers),this._socket=s.socket(this),this._progressBar=s.progressOverlay(this.getCenter(),s.point(150,25)),this.on("contextmenu",function(){}),this.initConditions={doclayerinit:!1,statusindicatorfinish:!1,StyleApply:!1,CharFontName:!1,updatepermission:!1},this.initComplete=!1,this.on("updatepermission",function(t){this.initComplete||this._fireInitComplete("updatepermission"),"readonly"===t.perm&&(s.DomUtil.addClass(this._container.parentElement,"readonly"),s.DomUtil.addClass(s.DomUtil.get("logo"),"readonly"),s.DomUtil.addClass(s.DomUtil.get("toolbar-wrapper"),"readonly"),s.DomUtil.addClass(s.DomUtil.get("main-menu"),"readonly"),s.DomUtil.addClass(s.DomUtil.get("presentation-controls-wrapper"),"readonly"),s.DomUtil.addClass(s.DomUtil.get("spreadsheet-row-column-frame"),"readonly"))},this),this.on("doclayerinit",function(){this.initComplete||this._fireInitComplete("doclayerinit")}),this.on("updatetoolbarcommandvalues",function(t){this.initComplete||(".uno:StyleApply"===t.commandName?this._fireInitComplete("StyleApply"):".uno:CharFontName"===t.commandName&&this._fireInitComplete("CharFontName"))}),this.showBusy(_("Initializing..."),!1),this.on("statusindicator",this._onUpdateProgress,this),this._viewInfo={},this._viewColors={},this._everModified=!1,this.on("commandstatechanged",function(t){".uno:ModifiedStatus"===t.commandName&&(this._everModified=this._everModified||"true"===t.state)},this)},addView:function(t,e,i,n){this._viewInfo[t]={userid:e,username:i,color:n},this.fire("postMessage",{msgId:"View_Added",args:{ViewId:t,UserId:e,UserName:i,Color:n}}),this.fire("addview",{viewId:t,username:i})},removeView:function(t){var e=this._viewInfo[t].username;delete this._viewInfo[t],this.fire("postMessage",{msgId:"View_Removed",args:{ViewId:t}}),this.fire("removeview",{viewId:t,username:e})},setView:function(t,e){return e=e===i?this.getZoom():e,this._resetView(s.latLng(t),this._limitZoom(e)),this},showBusy:function(t,e){return this._docLayer?void this.fire("showbusy",{label:t}):(this._progressBar.setLabel(t),this._progressBar.setBar(e),this._progressBar.setValue(0),void(this.hasLayer(this._progressBar)||this.addLayer(this._progressBar)))},hideBusy:function(){this.fire("hidebusy"),this.hasLayer(this._progressBar)&&this.removeLayer(this._progressBar)},setZoom:function(t,e){return this._loaded?(this._docLayer&&"spreadsheet"===this._docLayer._docType&&this._docLayer._checkSpreadSheetBounds(t),this.setView(this.getCenter(),t,{zoom:e})):(this._zoom=this._limitZoom(t),this)},zoomIn:function(t,e){return this.setZoom(this._zoom+(t||1),e)},zoomOut:function(t,e){return this.setZoom(this._zoom-(t||1),e)},setZoomAround:function(t,e,i){var n=this.getZoomScale(e),o=this.getSize().divideBy(2),a=t instanceof s.Point?t:this.latLngToContainerPoint(t),r=a.subtract(o).multiplyBy(1-1/n),l=this.containerPointToLatLng(o.add(r));return this.setView(l,e,{zoom:i})},fitBounds:function(t,e){e=e||{},t=t.getBounds?t.getBounds():s.latLngBounds(t);var i=s.point(e.paddingTopLeft||e.padding||[0,0]),n=s.point(e.paddingBottomRight||e.padding||[0,0]),o=this.getBoundsZoom(t,!1,i.add(n));o=e.maxZoom?Math.min(e.maxZoom,o):o;var a=n.subtract(i).divideBy(2),r=this.project(t.getSouthWest(),o),l=this.project(t.getNorthEast(),o),h=this.unproject(r.add(l).divideBy(2).add(a),o);return this.setView(h,o,e)},fitWorld:function(t){return this.fitBounds([[-90,-180],[90,180]],t)},panTo:function(t,e){return this.setView(t,this._zoom,{pan:e})},panBy:function(t){return this.fire("movestart"),this._rawPanBy(s.point(t)),this.fire("move"),this.fire("moveend")},setMaxBounds:function(t){return t=s.latLngBounds(t),this.options.maxBounds=t,t?(this._loaded&&this._panInsideMaxBounds(),this.on("moveend",this._panInsideMaxBounds)):this.off("moveend",this._panInsideMaxBounds)},panInsideBounds:function(t,e){var i=this.getCenter(),n=this._limitCenter(i,this._zoom,t);return i.equals(n)?this:this.panTo(n,e)},invalidateSize:function(t){if(!this._loaded)return this;t=s.extend({animate:!1,pan:!0},t===!0?{animate:!0}:t);var e=this.getSize();this._sizeChanged=!0,this._initialCenter=null;var i=this.getSize(),n=e.divideBy(2).round(),o=i.divideBy(2).round(),a=n.subtract(o);return a.x||a.y?(t.animate&&t.pan?this.panBy(a):(t.pan&&this._rawPanBy(a),this.fire("move"),t.debounceMoveend?(clearTimeout(this._sizeTimer),this._sizeTimer=setTimeout(s.bind(this.fire,this,"moveend"),200)):this.fire("moveend")),this.fire("resize",{oldSize:e,newSize:i})):this},stop:function(){return s.Util.cancelAnimFrame(this._flyToFrame),this._panAnim&&this._panAnim.stop(),this},addHandler:function(t,e){if(!e)return this;var i=this[t]=new e(this);return this._handlers.push(i),this.options[t]&&i.enable(),this},remove:function(){this._initEvents(!0);try{delete this._container._leaflet}catch(t){this._container._leaflet=i}return s.DomUtil.remove(this._mapPane),this._clearControlPos&&this._clearControlPos(),this._clearHandlers(),this._loaded&&this.fire("unload"),this._docLayer&&this.removeLayer(this._docLayer),this.removeControls(),this._socket.close(),this},createPane:function(t,e){var i="leaflet-pane"+(t?" leaflet-"+t.replace("Pane","")+"-pane":""),n=s.DomUtil.create("div",i,e||this._mapPane);return t&&(this._panes[t]=n),n},getViewName:function(t){return this._viewInfo[t].username},getViewColor:function(t){return this._viewInfo[t].color},getCenter:function(){return this._checkIfLoaded(),this._initialCenter&&!this._moved()?this._initialCenter:this.layerPointToLatLng(this._getCenterLayerPoint())},getZoom:function(){return this._zoom},getBounds:function(){var t=this.getPixelBounds(),e=this.unproject(t.getBottomLeft()),i=this.unproject(t.getTopRight());return new s.LatLngBounds(e,i)},getMinZoom:function(){return this.options.minZoom===i?this._layersMinZoom||0:this.options.minZoom},getMaxZoom:function(){return this.options.maxZoom===i?this._layersMaxZoom===i?1/0:this._layersMaxZoom:this.options.maxZoom},getBoundsZoom:function(t,e,i){t=s.latLngBounds(t);var n,o=this.getMinZoom()-(e?1:0),a=this.getMaxZoom(),r=this.getSize(),l=t.getNorthWest(),h=t.getSouthEast(),d=!0;i=s.point(i||[0,0]);do o++,n=this.project(h,o).subtract(this.project(l,o)).add(i).floor(),d=e?n.x<r.x||n.y<r.y:r.contains(n);while(d&&a>=o);return d&&e?null:e?o:o-1},getSize:function(){return(!this._size||this._sizeChanged)&&(this._size=new s.Point(this._container.clientWidth,this._container.clientHeight),this._sizeChanged=!1),this._size.clone()},getPixelBounds:function(t,e){var i=this._getTopLeftPoint(t,e);return new s.Bounds(i,i.add(this.getSize()))},getPixelOrigin:function(){return this._checkIfLoaded(),this._pixelOrigin},getPixelWorldBounds:function(t){return this.options.crs.getProjectedBounds(t===i?this.getZoom():t)},getPane:function(t){return"string"==typeof t?this._panes[t]:t},getPanes:function(){return this._panes},getContainer:function(){return this._container},getZoomScale:function(t,e){var n=this.options.crs;return e=e===i?this._zoom:e,n.scale(t)/n.scale(e)},getScaleZoom:function(t,e){return e=e===i?this._zoom:e,e+Math.log(t)/Math.LN2},project:function(t,e){e=e===i?this._zoom:e;var n=this.options.crs.latLngToPoint(s.latLng(t),e);return new s.Point(s.round(n.x,1e-6),s.round(n.y,1e-6))},unproject:function(t,e){return e=e===i?this._zoom:e,this.options.crs.pointToLatLng(s.point(t),e)},layerPointToLatLng:function(t){var e=s.point(t).add(this.getPixelOrigin());return this.unproject(e)},latLngToLayerPoint:function(t){var e=this.project(s.latLng(t))._round();return e._subtract(this.getPixelOrigin())},wrapLatLng:function(t){return this.options.crs.wrapLatLng(s.latLng(t))},distance:function(t,e){return this.options.crs.distance(s.latLng(t),s.latLng(e))},containerPointToLayerPoint:function(t){return s.point(t).subtract(this._getMapPanePos())},layerPointToContainerPoint:function(t){return s.point(t).add(this._getMapPanePos())},containerPointToLatLng:function(t){var e=this.containerPointToLayerPoint(s.point(t));return this.layerPointToLatLng(e)},latLngToContainerPoint:function(t){return this.layerPointToContainerPoint(this.latLngToLayerPoint(s.latLng(t)))},mouseEventToContainerPoint:function(t){return s.DomEvent.getMousePosition(t,this._container)},mouseEventToLayerPoint:function(t){return this.containerPointToLayerPoint(this.mouseEventToContainerPoint(t))},mouseEventToLatLng:function(t){return this.layerPointToLatLng(this.mouseEventToLayerPoint(t))},focus:function(){console.debug("focus:"),this._docLayer&&e.activeElement!==this._docLayer._textArea&&(console.debug("focus: focussing"),this._docLayer._textArea.focus())},_fireInitComplete:function(t){if(!this.initComplete){this.initConditions[t]=!0;for(var e in this.initConditions)if(!this.initConditions[e])return;this.fire("statusindicator",{statusType:"initializationcomplete"}),this.initComplete=!0}},_initContainer:function(t){var e=this._container=s.DomUtil.get(t);if(!e)throw new Error("Map container not found.");if(e._leaflet)throw new Error("Map container is already initialized.");var i=s.DomUtil.create("div","clipboard-container",e.parentElement);this._textArea=s.DomUtil.create("input","clipboard",i),this._textArea.setAttribute("type","text"),this._textArea.setAttribute("autocorrect","off"),this._textArea.setAttribute("autocapitalize","off"),this._resizeDetector=s.DomUtil.create("iframe","resize-detector",e),this._fileDownloader=s.DomUtil.create("iframe","",e),s.DomUtil.setStyle(this._fileDownloader,"display","none"),e._leaflet=!0},_initLayout:function(){var t=this._container;this._fadeAnimated=this.options.fadeAnimation&&s.Browser.any3d,s.DomUtil.addClass(t,"leaflet-container"+(s.Browser.touch?" leaflet-touch":"")+(s.Browser.retina?" leaflet-retina":"")+(s.Browser.ielt9?" leaflet-oldie":"")+(s.Browser.safari?" leaflet-safari":"")+(this._fadeAnimated?" leaflet-fade-anim":""));var e=s.DomUtil.getStyle(t,"position");"absolute"!==e&&"relative"!==e&&"fixed"!==e&&(t.style.position="absolute"),this._initPanes(),this._initControlPos&&this._initControlPos()},_initPanes:function(){var t=this._panes={};this._paneRenderers={},this._mapPane=this.createPane("mapPane",this._container),this.createPane("tilePane"),this.createPane("shadowPane"),this.createPane("overlayPane"),this.createPane("markerPane"),this.createPane("popupPane"),this.options.markerZoomAnimation||(s.DomUtil.addClass(t.markerPane,"leaflet-zoom-hide"),s.DomUtil.addClass(t.shadowPane,"leaflet-zoom-hide"))},_resetView:function(t,e,i,n){var o=this._zoom!==e;n||(this.fire("movestart"),o&&this.fire("zoomstart")),this._zoom=e,this._initialCenter=t,i||s.DomUtil.setPosition(this._mapPane,new s.Point(0,0)),this._pixelOrigin=this._getNewPixelOrigin(t);var a=!this._loaded;this._loaded=!0,this.fire("viewreset",{hard:!i}),a&&this.fire("load"),this.fire("move"),(o||n)&&(this.fire("zoomend"),this.fire("zoomlevelschange")),this.fire("moveend",{hard:!i})},_rawPanBy:function(t){s.DomUtil.setPosition(this._mapPane,this._getMapPanePos().subtract(t))},_getZoomSpan:function(){return this.getMaxZoom()-this.getMinZoom()},_panInsideMaxBounds:function(){this.panInsideBounds(this.options.maxBounds)},_checkIfLoaded:function(){if(!this._loaded)throw new Error("Set map center and zoom first.")},_initEvents:function(e){if(s.DomEvent){this._targets={},this._mouseOut=!1;var i=e?"off":"on";s.DomEvent[i](this._container,"click dblclick mousedown mouseup mouseover mouseout mousemove contextmenu dragover drop keydown keypress keyup trplclick qdrplclick",this._handleDOMEvent,this),s.DomEvent[i](this._textArea,"copy cut paste keydown keypress keyup compositionstart compositionupdate compositionend textInput",this._handleDOMEvent,this),this.options.trackResize&&this._resizeDetector.contentWindow&&s.DomEvent[i](this._resizeDetector.contentWindow,"resize",this._onResize,this),s.DomEvent[i](t,"blur",this._onLostFocus,this),s.DomEvent[i](t,"focus",this._onGotFocus,this)}},_onResize:function(){s.Util.cancelAnimFrame(this._resizeRequest),this._resizeRequest=s.Util.requestAnimFrame(function(){this.invalidateSize({debounceMoveend:!0})},this,!1,this._container)},_activate:function(){if(clearTimeout(vex.timer),!this._active)if(this._socket.connected()){if(this._socket.sendMessage("useractive"),this._active=!0,this._docLayer._onMessage("invalidatetiles: EMPTY",null),vex.dialogID>0){var t=vex.dialogID;return vex.dialogID=-1,this._startInactiveTimer(),this.focus(),vex.close(t)}}else this._socket.initialize(this);return this._startInactiveTimer(),this.focus(),!1},_dim:function(){if(!t.devtools.open&&map._socket.connected()&&!this.options.alwaysActive){map._active=!1,clearTimeout(vex.timer);var e=$.extend({},vex.defaultOptions,{contentCSS:{background:"rgba(0, 0, 0, 0)","font-size":"xx-large",color:"#fff","text-align":"center"},content:_("Inactive document - please click to resume editing")});e.id=vex.globalID,vex.dialogID=e.id,vex.globalID+=1,e.$vex=$("<div>").addClass(vex.baseClassNames.vex).addClass(e.className).css(e.css).data({vex:e}),e.$vexOverlay=$("<div>").addClass(vex.baseClassNames.overlay).addClass(e.overlayClassName).css(e.overlayCSS).data({vex:e}),e.$vexOverlay.bind("click.vex",function(t){return t.target!==this?0:map._activate()}),e.$vex.append(e.$vexOverlay),e.$vexContent=$("<div>").addClass(vex.baseClassNames.content).addClass(e.contentClassName).css(e.contentCSS).text(e.content).data({vex:e}),e.$vex.append(e.$vexContent),$(e.appendLocation).append(e.$vex),vex.setupBodyClassName(e.$vex),map._doclayer&&map._docLayer._onMessage("textselection:",null),map._socket.sendMessage("userinactive")}},_dimIfInactive:function(){Date.now()-map.lastActiveTime>=6e5?map._dim():map._startInactiveTimer()},_startInactiveTimer:function(){clearTimeout(vex.timer);var t=this;vex.timer=setTimeout(function(){t._dimIfInactive()},6e4)},_deactivate:function(){if(clearTimeout(vex.timer),!t.devtools.open&&(!this._active||vex.dialogID>0))return this._active=!1,this._docLayer&&this._docLayer._onMessage("textselection:",null),void(this._socket.connected()&&this._socket.sendMessage("userinactive"));var e=this;vex.timer=setTimeout(function(){e._dim()},3e4)},_onLostFocus:function(){if(this._loaded){console.debug("_onLostFocus: ");var t=this._docLayer;t&&(t._isCursorVisibleOnLostFocus=t._isCursorVisible,t._isCursorOverlayVisibleOnLostFocus=t._isCursorOverlayVisible,t._isCursorVisible&&t._isCursorOverlayVisible&&(t._isCursorOverlayVisible=!1,t._updateCursorAndOverlay()),this._deactivate())}},_onGotFocus:function(){if(this._loaded){var t=this._docLayer;t&&"undefined"!=typeof t._isCursorOverlayVisibleOnLostFocus&&"undefined"!=typeof t._isCursorVisibleOnLostFocus&&setTimeout(function(){t._isCursorOverlayVisible=t._isCursorOverlayVisibleOnLostFocus,t._isCursorVisible=t._isCursorVisibleOnLostFocus,t._updateCursorAndOverlay()},300),this._activate()}},_onUpdateProgress:function(t){"start"===t.statusType?1===this._socket.readyState?this.showBusy(_("Saving..."),!0):this.showBusy(_("Loading..."),!0):"setvalue"===t.statusType?this._progressBar.setValue(t.value):("finish"===t.statusType||"loleafletloaded"===t.statusType||"reconnected"===t.statusType)&&this.hideBusy()},_isMouseEnteringLeaving:function(t){var e=t.target||t.srcElement,i=t.relatedTarget;return e?s.DomUtil.hasClass(e,"leaflet-tile")&&!(i&&(s.DomUtil.hasClass(i,"leaflet-tile")||s.DomUtil.hasClass(i,"leaflet-cursor"))):!1},_handleDOMEvent:function(t){if(this._loaded&&this._enabled&&!s.DomEvent._skipped(t)){this.lastActiveTime=Date.now();var e=this._targets[s.stamp(t.target||t.srcElement)],n=t.type;"click"===n&&"edit"===this._permission&&(this._textArea.blur(),this._textArea.focus()),this._mouseEnteringLeaving=!1,e||this._mouseOut||"mouseout"!==n||(this._mouseEnteringLeaving=this._isMouseEnteringLeaving(t),this._mouseOut=this._mouseEnteringLeaving),!e&&this._mouseOut&&"mouseover"===n&&(this._mouseEnteringLeaving=this._isMouseEnteringLeaving(t),this._mouseOut=!this._mouseEnteringLeaving),(e||this._mouseEnteringLeaving||"mouseover"!==n&&"mouseout"!==n||s.DomEvent._checkMouse(this._container,t))&&("mousedown"===n&&(s.DomUtil.preventOutline(t.target||t.srcElement),t.preventDefault()),e!==i&&e._path!==i&&"mousemove"===n&&(e=i),this._fireDOMEvent(e||this,t,n))}},_fireDOMEvent:function(t,e,i){if((t.listens(i,!0)||"click"===i&&t.listens("preclick",!0))&&("contextmenu"===i&&s.DomEvent.preventDefault(e),"click"!==e.type||e._simulated||!this._draggableMoved(t))){var n={originalEvent:e};"keypress"!==e.type&&"keyup"!==e.type&&"keydown"!==e.type&&"copy"!==e.type&&"cut"!==e.type&&"paste"!==e.type&&"compositionstart"!==e.type&&"compositionupdate"!==e.type&&"compositionend"!==e.type&&"textInput"!==e.type&&(n.containerPoint=t instanceof s.Marker?this.latLngToContainerPoint(t.getLatLng()):this.mouseEventToContainerPoint(e),n.layerPoint=this.containerPointToLayerPoint(n.containerPoint),n.latlng=this.layerPointToLatLng(n.layerPoint)),"click"===i&&t.fire("preclick",n,!0),t.fire(i,n,!0)}},_draggableMoved:function(t){return t=t.options.draggable?t:this,t.dragging&&t.dragging.moved()||this.boxZoom&&this.boxZoom.moved()},_clearHandlers:function(){for(var t=0,e=this._handlers.length;e>t;t++)this._handlers[t].disable()},whenReady:function(t,e){return this._loaded?t.call(e||this,{target:this}):this.on("load",t,e),this},_getMapPanePos:function(){return s.DomUtil.getPosition(this._mapPane)||new s.Point(0,0)},_moved:function(){var t=this._getMapPanePos();return t&&!t.equals([0,0])},_getTopLeftPoint:function(t,e){var n=t&&e!==i?this._getNewPixelOrigin(t,e):this.getPixelOrigin();return n.subtract(this._getMapPanePos())},_getNewPixelOrigin:function(t,e){var i=this.getSize()._divideBy(2);return this.project(t,e)._subtract(i)._add(this._getMapPanePos())._round()},_latLngToNewLayerPoint:function(t,e,i){var n=this._getNewPixelOrigin(i,e);return this.project(t,e)._subtract(n)},_getCenterLayerPoint:function(){return this.containerPointToLayerPoint(this.getSize()._divideBy(2))},_getCenterOffset:function(t){return this.latLngToLayerPoint(t).subtract(this._getCenterLayerPoint())},_limitCenter:function(t,e,i){if(!i)return t;var n=this.project(t,e),o=this.getSize().divideBy(2),a=new s.Bounds(n.subtract(o),n.add(o)),r=this._getBoundsOffset(a,i,e);return this.unproject(n.add(r),e)},_limitOffset:function(t,e){if(!e)return t;var i=this.getPixelBounds(),n=new s.Bounds(i.min.add(t),i.max.add(t));return t.add(this._getBoundsOffset(n,e))},_getBoundsOffset:function(t,e,i){var n=this.project(e.getNorthWest(),i).subtract(t.min),o=this.project(e.getSouthEast(),i).subtract(t.max),a=this._rebound(n.x,-o.x),r=this._rebound(n.y,-o.y);return new s.Point(a,r)},_rebound:function(t,e){return t+e>0?Math.round(t-e)/2:Math.max(0,Math.ceil(t))-Math.max(0,Math.floor(e))},_limitZoom:function(t){var e=this.getMinZoom(),i=this.getMaxZoom();return Math.max(e,Math.min(i,t))},enable:function(t){this._enabled=t,this._enabled?$(".scroll-container").mCustomScrollbar("update"):$(".scroll-container").mCustomScrollbar("disable")}}),s.map=function(t,e){return new s.Map(t,e)},s.Layer=s.Evented.extend({options:{pane:"overlayPane"},addTo:function(t){return t.addLayer(this),this},remove:function(){return this.removeFrom(this._map||this._mapToAdd)},removeFrom:function(t){return t&&t.removeLayer(this),this},getPane:function(t){return this._map.getPane(t?this.options[t]||t:this.options.pane)},addInteractiveTarget:function(t){return this._map._targets[s.stamp(t)]=this,this},removeInteractiveTarget:function(t){return delete this._map._targets[s.stamp(t)],this},_layerAdd:function(t){var e=t.target;e.hasLayer(this)&&(this._map=e,this._zoomAnimated=e._zoomAnimated,this.onAdd(e),this.getEvents&&e.on(this.getEvents(),this),this.fire("add"),e.fire("layeradd",{layer:this}))}}),s.Map.include({addLayer:function(t){var e=s.stamp(t);return this._layers[e]?t:(this._layers[e]=t,t._mapToAdd=this,t.beforeAdd&&t.beforeAdd(this),this.whenReady(t._layerAdd,t),this)},removeLayer:function(t){var e=s.stamp(t);return this._layers[e]?(this._loaded&&t.onRemove(this),t.getEvents&&this.off(t.getEvents(),t),delete this._layers[e],this._loaded&&(this.fire("layerremove",{layer:t}),t.fire("remove")),t._map=t._mapToAdd=null,this):this},hasLayer:function(t){return!!t&&s.stamp(t)in this._layers},eachLayer:function(t,e){for(var i in this._layers)t.call(e,this._layers[i]);return this},_addLayers:function(t){t=t?s.Util.isArray(t)?t:[t]:[];for(var e=0,i=t.length;i>e;e++)this.addLayer(t[e])},_addZoomLimit:function(t){(isNaN(t.options.maxZoom)||!isNaN(t.options.minZoom))&&(this._zoomBoundLayers[s.stamp(t)]=t,this._updateZoomLevels())},_removeZoomLimit:function(t){var e=s.stamp(t);this._zoomBoundLayers[e]&&(delete this._zoomBoundLayers[e],this._updateZoomLevels())},_updateZoomLevels:function(){var t=1/0,e=-(1/0),n=this._getZoomSpan();for(var s in this._zoomBoundLayers){var o=this._zoomBoundLayers[s].options;t=o.minZoom===i?t:Math.min(t,o.minZoom),e=o.maxZoom===i?e:Math.max(e,o.maxZoom)}this._layersMaxZoom=e===-(1/0)?i:e,this._layersMinZoom=t===1/0?i:t,n!==this._getZoomSpan()&&this.fire("zoomlevelschange")}}),s.Projection.Mercator={R:6378137,R_MINOR:6356752.314245179,bounds:s.bounds([-20037508.34279,-15496570.73972],[20037508.34279,18764656.23138]),project:function(t){var e=Math.PI/180,i=this.R,n=t.lat*e,o=this.R_MINOR/i,a=Math.sqrt(1-o*o),r=a*Math.sin(n),l=Math.tan(Math.PI/4-n/2)/Math.pow((1-r)/(1+r),a/2);return n=-i*Math.log(Math.max(l,1e-10)),new s.Point(t.lng*e*i,n)},unproject:function(t){for(var e,i=180/Math.PI,n=this.R,o=this.R_MINOR/n,a=Math.sqrt(1-o*o),r=Math.exp(-t.y/n),l=Math.PI/2-2*Math.atan(r),h=0,d=.1;15>h&&Math.abs(d)>1e-7;h++)e=a*Math.sin(l),e=Math.pow((1-e)/(1+e),a/2),d=Math.PI/2-2*Math.atan(r*e)-l,l+=d;return new s.LatLng(l*i,t.x*i/n)}},s.CRS.EPSG3395=s.extend({},s.CRS.Earth,{code:"EPSG:3395",projection:s.Projection.Mercator,transformation:function(){var t=.5/(Math.PI*s.Projection.Mercator.R);return new s.Transformation(t,.5,-t,.5)}()}),s.GridLayer=s.Layer.extend({options:{pane:"tilePane",tileSize:256,opacity:1,updateWhenIdle:s.Browser.mobile,updateInterval:200,attribution:null,zIndex:null,bounds:null,minZoom:0},initialize:function(t){t=s.setOptions(this,t)},onAdd:function(){this._initContainer(),this._levels={},this._tiles={},this._viewReset()},beforeAdd:function(t){t._addZoomLimit(this)},onRemove:function(t){s.DomUtil.remove(this._container),t._removeZoomLimit(this),this._container=null,this._tileZoom=null,clearTimeout(this._preFetchIdle),clearTimeout(this._previewInvalidator),clearInterval(this._tilesPreFetcher),this._selections&&this._map.removeLayer(this._selections),this._cursorMarker&&this._cursorMarker.remove(),this._graphicMarker&&this._graphicMarker.remove();for(var e in this._selectionHandles)this._selectionHandles[e].remove()},bringToFront:function(){return this._map&&(s.DomUtil.toFront(this._container),this._setAutoZIndex(Math.max)),this},bringToBack:function(){return this._map&&(s.DomUtil.toBack(this._container),this._setAutoZIndex(Math.min)),this},getAttribution:function(){return this.options.attribution},getContainer:function(){return this._container},setOpacity:function(t){return this.options.opacity=t,this._map&&this._updateOpacity(),this},setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},redraw:function(){return this._map&&(this._removeAllTiles(),this._update()),this},getEvents:function(){var t={viewreset:this._viewReset,movestart:this._moveStart,moveend:this._move};return this.options.updateWhenIdle||(t.move=s.Util.throttle(this._move,this.options.updateInterval,this)),this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},createTile:function(){return e.createElement("div")},_updateZIndex:function(){this._container&&this.options.zIndex!==i&&null!==this.options.zIndex&&(this._container.style.zIndex=this.options.zIndex)},_setAutoZIndex:function(t){for(var e,i=this.getPane().children,n=-t(-(1/0),1/0),s=0,o=i.length;o>s;s++)e=i[s].style.zIndex,i[s]!==this._container&&e&&(n=t(n,+e));isFinite(n)&&(this.options.zIndex=n+t(-1,1),this._updateZIndex())},_updateOpacity:function(){var t=this.options.opacity;if(!s.Browser.ielt9&&!this._map._fadeAnimated)return void s.DomUtil.setOpacity(this._container,t);var e=+new Date,i=!1;for(var n in this._tiles){var o=this._tiles[n];if(o.current&&o.loaded&&!o.active){var a=Math.min(1,(e-o.loaded)/200);1>a?(s.DomUtil.setOpacity(o.el,t*a),i=!0):(s.DomUtil.setOpacity(o.el,t),o.active=!0,this._pruneTiles())}}i&&(s.Util.cancelAnimFrame(this._fadeFrame),this._fadeFrame=s.Util.requestAnimFrame(this._updateOpacity,this))},_initContainer:function(){this._container||(this._container=s.DomUtil.create("div","leaflet-layer"),this._updateZIndex(),this.options.opacity<1&&this._updateOpacity(),this.getPane().appendChild(this._container))},_updateLevels:function(){var t=this._tileZoom,e=this.options.maxZoom;for(var i in this._levels)this._levels[i].el.children.length||i===t?this._levels[i].el.style.zIndex=e-Math.abs(t-i):(s.DomUtil.remove(this._levels[i].el),delete this._levels[i]);var n=this._levels[t],o=this._map;return n||(n=this._levels[t]={},n.el=s.DomUtil.create("div","leaflet-tile-container leaflet-zoom-animated",this._container),n.el.style.zIndex=e,n.origin=o.project(o.unproject(o.getPixelOrigin()),t).round(),n.zoom=t,this._setZoomTransform(n,o.getCenter(),o.getZoom()),s.Util.falseFn(n.el.offsetWidth)),this._level=n,n},_pruneTiles:function(){var t,e;for(t in this._tiles)e=this._tiles[t],e.retain=e.current;for(t in this._tiles)if(e=this._tiles[t],e.current&&!e.active){var i=e.coords;this._retainParent(i.x,i.y,i.z,i.part,i.z-5)||this._retainChildren(i.x,i.y,i.z,i.part,i.z+2)}for(t in this._tiles)this._tiles[t].retain||this._removeTile(t)},_removeAllTiles:function(){for(var t in this._tiles)this._removeTile(t)},_retainParent:function(t,e,i,n,s){var o=Math.floor(t/1.2),a=Math.floor(e/1.2),r=i-1,l=o+":"+a+":"+r+":"+n,h=this._tiles[l];return h&&h.active?(h.retain=!0,!0):(h&&h.loaded&&(h.retain=!0),r>s?this._retainParent(o,a,r,n,s):!1)},_retainChildren:function(t,e,i,n,s){for(var o=1.2*t;1.2*t+2>o;o++)for(var a=1.2*e;1.2*e+2>a;a++){var r=Math.floor(o)+":"+Math.floor(a)+":"+(i+1)+":"+n,l=this._tiles[r];l&&l.active?l.retain=!0:(l&&l.loaded&&(l.retain=!0),s>i+1&&this._retainChildren(o,a,i+1,n,s))}},_viewReset:function(t){this._reset(this._map.getCenter(),this._map.getZoom(),t&&t.hard)},_animateZoom:function(t){this._reset(t.center,t.zoom,!1,!0,t.noUpdate)},_reset:function(t,e,i,n,o){var a=Math.round(e),r=this._tileZoom!==a;o||!i&&!r||(this._abortLoading&&this._abortLoading(),this._tileZoom=a,r&&(this._updateTileTwips(),this._updateMaxBounds()),this._updateLevels(),this._resetGrid(),s.Browser.mobileWebkit||this._update(t,a),n||this._pruneTiles()),this._setZoomTransforms(t,e)},_updateTileTwips:function(){var t=Math.pow(1.2,this._map.options.zoom-this._tileZoom);this._tileWidthTwips=Math.round(this.options.tileWidthTwips*t),this._tileHeightTwips=Math.round(this.options.tileHeightTwips*t)},_updateMaxBounds:function(t){if(this._docWidthTwips!==i&&this._docHeightTwips!==i){var e=new s.Point(this._docWidthTwips/this.options.tileWidthTwips,this._docHeightTwips/this.options.tileHeightTwips);e=e.multiplyBy(this._tileSize);var n=this._map.getZoomScale(this._map.getZoom(),10),o=new s.Point(0,0);o=this._map.unproject(o.multiplyBy(n));var a=new s.Point(e.x,e.y);a=this._map.unproject(a.multiplyBy(n)),(""===this._documentInfo||t)&&this._map.setMaxBounds(new s.LatLngBounds(o,a));var r=new s.Point(this._docWidthTwips/this._tileWidthTwips,this._docHeightTwips/this._tileHeightTwips);r=r.multiplyBy(this._tileSize),this._docPixelSize={x:r.x,y:r.y},this._map.fire("docsize",{x:r.x,y:r.y})}},_checkSpreadSheetBounds:function(t){var e=this._map.getSize(),i=this._map.getZoomScale(t),n=this._docWidthTwips/this._tileWidthTwips*this._tileSize*i,o=this._docHeightTwips/this._tileHeightTwips*this._tileSize*i;n<e.x||o<e.y?(n=Math.max(n,e.x),o=Math.max(o,e.y),this._map.options._origMaxBounds||(this._map.options._origMaxBounds=this._map.options.maxBounds),i=this._map.options.crs.scale(1),this._map.setMaxBounds(new s.LatLngBounds(this._map.unproject(new s.Point(0,0)),this._map.unproject(new s.Point(n*i,o*i))))):this._map.options._origMaxBounds&&(this._map.setMaxBounds(this._map.options._origMaxBounds),this._map.options._origMaxBounds=null)},_updateScrollOffset:function(){var t=this._map.project(this._map.getCenter()),e=t.subtract(this._map.getSize().divideBy(2)),i=Math.round(e.x<0?0:e.x),n=Math.round(e.y<0?0:e.y);this._map.fire("updatescrolloffset",{x:i,y:n})},_setZoomTransforms:function(t,e){for(var i in this._levels)this._setZoomTransform(this._levels[i],t,e)},_setZoomTransform:function(t,e,i){var n=this._map.getZoomScale(i,t.zoom),o=t.origin.multiplyBy(n).subtract(this._map._getNewPixelOrigin(e,i)).round();
s.DomUtil.setTransform(t.el,o,n)},_resetGrid:function(){var t=this._map,e=t.options.crs,n=this._tileSize=this._getTileSize(),s=this._tileZoom;this._tileWidthTwips===i&&(this._tileWidthTwips=this.options.tileWidthTwips),this._tileHeightTwips===i&&(this._tileHeightTwips=this.options.tileHeightTwips);var o=this._map.getPixelWorldBounds(this._tileZoom);o&&(this._globalTileRange=this._pxBoundsToTileRange(o)),this._wrapX=e.wrapLng&&[Math.floor(t.project([0,e.wrapLng[0]],s).x/n),Math.ceil(t.project([0,e.wrapLng[1]],s).x/n)],this._wrapY=e.wrapLat&&[Math.floor(t.project([e.wrapLat[0],0],s).y/n),Math.ceil(t.project([e.wrapLat[1],0],s).y/n)]},_getTileSize:function(){return this.options.tileSize},_moveStart:function(){this._resetPreFetching()},_move:function(){this._update(),this._resetPreFetching(!0),this._onCurrentPageUpdate()},_update:function(t,n){var o=this._map;if(o&&""!==this._documentInfo){t===i&&(t=o.getCenter()),n===i&&(n=Math.round(o.getZoom()));var a=o.getPixelBounds(t,n),r=this._pxBoundsToTileRange(a),l=[];for(var h in this._tiles)(this._keyToTileCoords(h).z!==n||this._keyToTileCoords(h).part!==this._selectedPart)&&(this._tiles[h].current=!1);for(var d=!0,u=r.min.y;u<=r.max.y;u++)for(var c=r.min.x;c<=r.max.x;c++){var p=new s.Point(c,u);if(p.z=n,p.part=this._selectedPart,this._isValidTile(p)){h=this._tileCoordsToKey(p);var _=this._tiles[h];_?(_.current=!0,d=!1):l.push(p)}}if(0!==l.length){if(d){this._map._socket.sendMessage("canceltiles");for(h in this._tiles)this._tiles[h].loaded||(s.DomUtil.remove(this._tiles[h].el),delete this._tiles[h],this._debug&&(this._debugCancelledTiles++,this._debugShowTileData()));this._emptyTilesCount=0}this._noTilesToLoad()&&this.fire("loading");var m=e.createDocumentFragment();this._addTiles(l,m),this._level.el.appendChild(m)}}},_updateOnChangePart:function(){var t=this._map;if(t&&""!==this._documentInfo){var i,n,o,a=t.getCenter(),r=Math.round(t.getZoom()),l=t.getPixelBounds(a,r),h=this._pxBoundsToTileRange(l),d=[];for(i in this._tiles)(this._keyToTileCoords(i).z!==r||this._keyToTileCoords(i).part!==this._selectedPart)&&(this._tiles[i].current=!1);for(var u=!0,c=h.min.y;c<=h.max.y;c++)for(var p=h.min.x;p<=h.max.x;p++)n=new s.Point(p,c),n.z=r,n.part=this._selectedPart,this._isValidTile(n)&&(i=this._tileCoordsToKey(n),o=this._tiles[i],o?(o.current=!0,u=!1):d.push(n));if(0!==d.length){if(u){this._map._socket.sendMessage("canceltiles");for(i in this._tiles)o=this._tiles[i],o.loaded||(s.DomUtil.remove(o.el),delete this._tiles[i],this._debug&&this._debugDataCancelledTiles&&(this._debugCancelledTiles++,this._debugDataCancelledTiles.setPrefix("Cancelled tiles: "+this._debugCancelledTiles)));this._emptyTilesCount=0}this._noTilesToLoad()&&this.fire("loading");var _=e.createDocumentFragment(),m="",g="";for(p=0;p<d.length;p++){n=d[p];var f=this._getTilePos(n);if(i=this._tileCoordsToKey(n),n.part===this._selectedPart&&(o=this.createTile(this._wrapCoords(n),s.bind(this._tileReady,this,n)),this._initTile(o),this.createTile.length<2&&setTimeout(s.bind(this._tileReady,this,n,null,o),0),s.DomUtil.setPosition(o,f,!0),this._tiles[i]={el:o,coords:n,current:!0},_.appendChild(o),this.fire("tileloadstart",{tile:o,coords:n})),this._tileCache[i])o.src=this._tileCache[i];else{var v=this._coordsToTwips(n);""!==m&&(m+=","),m+=v.x,""!==g&&(g+=","),g+=v.y}}if(""!==m&&""!==g){var y="tilecombine part="+this._selectedPart+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+m+" tileposy="+g+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips;this._map._socket.sendMessage(y,"")}this._level.el.appendChild(_)}}},_isValidTile:function(t){return t.x<0||t.y<0?!1:t.x*this._tileWidthTwips>=this._docWidthTwips||t.y*this._tileHeightTwips>=this._docHeightTwips?!1:!0},_keyToBounds:function(t){return this._tileCoordsToBounds(this._keyToTileCoords(t))},_tileCoordsToBounds:function(t){var e=this._map,i=this._getTileSize(),n=t.multiplyBy(i),o=n.add([i,i]),a=e.wrapLatLng(e.unproject(n,t.z)),r=e.wrapLatLng(e.unproject(o,t.z));return new s.LatLngBounds(a,r)},_tileCoordsToKey:function(t){return t.x+":"+t.y+":"+t.z+":"+t.part},_keyToTileCoords:function(t){var e=t.split(":"),i=new s.Point(+e[0],+e[1]);return i.z=+e[2],i.part=+e[3],i},_removeTile:function(t){var e=this._tiles[t];e&&(this._tiles[t]._invalidCount>0||(this._tileCache[t]=e.el.src),!e.loaded&&this._emptyTilesCount>0&&(this._emptyTilesCount-=1),s.DomUtil.remove(e.el),this._debug&&this._debugInfo&&this._tiles[t]._debugPopup&&this._debugInfo.removeLayer(this._tiles[t]._debugPopup),delete this._tiles[t],this.fire("tileunload",{tile:e.el,coords:this._keyToTileCoords(t)}))},_initTile:function(t){s.DomUtil.addClass(t,"leaflet-tile"),t.style.width=this._tileSize+"px",t.style.height=this._tileSize+"px",t.onselectstart=s.Util.falseFn,t.onmousemove=s.Util.falseFn,s.Browser.ielt9&&this.options.opacity<1&&s.DomUtil.setOpacity(t,this.options.opacity),s.Browser.android&&!s.Browser.android23&&(t.style.WebkitBackfaceVisibility="hidden")},_addTiles:function(t,e){for(var i,n,o=0;o<t.length;o++){i=t[o];var a=this._getTilePos(i);if(n=this._tileCoordsToKey(i),i.part===this._selectedPart){var r=this.createTile(this._wrapCoords(i),s.bind(this._tileReady,this,i));this._initTile(r),this.createTile.length<2&&setTimeout(s.bind(this._tileReady,this,i,null,r),0),s.DomUtil.setPosition(r,a,!0),this._tiles[n]={el:r,coords:i,current:!0},e.appendChild(r),this.fire("tileloadstart",{tile:r,coords:i})}this._tileCache[n]&&(r.src=this._tileCache[n])}t.sort(function(t,e){return t.y!==e.y?t.y-e.y:t.x-e.x});for(var l=[];t.length>0;)if(i=t[0],n=this._tileCoordsToKey(i),this._tileCache[n]||i.part!==this._selectedPart)t.splice(0,1);else{var h=[i],d=new s.Point(i.x,i.y);t.splice(0,1);var u=!1,c=!1;for(o=0;o<t.length;){var p=t[o];if(c||p.y!==d.y+1||(u=!0,++d.y),p.y>d.y)break;u?p.x<=d.x&&p.y<=d.y?(h.push(p),t.splice(o,1)):(c=!0,++o):p.y===d.y&&p.x===d.x+1?(++d.x,h.push(p),t.splice(o,1)):(u=!0,++o)}l.push(h)}for(var _,m,g=0;g<l.length;++g)if(h=l[g],1===h.length)i=h[0],n=this._tileCoordsToKey(i),_=this._coordsToTwips(i),m="tile part="+i.part+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+_.x+" tileposy="+_.y+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips,this._map._socket.sendMessage(m,n);else{var f="",v="";for(o=0;o<h.length;o++)i=h[o],_=this._coordsToTwips(i),""!==f&&(f+=","),f+=_.x,""!==v&&(v+=","),v+=_.y;_=this._coordsToTwips(i),m="tilecombine part="+i.part+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+f+" tileposy="+v+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips,this._map._socket.sendMessage(m,"")}},_tileReady:function(t,e,i){if(this._map){e&&this.fire("tileerror",{error:e,tile:i,coords:t});var n=this._tileCoordsToKey(t);i=this._tiles[n],i&&(i.loaded=+new Date,this._map._fadeAnimated?(s.DomUtil.setOpacity(i.el,0),s.Util.cancelAnimFrame(this._fadeFrame),this._fadeFrame=s.Util.requestAnimFrame(this._updateOpacity,this)):i.active=!0,s.DomUtil.addClass(i.el,"leaflet-tile-loaded"),this._noTilesToLoad()&&(this.fire("load"),this._pruneTiles()))}},_getTilePos:function(t){return t.multiplyBy(this._tileSize).subtract(this._level.origin)},_wrapCoords:function(t){var e=new s.Point(this._wrapX?s.Util.wrapNum(t.x,this._wrapX):t.x,this._wrapY?s.Util.wrapNum(t.y,this._wrapY):t.y);return e.z=t.z,e.part=t.part,e},_pxBoundsToTileRange:function(t){return new s.Bounds(t.min.divideBy(this._tileSize).floor().subtract([1,1]),t.max.divideBy(this._tileSize).ceil())},_twipsToCoords:function(t){return new s.Point(Math.round(t.x/t.tileWidth),Math.round(t.y/t.tileHeight))},_coordsToTwips:function(t){return new s.Point(t.x*this._tileWidthTwips,t.y*this._tileHeightTwips)},_twipsToLatLng:function(t,e){var i=new s.Point(t.x/this._tileWidthTwips*this._tileSize,t.y/this._tileHeightTwips*this._tileSize);return this._map.unproject(i,e)},_latLngToTwips:function(t,e){var i=this._map.project(t,e);return new s.Point(Math.round(i.x/this._tileSize*this._tileWidthTwips),Math.round(i.y/this._tileSize*this._tileHeightTwips))},_twipsToPixels:function(t){return new s.Point(t.x/this._tileWidthTwips*this._tileSize,t.y/this._tileHeightTwips*this._tileSize)},_pixelsToTwips:function(t){return new s.Point(t.x*this._tileWidthTwips/this._tileSize,t.y*this._tileHeightTwips/this._tileSize)},_twipsRectangleToPixelBounds:function(t){var e=t.match(/\d+/g);if(!e)return null;var i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);return new s.Bounds(this._twipsToPixels(i),this._twipsToPixels(o))},_twipsRectanglesToPixelBounds:function(t){t=t.split(";");for(var e=[],i=0;i<t.length;i++){var n=this._twipsRectangleToPixelBounds(t[i]);n&&e.push(n)}return e},_noTilesToLoad:function(){for(var t in this._tiles)if(!this._tiles[t].loaded)return!1;return!0},_preFetchTiles:function(){if(!(this._emptyTilesCount>0)){var t=this._map.getCenter(),i=this._map.getZoom(),n=10,o=5;if("edit"===this._map._permission&&(n=5,o=3),this._preFetchBorder)a=this._preFetchBorder;else if(this._selectedPart!==this._preFetchPart)var a=this._preFetchBorder=new s.Bounds(new s.Point(0,0),new s.Point(0,0));else{var r=this._map.getPixelBounds(t,i);a=this._pxBoundsToTileRange(r),this._preFetchBorder=a}for(var l=[],h=[],d={},u=0;(a.min.x>=0||a.min.y>=0||a.max.x*this._tileWidthTwips<this._docWidthTwips||a.max.y*this._tileHeightTwips<this._docHeightTwips)&&n>0&&o>u;){for(var c=a.min.x;c<=a.max.x;c++){var p=new s.Point(c,a.max.y);l.push(p)}for(c=a.min.x;c<=a.max.x;c++)p=new s.Point(c,a.min.y),l.push(p);for(c=a.min.y;c<=a.max.y;c++)p=new s.Point(a.max.x,c),l.push(p);for(c=a.min.y;c<=a.max.y;c++)p=new s.Point(a.min.x,c),l.push(p);for(c=0;c<l.length&&n>0;c++){p=l[c],p.z=i,p.part=this._preFetchPart;var _=this._tileCoordsToKey(p);!this._isValidTile(p)||this._tiles[_]||this._tileCache[_]||d[_]||(d[_]=!0,h.push(p),n-=1)}0!==n&&(a.min.x>=0&&(a.min.x-=1),a.min.y>=0&&(a.min.y-=1),a.max.x*this._tileWidthTwips<=this._docWidthTwips&&(a.max.x+=1),a.max.y*this._tileHeightTwips<=this._docHeightTwips&&(a.max.y+=1),u+=1)}if(h.length>0){var m=e.createDocumentFragment();this._addTiles(h,m),this._level.el.appendChild(m)}}},_resetPreFetching:function(t){if(this._map){clearInterval(this._tilesPreFetcher),clearTimeout(this._preFetchIdle),t&&(this._preFetchBorder=null);var e=750,i=5e3;this._preFetchPart=this._selectedPart,this._preFetchIdle=setTimeout(s.bind(function(){this._tilesPreFetcher=setInterval(s.bind(this._preFetchTiles,this),e)},this),i)}}}),s.gridLayer=function(t){return new s.GridLayer(t)},"function"!=typeof String.prototype.startsWith&&(String.prototype.startsWith=function(t){return this.slice(0,t.length)===t}),s.Compatibility={clipboardGet:function(e){var i=null;return e.clipboardData?i=e.clipboardData.getData("text/plain"):t.clipboardData&&(i=t.clipboardData.getData("Text")),i},clipboardSet:function(e,i){e.clipboardData?e.clipboardData.setData("text/plain",i):t.clipboardData&&t.clipboardData.setData("Text",i)}},s.TileLayer=s.GridLayer.extend({options:{maxZoom:18,subdomains:"abc",errorTileUrl:"",zoomOffset:0,maxNativeZoom:null,tms:!1,zoomReverse:!1,detectRetina:!0,crossOrigin:!1,previewInvalidationTimeout:1e3},initialize:function(t,e){this._url=t,e=s.setOptions(this,e),this._tileWidthPx=e.tileSize,this._tileHeightPx=e.tileSize,e.detectRetina&&s.Browser.retina&&e.maxZoom>0&&(this._tileWidthPx*=2,this._tileHeightPx*=2,e.zoomOffset++,e.minZoom=Math.max(0,e.minZoom),e.maxZoom--),"string"==typeof e.subdomains&&(e.subdomains=e.subdomains.split("")),s.Browser.android||this.on("tileunload",this._onTileRemove),this._docType=e.docType,this._documentInfo="",this._visibleCursor=new s.LatLngBounds(new s.LatLng(0,0),new s.LatLng(0,0)),this._isCursorOverlayVisible=!1,this._isCursorVisible=!0,this._graphicSelectionTwips=new s.Bounds(new s.Point(0,0),new s.Point(0,0)),this._graphicSelection=new s.LatLngBounds(new s.LatLng(0,0),new s.LatLng(0,0)),this._cellCursorTwips=new s.Bounds(new s.Point(0,0),new s.Point(0,0)),this._cellCursor=s.LatLngBounds.createDefault(),this._prevCellCursor=s.LatLngBounds.createDefault(),this._cellCursorOnPgUp=null,this._cellCursorOnPgDn=null,this._viewCursors={},this._cellViewCursors={},this._viewSelections={},this._graphicViewMarkers={},this._lastValidPart=-1,this._cursorMarker=null,this._graphicMarker=null,this._selectionHandles={},["start","end"].forEach(s.bind(function(t){this._selectionHandles[t]=s.marker(new s.LatLng(0,0),{icon:s.divIcon({className:"leaflet-selection-marker-"+t,iconSize:null}),draggable:!0})},this)),this._emptyTilesCount=0,this._msgQueue=[],this._toolbarCommandValues={},this._previewInvalidations=[],this._partPageRectanglesTwips=[],this._partPageRectanglesPixels=[],this._clientZoom="tilepixelwidth="+this._tileWidthPx+" tilepixelheight="+this._tileHeightPx+" tiletwipwidth="+this.options.tileWidthTwips+" tiletwipheight="+this.options.tileHeightTwips,this._invalidateClientVisibleArea()},onAdd:function(t){this._initContainer(),this._getToolbarCommandsValues(),this._selections=new s.LayerGroup,"readonly"!==this.options.permission&&t.addLayer(this._selections),this._viewLayerGroup=new s.LayerGroup,"readonly"!==this.options.permission&&t.addLayer(this._viewLayerGroup),this._debug=t.options.debug,this._debug&&this._debugInit(),this._searchResultsLayer=new s.LayerGroup,t.addLayer(this._searchResultsLayer),this._levels={},this._tiles={},this._tileCache={},t._fadeAnimated=!1,this._viewReset(),t.on("drag resize zoomend",this._updateScrollOffset,this),t.on("copy",this._onCopy,this),t.on("cut",this._onCut,this),t.on("paste",this._onPaste,this),t.on("dragover",this._onDragOver,this),t.on("drop",this._onDrop,this),t.on("zoomend",this._onUpdateCursor,this),t.on("zoomend",this._onUpdatePartPageRectangles,this),"spreadsheet"===this._docType&&t.on("zoomend",this._onCellCursorShift,this),t.on("zoomend",this._updateClientZoom,this),t.on("zoomend",s.bind(this.eachView,this,this._viewCursors,this._onUpdateViewCursor,this,!1)),t.on("resize zoomend",this._invalidateClientVisibleArea,this),t.on("dragstart",this._onDragStart,this),t.on("requestloksession",this._onRequestLOKSession,this),t.on("error",this._mapOnError,this),t.options.autoFitWidth!==!1&&t.on("resize",this._fitWidthZoom,this),t.on("statusindicator",function(t){"alltilesloaded"===t.statusType&&"spreadsheet"===this._docType&&this._onCellCursorShift(!0)},this),t.on("updatepermission",function(t){"edit"!==t.perm&&this._clearSelections()},this);for(var e in this._selectionHandles)this._selectionHandles[e].on("drag dragend",this._onSelectionHandleDrag,this);this._textArea=t._textArea,this._textArea.focus(),t.setPermission(this.options.permission),t.fire("statusindicator",{statusType:"loleafletloaded"})},getEvents:function(){var t={viewreset:this._viewReset,movestart:this._moveStart,moveend:this._move};return this.options.updateWhenIdle||(t.move=s.Util.throttle(this._move,this.options.updateInterval,this)),this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},registerExportFormat:function(t,e){this._exportFormats||(this._exportFormats=[]),this._exportFormats.push({label:t,format:e})},setUrl:function(t,e){return this._url=t,e||this.redraw(),this},createTile:function(t,i){var n=e.createElement("img");return n.onload=s.bind(this._tileOnLoad,this,i,n),n.onerror=s.bind(this._tileOnError,this,i,n),this.options.crossOrigin&&(n.crossOrigin=""),n.alt="",this._emptyTilesCount+=1,n},_getToolbarCommandsValues:function(){for(var t=0;t<this._map.unoToolbarCommands.length;t++){var e=this._map.unoToolbarCommands[t];this._map._socket.sendMessage("commandvalues command="+e)}},_onMessage:function(t,e){if(t.startsWith("commandvalues:"))this._onCommandValuesMsg(t);else if(t.startsWith("cursorvisible:"))this._onCursorVisibleMsg(t);else if(t.startsWith("downloadas:"))this._onDownloadAsMsg(t);else if(t.startsWith("error:"))this._onErrorMsg(t);else if(t.startsWith("getchildid:"))this._onGetChildIdMsg(t);else if(t.startsWith("graphicselection:"))this._onGraphicSelectionMsg(t);else if(t.startsWith("cellcursor:"))this._onCellCursorMsg(t);else if(t.startsWith("cellformula:"))this._onCellFormulaMsg(t);else if(t.startsWith("hyperlinkclicked:"))this._onHyperlinkClickedMsg(t);else if(t.startsWith("invalidatecursor:"))this._onInvalidateCursorMsg(t);else if(t.startsWith("invalidatetiles:")){var i=t.substring("invalidatetiles:".length+1);if(i.startsWith("EMPTY")){var n="invalidatetiles: ";if("text"===this._docType)n+="part=0 ";else{var s=parseInt(i.substring("EMPTY".length+1));n+="part="+(isNaN(s)?this._selectedPart:s)+" "}n+="x=0 y=0 ",n+="width="+this._docWidthTwips+" ",n+="height="+this._docHeightTwips,this._onInvalidateTilesMsg(n)}else this._onInvalidateTilesMsg(t)}else t.startsWith("mousepointer:")?this._onMousePointerMsg(t):t.startsWith("partpagerectangles:")?this._onPartPageRectanglesMsg(t):t.startsWith("renderfont:")?this._onRenderFontMsg(t,e):t.startsWith("searchnotfound:")?this._onSearchNotFoundMsg(t):t.startsWith("searchresultselection:")?this._onSearchResultSelection(t):t.startsWith("setpart:")?this._onSetPartMsg(t):t.startsWith("statechanged:")?this._onStateChangedMsg(t):t.startsWith("status:")?this._onStatusMsg(t):t.startsWith("textselection:")?this._onTextSelectionMsg(t):t.startsWith("textselectioncontent:")?this._onTextSelectionContentMsg(t):t.startsWith("textselectionend:")?this._onTextSelectionEndMsg(t):t.startsWith("textselectionstart:")?this._onTextSelectionStartMsg(t):t.startsWith("tile:")?this._onTileMsg(t,e):t.startsWith("unocommandresult:")?this._onUnoCommandResultMsg(t):t.startsWith("contextmenu:")?this._onContextMenuMsg(t):t.startsWith("invalidateviewcursor:")?this._onInvalidateViewCursorMsg(t):t.startsWith("viewcursorvisible:")?this._onViewCursorVisibleMsg(t):t.startsWith("cellviewcursor:")?this._onCellViewCursorMsg(t):t.startsWith("viewinfo:")?this._onViewInfoMsg(t):t.startsWith("textviewselection:")?this._onTextViewSelectionMsg(t):t.startsWith("graphicviewselection:")&&this._onGraphicViewSelectionMsg(t)},toggleTileDebugMode:function(){this._invalidateClientVisibleArea(),this._debug=!this._debug,this._debug?(this._debugInfo&&(map.addLayer(this._debugInfo),map.addLayer(this._debugInfo2),$(".leaflet-control-layers-expanded").css("display","block")),this._debugInit()):(map.removeLayer(this._debugInfo),map.removeLayer(this._debugInfo2),$(".leaflet-control-layers-expanded").css("display","none")),this._onMessage("invalidatetiles: EMPTY",null)},_onCommandValuesMsg:function(t){var e=t.indexOf("{");if(-1!==e){var i=JSON.parse(t.substring(e));".uno:DocumentRepair"===i.commandName?this._onDocumentRepair(i):".uno:CellCursor"===i.commandName?this._onCellCursorMsg(i.commandValues):-1!==this._map.unoToolbarCommands.indexOf(i.commandName)?(this._toolbarCommandValues[i.commandName]=i.commandValues,this._map.fire("updatetoolbarcommandvalues",{commandName:i.commandName,commandValues:i.commandValues})):this._map.fire("commandvalues",{commandName:i.commandName,commandValues:i.commandValues})}},_onCellFormulaMsg:function(t){var e=t.substring(13);this._selectionTextContent=e,this._map.fire("cellformula",{formula:e})},_onCursorVisibleMsg:function(t){var e=t.match("cursorvisible: true");this._isCursorVisible=e?!0:!1,this._isCursorOverlayVisible=!0,this._onUpdateCursor()},_onDownloadAsMsg:function(t){var i=this._map._socket.parseServerCmd(t),n=e.createElement("a");n.href=this._map.options.server;var o=this._map.options.webserver+"/"+this._map.options.urlPrefix+"/"+encodeURIComponent(this._map.options.doc)+"/"+i.jail+"/"+i.dir+"/"+i.name;this._map.hideBusy(),"print"===i.id?s.Browser.gecko||s.Browser.edge||this._map.options.print===!1?this._map.fire("print",{url:o}):this._map.fire("filedownloadready",{url:o}):"slideshow"===i.id?this._map.fire("slidedownloadready",{url:o}):"export"===i.id&&(this._map._fileDownloader.src=o)},_onErrorMsg:function(t){var e=this._map._socket.parseServerCmd(t),n=1;"load"===e.errorCmd?n=2:("save"===e.errorCmd||"saveas"===e.errorCmd)&&(n=5);var s=-1;e.errorCode!==i&&(s=e.errorCode),this._map.fire("error",{cmd:e.errorCmd,kind:e.errorKind,id:n,code:s})},_onGetChildIdMsg:function(t){var e=this._map._socket.parseServerCmd(t);this._map.fire("childid",{id:e.id})},_onGraphicSelectionMsg:function(t){if(t.match("EMPTY"))this._graphicSelectionTwips=new s.Bounds(new s.Point(0,0),new s.Point(0,0)),this._graphicSelection=new s.LatLngBounds(new s.LatLng(0,0),new s.LatLng(0,0));else{var e=t.match(/\d+/g),i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);this._graphicSelectionTwips=new s.Bounds(i,o),this._graphicSelection=new s.LatLngBounds(this._twipsToLatLng(i,this._map.getZoom()),this._twipsToLatLng(o,this._map.getZoom()))}this._onUpdateGraphicSelection()},_onGraphicViewSelectionMsg:function(t){t=t.substring("graphicviewselection:".length+1);var e=JSON.parse(t),i=parseInt(e.viewId);if(i!==this._viewId&&this._map._viewInfo[i]){var n=e.selection.match(/\d+/g);if(this._graphicViewMarkers[i]=this._graphicViewMarkers[i]||{},this._graphicViewMarkers[i].part=parseInt(e.part),null!=n){var o=new s.Point(parseInt(n[0]),parseInt(n[1])),a=new s.Point(parseInt(n[2]),parseInt(n[3])),r=o.add(a);this._graphicViewMarkers[i].bounds=new s.LatLngBounds(this._twipsToLatLng(o,this._map.getZoom()),this._twipsToLatLng(r,this._map.getZoom()))}else this._graphicViewMarkers[i].bounds=s.LatLngBounds.createDefault();this._onUpdateGraphicViewSelection(i)}},_onCellCursorMsg:function(t){if(this._cellCursor||(this._cellCursor=s.LatLngBounds.createDefault()),this._prevCellCursor||(this._prevCellCursor=s.LatLngBounds.createDefault()),t.match("EMPTY"))this._cellCursorTwips=new s.Bounds(new s.Point(0,0),new s.Point(0,0)),this._cellCursor=s.LatLngBounds.createDefault();else{var e=t.match(/\d+/g),i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);this._cellCursorTwips=new s.Bounds(i,o),this._cellCursor=new s.LatLngBounds(this._twipsToLatLng(i,this._map.getZoom()),this._twipsToLatLng(o,this._map.getZoom()))}var a=0,r=0,l=function(t){return t>0?1:0>t?-1:t};this._isEmptyRectangle(this._prevCellCursor)||this._isEmptyRectangle(this._cellCursor)||(a=l(this._cellCursor.getWest()-this._prevCellCursor.getWest()),r=l(this._cellCursor.getNorth()-this._prevCellCursor.getNorth()));var h=!1;this._isEmptyRectangle(this._cellCursor)||this._prevCellCursor.equals(this._cellCursor)||((this._cellCursorOnPgUp&&this._cellCursorOnPgUp.equals(this._prevCellCursor)||this._cellCursorOnPgDn&&this._cellCursorOnPgDn.equals(this._prevCellCursor))&&(h=!0),this._prevCellCursor=new s.LatLngBounds(this._cellCursor.getSouthWest(),this._cellCursor.getNorthEast())),this._onUpdateCellCursor(a,r,h)},_onDocumentRepair:function(t){this._docRepair||(this._docRepair=s.control.documentRepair()),this._docRepair.isVisible()||(this._docRepair.addTo(this._map),this._docRepair.fillActions(t),this._map.enable(!1),this._docRepair.show())},_onSpecialChar:function(t,e){this._specialChar||(this._specialChar=s.control.characterMap()),this._specialChar.isVisible()||(this._specialChar.addTo(this._map),this._specialChar.fillFontNames(t,e),this._map.enable(!1),this._specialChar.show())},_onMousePointerMsg:function(t){t=t.substring(14),t=s.Cursor.getCustomCursor(t)||t,this._map._container.style.cursor!==t&&(this._map._container.style.cursor=t)},_onHyperlinkClickedMsg:function(t){var e=t.substring(18);this._map.fire("hyperlinkclicked",{url:e})},_onInvalidateCursorMsg:function(t){var e=t.match(/\d+/g),i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);this._visibleCursor=new s.LatLngBounds(this._twipsToLatLng(i,this._map.getZoom()),this._twipsToLatLng(o,this._map.getZoom())),this._visibleCursorOnLostFocus=this._visibleCursor,this._isCursorOverlayVisible=!0,this._onUpdateCursor()},_onInvalidateViewCursorMsg:function(t){t=t.substring("invalidateviewcursor:".length+1);var e=JSON.parse(t),i=parseInt(e.viewId);if(i!==this._viewId&&this._map._viewInfo[i]){var n=e.rectangle.match(/\d+/g),o=new s.Point(parseInt(n[0]),parseInt(n[1])),a=new s.Point(parseInt(n[2]),parseInt(n[3])),r=o.add(a);this._viewCursors[i]=this._viewCursors[i]||{},this._viewCursors[i].bounds=new s.LatLngBounds(this._twipsToLatLng(o,this._map.getZoom()),this._twipsToLatLng(r,this._map.getZoom())),this._viewCursors[i].part=parseInt(e.part),"undefined"==typeof this._viewCursors[i].visible&&(this._viewCursors[i].visible=!0),this._onUpdateViewCursor(i)}},_onCellViewCursorMsg:function(t){t=t.substring("cellviewcursor:".length+1);var e=JSON.parse(t),i=parseInt(e.viewId);if(i!==this._viewId){if(this._cellViewCursors[i]=this._cellViewCursors[i]||{},this._cellViewCursors[i].bounds||(this._cellViewCursors[i].bounds=s.LatLngBounds.createDefault()),e.rectangle.match("EMPTY"))this._cellViewCursors[i].bounds=s.LatLngBounds.createDefault();else{var n=e.rectangle.match(/\d+/g),o=new s.Point(parseInt(n[0]),parseInt(n[1])),a=new s.Point(parseInt(n[2]),parseInt(n[3])),r=o.add(a);this._cellViewCursors[i].bounds=new s.LatLngBounds(this._twipsToLatLng(o,this._map.getZoom()),this._twipsToLatLng(r,this._map.getZoom()))}this._cellViewCursors[i].part=parseInt(e.part),this._onUpdateCellViewCursor(i)}},_onUpdateCellViewCursor:function(t){if(this._cellViewCursors[t]&&this._cellViewCursors[t].bounds){var e=this._cellViewCursors[t].marker,i=this._cellViewCursors[t].part;if(this._isEmptyRectangle(this._cellViewCursors[t].bounds)||this._selectedPart!==i)e&&this._viewLayerGroup.removeLayer(e);else{if(e)e.setBounds(this._cellViewCursors[t].bounds);else{var n=s.LOUtil.rgbToHex(this._map.getViewColor(t));e=s.rectangle(this._cellViewCursors[t].bounds,{fill:!1,color:n,weight:2}),this._cellViewCursors[t].marker=e,e.bindPopup(this._map.getViewName(t),{autoClose:!1,autoPan:!1,backgroundColor:n,color:"white",closeButton:!1})}this._viewLayerGroup.addLayer(e)}}},goToCellViewCursor:function(t){if(this._cellViewCursors[t]&&!this._isEmptyRectangle(this._cellViewCursors[t].bounds)){if(!this._map.getBounds().contains(this._cellViewCursors[t].bounds)){var e=this._map.getBounds(),i=0,n=0,o=Math.abs(this._cellViewCursors[t].bounds.getEast()-this._cellViewCursors[t].bounds.getWest())/4,a=Math.abs(this._cellViewCursors[t].bounds.getSouth()-this._cellViewCursors[t].bounds.getNorth())/4;if(this._cellViewCursors[t].bounds.getWest()<e.getWest()?i=this._cellViewCursors[t].bounds.getWest()-e.getWest()-o:this._cellViewCursors[t].bounds.getEast()>e.getEast()&&(i=this._cellViewCursors[t].bounds.getEast()-e.getEast()+o),this._cellViewCursors[t].bounds.getNorth()>e.getNorth()?n=this._cellViewCursors[t].bounds.getNorth()-e.getNorth()+a:this._cellViewCursors[t].bounds.getSouth()<e.getSouth()&&(n=this._cellViewCursors[t].bounds.getSouth()-e.getSouth()-a),0!==i||0!==n){var r=e.getCenter();r.lat+=i,r.lat+=n;var l=this._map.project(r);l=l.subtract(this._map.getSize().divideBy(2)),l.x=Math.round(l.x<0?0:l.x),l.y=Math.round(l.y<0?0:l.y),this._map.fire("scrollto",{x:l.x,y:l.y})}}var h=s.LOUtil.rgbToHex(this._map.getViewColor(t));this._cellViewCursors[t].marker.bindPopup(this._map.getViewName(t),{autoClose:!1,autoPan:!1,backgroundColor:h,color:"white",closeButton:!1})}},_onViewCursorVisibleMsg:function(t){t=t.substring("viewcursorvisible:".length+1);var e=JSON.parse(t),i=parseInt(e.viewId);i!==this._viewId&&this._map._viewInfo[i]&&("undefined"!=typeof this._viewCursors[i]&&(this._viewCursors[i].visible="true"===e.visible),this._onUpdateViewCursor(i))},_addView:function(t,e,i,n){0===n&&"text"!==this._map.getDocType()&&(n=s.LOUtil.getViewIdColor(t)),this._map.addView(t,e,i,n),"undefined"!=typeof this._viewCursors[t]&&(this._viewCursors[t]={}),this._onUpdateViewCursor(t)},_removeView:function(t){this._viewSelections[t]&&this._viewSelections[t].selection&&this._viewLayerGroup.removeLayer(this._viewSelections[t].selection),"undefined"!=typeof this._viewCursors[t]&&(this._viewCursors[t].visible=!1,this._onUpdateViewCursor(t),delete this._viewCursors[t]),this._map.removeView(t)},removeAllViews:function(){for(var t in this._map._viewInfo)this._removeView(parseInt(t))},_onViewInfoMsg:function(t){t=t.substring("viewinfo: ".length);var e=JSON.parse(t);this._map.fire("viewinfo",e);var i=[];for(var n in e)parseInt(e[n].id)in this._map._viewInfo||this._addView(e[n].id,e[n].userid,e[n].username,e[n].color),i.push(e[n].id);for(n in this._map._viewInfo)-1===i.indexOf(parseInt(n))&&this._removeView(parseInt(n))},_onPartPageRectanglesMsg:function(t){t=t.substring(19);var e=t.split(";");this._partPageRectanglesTwips=[],this._partPageRectanglesPixels=[];for(var i=0;i<e.length;i++){var n=e[i].match(/\d+/g);if(!n)return;var o=new s.Point(parseInt(n[0]),parseInt(n[1])),a=new s.Point(parseInt(n[2]),parseInt(n[3])),r=o.add(a),l=new s.Bounds(o,r);this._partPageRectanglesTwips.push(l);var h=new s.Bounds(this._twipsToPixels(o),this._twipsToPixels(r));this._partPageRectanglesPixels.push(h)}this._map.fire("partpagerectangles",{pixelRectangles:this._partPageRectanglesPixels,twipsRectangles:this._partPageRectanglesTwips}),this._onCurrentPageUpdate()},_onRenderFontMsg:function(t,e){var i=this._map._socket.parseServerCmd(t);this._map.fire("renderfont",{font:i.font,"char":i["char"],img:e})},_onSearchNotFoundMsg:function(t){this._clearSearchResults();var e=t.substring(16);this._map.fire("search",{originalPhrase:e,count:0})},_onSearchResultSelection:function(t){t=t.substring(23);for(var e=JSON.parse(t),i=e.searchString,n=e.searchResultSelection.length,s=e.highlightAll,o=[],a=0;a<e.searchResultSelection.length;a++)o.push({part:parseInt(e.searchResultSelection[a].part),rectangles:this._twipsRectanglesToPixelBounds(e.searchResultSelection[a].rectangles),twipsRectangles:e.searchResultSelection[a].rectangles});n>1&&(this._clearSearchResults(),this._searchResults=o,this._map.setPart(o[0].part)),this._searchTerm=i,this._map.fire("search",{originalPhrase:i,count:n,highlightAll:s,results:o})},_clearSearchResults:function(){this._searchResults=null,this._searchTerm=null,this._searchResultsLayer.clearLayers()},_drawSearchResults:function(){if(this._searchResults){this._searchResultsLayer.clearLayers();for(var t=0;t<this._searchResults.length;t++){var e=this._searchResults[t];if(e.part===this._selectedPart){for(var i="#CCCCCC",n=e.twipsRectangles.match(/\d+/g),o=[],a=0;a<n.length;a+=4){var r=new s.Point(parseInt(n[a]),parseInt(n[a+1])),l=new s.Point(parseInt(n[a+2]),parseInt(n[a+3])),h=r.add(new s.Point(l.x,0)),d=r.add(new s.Point(0,l.y)),u=r.add(l);o.push([d,u,r,h])}var c=s.PolyUtil.rectanglesToPolygons(o,this),p=new s.Polygon(c,{pointerEvents:"none",fillColor:i,fillOpacity:.25,weight:2,opacity:.25});this._searchResultsLayer.addLayer(p)}}}},_onStateChangedMsg:function(t){t=t.substr(14);var e=t.indexOf("="),i=-1!==e?t.substr(0,e):"",n=-1!==e?t.substr(e+1):"";this._map.fire("commandstatechanged",{commandName:i,state:n})},_onUnoCommandResultMsg:function(t){t=t.substring(18);var e=JSON.parse(t),i=e.commandName;if("true"===e.success)var n=!0;else"false"===e.success&&(n=!1);this._map.hideBusy(),this._map.fire("commandresult",{commandName:i,success:n,result:e.result})},_onContextMenuMsg:function(t){t=t.substring(13);var e=JSON.parse(t);this._map.fire("locontextmenu",e)},_onTextSelectionMsg:function(t){var e=t.match(/\d+/g);if(this._selections.clearLayers(),null!=e){for(var i=[],n=0;n<e.length;n+=4){var o=new s.Point(parseInt(e[n]),parseInt(e[n+1])),a=new s.Point(parseInt(e[n+2]),parseInt(e[n+3])),r=o.add(new s.Point(a.x,0)),l=o.add(new s.Point(0,a.y)),h=o.add(a);i.push([l,h,o,r])}var d=s.PolyUtil.rectanglesToPolygons(i,this),u=new s.Polygon(d,{pointerEvents:"none",fillColor:"#43ACE8",fillOpacity:.25,weight:2,opacity:.25});this._selections.addLayer(u),this._selectionContentRequest&&clearTimeout(this._selectionContentRequest),this._selectionContentRequest=setTimeout(s.bind(function(){this._map._socket.sendMessage("gettextselection mimetype=text/plain;charset=utf-8")},this),100)}this._onUpdateTextSelection()},_onTextViewSelectionMsg:function(t){t=t.substring("textviewselection:".length+1);var e=JSON.parse(t),i=parseInt(e.viewId),n=parseInt(e.part);
if(i!==this._viewId&&this._map._viewInfo[i]){var o=e.selection.match(/\d+/g);if(this._viewSelections[i]=this._viewSelections[i]||{},null!=o){for(var a=[],r=0;r<o.length;r+=4){var l=new s.Point(parseInt(o[r]),parseInt(o[r+1])),h=new s.Point(parseInt(o[r+2]),parseInt(o[r+3])),d=l.add(new s.Point(h.x,0)),u=l.add(new s.Point(0,h.y)),c=l.add(h);a.push([u,c,l,d])}this._viewSelections[i].part=n,this._viewSelections[i].polygons=s.PolyUtil.rectanglesToPolygons(a,this)}else this._viewSelections[i].polygons=null;this._onUpdateTextViewSelection(i)}},_onTextSelectionContentMsg:function(t){this._selectionTextContent=t.substr(22)},_onTextSelectionEndMsg:function(t){var e=t.match(/\d+/g);if(null!=e&&"edit"===this._map._permission){var i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);this._textSelectionEnd=new s.LatLngBounds(this._twipsToLatLng(i,this._map.getZoom()),this._twipsToLatLng(o,this._map.getZoom()))}else this._textSelectionEnd=null},_onTextSelectionStartMsg:function(t){var e=t.match(/\d+/g);if(null!=e&&"edit"===this._map._permission){var i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);this._textSelectionStart=new s.LatLngBounds(this._twipsToLatLng(i,this._map.getZoom()),this._twipsToLatLng(o,this._map.getZoom()))}else this._textSelectionStart=null},_onTileMsg:function(t,e){var n=this._map._socket.parseServerCmd(t),o=this._twipsToCoords(n);o.z=n.zoom,o.part=n.part;var a=this._tileCoordsToKey(o),r=this._tiles[a];if(this._debug&&r){if(r._debugLoadCount?(r._debugLoadCount++,this._debugLoadCount++):(r._debugLoadCount=1,r._debugInvalidateCount=1),!r._debugPopup){var l=this._keyToBounds(a);r._debugPopup=s.popup({className:"debug",offset:new s.Point(0,0),autoPan:!1,closeButton:!1,closeOnClick:!1}).setLatLng(new s.LatLng(l.getSouth(),l.getWest()+(l.getEast()-l.getWest())/5)),this._debugInfo.addLayer(r._debugPopup),this._debugTiles[a]&&this._debugInfo.removeLayer(this._debugTiles[a]),r._debugTile=s.rectangle(l,{color:"blue",weight:1,fillOpacity:0,pointerEvents:"none"}),this._debugTiles[a]=r._debugTile,r._debugTime=this._debugGetTimeArray(),this._debugInfo.addLayer(r._debugTile)}0===r._debugTime.date?r._debugPopup.setContent("requested: "+this._tiles[a]._debugInvalidateCount+"<br>received: "+this._tiles[a]._debugLoadCount):r._debugPopup.setContent("requested: "+this._tiles[a]._debugInvalidateCount+"<br>received: "+this._tiles[a]._debugLoadCount+"<br>"+this._debugSetTimes(r._debugTime,+new Date-r._debugTime.date).replace(/, /g,"<br>")),r._debugTile&&r._debugTile.setStyle({fillOpacity:"cached"===n.renderid?.1:0,fillColor:"yellow"}),this._debugShowTileData()}n.id!==i?this._map.fire("tilepreview",{tile:e,id:n.id,width:n.width,height:n.height,part:n.part,docType:this._docType}):r?(this._tiles[a]._invalidCount>0&&(this._tiles[a]._invalidCount-=1),r.loaded||(this._emptyTilesCount-=1,0===this._emptyTilesCount&&this._map.fire("statusindicator",{statusType:"alltilesloaded"})),r.el.src=e):"true"===n.preFetch&&(this._tileCache[a]=e),s.Log.log(t,s.INCOMING,a)},_tileOnLoad:function(t,e){t(null,e)},_tileOnError:function(t,e,i){var n=this.options.errorTileUrl;n&&(e.src=n),t(i,e)},_mapOnError:function(t){t.msg&&"edit"===this._map._permission&&this._map.setPermission("view")},_onTileRemove:function(t){t.tile.onload=null},_clearSelections:function(){this._isCursorOverlayVisible=!1,this._onUpdateCursor(),this._selections.clearLayers(),this._onUpdateTextSelection(),this._graphicSelection=null,this._onUpdateGraphicSelection(),this._cellCursor=null,this._onUpdateCellCursor()},_postMouseEvent:function(t,e,i,n,s,o){this._clientZoom&&(this._map._socket.sendMessage("clientzoom "+this._clientZoom),this._clientZoom=null),this._map._socket.sendMessage("mouse type="+t+" x="+e+" y="+i+" count="+n+" buttons="+s+" modifier="+o),"buttondown"===t&&this._clearSearchResults()},_postKeyboardEvents:function(t,e,i){if(("number"==typeof e.length||"number"==typeof i.length)&&e.length===i.length)for(var n=0;n<e.length;n++)this._postKeyboardEvent(t,e[n],i[n])},_postKeyboardEvent:function(t,e,i){if("spreadsheet"===this._docType&&this._prevCellCursor&&"input"===t)if(1030===i){if(this._cellCursorOnPgUp)return;this._cellCursorOnPgUp=new s.LatLngBounds(this._prevCellCursor.getSouthWest(),this._prevCellCursor.getNorthEast())}else if(1031===i){if(this._cellCursorOnPgDn)return;this._cellCursorOnPgDn=new s.LatLngBounds(this._prevCellCursor.getSouthWest(),this._prevCellCursor.getNorthEast())}if(this._clientZoom&&(this._map._socket.sendMessage("clientzoom "+this._clientZoom),this._clientZoom=null),this._clientVisibleArea){var n=this._map._container.getBoundingClientRect(),o=this._pixelsToTwips(new s.Point(n.left,n.top)),a=this._pixelsToTwips(new s.Point(n.width,n.height)),r="clientvisiblearea x="+Math.round(o.x)+" y="+Math.round(o.y)+" width="+Math.round(a.x)+" height="+Math.round(a.y);this._map._socket.sendMessage(r),this._clientVisibleArea=!1}this._map._socket.sendMessage("key type="+t+" char="+e+" key="+i)},_postSelectGraphicEvent:function(t,e,i){this._map._socket.sendMessage("selectgraphic type="+t+" x="+e+" y="+i)},_postSelectTextEvent:function(t,e,i){this._map._socket.sendMessage("selecttext type="+t+" x="+e+" y="+i)},_isEmptyRectangle:function(t){return t?t.getSouthWest().equals(new s.LatLng(0,0))&&t.getNorthEast().equals(new s.LatLng(0,0)):!0},_onUpdateCursor:function(t){var e=(s.bounds(this._map.latLngToLayerPoint(this._visibleCursor.getSouthWest()),this._map.latLngToLayerPoint(this._visibleCursor.getNorthEast())),this._visibleCursor.getNorthWest());if(!t&&!this._map.getBounds().contains(this._visibleCursor)&&this._isCursorVisible){var i=this._map.project(e);i=i.subtract(this._map.getSize().divideBy(2)),i.x=Math.round(i.x<0?0:i.x),i.y=Math.round(i.y<0?0:i.y),this._selectionHandles.start&&this._selectionHandles.start.isDragged||this._selectionHandles.end&&this._selectionHandles.end.isDragged||this._map.fire("scrollto",{x:i.x,y:i.y})}this._updateCursorAndOverlay(),this.eachView(this._viewCursors,function(t){var e=t.marker;e&&e.setOpacity(this._map.hasLayer(this._cursorMarker)&&this._cursorMarker.getLatLng().equals(e.getLatLng())?0:1)},this,!0)},_updateCursorAndOverlay:function(t){if("edit"===this._map._permission&&this._isCursorVisible&&this._isCursorOverlayVisible&&!this._isEmptyRectangle(this._visibleCursor)){var e=s.bounds(this._map.latLngToLayerPoint(this._visibleCursor.getSouthWest()),this._map.latLngToLayerPoint(this._visibleCursor.getNorthEast())),i=this._visibleCursor.getNorthWest();this._cursorMarker?this._cursorMarker.setLatLng(i,e.getSize().multiplyBy(this._map.getZoomScale(this._map.getZoom()))):this._cursorMarker=s.cursor(i,e.getSize().multiplyBy(this._map.getZoomScale(this._map.getZoom())),{blink:!0}),this._map.addLayer(this._cursorMarker)}else this._cursorMarker&&(this._map.removeLayer(this._cursorMarker),this._isCursorOverlayVisible=!1)},_onUpdateViewCursor:function(t){if("object"==typeof this._viewCursors[t]&&"object"==typeof this._viewCursors[t].bounds){var e=s.bounds(this._map.latLngToLayerPoint(this._viewCursors[t].bounds.getSouthWest()),this._map.latLngToLayerPoint(this._viewCursors[t].bounds.getNorthEast())),i=this._viewCursors[t].bounds.getNorthWest(),n=this._viewCursors[t].marker,o=this._viewCursors[t].visible,a=this._viewCursors[t].part;if(!o||this._isEmptyRectangle(this._viewCursors[t].bounds)||"text"!==this._docType&&this._selectedPart!==a)n&&this._viewLayerGroup.removeLayer(n);else{if(n)n.setLatLng(i,e.getSize().multiplyBy(this._map.getZoomScale(this._map.getZoom())));else{var r={color:s.LOUtil.rgbToHex(this._map.getViewColor(t)),blink:!1,header:!0,headerTimeout:3e3,zIndex:t,headerName:this._map.getViewName(t)};n=s.cursor(i,e.getSize().multiplyBy(this._map.getZoomScale(this._map.getZoom())),r),this._viewCursors[t].marker=n}n.setOpacity(this._map.hasLayer(this._cursorMarker)&&this._cursorMarker.getLatLng().equals(n.getLatLng())?0:1),this._viewLayerGroup.addLayer(n)}}},goToViewCursor:function(t){if(t===this._viewId)return void this._onUpdateCursor();if(this._viewCursors[t]&&this._viewCursors[t].visible&&!this._isEmptyRectangle(this._viewCursors[t].bounds)){if(!this._map.getBounds().contains(this._viewCursors[t].bounds)){var e=this._viewCursors[t].bounds.getNorthWest(),i=this._map.project(e);i=i.subtract(this._map.getSize().divideBy(2)),i.x=Math.round(i.x<0?0:i.x),i.y=Math.round(i.y<0?0:i.y),this._map.fire("scrollto",{x:i.x,y:i.y})}this._viewCursors[t].marker.showCursorHeader()}},_onUpdateTextViewSelection:function(t){t=parseInt(t);var e=this._viewSelections[t].polygons,i=this._viewSelections[t].selection,n=this._viewSelections[t].part;!e||"text"!==this._docType&&this._selectedPart!==n?i&&this._viewLayerGroup.removeLayer(i):(i&&this._viewLayerGroup.removeLayer(i),i=new s.Polygon(e,{pointerEvents:"none",fillColor:s.LOUtil.rgbToHex(this._map.getViewColor(t)),fillOpacity:.25,weight:2,opacity:.25}),this._viewSelections[t].selection=i,this._viewLayerGroup.addLayer(i))},_onUpdateGraphicViewSelection:function(t){var e=this._graphicViewMarkers[t].bounds,i=this._graphicViewMarkers[t].marker,n=this._graphicViewMarkers[t].part;if(this._isEmptyRectangle(e)||"text"!==this._docType&&this._selectedPart!==n)i&&this._viewLayerGroup.removeLayer(i);else{if(i)i.setBounds(e);else{var o=s.LOUtil.rgbToHex(this._map.getViewColor(t));i=s.rectangle(e,{pointerEvents:"auto",fill:!1,color:o}),i.bindPopup(this._map.getViewName(t),{autoClose:!1,autoPan:!1,backgroundColor:o,color:"white",closeButton:!1}),this._graphicViewMarkers[t].marker=i}this._viewLayerGroup.addLayer(i)}},eachView:function(t,e,i,n){for(var s in t)e.call(i,n?t[s]:s)},_onGraphicEdit:function(t){if(t.handle){var e=this._latLngToTwips(t.handle.getLatLng());"editstart"===t.type?(this._graphicMarker.isDragged=!0,this._postSelectGraphicEvent("start",Math.min(e.x,this._graphicSelectionTwips.max.x-1),Math.min(e.y,this._graphicSelectionTwips.max.y-1))):"editend"===t.type&&(this._postSelectGraphicEvent("end",e.x,e.y),this._graphicMarker.isDragged=!1)}},_onSelectionHandleDrag:function(t){if("drag"===t.type){t.target.isDragged=!0;var e=t.target._icon.getBoundingClientRect(),i=s.point(e.left,e.top),n=s.point(t.originalEvent.pageX,t.originalEvent.pageY).subtract(t.target.dragging._draggable.startOffset);if(!n.equals(i)){var o=n.subtract(i);t.target.dragging._draggable._startPoint=t.target.dragging._draggable._startPoint.add(o),t.target.dragging._draggable._startPos=t.target.dragging._draggable._startPos.add(o),t.target.dragging._draggable._newPos=t.target.dragging._draggable._newPos.add(o),t.target.dragging._draggable._updatePosition()}var a=new s.Point(n.x-this._map._container.getBoundingClientRect().left,n.y-this._map._container.getBoundingClientRect().top);a=a.add(t.target.dragging._draggable.startOffset),this._map.fire("handleautoscroll",{pos:a,map:this._map})}"dragend"===t.type&&(t.target.isDragged=!1,this._textArea.focus(),this._map.fire("scrollvelocity",{vx:0,vy:0}));var r=this._latLngToTwips(t.target.getLatLng());this._selectionHandles.start===t.target?this._postSelectTextEvent("start",r.x,r.y):this._selectionHandles.end===t.target&&this._postSelectTextEvent("end",r.x,r.y)},_onUpdateGraphicSelection:function(){if(this._graphicSelection&&!this._isEmptyRectangle(this._graphicSelection)){if(this._graphicMarker&&(this._graphicMarker.off("editstart editend",this._onGraphicEdit,this),this._map.removeLayer(this._graphicMarker)),"edit"!==this._map._permission)return;if(this._graphicMarker=s.rectangle(this._graphicSelection,{pointerEvents:"none",fill:!1}),this._visibleCursor=this._visibleCursorOnLostFocus=this._graphicMarker._bounds,!this._graphicMarker)return void this._map.fire("error",{msg:"Graphic marker initialization",cmd:"marker",kind:"failed",id:1});this._graphicMarker.editing.enable(),this._graphicMarker.on("editstart editend",this._onGraphicEdit,this),this._map.addLayer(this._graphicMarker)}else this._graphicMarker&&(this._graphicMarker.off("editstart editend",this._onGraphicEdit,this),this._map.removeLayer(this._graphicMarker),this._graphicMarker.isDragged=!1)},_onUpdateCellCursor:function(t,e,i){if(this._cellCursor&&!this._isEmptyRectangle(this._cellCursor)){var n=this._map.getBounds();if(!n.contains(this._cellCursor)){var o=0,a=0;if(i){var r=(n.getNorth()-n.getSouth())/2,l=this._cellCursorOnPgUp?this._cellCursorOnPgUp:this._cellCursorOnPgDn;a=this._cellCursor.getNorth()-l.getNorth(),this._cellCursor.getNorth()>n.getNorth()+a?a=this._cellCursor.getNorth()-n.getNorth()+r:this._cellCursor.getSouth()<n.getSouth()+a&&(a=this._cellCursor.getNorth()-n.getNorth()+r)}else{var h=Math.abs(this._cellCursor.getEast()-this._cellCursor.getWest())/4,d=Math.abs(this._cellCursor.getSouth()-this._cellCursor.getNorth())/4;-1===t&&this._cellCursor.getWest()<n.getWest()?o=this._cellCursor.getWest()-n.getWest()-h:1===t&&this._cellCursor.getEast()>n.getEast()&&(o=this._cellCursor.getEast()-n.getEast()+h),1===e&&this._cellCursor.getNorth()>n.getNorth()?a=this._cellCursor.getNorth()-n.getNorth()+d:-1===e&&this._cellCursor.getSouth()<n.getSouth()&&(a=this._cellCursor.getSouth()-n.getSouth()-d)}if(0!==o||0!==a){var u=n.getCenter();u.lng+=o,u.lat+=a;var c=this._map.project(u);c=c.subtract(this._map.getSize().divideBy(2)),c.x=Math.round(c.x<0?0:c.x),c.y=Math.round(c.y<0?0:c.y),this._map.fire("scrollto",{x:c.x,y:c.y})}}if(i&&(this._cellCursorOnPgUp=null,this._cellCursorOnPgDn=null),this._cellCursorMarker&&this._map.removeLayer(this._cellCursorMarker),this._cellCursorMarker=s.rectangle(this._cellCursor,{pointerEvents:"none",fill:!1,color:"#000000",weight:2}),!this._cellCursorMarker)return void this._map.fire("error",{msg:"Cell Cursor marker initialization",cmd:"cellCursor",kind:"failed",id:1});this._map.addLayer(this._cellCursorMarker)}else this._cellCursorMarker&&this._map.removeLayer(this._cellCursorMarker)},_onUpdateTextSelection:function(){var t,e;for(var i in this._selectionHandles)"start"===i?t=this._selectionHandles[i]:"end"===i&&(e=this._selectionHandles[i]);if(0!==this._selections.getLayers().length||t.isDragged||e.isDragged){if(!t||!e||this._isEmptyRectangle(this._textSelectionStart)||this._isEmptyRectangle(this._textSelectionEnd))return;var n=this._map.project(this._textSelectionStart.getSouthWest()),o=this._map.project(this._textSelectionEnd.getSouthWest()),a=this._map.project(t.getLatLng());if(a.distanceTo(o)<a.distanceTo(n)&&t._icon&&e._icon){s.DomUtil.removeClass(t._icon,"leaflet-selection-marker-start"),s.DomUtil.removeClass(e._icon,"leaflet-selection-marker-end"),s.DomUtil.addClass(t._icon,"leaflet-selection-marker-end"),s.DomUtil.addClass(e._icon,"leaflet-selection-marker-start");var r=t;t=e,e=r}else t._icon&&e._icon&&(s.DomUtil.removeClass(t._icon,"leaflet-selection-marker-end"),s.DomUtil.removeClass(e._icon,"leaflet-selection-marker-start"),s.DomUtil.addClass(t._icon,"leaflet-selection-marker-start"),s.DomUtil.addClass(e._icon,"leaflet-selection-marker-end"));if(!t.isDragged){var l=this._map.project(this._textSelectionStart.getSouthWest());l=l.subtract(new s.Point(0,2)),l=this._map.unproject(l),t.setLatLng(l),this._map.addLayer(t)}e.isDragged||(l=this._map.project(this._textSelectionEnd.getSouthEast()),l=l.subtract(new s.Point(0,2)),l=this._map.unproject(l),e.setLatLng(l),this._map.addLayer(e))}else{this._textSelectionStart=null,this._textSelectionEnd=null;for(i in this._selectionHandles)this._map.removeLayer(this._selectionHandles[i]),this._selectionHandles[i].isDragged=!1}},_onCopy:function(t){t=t.originalEvent,t.preventDefault(),this._selectionTextContent&&(s.Compatibility.clipboardSet(t,this._selectionTextContent),this._selectionTextHash=this._selectionTextContent,this._map._socket.sendMessage("uno .uno:Copy"))},_onCut:function(t){t=t.originalEvent,t.preventDefault(),this._selectionTextContent&&(s.Compatibility.clipboardSet(t,this._selectionTextContent),this._selectionTextHash=this._selectionTextContent,this._map._socket.sendMessage("uno .uno:Cut"))},_onPaste:function(t){t=t.originalEvent,t.preventDefault();var e=s.Compatibility.clipboardGet(t);e&&(e===this._selectionTextHash?this._map._socket.sendMessage("uno .uno:Paste"):this._map._socket.sendMessage("paste mimetype=text/plain;charset=utf-8\n"+e))},_onDragOver:function(t){t=t.originalEvent,t.preventDefault()},_onDrop:function(t){var e=t.latlng,i=this._map._docLayer,n=i._latLngToTwips(e),s=1,o=1,a=this._map.keyboard.modifier;this._postMouseEvent("buttondown",n.x,n.y,s,o,a),this._postMouseEvent("buttonup",n.x,n.y,s,o,a),t=t.originalEvent,t.preventDefault();for(var r=t.dataTransfer.types,l=!1,h=0;!l&&h<r.length;h++)"text/html"===r[h]&&(l=!0);var d=!1;for(h=0;!d&&h<r.length;h++){var u=r[h];if("text/html"===u)this._map._socket.sendMessage("paste mimetype=text/html\n"+t.dataTransfer.getData(u)),d=!0;else if("text/plain"!==u||l){if("Files"===u)for(var c=t.dataTransfer.files,p=0;p<c.length;++p){var _=c[p];if(_.type.match(/image.*/)){var m=new FileReader;m.onload=this._onFileLoadFunc(_),m.readAsArrayBuffer(_),d=!0}}}else this._map._socket.sendMessage("paste mimetype=text/plain;charset=utf-8\n"+t.dataTransfer.getData(u)),d=!0}},_onFileLoadFunc:function(t){var e=this._map._socket;return function(i){var n=new Blob(["paste mimetype="+t.type+"\n",i.target.result]);e.sendMessage(n)}},_onDragStart:function(){this._map.on("moveend",this._updateScrollOffset,this)},_onRequestLOKSession:function(){this._map._socket.sendMessage("requestloksession")},_fitWidthZoom:function(t,e){var i=t?t.newSize:this._map.getSize(),n=i.x*this._map.options.tileWidthTwips/this._tileSize;if(e=e?e:this._map.options.zoom,"spreadsheet"!==this._docType){var s=this._map.options.crs.scale(1);if(this._docWidthTwips>0){var o=n/this._docWidthTwips,a=this._map.options.zoom+Math.floor(Math.log(o)/Math.log(s));a=Math.max(1,a),a=Math.min(e,a),this._map.setZoom(a,{animate:!1})}}},_onCurrentPageUpdate:function(){var t=this._map.project(this._map.getCenter());if(this._partPageRectanglesPixels&&this._currentPage>=0&&!(this._currentPage>=this._partPageRectanglesPixels.length)&&!this._partPageRectanglesPixels[this._currentPage].contains(t))for(var e=0;e<this._partPageRectanglesPixels.length;e++)if(this._partPageRectanglesPixels[e].contains(t))return this._currentPage=e,void this._map.fire("pagenumberchanged",{currentPage:this._currentPage,pages:this._pages,docType:this._docType})},_onUpdatePartPageRectangles:function(){if(this._partPageRectanglesPixels.length>0){this._partPageRectanglesPixels=[];for(var t=0;t<this._partPageRectanglesTwips.length;t++){var e=new s.Bounds(this._twipsToPixels(this._partPageRectanglesTwips[t].min),this._twipsToPixels(this._partPageRectanglesTwips[t].max));this._partPageRectanglesPixels.push(e)}this._map.fire("partpagerectangles",{pixelRectangles:this._partPageRectanglesPixels,twipsRectangles:this._partPageRectanglesTwips})}},_onCellCursorShift:function(t){(this._cellCursorMarker||t)&&this._map._socket.sendMessage("commandvalues command=.uno:CellCursor?outputHeight="+this._tileWidthPx+"&outputWidth="+this._tileHeightPx+"&tileHeight="+this._tileWidthTwips+"&tileWidth="+this._tileHeightTwips)},_invalidatePreviews:function(){if(this._map._docPreviews&&this._previewInvalidations.length>0){for(var t={},e=0;e<this._previewInvalidations.length;e++){var i=this._previewInvalidations[e];for(var n in this._map._docPreviews){var o=this._map._docPreviews[n];if(o.index>=0&&"text"===this._docType)this._partPageRectanglesTwips.length>o.index&&i.intersects(this._partPageRectanglesTwips[o.index])&&(t[n]=!0);else if(o.index>=0)(o.index===this._selectedPart||o.index===this._prevSelectedPart&&this._prevSelectedPartNeedsUpdate)&&(o.index===this._prevSelectedPart&&(this._prevSelectedPartNeedsUpdate=!1),t[n]=!0);else{var a=new s.Bounds(new s.Point(o.tilePosX,o.tilePosY),new s.Point(o.tilePosX+o.tileWidth,o.tilePosY+o.tileHeight));(o.part===this._selectedPart||o.part===this._prevSelectedPart&&this._prevSelectedPartNeedsUpdate)&&i.intersects(a)&&(o.index===this._prevSelectedPart&&(this._prevSelectedPartNeedsUpdate=!1),t[n]=!0)}}}for(n in t)o=this._map._docPreviews[n],o.autoUpdate&&(o.index>=0?this._map.getPreview(o.id,o.index,o.maxWidth,o.maxHeight,{autoUpdate:!0,broadcast:!0}):this._map.getCustomPreview(o.id,o.part,o.width,o.height,o.tilePosX,o.tilePosY,o.tileWidth,o.tileHeight,{autoUpdate:!0}))}this._previewInvalidations=[]},_updateClientZoom:function(){this._clientZoom="tilepixelwidth="+this._tileWidthPx+" tilepixelheight="+this._tileHeightPx+" tiletwipwidth="+this._tileWidthTwips+" tiletwipheight="+this._tileHeightTwips},_invalidateClientVisibleArea:function(){if(this._debug){this._debugInfo.clearLayers();for(var t in this._tiles)this._tiles[t]._debugPopup=null,this._tiles[t]._debugTile=null}this._clientVisibleArea=!0},_debugGetTimeArray:function(){return{count:0,ms:0,best:Number.MAX_SAFE_INTEGER,worst:0,date:0}},_debugShowTileData:function(){this._debugData.loadCount.setPrefix("Total of requested tiles: "+this._debugInvalidateCount+", received: "+this._debugLoadCount+", cancelled: "+this._debugCancelledTiles)},_debugInit:function(){if(this._debugTiles={},this._debugInvalidBounds={},this._debugInvalidBoundsMessage={},this._debugTimeout(),this._debugId=0,this._debugCancelledTiles=0,this._debugLoadCount=0,this._debugInvalidateCount=0,this._debugRenderCount=0,!this._debugData){this._debugData={},this._debugDataNames=["tileCombine","fromKeyInputToInvalidate","ping","loadCount"];for(var t=0;t<this._debugDataNames.length;t++)this._debugData[this._debugDataNames[t]]=s.control.attribution({prefix:"",position:"bottomleft"}).addTo(map);this._debugInfo=new s.LayerGroup,this._debugInfo2=new s.LayerGroup,this._debugTyper=new s.LayerGroup,map.addLayer(this._debugInfo),map.addLayer(this._debugInfo2);var e={"Tile overlays":this._debugInfo,"Screen overlays":this._debugInfo2,Typing:this._debugTyper};s.control.layers({},e,{collapsed:!1}).addTo(map),this._map.on("layeradd",function(t){if(t.layer===this._debugTyper)this._debugTypeTimeout();else if(t.layer===this._debugInfo2)for(var e=0;e<this._debugDataNames.length;e++)this._debugData[this._debugDataNames[e]].addTo(map)},this),map.on("layerremove",function(t){if(t.layer===this._debugTyper)clearTimeout(this._debugTypeTimeoutId);else if(t.layer===this._debugInfo2)for(var e in this._debugData)this._debugData[e].remove()},this)}this._debugTimePING=this._debugGetTimeArray(),this._debugPINGQueue=[],this._debugTimeKeypress=this._debugGetTimeArray(),this._debugKeypressQueue=[],this._debugLorem="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.",this._debugLorem+=" "+this._debugLorem+"\n",this._debugLoremPos=0},_debugSetTimes:function(t,e){return e<t.best&&(t.best=e),e>t.worst&&(t.worst=e),t.ms+=e,t.count++,"best: "+t.best+" ms, avg: "+Math.round(t.ms/t.count)+" ms, worst: "+t.worst+" ms, last: "+e+" ms"},_debugAddInvalidationRectangle:function(t,e,i){var n=+new Date,o=new s.LatLngBounds(this._twipsToLatLng(t,this._tileZoom),this._twipsToLatLng(e,this._tileZoom)),a=s.rectangle(o,{color:"red",weight:1,opacity:1,fillOpacity:.4,pointerEvents:"none"});this._debugInvalidBounds[this._debugId]=a,this._debugInvalidBoundsMessage[this._debugId]=i,this._debugId++,this._debugInfo.addLayer(a);var r=this._debugKeypressQueue.shift();if(r){var l=this._debugSetTimes(this._debugTimeKeypress,n-r);this._debugData.fromKeyInputToInvalidate.setPrefix("Elapsed time between key input and next invalidate: "+l)}this._debugPINGQueue.push(+new Date),this._map._socket.sendMessage("ping")},_debugAddInvalidationData:function(t){t._debugTile&&(t._debugTile.setStyle({fillOpacity:.5,fillColor:"blue"}),t._debugTime.date=+new Date,t._debugInvalidateCount++,this._debugInvalidateCount++)},_debugAddInvalidationMessage:function(t){this._debugInvalidBoundsMessage[this._debugId-1]=t;for(var e="",i=this._debugId-1;i>this._debugId-6;i--)i>=0&&this._debugInvalidBoundsMessage[i]&&(e+=""+i+": "+this._debugInvalidBoundsMessage[i]+" <br>");this._debugData.tileCombine.setPrefix(e),this._debugShowTileData()},_debugTimeout:function(){if(this._debug){for(var t in this._debugInvalidBounds){var e=this._debugInvalidBounds[t],i=e.options.fillOpacity;.04>=i?t<this._debugId-5?(this._debugInfo.removeLayer(e),delete this._debugInvalidBounds[t],delete this._debugInvalidBoundsMessage[t]):e.setStyle({fillOpacity:0,opacity:1-(this._debugId-t)/7}):e.setStyle({fillOpacity:i-.04})}this._debugTimeoutId=setTimeout(function(){map._docLayer._debugTimeout()},50)}},_debugTypeTimeout:function(){var t=this._debugLorem.charCodeAt(this._debugLoremPos%this._debugLorem.length);this._debugKeypressQueue.push(+new Date),t==="\n".charCodeAt(0)?this._postKeyboardEvent("input",0,1280):this._postKeyboardEvent("input",this._debugLorem.charCodeAt(this._debugLoremPos%this._debugLorem.length),0),this._debugLoremPos++,this._debugTypeTimeoutId=setTimeout(function(){map._docLayer._debugTypeTimeout()},50)}}),s.tileLayer=function(t,e){return new s.TileLayer(t,e)},s.TileLayer.WMS=s.TileLayer.extend({defaultWmsParams:{service:"WMS",request:"GetMap",version:"1.1.1",layers:"",styles:"",format:"image/jpeg",transparent:!1},options:{crs:null,uppercase:!1},initialize:function(t,e){this._url=t;var i=s.extend({},this.defaultWmsParams);for(var n in e)n in this.options||(i[n]=e[n]);e=s.setOptions(this,e),i.width=i.height=e.tileSize*(e.detectRetina&&s.Browser.retina?2:1),this.wmsParams=i},onAdd:function(t){this._crs=this.options.crs||t.options.crs,this._wmsVersion=parseFloat(this.wmsParams.version);var e=this._wmsVersion>=1.3?"crs":"srs";this.wmsParams[e]=this._crs.code,s.TileLayer.prototype.onAdd.call(this,t)},getTileUrl:function(t){var e=this._tileCoordsToBounds(t),i=this._crs.project(e.getNorthWest()),n=this._crs.project(e.getSouthEast()),o=(this._wmsVersion>=1.3&&this._crs===s.CRS.EPSG4326?[n.y,i.x,i.y,n.x]:[i.x,n.y,n.x,i.y]).join(","),a=s.TileLayer.prototype.getTileUrl.call(this,t);return a+s.Util.getParamString(this.wmsParams,a,this.options.uppercase)+(this.options.uppercase?"&BBOX=":"&bbox=")+o},setParams:function(t,e){return s.extend(this.wmsParams,t),e||this.redraw(),this}}),s.tileLayer.wms=function(t,e){return new s.TileLayer.WMS(t,e)},s.WriterTileLayer=s.TileLayer.extend({_onInvalidateTilesMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.x===i||e.y===i||e.part===i){var n=t.match(/\d+/g);e.x=parseInt(n[0]),e.y=parseInt(n[1]),e.width=parseInt(n[2]),e.height=parseInt(n[3]),e.part=this._selectedPart}e.part=0;var o=new s.Point(e.x,e.y),a=new s.Point(e.width,e.height),r=o.add(a);this._debug&&this._debugAddInvalidationRectangle(o,r,t);var l=new s.Bounds(o,r),h=this._latLngToTwips(this._map.getBounds().getNorthWest()),d=this._latLngToTwips(this._map.getBounds().getSouthEast()),u=new s.Bounds(h,d),c="",p="",_=!1;for(var m in this._tiles){var g=this._tiles[m].coords,f=this._coordsToTwips(g),v=new s.Point(this._tileWidthTwips,this._tileHeightTwips),y=new s.Bounds(f,f.add(v));l.intersects(y)&&g.part===e.part&&(this._tiles[m]._invalidCount?this._tiles[m]._invalidCount+=1:this._tiles[m]._invalidCount=1,u.intersects(y)?(""!==c&&(c+=","),c+=f.x,""!==p&&(p+=","),p+=f.y,_=!0,this._debug&&this._debugAddInvalidationData(this._tiles[m])):(this._preFetchBorder=null,this._removeTile(m)))}if(_){var w="tilecombine part="+e.part+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+c+" tileposy="+p+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips;this._map._socket.sendMessage(w,""),this._debug&&this._debugAddInvalidationMessage(w)}for(m in this._tileCache){g=this._keyToTileCoords(m);var b=this._map.getZoomScale(g.z);o=new s.Point(this.options.tileWidthTwips/b*g.x,this.options.tileHeightTwips/b*g.y),r=o.add(new s.Point(this.options.tileWidthTwips/b,this.options.tileHeightTwips/b)),y=new s.Bounds(o,r),l.intersects(y)&&delete this._tileCache[m]}this._previewInvalidations.push(l),clearTimeout(this._previewInvalidator),this._previewInvalidator=setTimeout(s.bind(this._invalidatePreviews,this),this.options.previewInvalidationTimeout)},_onSetPartMsg:function(t){var e=parseInt(t.match(/\d+/g)[0]);e!==this._selectedPart&&(this._currentPage=e,this._map.fire("pagenumberchanged",{currentPage:e,pages:this._pages,docType:this._docType}))},_onStatusMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.width&&e.height&&this._documentInfo!==t){var i=e.width!==this._docWidthTwips||e.height!==this._docHeightTwips;i&&(this._docWidthTwips=e.width,this._docHeightTwips=e.height,this._docType=e.type,this._viewId=parseInt(e.viewid),this._updateMaxBounds(!0)),this._documentInfo=t,this._selectedPart=0,this._parts=1,this._currentPage=e.selectedPart,this._pages=e.parts,this._map.fire("pagenumberchanged",{currentPage:this._currentPage,pages:this._pages,docType:this._docType}),this._resetPreFetching(!0),this._update()}}}),s.ImpressTileLayer=s.TileLayer.extend({_onInvalidateTilesMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.x===i||e.y===i||e.part===i){var n=t.match(/\d+/g);e.x=parseInt(n[0]),e.y=parseInt(n[1]),e.width=parseInt(n[2]),e.height=parseInt(n[3]),e.part=this._selectedPart}var o=new s.Point(e.x,e.y),a=new s.Point(e.width,e.height),r=o.add(a);this._debug&&this._debugAddInvalidationRectangle(o,r,t);var l=new s.Bounds(o,r),h=this._latLngToTwips(this._map.getBounds().getNorthWest()),d=this._latLngToTwips(this._map.getBounds().getSouthEast()),u=new s.Bounds(h,d),c="",p="",_=!1;for(var m in this._tiles){var g=this._tiles[m].coords,f=this._coordsToTwips(g),v=new s.Point(this._tileWidthTwips,this._tileHeightTwips),y=new s.Bounds(f,f.add(v));l.intersects(y)&&g.part===e.part&&(this._tiles[m]._invalidCount?this._tiles[m]._invalidCount+=1:this._tiles[m]._invalidCount=1,u.intersects(y)?(""!==c&&(c+=","),c+=f.x,""!==p&&(p+=","),p+=f.y,_=!0,this._debug&&this._debugAddInvalidationData(this._tiles[m])):(this._preFetchBorder=null,this._removeTile(m)))}if(_&&e.part===this._selectedPart){var w="tilecombine part="+e.part+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+c+" tileposy="+p+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips;this._map._socket.sendMessage(w,""),this._debug&&this._debugAddInvalidationMessage(w)}for(m in this._tileCache)if(g=this._keyToTileCoords(m),g.part===e.part){var b=this._map.getZoomScale(g.z);o=new s.Point(this.options.tileWidthTwips/b*g.x,this.options.tileHeightTwips/b*g.y),r=o.add(new s.Point(this.options.tileWidthTwips/b,this.options.tileHeightTwips/b)),y=new s.Bounds(o,r),l.intersects(y)&&delete this._tileCache[m]}e.part===this._selectedPart&&e.part!==this._lastValidPart&&(this._map.fire("updatepart",{part:this._lastValidPart,docType:this._docType}),this._lastValidPart=e.part,this._map.fire("updatepart",{part:e.part,docType:this._docType})),this._previewInvalidations.push(l),clearTimeout(this._previewInvalidator),this._previewInvalidator=setTimeout(s.bind(this._invalidatePreviews,this),this.options.previewInvalidationTimeout)},_onSetPartMsg:function(t){var e=parseInt(t.match(/\d+/g)[0]);e!==this._selectedPart&&(this._map.setPart(e),this._map.fire("setpart",{selectedPart:this._selectedPart}))},_onStatusMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.width&&e.height&&this._documentInfo!==t){this._docWidthTwips=e.width,this._docHeightTwips=e.height,this._docType=e.type,"drawing"===this._docType&&s.DomUtil.addClass(s.DomUtil.get("presentation-controls-wrapper"),"drawing"),this._updateMaxBounds(!0),this._documentInfo=t,this._parts=e.parts,this._viewId=parseInt(e.viewid),this._selectedPart=e.selectedPart,this._resetPreFetching(!0),this._update(),this._preFetchPart!==this._selectedPart&&(this._preFetchPart=this._selectedPart,this._preFetchBorder=null);var i=t.match(/[^\r\n]+/g),n=i.slice(i.length-this._parts);this._map.fire("updateparts",{selectedPart:this._selectedPart,parts:this._parts,docType:this._docType,partNames:n})}}}),s.CalcTileLayer=s.TileLayer.extend({STD_EXTRA_WIDTH:113,twipsToHMM:function(t){return(127*t+36)/72},beforeAdd:function(t){t._addZoomLimit(this),t.on("zoomend",this._onZoomRowColumns,this),
t.on("resize",this._onUpdateViewPort,this)},_onInvalidateTilesMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.x===i||e.y===i||e.part===i){var n=t.match(/\d+/g);e.x=parseInt(n[0]),e.y=parseInt(n[1]),e.width=parseInt(n[2]),e.height=parseInt(n[3]),e.part=this._selectedPart}"text"===this._docType&&(e.part=0);var o=new s.Point(e.x,e.y),a=new s.Point(e.width,e.height),r=o.add(a);this._debug&&this._debugAddInvalidationRectangle(o,r,t);var l=new s.Bounds(o,r),h=this._latLngToTwips(this._map.getBounds().getNorthWest()),d=this._latLngToTwips(this._map.getBounds().getSouthEast()),u=new s.Bounds(h,d),c="",p="",_=!1;for(var m in this._tiles){var g=this._tiles[m].coords,f=this._coordsToTwips(g),v=new s.Point(this._tileWidthTwips,this._tileHeightTwips),y=new s.Bounds(f,f.add(v));l.intersects(y)&&g.part===e.part&&(this._tiles[m]._invalidCount?this._tiles[m]._invalidCount+=1:this._tiles[m]._invalidCount=1,u.intersects(y)?(""!==c&&(c+=","),c+=f.x,""!==p&&(p+=","),p+=f.y,_=!0,this._debug&&this._debugAddInvalidationData(this._tiles[m])):(this._preFetchBorder=null,this._removeTile(m)))}if(_&&e.part===this._selectedPart){var w="tilecombine part="+e.part+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+c+" tileposy="+p+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips;this._map._socket.sendMessage(w,""),this._debug&&this._debugAddInvalidationMessage(w)}for(m in this._tileCache)if(g=this._keyToTileCoords(m),g.part===e.part){var b=this._map.getZoomScale(g.z);o=new s.Point(this.options.tileWidthTwips/b*g.x,this.options.tileHeightTwips/b*g.y),r=o.add(new s.Point(this.options.tileWidthTwips/b,this.options.tileHeightTwips/b)),y=new s.Bounds(o,r),l.intersects(y)&&delete this._tileCache[m]}this._previewInvalidations.push(l),clearTimeout(this._previewInvalidator),this._previewInvalidator=setTimeout(s.bind(this._invalidatePreviews,this),this.options.previewInvalidationTimeout)},_onSetPartMsg:function(t){var e=parseInt(t.match(/\d+/g)[0]);e!==this._selectedPart&&(this._map.setPart(e),this._map.fire("setpart",{selectedPart:this._selectedPart}),this._map._socket.sendMessage("commandvalues command=.uno:ViewRowColumnHeaders"))},_onZoomRowColumns:function(){this._updateClientZoom(),this._clientZoom&&(this._map._socket.sendMessage("clientzoom "+this._clientZoom),this._clientZoom=null),this._map._socket.sendMessage("commandvalues command=.uno:ViewRowColumnHeaders")},_onUpdateViewPort:function(){var t=parseInt(s.DomUtil.getStyle(this._map._container,"width")),e=parseInt(s.DomUtil.getStyle(this._map._container,"height"));this._map.fire("updateviewport",{rows:{totalHeight:this._docPixelSize.y,viewPort:e},columns:{totalWidth:this._docPixelSize.x,viewPort:t}})},_onUpdateSelectionHeader:function(){var t=this._selections.getLayers(),e=t.pop();if(0===t.length&&e&&1===e.getLatLngs().length){var i=this._latLngToTwips(e.getBounds().getNorthWest()).add([1,1]),n=this._latLngToTwips(e.getBounds().getSouthEast()).subtract([1,1]);this._map.fire("updateselectionheader",{start:i,end:n})}else this._map.fire("clearselectionheader")},_onStatusMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.width&&e.height&&this._documentInfo!==t){this._docWidthTwips=e.width,this._docHeightTwips=e.height,this._docType=e.type,this._parts=e.parts,this._selectedPart=e.selectedPart,this._viewId=parseInt(e.viewid);var i=this._map.getSize(),n=this._docWidthTwips/this._tileWidthTwips*this._tileSize,o=this._docHeightTwips/this._tileHeightTwips*this._tileSize;if(n<i.x||o<i.y){n=Math.max(n,i.x),o=Math.max(o,i.y);var a=this._map.unproject(new s.Point(0,0)),r=this._map.unproject(new s.Point(n,o));this._map.setMaxBounds(new s.LatLngBounds(a,r)),this._docPixelSize={x:n,y:o},this._map.fire("docsize",{x:n,y:o})}else this._updateMaxBounds(!0);this._documentInfo=t;var l=t.match(/[^\r\n]+/g);l=l.slice(l.length-this._parts),this._map.fire("updateparts",{selectedPart:this._selectedPart,parts:this._parts,docType:this._docType,partNames:l}),this._resetPreFetching(!0),this._update(),this._preFetchPart!==this._selectedPart&&(this._preFetchPart=this._selectedPart,this._preFetchBorder=null)}this._onZoomRowColumns()},_onCommandValuesMsg:function(t){if(t.match(".uno:ViewRowColumnHeaders")){var e=JSON.parse(t.substring(t.indexOf("{")));this._map.fire("viewrowcolumnheaders",{data:e,converter:this._twipsToPixels,context:this}),this._onUpdateViewPort(),this._onUpdateSelectionHeader()}else s.TileLayer.prototype._onCommandValuesMsg.call(this,t)},_onTextSelectionMsg:function(t){s.TileLayer.prototype._onTextSelectionMsg.call(this,t),this._onUpdateSelectionHeader()},_onCellCursorMsg:function(t){var e=new s.Point(-1,-1);s.TileLayer.prototype._onCellCursorMsg.call(this,t),this._cellCursor&&!this._isEmptyRectangle(this._cellCursor)&&(e=this._cellCursorTwips.min.add([1,1])),this._map.fire("updatecurrentheader",e)}}),s.ImageOverlay=s.Layer.extend({options:{opacity:1,alt:"",interactive:!1},initialize:function(t,e,i){this._url=t,this._bounds=s.latLngBounds(e),s.setOptions(this,i)},onAdd:function(){this._image||(this._initImage(),this.options.opacity<1&&this._updateOpacity()),this.options.interactive&&(s.DomUtil.addClass(this._image,"leaflet-interactive"),this.addInteractiveTarget(this._image)),this.getPane().appendChild(this._image),this._reset()},onRemove:function(){s.DomUtil.remove(this._image),this.options.interactive&&this.removeInteractiveTarget(this._image)},setOpacity:function(t){return this.options.opacity=t,this._image&&this._updateOpacity(),this},setStyle:function(t){return t.opacity&&this.setOpacity(t.opacity),this},bringToFront:function(){return this._map&&s.DomUtil.toFront(this._image),this},bringToBack:function(){return this._map&&s.DomUtil.toBack(this._image),this},setUrl:function(t){return this._url=t,this._image&&(this._image.src=t),this},getAttribution:function(){return this.options.attribution},getEvents:function(){var t={viewreset:this._reset};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},getBounds:function(){return this._bounds},_initImage:function(){var t=this._image=s.DomUtil.create("img","leaflet-image-layer "+(this._zoomAnimated?"leaflet-zoom-animated":""));t.onselectstart=s.Util.falseFn,t.onmousemove=s.Util.falseFn,t.onload=s.bind(this.fire,this,"load"),t.src=this._url,t.alt=this.options.alt},_animateZoom:function(t){var e=new s.Bounds(this._map._latLngToNewLayerPoint(this._bounds.getNorthWest(),t.zoom,t.center),this._map._latLngToNewLayerPoint(this._bounds.getSouthEast(),t.zoom,t.center)),i=e.min.add(e.getSize()._multiplyBy((1-1/t.scale)/2));s.DomUtil.setTransform(this._image,i,t.scale)},_reset:function(){var t=this._image,e=new s.Bounds(this._map.latLngToLayerPoint(this._bounds.getNorthWest()),this._map.latLngToLayerPoint(this._bounds.getSouthEast())),i=e.getSize();s.DomUtil.setPosition(t,e.min),t.style.width=i.x+"px",t.style.height=i.y+"px"},_updateOpacity:function(){s.DomUtil.setOpacity(this._image,this.options.opacity)}}),s.imageOverlay=function(t,e,i){return new s.ImageOverlay(t,e,i)},s.ProgressOverlay=s.Layer.extend({options:{spinnerSpeed:1.5},initialize:function(t,e){this._latlng=s.latLng(t),this._size=e,this._initLayout()},onAdd:function(){this._container&&(this.getPane().appendChild(this._container),this.update()),this._spinnerInterval=s.LOUtil.startSpinner(this._spinnerCanvas,this.options.spinnerSpeed),this._map.on("moveend",this.update,this)},onRemove:function(){this._container&&this.getPane().removeChild(this._container),this._spinnerInterval&&clearInterval(this._spinnerInterval)},update:function(){if(this._container&&this._map){var t=new s.Point(0,0),e=this._map.layerPointToContainerPoint(t),i=this._size.divideBy(2,!0),n=this._map.latLngToLayerPoint(this._latlng).round();this._setPos(n.subtract(e).subtract(i))}},_initLayout:function(){this._container=s.DomUtil.create("div","leaflet-progress-layer"),this._spinner=s.DomUtil.create("div","leaflet-progress-spinner",this._container),this._spinnerCanvas=s.DomUtil.create("canvas","leaflet-progress-spinner-canvas",this._spinner),this._label=s.DomUtil.create("div","leaflet-progress-label",this._container),this._progress=s.DomUtil.create("div","leaflet-progress",this._container),this._bar=s.DomUtil.create("span","",this._progress),this._value=s.DomUtil.create("span","",this._bar),s.DomUtil.setStyle(this._value,"line-height",this._size.y+"px"),this._container.style.width=this._size.x+"px",s.DomEvent.disableClickPropagation(this._progress).disableScrollPropagation(this._container)},_setPos:function(t){s.DomUtil.setPosition(this._container,t)},setLabel:function(t){this._label.innerHTML!==t&&(this._label.innerHTML=t)},setBar:function(t){t?this._progress.style.visibility="":this._progress.style.visibility="hidden"},setValue:function(t){this._bar.style.width=t+"%",this._value.innerHTML=t+"%"}}),s.progressOverlay=function(t,e){return new s.ProgressOverlay(t,e)},s.Icon=s.Class.extend({initialize:function(t){s.setOptions(this,t)},createIcon:function(t){return this._createIcon("icon",t)},createShadow:function(t){return this._createIcon("shadow",t)},_createIcon:function(t,e){var i=this._getIconUrl(t);if(!i){if("icon"===t)throw new Error("iconUrl not set in Icon options (see the docs).");return null}var n=this._createImg(i,e&&"IMG"===e.tagName?e:null);return this._setIconStyles(n,t),n},_setIconStyles:function(t,e){var i=this.options,n=s.point(i[e+"Size"]),o=s.point("shadow"===e&&i.shadowAnchor||i.iconAnchor||n&&n.divideBy(2,!0));t.className="leaflet-marker-"+e+" "+(i.className||""),o&&(t.style.marginLeft=-o.x+"px",t.style.marginTop=-o.y+"px"),n&&(t.style.width=n.x+"px",t.style.height=n.y+"px")},_createImg:function(t,i){return i=i||e.createElement("img"),i.src=t,i},_getIconUrl:function(t){return s.Browser.retina&&this.options[t+"RetinaUrl"]||this.options[t+"Url"]}}),s.icon=function(t){return new s.Icon(t)},s.Icon.Default=s.Icon.extend({options:{iconSize:[25,41],iconAnchor:[12,41],popupAnchor:[1,-34],shadowSize:[41,41]},_getIconUrl:function(t){var e=t+"Url";if(this.options[e])return this.options[e];var i=s.Icon.Default.imagePath;if(!i)throw new Error("Couldn't autodetect L.Icon.Default.imagePath, set it manually.");return i+"/marker-"+t+(s.Browser.retina&&"icon"===t?"-2x":"")+".png"}}),s.Icon.Default.imagePath=function(){var t,i,n,s,o=e.getElementsByTagName("script"),a=/[\/^]loleaflet/;for(t=0,i=o.length;i>t;t++)if(n=o[t].src,n.match(a))return s=n.substring(0,n.lastIndexOf("/")),(s?s+"/":"")+"images"}(),s.Marker=s.Layer.extend({options:{pane:"markerPane",icon:new s.Icon.Default,interactive:!0,draggable:!1,keyboard:!0,zIndexOffset:0,opacity:1,riseOffset:250},initialize:function(t,e){s.setOptions(this,e),this._latlng=s.latLng(t)},setDraggable:function(t){return this.dragging?void(t?this.dragging.enable():this.dragging.disable()):void(this.options.draggable=t)},onAdd:function(t){this._zoomAnimated=this._zoomAnimated&&t.options.markerZoomAnimation,this._initIcon(),this.update()},onRemove:function(){this.dragging&&this.dragging.enabled()&&this.dragging.removeHooks(),this._removeIcon(),this._removeShadow()},getEvents:function(){var t={viewreset:this.update};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},getLatLng:function(){return this._latlng},setLatLng:function(t){var e=this._latlng;return this._latlng=s.latLng(t),this.update(),this.fire("move",{oldLatLng:e,latlng:this._latlng})},setZIndexOffset:function(t){return this.options.zIndexOffset=t,this.update()},setIcon:function(t){return this.options.icon=t,this._map&&(this._initIcon(),this.update()),this._popup&&this.bindPopup(this._popup,this._popup.options),this},update:function(){if(this._icon){var t=this._map.latLngToLayerPoint(this._latlng).round();this._setPos(t)}return this},_initIcon:function(){var t=this.options,e="leaflet-zoom-"+(this._zoomAnimated?"animated":"hide"),i=t.icon.createIcon(this._icon),n=!1;i!==this._icon&&(this._icon&&this._removeIcon(),n=!0,t.title&&(i.title=t.title),t.alt&&(i.alt=t.alt)),s.DomUtil.addClass(i,e),t.keyboard&&(i.tabIndex="0"),this._icon=i,this._initInteraction(),t.riseOnHover&&this.on({mouseover:this._bringToFront,mouseout:this._resetZIndex});var o=t.icon.createShadow(this._shadow),a=!1;o!==this._shadow&&(this._removeShadow(),a=!0),o&&s.DomUtil.addClass(o,e),this._shadow=o,t.opacity<1&&this._updateOpacity(),n&&this.getPane().appendChild(this._icon),o&&a&&this.getPane("shadowPane").appendChild(this._shadow)},_removeIcon:function(){this.options.riseOnHover&&this.off({mouseover:this._bringToFront,mouseout:this._resetZIndex}),s.DomUtil.remove(this._icon),this.removeInteractiveTarget(this._icon),this._icon=null},_removeShadow:function(){this._shadow&&s.DomUtil.remove(this._shadow),this._shadow=null},_setPos:function(t){s.DomUtil.setPosition(this._icon,t),this._shadow&&s.DomUtil.setPosition(this._shadow,t),this._zIndex=t.y+this.options.zIndexOffset,this._resetZIndex()},_updateZIndex:function(t){this._icon.style.zIndex=this._zIndex+t},_animateZoom:function(t){var e=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center).round();this._setPos(e)},_initInteraction:function(){if(this.options.interactive&&(s.DomUtil.addClass(this._icon,"leaflet-interactive"),this.addInteractiveTarget(this._icon),s.Handler.MarkerDrag)){var t=this.options.draggable;this.dragging&&(t=this.dragging.enabled(),this.dragging.disable()),this.dragging=new s.Handler.MarkerDrag(this),t&&this.dragging.enable()}},setOpacity:function(t){return this.options.opacity=t,this._map&&this._updateOpacity(),this},_updateOpacity:function(){var t=this.options.opacity;s.DomUtil.setOpacity(this._icon,t),this._shadow&&s.DomUtil.setOpacity(this._shadow,t)},_bringToFront:function(){this._updateZIndex(this.options.riseOffset)},_resetZIndex:function(){this._updateZIndex(0)}}),s.marker=function(t,e){return new s.Marker(t,e)},s.Cursor=s.Layer.extend({options:{opacity:1,zIndex:1e3},initialize:function(t,e,i){s.setOptions(this,i),this._latlng=s.latLng(t),this._size=s.point(e),this._initLayout()},onAdd:function(){this._container||this._initLayout(),this.update(),this.getPane().appendChild(this._container)},onRemove:function(){this._container&&this.getPane().removeChild(this._container)},getEvents:function(){var t={viewreset:this.update};return t},getLatLng:function(){return this._latlng},setLatLng:function(t,e){var i=this._latlng;return this._latlng=s.latLng(t),this._size=s.point(e),this.update(),this.fire("move",{oldLatLng:i,latlng:this._latlng})},update:function(){if(this._container&&this._map){var t=this._map.latLngToLayerPoint(this._latlng).round();this._setSize(),this._setPos(t)}return this},setOpacity:function(t){this._container&&s.DomUtil.setOpacity(this._cursor,t)},showCursorHeader:function(){this._cursorHeader&&(s.DomUtil.setStyle(this._cursorHeader,"visibility","visible"),setTimeout(s.bind(function(){s.DomUtil.setStyle(this._cursorHeader,"visibility","hidden")},this),this.options.headerTimeout))},_initLayout:function(){this._container=s.DomUtil.create("div","leaflet-cursor-container"),this.options.header&&(this._cursorHeader=s.DomUtil.create("div","leaflet-cursor-header",this._container),this._cursorHeader.innerHTML=this.options.headerName,setTimeout(s.bind(function(){s.DomUtil.setStyle(this._cursorHeader,"visibility","hidden")},this),this.options.headerTimeout)),this._cursor=s.DomUtil.create("div","leaflet-cursor",this._container),this.options.blink&&s.DomUtil.addClass(this._cursor,"blinking-cursor"),this.options.color&&(s.DomUtil.setStyle(this._cursorHeader,"background",this.options.color),s.DomUtil.setStyle(this._cursor,"background",this.options.color)),s.DomEvent.disableClickPropagation(this._cursor).disableScrollPropagation(this._container)},_setPos:function(t){s.DomUtil.setPosition(this._container,t),this._container.style.zIndex=this.options.zIndex},_setSize:function(){this._cursor.style.height=this._size.y+"px",this._container.style.top="-"+(this._container.clientHeight-this._size.y-2)/2+"px"}}),s.cursor=function(t,e,i){return new s.Cursor(t,e,i)},s.Cursor.getCursorURL=function(t){var i,n,s,o,a=e.getElementsByTagName("script"),r=/[\/^]leaflet[\-\._]?([\w\-\._]*)\.js\??/;for(i=0,n=a.length;n>i;i++)if(s=a[i].src,s.match(r))return o=s.split(r)[0],(o?o+"/":"")+t},s.Cursor.hotSpot={fill:{x:7,y:16}},s.Cursor.customCursors=["fill"],s.Cursor.isCustomCursor=function(t){return-1!==s.Cursor.customCursors.indexOf(t)},s.Cursor.getCustomCursor=function(t){var e;if(s.Cursor.isCustomCursor(t)){var i=s.Cursor.hotSpot[t]||{x:0,y:0};e=s.Browser.ie?"url("+s.Cursor.imagePath+"/"+t+".cur), default":"url("+s.Cursor.imagePath+"/"+t+".png) "+i.x+" "+i.y+", default"}return e},s.DivIcon=s.Icon.extend({options:{iconSize:[12,12],className:"leaflet-div-icon",html:!1},createIcon:function(t){var i=t&&"DIV"===t.tagName?t:e.createElement("div"),n=this.options;return i.innerHTML=n.html!==!1?n.html:"",n.bgPos&&(i.style.backgroundPosition=-n.bgPos.x+"px "+-n.bgPos.y+"px"),this._setIconStyles(i,"icon"),i},createShadow:function(){return null}}),s.divIcon=function(t){return new s.DivIcon(t)},s.Map.mergeOptions({closePopupOnClick:!0}),s.Popup=s.Layer.extend({options:{pane:"popupPane",minWidth:50,maxWidth:300,offset:[0,7],autoPan:!0,autoPanPadding:[5,5],closeButton:!0,autoClose:!0,zoomAnimation:!0},initialize:function(t,e){s.setOptions(this,t),this._source=e},onAdd:function(t){this._zoomAnimated=this._zoomAnimated&&this.options.zoomAnimation,this._container||this._initLayout(),t._fadeAnimated&&s.DomUtil.setOpacity(this._container,0),clearTimeout(this._removeTimeout),this.getPane().appendChild(this._container),this.update(),t._fadeAnimated&&s.DomUtil.setOpacity(this._container,1),t.fire("popupopen",{popup:this}),this._source&&this._source.fire("popupopen",{popup:this},!0)},openOn:function(t){return t.openPopup(this),this},onRemove:function(t){t._fadeAnimated?(s.DomUtil.setOpacity(this._container,0),this._removeTimeout=setTimeout(s.bind(s.DomUtil.remove,s.DomUtil,this._container),200)):s.DomUtil.remove(this._container),t.fire("popupclose",{popup:this}),this._source&&this._source.fire("popupclose",{popup:this},!0)},getLatLng:function(){return this._latlng},setLatLng:function(t){return this._latlng=s.latLng(t),this._map&&(this._updatePosition(),this._adjustPan()),this},getContent:function(){return this._content},setContent:function(t){return this._content=t,this.update(),this},update:function(){this._map&&(this._container.style.visibility="hidden",this._updateContent(),this._updateLayout(),this._updatePosition(),this._container.style.visibility="",this._adjustPan())},getEvents:function(){var t={viewreset:this._updatePosition},e=this.options;return this._zoomAnimated&&(t.zoomanim=this._animateZoom),("closeOnClick"in e?e.closeOnClick:this._map.options.closePopupOnClick)&&(t.preclick=this._close),e.keepInView&&(t.moveend=this._adjustPan),t},isOpen:function(){return!!this._map&&this._map.hasLayer(this)},_close:function(){this._map&&this._map.closePopup(this)},_initLayout:function(){var t="leaflet-popup",e=this._container=s.DomUtil.create("div",t+" "+(this.options.className||"")+" leaflet-zoom-"+(this._zoomAnimated?"animated":"hide"));if(this.options.closeButton){var i=this._closeButton=s.DomUtil.create("a",t+"-close-button",e);i.href="#close",i.innerHTML="&#215;",s.DomEvent.on(i,"click",this._onCloseButtonClick,this)}var n=this._wrapper=s.DomUtil.create("div",t+"-content-wrapper",e);this._contentNode=s.DomUtil.create("div",t+"-content",n),s.DomEvent.disableClickPropagation(n).disableScrollPropagation(this._contentNode).on(n,"contextmenu",s.DomEvent.stopPropagation),this._tipContainer=s.DomUtil.create("div",t+"-tip-container",e),this._tip=s.DomUtil.create("div",t+"-tip",this._tipContainer),this.options.backgroundColor&&(this._tip.style["background-color"]=this._wrapper.style["background-color"]=this.options.backgroundColor),this.options.color&&(this._wrapper.style.color=this.options.color)},_updateContent:function(){if(this._content){var t=this._contentNode;if("string"==typeof this._content)t.innerHTML=this._content;else{for(;t.hasChildNodes();)t.removeChild(t.firstChild);t.appendChild(this._content)}this.fire("contentupdate")}},_updateLayout:function(){var t=this._contentNode,e=t.style;e.width="",e.whiteSpace="nowrap";var i=t.offsetWidth;i=Math.min(i,this.options.maxWidth),i=Math.max(i,this.options.minWidth),e.width=i+1+"px",e.whiteSpace="",e.height="";var n=t.offsetHeight,o=this.options.maxHeight,a="leaflet-popup-scrolled";o&&n>o?(e.height=o+"px",s.DomUtil.addClass(t,a)):s.DomUtil.removeClass(t,a),this._containerWidth=this._container.offsetWidth},_updatePosition:function(){if(this._map){var t=this._map.latLngToLayerPoint(this._latlng),e=s.point(this.options.offset);this._zoomAnimated?s.DomUtil.setPosition(this._container,t):e=e.add(t);var i=this._containerBottom=-e.y,n=this._containerLeft=-Math.round(this._containerWidth/2)+e.x;this._container.style.bottom=i+"px",this._container.style.left=n+"px"}},_animateZoom:function(t){var e=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center);s.DomUtil.setPosition(this._container,e)},_adjustPan:function(){if(this.options.autoPan){var t=this._map,e=this._container.offsetHeight,i=this._containerWidth,n=new s.Point(this._containerLeft,-e-this._containerBottom);this._zoomAnimated&&n._add(s.DomUtil.getPosition(this._container));var o=t.layerPointToContainerPoint(n),a=s.point(this.options.autoPanPadding),r=s.point(this.options.autoPanPaddingTopLeft||a),l=s.point(this.options.autoPanPaddingBottomRight||a),h=t.getSize(),d=0,u=0;o.x+i+l.x>h.x&&(d=o.x+i-h.x+l.x),o.x-d-r.x<0&&(d=o.x-r.x),o.y+e+l.y>h.y&&(u=o.y+e-h.y+l.y),o.y-u-r.y<0&&(u=o.y-r.y),(d||u)&&t.fire("autopanstart").panBy([d,u])}},_onCloseButtonClick:function(t){this._close(),s.DomEvent.stop(t)}}),s.popup=function(t,e){return new s.Popup(t,e)},s.Map.include({openPopup:function(t,e,i){if(!(t instanceof s.Popup)){var n=t;t=new s.Popup(i).setContent(n)}return e&&t.setLatLng(e),this.hasLayer(t)?this:(this._popup&&this._popup.options.autoClose&&this.closePopup(),this._popup=t,this.addLayer(t))},closePopup:function(t){return t&&t!==this._popup||(t=this._popup,this._popup=null),t&&this.removeLayer(t),this}}),s.Layer.include({bindPopup:function(t,e){return t instanceof s.Popup?(s.setOptions(t,e),this._popup=t,t._source=this):((!this._popup||e)&&(this._popup=new s.Popup(e,this)),this._popup.setContent(t)),this._popupHandlersAdded||(this.on({click:this._openPopup,remove:this.closePopup,move:this._movePopup}),this._popupHandlersAdded=!0),this},unbindPopup:function(){return this._popup&&(this.off({click:this._openPopup,remove:this.closePopup,move:this._movePopup}),this._popupHandlersAdded=!1,this._popup=null),this},openPopup:function(t){return this._popup&&this._map&&this._map.openPopup(this._popup,t||this._latlng||this.getCenter()),this},closePopup:function(){return this._popup&&this._popup._close(),this},togglePopup:function(){return this._popup&&(this._popup._map?this.closePopup():this.openPopup()),this},setPopupContent:function(t){return this._popup&&this._popup.setContent(t),this},getPopup:function(){return this._popup},_openPopup:function(t){this._map.openPopup(this._popup,t.latlng)},_movePopup:function(t){this._popup.setLatLng(t.latlng)}}),s.Marker.include({bindPopup:function(t,e){var i=s.point(this.options.icon.options.popupAnchor||[0,0]).add(s.Popup.prototype.options.offset);return e=s.extend({offset:i},e),s.Layer.prototype.bindPopup.call(this,t,e)},_openPopup:s.Layer.prototype.togglePopup}),s.LayerGroup=s.Layer.extend({initialize:function(t){this._layers={};var e,i;if(t)for(e=0,i=t.length;i>e;e++)this.addLayer(t[e])},addLayer:function(t){var e=this.getLayerId(t);return this._layers[e]=t,this._map&&this._map.addLayer(t),this},removeLayer:function(t){var e=t in this._layers?t:this.getLayerId(t);return this._map&&this._layers[e]&&this._map.removeLayer(this._layers[e]),delete this._layers[e],this},hasLayer:function(t){return!!t&&(t in this._layers||this.getLayerId(t)in this._layers)},clearLayers:function(){for(var t in this._layers)this.removeLayer(this._layers[t]);return this},invoke:function(t){var e,i,n=Array.prototype.slice.call(arguments,1);for(e in this._layers)i=this._layers[e],i[t]&&i[t].apply(i,n);return this},onAdd:function(t){for(var e in this._layers)t.addLayer(this._layers[e])},onRemove:function(t){for(var e in this._layers)t.removeLayer(this._layers[e])},eachLayer:function(t,e){for(var i in this._layers)t.call(e,this._layers[i]);return this},getLayer:function(t){return this._layers[t]},getLayers:function(){var t=[];for(var e in this._layers)t.push(this._layers[e]);return t},setZIndex:function(t){return this.invoke("setZIndex",t)},getLayerId:function(t){return s.stamp(t)}}),s.layerGroup=function(t){return new s.LayerGroup(t)},s.FeatureGroup=s.LayerGroup.extend({addLayer:function(t){return this.hasLayer(t)?this:(t.addEventParent(this),s.LayerGroup.prototype.addLayer.call(this,t),this._popupContent&&t.bindPopup&&t.bindPopup(this._popupContent,this._popupOptions),this.fire("layeradd",{layer:t}))},removeLayer:function(t){return this.hasLayer(t)?(t in this._layers&&(t=this._layers[t]),t.removeEventParent(this),s.LayerGroup.prototype.removeLayer.call(this,t),this._popupContent&&this.invoke("unbindPopup"),this.fire("layerremove",{layer:t})):this},bindPopup:function(t,e){return this._popupContent=t,this._popupOptions=e,this.invoke("bindPopup",t,e)},openPopup:function(t){for(var e in this._layers){this._layers[e].openPopup(t);break}return this},setStyle:function(t){return this.invoke("setStyle",t)},bringToFront:function(){return this.invoke("bringToFront")},bringToBack:function(){return this.invoke("bringToBack")},getBounds:function(){var t=new s.LatLngBounds;return this.eachLayer(function(e){t.extend(e.getBounds?e.getBounds():e.getLatLng())}),t}}),s.featureGroup=function(t){return new s.FeatureGroup(t)},s.Renderer=s.Layer.extend({options:{padding:0},initialize:function(t){s.setOptions(this,t),s.stamp(this)},onAdd:function(){this._container||(this._initContainer(),this._zoomAnimated&&s.DomUtil.addClass(this._container,"leaflet-zoom-animated")),this.getPane().appendChild(this._container),this._update()},onRemove:function(){s.DomUtil.remove(this._container)},getEvents:function(){var t={moveend:this._update};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},_animateZoom:function(t){var e=t.origin.subtract(this._map._getCenterLayerPoint()),i=this._bounds.min.add(e.multiplyBy(1-t.scale)).add(t.offset).round();s.DomUtil.setTransform(this._container,i,t.scale)},_update:function(){var t=this.options.padding,e=this._map.getSize(),i=this._map.containerPointToLayerPoint(e.multiplyBy(-t)).round();this._bounds=new s.Bounds(i,i.add(e.multiplyBy(1+2*t)).round())}}),s.Map.include({getRenderer:function(t){var e=t.options.renderer||this._getPaneRenderer(t.options.pane)||this.options.renderer||this._renderer;return e||(e=this._renderer=s.SVG&&s.svg()||s.Canvas&&s.canvas()),this.hasLayer(e)||this.addLayer(e),e},_getPaneRenderer:function(t){if("overlayPane"===t||t===i)return!1;var e=this._paneRenderers[t];return e===i&&(e=s.SVG&&s.svg({pane:t})||s.Canvas&&s.canvas({pane:t}),this._paneRenderers[t]=e),e}}),s.Path=s.Layer.extend({options:{stroke:!0,color:"#3388ff",weight:3,opacity:1,lineCap:"round",lineJoin:"round",fillOpacity:.2,fillRule:"evenodd",interactive:!0},onAdd:function(){this._renderer=this._map.getRenderer(this),this._renderer._initPath(this),this._project(),this._update(),this._renderer._addPath(this)},onRemove:function(){this._renderer._removePath(this)},getEvents:function(){return{viewreset:this._project,moveend:this._update}},redraw:function(){return this._map&&this._renderer._updatePath(this),this},setStyle:function(t){return s.setOptions(this,t),this._renderer&&this._renderer._updateStyle(this),this},bringToFront:function(){return this._renderer&&this._renderer._bringToFront(this),this},bringToBack:function(){return this._renderer&&this._renderer._bringToBack(this),this},_clickTolerance:function(){return(this.options.stroke?this.options.weight/2:0)+(s.Browser.touch?10:0)}}),s.Path.include({bindPopup:function(t,e){return t instanceof s.Popup?this._popup=t:((!this._popup||e)&&(this._popup=new s.Popup(e,this)),this._popup.setContent(t)),this._popupHandlersAdded||(this.on({mouseover:this._openPopup,mouseout:this._delayClose,remove:this.closePopup,add:this.firstPopup}),this._popupHandlersAdded=!0),this},unbindPopup:function(){return this._popup&&(this._popup=null,this.off({mouseover:this._openPopup,mouseout:this._delayClose,remove:this.closePopup,add:this.firstPopup}),this._popupHandlersAdded=!1),this},firstPopup:function(t){this._popup&&this._openPopup({latlng:this._bounds.getCenter()})},closePopup:function(){return this._popup&&this._popup._close(),this},_delayClose:function(){clearTimeout(this._timer),this._timer=setTimeout(s.bind(this.closePopup,this),3e3)},_openPopup:function(t){this._map.hasLayer(this._popup)||(this._popup.setLatLng(t.latlng),this._map.openPopup(this._popup),this._delayClose())}}),s.LineUtil={simplify:function(t,e){if(!e||!t.length)return t.slice();var i=e*e;return t=this._reducePoints(t,i),t=this._simplifyDP(t,i)},pointToSegmentDistance:function(t,e,i){return Math.sqrt(this._sqClosestPointOnSegment(t,e,i,!0))},closestPointOnSegment:function(t,e,i){return this._sqClosestPointOnSegment(t,e,i)},_simplifyDP:function(t,e){var n=t.length,s=typeof Uint8Array!=i+""?Uint8Array:Array,o=new s(n);o[0]=o[n-1]=1,this._simplifyDPStep(t,o,e,0,n-1);var a,r=[];for(a=0;n>a;a++)o[a]&&r.push(t[a]);return r},_simplifyDPStep:function(t,e,i,n,s){var o,a,r,l=0;for(a=n+1;s-1>=a;a++)r=this._sqClosestPointOnSegment(t[a],t[n],t[s],!0),r>l&&(o=a,l=r);l>i&&(e[o]=1,this._simplifyDPStep(t,e,i,n,o),this._simplifyDPStep(t,e,i,o,s))},_reducePoints:function(t,e){for(var i=[t[0]],n=1,s=0,o=t.length;o>n;n++)this._sqDist(t[n],t[s])>e&&(i.push(t[n]),s=n);return o-1>s&&i.push(t[o-1]),i},clipSegment:function(t,e,i,n,s){var o,a,r,l=n?this._lastCode:this._getBitCode(t,i),h=this._getBitCode(e,i);for(this._lastCode=h;;){if(!(l|h))return[t,e];if(l&h)return!1;o=l||h,a=this._getEdgeIntersection(t,e,o,i,s),r=this._getBitCode(a,i),o===l?(t=a,l=r):(e=a,h=r)}},_getEdgeIntersection:function(t,e,i,n,o){var a,r,l=e.x-t.x,h=e.y-t.y,d=n.min,u=n.max;return 8&i?(a=t.x+l*(u.y-t.y)/h,r=u.y):4&i?(a=t.x+l*(d.y-t.y)/h,r=d.y):2&i?(a=u.x,r=t.y+h*(u.x-t.x)/l):1&i&&(a=d.x,r=t.y+h*(d.x-t.x)/l),new s.Point(a,r,o)},_getBitCode:function(t,e){var i=0;return t.x<e.min.x?i|=1:t.x>e.max.x&&(i|=2),t.y<e.min.y?i|=4:t.y>e.max.y&&(i|=8),i},_sqDist:function(t,e){var i=e.x-t.x,n=e.y-t.y;return i*i+n*n},_sqClosestPointOnSegment:function(t,e,i,n){var o,a=e.x,r=e.y,l=i.x-a,h=i.y-r,d=l*l+h*h;return d>0&&(o=((t.x-a)*l+(t.y-r)*h)/d,o>1?(a=i.x,r=i.y):o>0&&(a+=l*o,r+=h*o)),l=t.x-a,h=t.y-r,n?l*l+h*h:new s.Point(a,r)}},s.Polyline=s.Path.extend({options:{smoothFactor:1},initialize:function(t,e){s.setOptions(this,e),this._setLatLngs(t)},getLatLngs:function(){return this._latlngs},setLatLngs:function(t){return this._setLatLngs(t),this.redraw()},addLatLng:function(t){return t=s.latLng(t),this._latlngs.push(t),this._bounds.extend(t),this.redraw()},spliceLatLngs:function(){var t=[].splice.apply(this._latlngs,arguments);return this._setLatLngs(this._latlngs),this.redraw(),t},closestLayerPoint:function(t){for(var e,i,n=1/0,o=null,a=s.LineUtil._sqClosestPointOnSegment,r=0,l=this._parts.length;l>r;r++)for(var h=this._parts[r],d=1,u=h.length;u>d;d++){e=h[d-1],i=h[d];var c=a(t,e,i,!0);n>c&&(n=c,o=a(t,e,i))}return o&&(o.distance=Math.sqrt(n)),o},getCenter:function(){var t,e,i,n,s,o,a,r=this._rings[0],l=r.length;for(t=0,e=0;l-1>t;t++)e+=r[t].distanceTo(r[t+1])/2;for(t=0,n=0;l-1>t;t++)if(s=r[t],o=r[t+1],i=s.distanceTo(o),n+=i,n>e)return a=(n-e)/i,this._map.layerPointToLatLng([o.x-a*(o.x-s.x),o.y-a*(o.y-s.y)])},getBounds:function(){return this._bounds},_setLatLngs:function(t){this._bounds=new s.LatLngBounds,this._latlngs=this._convertLatLngs(t)},_convertLatLngs:function(t){for(var e=[],i=this._flat(t),n=0,o=t.length;o>n;n++)i?(e[n]=s.latLng(t[n]),this._bounds.extend(e[n])):e[n]=this._convertLatLngs(t[n]);return e},_flat:function(t){return!s.Util.isArray(t[0])||"object"!=typeof t[0][0];
},_project:function(){this._rings=[],this._projectLatlngs(this._latlngs,this._rings);var t=this._clickTolerance(),e=new s.Point(t,-t);this._latlngs.length&&(this._pxBounds=new s.Bounds(this._map.latLngToLayerPoint(this._bounds.getSouthWest())._subtract(e),this._map.latLngToLayerPoint(this._bounds.getNorthEast())._add(e)))},_projectLatlngs:function(t,e){var i,n,o=t[0]instanceof s.LatLng,a=t.length;if(o){for(n=[],i=0;a>i;i++)n[i]=this._map.latLngToLayerPoint(t[i]);e.push(n)}else for(i=0;a>i;i++)this._projectLatlngs(t[i],e)},_clipPoints:function(){if(this.options.noClip)return void(this._parts=this._rings);this._parts=[];var t,e,i,n,o,a,r,l=this._parts,h=this._renderer._bounds;for(t=0,i=0,n=this._rings.length;n>t;t++)for(r=this._rings[t],e=0,o=r.length;o-1>e;e++)a=s.LineUtil.clipSegment(r[e],r[e+1],h,e,!0),a&&(l[i]=l[i]||[],l[i].push(a[0]),(a[1]!==r[e+1]||e===o-2)&&(l[i].push(a[1]),i++))},_simplifyPoints:function(){for(var t=this._parts,e=this.options.smoothFactor,i=0,n=t.length;n>i;i++)t[i]=s.LineUtil.simplify(t[i],e)},_update:function(){this._map&&(this._clipPoints(),this._simplifyPoints(),this._updatePath())},_updatePath:function(){this._renderer._updatePoly(this)}}),s.polyline=function(t,e){return new s.Polyline(t,e)},s.PolyUtil={},s.PolyUtil.clipPolygon=function(t,e,i){var n,o,a,r,l,h,d,u,c,p=[1,4,2,8],_=s.LineUtil;for(o=0,d=t.length;d>o;o++)t[o]._code=_._getBitCode(t[o],e);for(r=0;4>r;r++){for(u=p[r],n=[],o=0,d=t.length,a=d-1;d>o;a=o++)l=t[o],h=t[a],l._code&u?h._code&u||(c=_._getEdgeIntersection(h,l,u,e,i),c._code=_._getBitCode(c,e),n.push(c)):(h._code&u&&(c=_._getEdgeIntersection(h,l,u,e,i),c._code=_._getBitCode(c,e),n.push(c)),n.push(l));t=n}return t},s.PolyUtil.rectanglesToPolygons=function(t,e){function i(t){var e=[];for(var i in t)t.hasOwnProperty(i)&&e.push(i);return e}function n(t,e){var i=t.match(/\d+/g);i[0]=parseInt(i[0]),i[1]=parseInt(i[1]);var n=e.match(/\d+/g);return n[0]=parseInt(n[0]),n[1]=parseInt(n[1]),i[0]<n[0]||i[0]===n[0]&&i[1]<n[1]?-1:i[0]===n[0]&&i[1]===n[1]?0:1}function s(t,e){var i=t.match(/\d+/g);i[0]=parseInt(i[0]),i[1]=parseInt(i[1]);var n=e.match(/\d+/g);return n[0]=parseInt(n[0]),n[1]=parseInt(n[1]),i[1]<n[1]||i[1]===n[1]&&i[0]<n[0]?-1:i[0]===n[0]&&i[1]===n[1]?0:1}for(var o=20,a=0;a<t.length-1;a++)for(var r=a+1;r<t.length;r++)for(var l=0;l<t[a].length;l++)for(var h=0;h<t[r].length;h++)Math.abs(t[a][l].x-t[r][h].x)<o&&(t[r][h].x=t[a][l].x),Math.abs(t[a][l].y-t[r][h].y)<o&&(t[r][h].y=t[a][l].y);var d={};for(a=0;a<t.length;a++)for(r=0;r<t[a].length;r++)d[t[a][r]]?delete d[t[a][r]]:d[t[a][r]]=t[a][r];var u=i(d).sort(n),c=i(d).sort(s),p={},_={},m=i(d).length;for(a=0;m>a;)for(var g=d[c[a]].y;m>a&&d[c[a]].y===g;)p[c[a]]=c[a+1],p[c[a+1]]=c[a],a+=2;for(a=0;m>a;)for(var f=d[u[a]].x;m>a&&d[u[a]].x===f;)_[u[a]]=u[a+1],_[u[a+1]]=u[a],a+=2;for(var v=[],y=i(p);y.length>0;){for(var w=[[y[0],0]];;){var b=w[w.length-1][0],C=w[w.length-1][1];if(0===C){var x=_[b];delete _[b],w.push([x,1])}else x=p[b],delete p[b],w.push([x,0]);if(w[w.length-1][0]===w[0][0]&&w[w.length-1][1]===w[0][1]){w.pop();break}}var P=[];for(a=0;a<w.length;a++)P.push(e._twipsToLatLng(d[w[a][0]])),delete p[w[a][0]],delete _[w[a][0]];P.push(e._twipsToLatLng(d[w[0][0]])),y=i(p),v.push(P)}return v},s.Polygon=s.Polyline.extend({options:{fill:!0},getCenter:function(){var t,e,i,n,s,o,a,r,l,h=this._rings[0];for(a=r=l=0,t=0,i=h.length,e=i-1;i>t;e=t++)n=h[t],s=h[e],o=n.y*s.x-s.y*n.x,r+=(n.x+s.x)*o,l+=(n.y+s.y)*o,a+=3*o;return this._map.layerPointToLatLng([r/a,l/a])},_convertLatLngs:function(t){var e=s.Polyline.prototype._convertLatLngs.call(this,t),i=e.length;return i>=2&&e[0]instanceof s.LatLng&&e[0].equals(e[i-1])&&e.pop(),e},_clipPoints:function(){if(this.options.noClip)return void(this._parts=this._rings);var t=this._renderer._bounds,e=this.options.weight,i=new s.Point(e,e);t=new s.Bounds(t.min.subtract(i),t.max.add(i)),this._parts=[];for(var n,o=0,a=this._rings.length;a>o;o++)n=s.PolyUtil.clipPolygon(this._rings[o],t,!0),n.length&&this._parts.push(n)},_updatePath:function(){this._renderer._updatePoly(this,!0)}}),s.polygon=function(t,e){return new s.Polygon(t,e)},s.Rectangle=s.Polygon.extend({initialize:function(t,e){s.Polygon.prototype.initialize.call(this,this._boundsToLatLngs(t),e)},setBounds:function(t){this.setLatLngs(this._boundsToLatLngs(t))},_boundsToLatLngs:function(t){return t=s.latLngBounds(t),[t.getSouthWest(),t.getNorthWest(),t.getNorthEast(),t.getSouthEast()]}}),s.rectangle=function(t,e){return new s.Rectangle(t,e)},s.CircleMarker=s.Path.extend({options:{fill:!0,radius:10},initialize:function(t,e){s.setOptions(this,e),this._latlng=s.latLng(t),this._radius=this.options.radius},setLatLng:function(t){return this._latlng=s.latLng(t),this.redraw(),this.fire("move",{latlng:this._latlng})},getLatLng:function(){return this._latlng},setRadius:function(t){return this.options.radius=this._radius=t,this.redraw()},getRadius:function(){return this._radius},setStyle:function(t){var e=t&&t.radius||this._radius;return s.Path.prototype.setStyle.call(this,t),this.setRadius(e),this},_project:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._updateBounds()},_updateBounds:function(){var t=this._radius,e=this._radiusY||t,i=this._clickTolerance(),n=[t+i,e+i];this._pxBounds=new s.Bounds(this._point.subtract(n),this._point.add(n))},_update:function(){this._map&&this._updatePath()},_updatePath:function(){this._renderer._updateCircle(this)},_empty:function(){return this._radius&&!this._renderer._bounds.intersects(this._pxBounds)}}),s.circleMarker=function(t,e){return new s.CircleMarker(t,e)},s.Circle=s.CircleMarker.extend({initialize:function(t,e,i){s.setOptions(this,i),this._latlng=s.latLng(t),this._mRadius=e},setRadius:function(t){return this._mRadius=t,this.redraw()},getRadius:function(){return this._mRadius},getBounds:function(){var t=[this._radius,this._radiusY];return new s.LatLngBounds(this._map.layerPointToLatLng(this._point.subtract(t)),this._map.layerPointToLatLng(this._point.add(t)))},setStyle:s.Path.prototype.setStyle,_project:function(){var t=this._latlng.lng,e=this._latlng.lat,i=this._map,n=i.options.crs;if(n.distance===s.CRS.Earth.distance){var o=Math.PI/180,a=this._mRadius/s.CRS.Earth.R/o,r=i.project([e+a,t]),l=i.project([e-a,t]),h=r.add(l).divideBy(2),d=i.unproject(h).lat,u=Math.acos((Math.cos(a*o)-Math.sin(e*o)*Math.sin(d*o))/(Math.cos(e*o)*Math.cos(d*o)))/o;this._point=h.subtract(i.getPixelOrigin()),this._radius=isNaN(u)?0:Math.max(Math.round(h.x-i.project([d,t-u]).x),1),this._radiusY=Math.max(Math.round(h.y-r.y),1)}else{var c=n.unproject(n.project(this._latlng).subtract([this._mRadius,0]));this._point=i.latLngToLayerPoint(this._latlng),this._radius=this._point.x-i.latLngToLayerPoint(c).x}this._updateBounds()}}),s.circle=function(t,e,i){return new s.Circle(t,e,i)},s.SVG=s.Renderer.extend({_initContainer:function(){this._container=s.SVG.create("svg"),this._container.setAttribute("pointer-events","none")},_update:function(){if(!this._map._animatingZoom||!this._bounds){s.Renderer.prototype._update.call(this);var t=this._bounds,e=t.getSize(),i=this._container;s.DomUtil.setPosition(i,t.min),this._svgSize&&this._svgSize.equals(e)||(this._svgSize=e,i.setAttribute("width",e.x),i.setAttribute("height",e.y)),s.DomUtil.setPosition(i,t.min),i.setAttribute("viewBox",[t.min.x,t.min.y,e.x,e.y].join(" "))}},_initPath:function(t){var e=t._path=s.SVG.create("path");if(t.options.className&&s.DomUtil.addClass(e,t.options.className),t.options.interactive){s.DomUtil.addClass(e,"leaflet-interactive");for(var i=["mouseenter","mouseout"],n=0;n<i.length;n++)s.DomEvent.on(e,i[n],this._fireMouseEvent,this)}this._updateStyle(t)},_fireMouseEvent:function(t){if(this._map&&this.hasEventListeners(t.type)){var e=this._map,i=e.mouseEventToContainerPoint(t),n=e.containerPointToLayerPoint(i),s=e.layerPointToLatLng(n);this.fire(t.type,{latlng:s,layerPoint:n,containerPoint:i,originalEvent:t})}},_addPath:function(t){this._container.appendChild(t._path),t.addInteractiveTarget(t._path)},_removePath:function(t){s.DomUtil.remove(t._path),t.removeInteractiveTarget(t._path)},_updatePath:function(t){t._project(),t._update()},_updateStyle:function(t){var e=t._path,i=t.options;e&&(i.stroke?(e.setAttribute("stroke",i.color),e.setAttribute("stroke-opacity",i.opacity),e.setAttribute("stroke-width",i.weight),e.setAttribute("stroke-linecap",i.lineCap),e.setAttribute("stroke-linejoin",i.lineJoin),i.dashArray?e.setAttribute("stroke-dasharray",i.dashArray):e.removeAttribute("stroke-dasharray"),i.dashOffset?e.setAttribute("stroke-dashoffset",i.dashOffset):e.removeAttribute("stroke-dashoffset")):e.setAttribute("stroke","none"),i.fill?(e.setAttribute("fill",i.fillColor||i.color),e.setAttribute("fill-opacity",i.fillOpacity),e.setAttribute("fill-rule",i.fillRule||"evenodd")):e.setAttribute("fill","none"),e.setAttribute("pointer-events",i.pointerEvents||(i.interactive?"visiblePainted":"none")))},_updatePoly:function(t,e){this._setPath(t,s.SVG.pointsToPath(t._parts,e))},_updateCircle:function(t){var e=t._point,i=t._radius,n=t._radiusY||i,s="a"+i+","+n+" 0 1,0 ",o=t._empty()?"M0 0":"M"+(e.x-i)+","+e.y+s+2*i+",0 "+s+2*-i+",0 ";this._setPath(t,o)},_setPath:function(t,e){t._path.setAttribute("d",e)},_bringToFront:function(t){s.DomUtil.toFront(t._path)},_bringToBack:function(t){s.DomUtil.toBack(t._path)}}),s.extend(s.SVG,{create:function(t){return e.createElementNS("http://www.w3.org/2000/svg",t)},pointsToPath:function(t,e){var i,n,o,a,r,l,h="";for(i=0,o=t.length;o>i;i++){for(r=t[i],n=0,a=r.length;a>n;n++)l=r[n],h+=(n?"L":"M")+l.x+" "+l.y;h+=e?s.Browser.svg?"z":"x":""}return h||"M0 0"}}),s.Browser.svg=!(!e.createElementNS||!s.SVG.create("svg").createSVGRect),s.svg=function(t){return s.Browser.svg||s.Browser.vml?new s.SVG(t):null},s.Browser.vml=!s.Browser.svg&&function(){try{var t=e.createElement("div");t.innerHTML='<v:shape adj="1"/>';var i=t.firstChild;return i.style.behavior="url(#default#VML)",i&&"object"==typeof i.adj}catch(n){return!1}}(),s.SVG.include(s.Browser.vml?{_initContainer:function(){this._container=s.DomUtil.create("div","leaflet-vml-container"),this._paths={},this._initEvents()},_update:function(){this._map._animatingZoom||s.Renderer.prototype._update.call(this)},_initPath:function(t){var e=t._container=s.SVG.create("shape");s.DomUtil.addClass(e,"leaflet-vml-shape "+(this.options.className||"")),e.coordsize="1 1",t._path=s.SVG.create("path"),e.appendChild(t._path),this._updateStyle(t)},_addPath:function(t){var e=t._container;this._container.appendChild(e),this._paths[s.stamp(e)]=t},_removePath:function(t){var e=t._container;s.DomUtil.remove(e),delete this._paths[s.stamp(e)]},_updateStyle:function(t){var e=t._stroke,i=t._fill,n=t.options,o=t._container;o.stroked=!!n.stroke,o.filled=!!n.fill,n.stroke?(e||(e=t._stroke=s.SVG.create("stroke"),o.appendChild(e)),e.weight=n.weight+"px",e.color=n.color,e.opacity=n.opacity,n.dashArray?e.dashStyle=s.Util.isArray(n.dashArray)?n.dashArray.join(" "):n.dashArray.replace(/( *, *)/g," "):e.dashStyle="",e.endcap=n.lineCap.replace("butt","flat"),e.joinstyle=n.lineJoin):e&&(o.removeChild(e),t._stroke=null),n.fill?(i||(i=t._fill=s.SVG.create("fill"),o.appendChild(i)),i.color=n.fillColor||n.color,i.opacity=n.fillOpacity):i&&(o.removeChild(i),t._fill=null)},_updateCircle:function(t){var e=t._point.round(),i=Math.round(t._radius),n=Math.round(t._radiusY||i);this._setPath(t,t._empty()?"M0 0":"AL "+e.x+","+e.y+" "+i+","+n+" 0,23592600")},_setPath:function(t,e){t._path.v=e},_bringToFront:function(t){s.DomUtil.toFront(t._container)},_bringToBack:function(t){s.DomUtil.toBack(t._container)}}:{}),s.Browser.vml&&(s.SVG.create=function(){try{return e.namespaces.add("lvml","urn:schemas-microsoft-com:vml"),function(t){return e.createElement("<lvml:"+t+' class="lvml">')}}catch(t){return function(t){return e.createElement("<"+t+' xmlns="urn:schemas-microsoft.com:vml" class="lvml">')}}}()),s.Canvas=s.Renderer.extend({onAdd:function(){s.Renderer.prototype.onAdd.call(this),this._layers=this._layers||{},this._draw()},_initContainer:function(){var t=this._container=e.createElement("canvas");s.DomEvent.on(t,"mousemove",this._onMouseMove,this).on(t,"click dblclick mousedown mouseup contextmenu",this._onClick,this),this._ctx=t.getContext("2d")},_update:function(){if(!this._map._animatingZoom||!this._bounds){s.Renderer.prototype._update.call(this);var t=this._bounds,e=this._container,i=t.getSize(),n=s.Browser.retina?2:1;s.DomUtil.setPosition(e,t.min),e.width=n*i.x,e.height=n*i.y,e.style.width=i.x+"px",e.style.height=i.y+"px",s.Browser.retina&&this._ctx.scale(2,2),this._ctx.translate(-t.min.x,-t.min.y)}},_initPath:function(t){this._layers[s.stamp(t)]=t},_addPath:s.Util.falseFn,_removePath:function(t){t._removed=!0,this._requestRedraw(t)},_updatePath:function(t){this._redrawBounds=t._pxBounds,this._draw(!0),t._project(),t._update(),this._draw(),this._redrawBounds=null},_updateStyle:function(t){this._requestRedraw(t)},_requestRedraw:function(t){this._map&&(this._redrawBounds=this._redrawBounds||new s.Bounds,this._redrawBounds.extend(t._pxBounds.min).extend(t._pxBounds.max),this._redrawRequest=this._redrawRequest||s.Util.requestAnimFrame(this._redraw,this))},_redraw:function(){this._redrawRequest=null,this._draw(!0),this._draw(),this._redrawBounds=null},_draw:function(t){this._clear=t;var e;for(var i in this._layers)e=this._layers[i],(!this._redrawBounds||e._pxBounds.intersects(this._redrawBounds))&&e._updatePath(),t&&e._removed&&(delete e._removed,delete this._layers[i])},_updatePoly:function(t,e){var i,n,s,o,a=t._parts,r=a.length,l=this._ctx;if(r){for(l.beginPath(),i=0;r>i;i++){for(n=0,s=a[i].length;s>n;n++)o=a[i][n],l[n?"lineTo":"moveTo"](o.x,o.y);e&&l.closePath()}this._fillStroke(l,t)}},_updateCircle:function(t){if(!t._empty()){var e=t._point,i=this._ctx,n=t._radius,s=(t._radiusY||n)/n;1!==s&&(i.save(),i.scale(1,s)),i.beginPath(),i.arc(e.x,e.y/s,n,0,2*Math.PI,!1),1!==s&&i.restore(),this._fillStroke(i,t)}},_fillStroke:function(t,e){var i=this._clear,n=e.options;t.globalCompositeOperation=i?"destination-out":"source-over",n.fill&&(t.globalAlpha=i?1:n.fillOpacity,t.fillStyle=n.fillColor||n.color,t.fill(n.fillRule||"evenodd")),n.stroke&&0!==n.weight&&(t.globalAlpha=i?1:n.opacity,e._prevWeight=t.lineWidth=i?e._prevWeight+1:n.weight,t.strokeStyle=n.color,t.lineCap=n.lineCap,t.lineJoin=n.lineJoin,t.stroke())},_onClick:function(t){var e=this._map.mouseEventToLayerPoint(t);for(var i in this._layers)this._layers[i]._containsPoint(e)&&(s.DomEvent._fakeStop(t),this._fireEvent(this._layers[i],t))},_onMouseMove:function(t){if(this._map&&!this._map._animatingZoom){var e=this._map.mouseEventToLayerPoint(t);for(var i in this._layers)this._handleHover(this._layers[i],t,e)}},_handleHover:function(t,e,i){t.options.interactive&&(t._containsPoint(i)?(t._mouseInside||(s.DomUtil.addClass(this._container,"leaflet-interactive"),this._fireEvent(t,e,"mouseover"),t._mouseInside=!0),this._fireEvent(t,e)):t._mouseInside&&(s.DomUtil.removeClass(this._container,"leaflet-interactive"),this._fireEvent(t,e,"mouseout"),t._mouseInside=!1))},_fireEvent:function(t,e,i){this._map._fireDOMEvent(t,e,i||e.type)},_bringToFront:s.Util.falseFn,_bringToBack:s.Util.falseFn}),s.Browser.canvas=function(){return!!e.createElement("canvas").getContext}(),s.canvas=function(t){return s.Browser.canvas?new s.Canvas(t):null},s.Polyline.prototype._containsPoint=function(t,e){var i,n,o,a,r,l,h=this._clickTolerance();if(!this._pxBounds.contains(t))return!1;for(i=0,a=this._parts.length;a>i;i++)for(l=this._parts[i],n=0,r=l.length,o=r-1;r>n;o=n++)if((e||0!==n)&&s.LineUtil.pointToSegmentDistance(t,l[o],l[n])<=h)return!0;return!1},s.Polygon.prototype._containsPoint=function(t){var e,i,n,o,a,r,l,h,d=!1;if(!this._pxBounds.contains(t))return!1;for(o=0,l=this._parts.length;l>o;o++)for(e=this._parts[o],a=0,h=e.length,r=h-1;h>a;r=a++)i=e[a],n=e[r],i.y>t.y!=n.y>t.y&&t.x<(n.x-i.x)*(t.y-i.y)/(n.y-i.y)+i.x&&(d=!d);return d||s.Polyline.prototype._containsPoint.call(this,t,!0)},s.CircleMarker.prototype._containsPoint=function(t){return t.distanceTo(this._point)<=this._radius+this._clickTolerance()},s.GeoJSON=s.FeatureGroup.extend({initialize:function(t,e){s.setOptions(this,e),this._layers={},t&&this.addData(t)},addData:function(t){var e,i,n,o=s.Util.isArray(t)?t:t.features;if(o){for(e=0,i=o.length;i>e;e++)n=o[e],(n.geometries||n.geometry||n.features||n.coordinates)&&this.addData(n);return this}var a=this.options;if(a.filter&&!a.filter(t))return this;var r=s.GeoJSON.geometryToLayer(t,a);return r.feature=s.GeoJSON.asFeature(t),r.defaultOptions=r.options,this.resetStyle(r),a.onEachFeature&&a.onEachFeature(t,r),this.addLayer(r)},resetStyle:function(t){return t.options=t.defaultOptions,this._setLayerStyle(t,this.options.style),this},setStyle:function(t){return this.eachLayer(function(e){this._setLayerStyle(e,t)},this)},_setLayerStyle:function(t,e){"function"==typeof e&&(e=e(t.feature)),t.setStyle&&t.setStyle(e)}}),s.extend(s.GeoJSON,{geometryToLayer:function(t,e){var i,n,o,a,r="Feature"===t.type?t.geometry:t,l=r.coordinates,h=[],d=e&&e.pointToLayer,u=e&&e.coordsToLatLng||this.coordsToLatLng;switch(r.type){case"Point":return i=u(l),d?d(t,i):new s.Marker(i);case"MultiPoint":for(o=0,a=l.length;a>o;o++)i=u(l[o]),h.push(d?d(t,i):new s.Marker(i));return new s.FeatureGroup(h);case"LineString":case"MultiLineString":return n=this.coordsToLatLngs(l,"LineString"===r.type?0:1,u),new s.Polyline(n,e);case"Polygon":case"MultiPolygon":return n=this.coordsToLatLngs(l,"Polygon"===r.type?1:2,u),new s.Polygon(n,e);case"GeometryCollection":for(o=0,a=r.geometries.length;a>o;o++)h.push(this.geometryToLayer({geometry:r.geometries[o],type:"Feature",properties:t.properties},e));return new s.FeatureGroup(h);default:throw new Error("Invalid GeoJSON object.")}},coordsToLatLng:function(t){return new s.LatLng(t[1],t[0],t[2])},coordsToLatLngs:function(t,e,i){for(var n,s=[],o=0,a=t.length;a>o;o++)n=e?this.coordsToLatLngs(t[o],e-1,i):(i||this.coordsToLatLng)(t[o]),s.push(n);return s},latLngToCoords:function(t){return t.alt!==i?[t.lng,t.lat,t.alt]:[t.lng,t.lat]},latLngsToCoords:function(t,e,i){for(var n=[],o=0,a=t.length;a>o;o++)n.push(e?s.GeoJSON.latLngsToCoords(t[o],e-1,i):s.GeoJSON.latLngToCoords(t[o]));return!e&&i&&n.push(n[0]),n},getFeature:function(t,e){return t.feature?s.extend({},t.feature,{geometry:e}):s.GeoJSON.asFeature(e)},asFeature:function(t){return"Feature"===t.type?t:{type:"Feature",properties:{},geometry:t}}});var a={toGeoJSON:function(){return s.GeoJSON.getFeature(this,{type:"Point",coordinates:s.GeoJSON.latLngToCoords(this.getLatLng())})}};s.Marker.include(a),s.Circle.include(a),s.CircleMarker.include(a),s.Polyline.prototype.toGeoJSON=function(){var t=!this._flat(this._latlngs),e=s.GeoJSON.latLngsToCoords(this._latlngs,t?1:0);return s.GeoJSON.getFeature(this,{type:(t?"Multi":"")+"LineString",coordinates:e})},s.Polygon.prototype.toGeoJSON=function(){var t=!this._flat(this._latlngs),e=t&&!this._flat(this._latlngs[0]),i=s.GeoJSON.latLngsToCoords(this._latlngs,e?2:t?1:0,!0);return t||(i=[i]),s.GeoJSON.getFeature(this,{type:(e?"Multi":"")+"Polygon",coordinates:i})},s.LayerGroup.include({toMultiPoint:function(){var t=[];return this.eachLayer(function(e){t.push(e.toGeoJSON().geometry.coordinates)}),s.GeoJSON.getFeature(this,{type:"MultiPoint",coordinates:t})},toGeoJSON:function(){var t=this.feature&&this.feature.geometry&&this.feature.geometry.type;if("MultiPoint"===t)return this.toMultiPoint();var e="GeometryCollection"===t,i=[];return this.eachLayer(function(t){if(t.toGeoJSON){var n=t.toGeoJSON();i.push(e?n.geometry:s.GeoJSON.asFeature(n))}}),e?s.GeoJSON.getFeature(this,{geometries:i,type:"GeometryCollection"}):{type:"FeatureCollection",features:i}}}),s.geoJson=function(t,e){return new s.GeoJSON(t,e)};var r="_leaflet_events";s.DomEvent={on:function(t,e,i,n){if("object"==typeof e)for(var o in e)this._on(t,o,e[o],i);else{e=s.Util.splitWords(e);for(var a=0,r=e.length;r>a;a++)this._on(t,e[a],i,n)}return this},off:function(t,e,i,n){if("object"==typeof e)for(var o in e)this._off(t,o,e[o],i);else{e=s.Util.splitWords(e);for(var a=0,r=e.length;r>a;a++)this._off(t,e[a],i,n)}return this},_on:function(e,i,n,o){var a=i+s.stamp(n)+(o?"_"+s.stamp(o):"");if(e[r]&&e[r][a])return this;var l=function(i){return n.call(o||e,i||t.event)},h=l;return s.Browser.pointer&&0===i.indexOf("touch")?this.addPointerListener(e,i,l,a):s.Browser.touch&&"dblclick"===i&&this.addDoubleTapListener?this.addDoubleTapListener(e,l,a):"trplclick"===i||"qdrplclick"===i?this.addMultiClickListener(e,l,a,i):"addEventListener"in e?"mousewheel"===i?(e.addEventListener("DOMMouseScroll",l,!1),e.addEventListener(i,l,!1)):"mouseenter"===i||"mouseleave"===i?(l=function(i){i=i||t.event,s.DomEvent._checkMouse(e,i)&&h(i)},e.addEventListener("mouseenter"===i?"mouseover":"mouseout",l,!1)):("click"===i&&s.Browser.android&&(l=function(t){return s.DomEvent._filterClick(t,h)}),e.addEventListener(i,l,!1)):"attachEvent"in e&&e.attachEvent("on"+i,l),e[r]=e[r]||{},e[r][a]=l,this},_off:function(t,e,i,n){var o=e+s.stamp(i)+(n?"_"+s.stamp(n):""),a=t[r]&&t[r][o];return a?(s.Browser.pointer&&0===e.indexOf("touch")?this.removePointerListener(t,e,o):s.Browser.touch&&"dblclick"===e&&this.removeDoubleTapListener?this.removeDoubleTapListener(t,o):"trplclick"===e||"qdrplclick"===e?this.removeMultiClickListener(t,o,e):"removeEventListener"in t?"mousewheel"===e?(t.removeEventListener("DOMMouseScroll",a,!1),t.removeEventListener(e,a,!1)):t.removeEventListener("mouseenter"===e?"mouseover":"mouseleave"===e?"mouseout":e,a,!1):"detachEvent"in t&&t.detachEvent("on"+e,a),t[r][o]=null,this):this},stopPropagation:function(t){return t.stopPropagation?t.stopPropagation():t.cancelBubble=!0,s.DomEvent._skipped(t),this},disableScrollPropagation:function(t){return s.DomEvent.on(t,"mousewheel MozMousePixelScroll",s.DomEvent.stopPropagation)},disableClickPropagation:function(t){var e=s.DomEvent.stopPropagation;return s.DomEvent.on(t,s.Draggable.START.join(" "),e),s.DomEvent.on(t,{click:s.DomEvent._fakeStop,dblclick:e})},preventDefault:function(t){return t.preventDefault?t.preventDefault():t.returnValue=!1,this},stop:function(t){return s.DomEvent.preventDefault(t).stopPropagation(t)},getMousePosition:function(t,e){if(!e)return new s.Point(t.clientX,t.clientY);var i=e.getBoundingClientRect(),n=i.left,o=i.top;return t.currentTarget&&t.currentTarget.frameElement&&s.DomUtil.hasClass(t.currentTarget.frameElement,"resize-detector")&&(n=o=0),new s.Point(t.clientX-n-e.clientLeft,t.clientY-o-e.clientTop)},getWheelDelta:function(t){var e=0;return t.wheelDelta&&(e=t.wheelDelta/120),t.detail&&(e=-t.detail/3),e},_skipEvents:{},_fakeStop:function(t){s.DomEvent._skipEvents[t.type]=!0},_skipped:function(t){var e=this._skipEvents[t.type];return this._skipEvents[t.type]=!1,e},_checkMouse:function(t,e){var i=e.relatedTarget;if(!i)return!0;try{for(;i&&i!==t;)i=i.parentNode}catch(n){return!1}return i!==t},_filterClick:function(t,e){var i=t.timeStamp||t.originalEvent.timeStamp,n=s.DomEvent._lastClick&&i-s.DomEvent._lastClick;return n&&n>100&&500>n||t.target._simulatedClick&&!t._simulated?void s.DomEvent.stop(t):(s.DomEvent._lastClick=i,void e(t))}},s.DomEvent.addListener=s.DomEvent.on,s.DomEvent.removeListener=s.DomEvent.off,s.Draggable=s.Evented.extend({statics:{START:s.Browser.touch?["touchstart","mousedown"]:["mousedown"],END:{mousedown:"mouseup",touchstart:"touchend",pointerdown:"touchend",MSPointerDown:"touchend"},MOVE:{mousedown:"mousemove",touchstart:"touchmove",pointerdown:"touchmove",MSPointerDown:"touchmove"}},initialize:function(t,e,i){this._element=t,this._dragStartTarget=e||t,this._preventOutline=i},enable:function(){this._enabled||(s.DomEvent.on(this._dragStartTarget,s.Draggable.START.join(" "),this._onDown,this),this._enabled=!0)},disable:function(){this._enabled&&(s.DomEvent.off(this._dragStartTarget,s.Draggable.START.join(" "),this._onDown,this),this._enabled=!1,this._moved=!1)},_onDown:function(t){if(this._moved=!1,!t.shiftKey&&(1===t.which||0===t.button||t.touches)&&(s.DomUtil.hasClass(this._element,"leaflet-map-pane")||s.DomEvent.stopPropagation(t),this._preventOutline&&s.DomUtil.preventOutline(this._element),!s.DomUtil.hasClass(this._element,"leaflet-zoom-anim")&&(s.DomUtil.disableImageDrag(),s.DomUtil.disableTextSelection(),!this._moving))){this.fire("down");var i=t.touches?t.touches[0]:t;this._startPoint=new s.Point(i.clientX,i.clientY),this._startPos=this._newPos=s.DomUtil.getPosition(this._element);var n=this._element.getBoundingClientRect();this.startOffset=this._startPoint.subtract(new s.Point(n.left,n.top)),s.DomEvent.on(e,s.Draggable.MOVE[t.type],this._onMove,this).on(e,s.Draggable.END[t.type],this._onUp,this)}},_onMove:function(t){if(t.touches&&t.touches.length>1)return void(this._moved=!0);var i=t.touches&&1===t.touches.length?t.touches[0]:t,n=new s.Point(i.clientX,i.clientY),o=n.subtract(this._startPoint);if(this._map){if(t.currentTarget&&t.currentTarget.frameElement&&s.DomUtil.hasClass(t.currentTarget.frameElement,"resize-detector")){var a=this._map._container.getBoundingClientRect(),r=new s.Point(a.left,a.top);o=o.add(r)}this._map.getDocSize().x<this._map.getSize().x&&(o.x=0),this._map.getDocSize().y<this._map.getSize().y&&(o.y=0)}(o.x||o.y)&&(s.Browser.touch&&Math.abs(o.x)+Math.abs(o.y)<3||(s.DomEvent.preventDefault(t),this._moved||(this.fire("dragstart"),this._moved=!0,this._startPos=s.DomUtil.getPosition(this._element).subtract(o),s.DomUtil.addClass(e.body,"leaflet-dragging"),this._lastTarget=t.target||t.srcElement,s.DomUtil.addClass(this._lastTarget,"leaflet-drag-target")),this._newPos=this._startPos.add(o),this._moving=!0,s.Util.cancelAnimFrame(this._animRequest),this._lastEvent=t,this._animRequest=s.Util.requestAnimFrame(this._updatePosition,this,!0,this._dragStartTarget)))},_updatePosition:function(){var t={originalEvent:this._lastEvent};this.fire("predrag",t),s.DomUtil.setPosition(this._element,this._newPos),this.fire("drag",t)},_onUp:function(){s.DomUtil.removeClass(e.body,"leaflet-dragging"),this._lastTarget&&(s.DomUtil.removeClass(this._lastTarget,"leaflet-drag-target"),this._lastTarget=null);for(var t in s.Draggable.MOVE)s.DomEvent.off(e,s.Draggable.MOVE[t],this._onMove,this).off(e,s.Draggable.END[t],this._onUp,this);s.DomUtil.enableImageDrag(),s.DomUtil.enableTextSelection(),this._moved&&this._moving&&(s.Util.cancelAnimFrame(this._animRequest),this.fire("dragend",{distance:this._newPos.distanceTo(this._startPos)})),this._moving=!1}}),s.Handler=s.Class.extend({initialize:function(t){this._map=t},enable:function(){this._enabled||(this._enabled=!0,this.addHooks())},disable:function(){this._enabled&&(this._enabled=!1,this.removeHooks())},enabled:function(){return!!this._enabled}}),s.Map.mergeOptions({dragging:!0,inertia:!s.Browser.android23,inertiaDeceleration:3400,inertiaMaxSpeed:1/0,easeLinearity:.2,worldCopyJump:!1}),s.Map.Drag=s.Handler.extend({addHooks:function(){if(!this._draggable){var t=this._map;this._draggable=new s.Draggable(t._mapPane,t._container),this._draggable._map=t,this._draggable.on({down:this._onDown,dragstart:this._onDragStart,drag:this._onDrag,dragend:this._onDragEnd},this),t.options.worldCopyJump&&(this._draggable.on("predrag",this._onPreDrag,this),t.on("viewreset",this._onViewReset,this),t.whenReady(this._onViewReset,this))}this._draggable.enable()},removeHooks:function(){this._draggable.disable()},moved:function(){return this._draggable&&this._draggable._moved},_onDown:function(){this._map.stop()},_onDragStart:function(){var t=this._map;t.fire("movestart").fire("dragstart"),t.options.inertia&&(this._positions=[],this._times=[])},_onDrag:function(t){if(this._map.options.inertia){var e=this._lastTime=+new Date,i=this._lastPos=this._draggable._absPos||this._draggable._newPos;this._positions.push(i),this._times.push(e),e-this._times[0]>50&&(this._positions.shift(),this._times.shift())}this._map.fire("move",t).fire("drag",t)},_onViewReset:function(){var t=this._map.getSize().divideBy(2),e=this._map.latLngToLayerPoint([0,0]);this._initialWorldOffset=e.subtract(t).x,this._worldWidth=this._map.getPixelWorldBounds().getSize().x},_onPreDrag:function(){var t=this._worldWidth,e=Math.round(t/2),i=this._initialWorldOffset,n=this._draggable._newPos.x,s=(n-e+i)%t+e-i,o=(n+e+i)%t-e-i,a=Math.abs(s+i)<Math.abs(o+i)?s:o;this._draggable._absPos=this._draggable._newPos.clone(),this._draggable._newPos.x=a},_onDragEnd:function(t){var e=this._map,i=e.options,n=!i.inertia||this._times.length<2;if(e.fire("dragend",t),n)e.fire("moveend");else{var o=this._lastPos.subtract(this._positions[0]),a=(this._lastTime-this._times[0])/1e3,r=i.easeLinearity,l=o.multiplyBy(r/a),h=l.distanceTo([0,0]),d=Math.min(i.inertiaMaxSpeed,h),u=l.multiplyBy(d/h),c=d/(i.inertiaDeceleration*r),p=u.multiplyBy(-c/2).round();p.x&&p.y?(p=e._limitOffset(p,e.options.maxBounds),s.Util.requestAnimFrame(function(){e.panBy(p,{duration:c,easeLinearity:r,noMoveStart:!0,animate:!0})})):e.fire("moveend")}}}),s.Map.addInitHook("addHandler","dragging",s.Map.Drag),s.Map.mergeOptions({scrollHandler:!0,wheelDebounceTime:40}),s.Map.Scroll=s.Handler.extend({addHooks:function(){s.DomEvent.on(this._map._container,{mousewheel:this._onWheelScroll,MozMousePixelScroll:s.DomEvent.preventDefault},this),this._delta=0},removeHooks:function(){s.DomEvent.off(this._map._container,{mousewheel:this._onWheelScroll,MozMousePixelScroll:s.DomEvent.preventDefault},this)},_onWheelScroll:function(t){var e=s.DomEvent.getWheelDelta(t),i=this._map.options.wheelDebounceTime;this._delta+=e,this._lastMousePos=this._map.mouseEventToContainerPoint(t),this._startTime||(this._startTime=+new Date);var n=Math.max(i-(+new Date-this._startTime),0);clearTimeout(this._timer),this._timer=setTimeout(s.bind(this._performScroll,this),n),s.DomEvent.stop(t)},_performScroll:function(){var t=this._map,e=-this._delta,i=Math.round(t.getSize().y/4);this._delta=0,this._startTime=null,e&&t.fire("scrollby",{x:0,y:e*i})}}),s.Map.addInitHook("addHandler","scrollHandler",s.Map.Scroll),s.Map.mergeOptions({doubleClickZoom:!1}),s.Map.DoubleClickZoom=s.Handler.extend({addHooks:function(){this._map.on("dblclick",this._onDoubleClick,this)},removeHooks:function(){this._map.off("dblclick",this._onDoubleClick,this)},_onDoubleClick:function(t){var e=this._map,i=e.getZoom(),n=t.originalEvent.shiftKey?Math.ceil(i)-1:Math.floor(i)+1;"center"===e.options.doubleClickZoom?e.setZoom(n):e.setZoomAround(t.containerPoint,n)}}),s.Map.addInitHook("addHandler","doubleClickZoom",s.Map.DoubleClickZoom),s.extend(s.DomEvent,{_touchstart:s.Browser.msPointer?"MSPointerDown":s.Browser.pointer?"pointerdown":"touchstart",_touchend:s.Browser.msPointer?"MSPointerUp":s.Browser.pointer?"pointerup":"touchend",addDoubleTapListener:function(t,e,i){function n(t){var e;if(e=s.Browser.pointer?s.DomEvent._pointersCount:t.touches.length,!(e>1)){var i=Date.now(),n=i-(a||i);r=t.touches?t.touches[0]:t,l=n>0&&h>=n,a=i}}function o(){if(l){if(s.Browser.pointer){var t,i,n={};for(i in r)t=r[i],n[i]=t&&t.bind?t.bind(r):t;r=n}r.type="dblclick",r.button=0,e(r),a=null}}var a,r,l=!1,h=250,d="_leaflet_",u=this._touchstart,c=this._touchend;return t[d+u+i]=n,t[d+c+i]=o,t.addEventListener(u,n,!1),t.addEventListener(c,o,!1),this},removeDoubleTapListener:function(t,e){var i="_leaflet_",n=t[i+this._touchend+e];return t.removeEventListener(this._touchstart,t[i+this._touchstart+e],!1),t.removeEventListener(this._touchend,n,!1),this}}),s.extend(s.DomEvent,{POINTER_DOWN:s.Browser.msPointer?"MSPointerDown":"pointerdown",POINTER_MOVE:s.Browser.msPointer?"MSPointerMove":"pointermove",POINTER_UP:s.Browser.msPointer?"MSPointerUp":"pointerup",POINTER_CANCEL:s.Browser.msPointer?"MSPointerCancel":"pointercancel",_pointers:{},_pointersCount:0,addPointerListener:function(t,e,i,n){return"touchstart"===e?this._addPointerStart(t,i,n):"touchmove"===e?this._addPointerMove(t,i,n):"touchend"===e&&this._addPointerEnd(t,i,n),this},removePointerListener:function(t,e,i){var n=t["_leaflet_"+e+i];return"touchstart"===e?t.removeEventListener(this.POINTER_DOWN,n,!1):"touchmove"===e?t.removeEventListener(this.POINTER_MOVE,n,!1):"touchend"===e&&(t.removeEventListener(this.POINTER_UP,n,!1),
t.removeEventListener(this.POINTER_CANCEL,n,!1)),this},_addPointerStart:function(t,i,n){var o=s.bind(function(t){s.DomEvent.preventDefault(t),this._handlePointer(t,i)},this);if(t["_leaflet_touchstart"+n]=o,t.addEventListener(this.POINTER_DOWN,o,!1),!this._pointerDocListener){var a=s.bind(this._globalPointerUp,this);e.documentElement.addEventListener(this.POINTER_DOWN,s.bind(this._globalPointerDown,this),!0),e.documentElement.addEventListener(this.POINTER_MOVE,s.bind(this._globalPointerMove,this),!0),e.documentElement.addEventListener(this.POINTER_UP,a,!0),e.documentElement.addEventListener(this.POINTER_CANCEL,a,!0),this._pointerDocListener=!0}},_globalPointerDown:function(t){this._pointers[t.pointerId]=t,this._pointersCount++},_globalPointerMove:function(t){this._pointers[t.pointerId]&&(this._pointers[t.pointerId]=t)},_globalPointerUp:function(t){delete this._pointers[t.pointerId],this._pointersCount--},_handlePointer:function(t,e){t.touches=[];for(var i in this._pointers)t.touches.push(this._pointers[i]);t.changedTouches=[t],e(t)},_addPointerMove:function(t,e,i){var n=s.bind(function(t){(t.pointerType!==t.MSPOINTER_TYPE_MOUSE&&"mouse"!==t.pointerType||0!==t.buttons)&&this._handlePointer(t,e)},this);t["_leaflet_touchmove"+i]=n,t.addEventListener(this.POINTER_MOVE,n,!1)},_addPointerEnd:function(t,e,i){var n=s.bind(function(t){this._handlePointer(t,e)},this);t["_leaflet_touchend"+i]=n,t.addEventListener(this.POINTER_UP,n,!1),t.addEventListener(this.POINTER_CANCEL,n,!1)}}),s.Map.mergeOptions({touchZoom:s.Browser.touch&&!s.Browser.android23,bounceAtZoomLimits:!0}),s.Map.TouchZoom=s.Handler.extend({addHooks:function(){s.DomEvent.on(this._map._container,"touchstart",this._onTouchStart,this)},removeHooks:function(){s.DomEvent.off(this._map._container,"touchstart",this._onTouchStart,this)},_onTouchStart:function(t){var i=this._map;if(t.touches&&2===t.touches.length&&!i._animatingZoom&&!this._zooming){var n=i.mouseEventToLayerPoint(t.touches[0]),o=i.mouseEventToLayerPoint(t.touches[1]),a=i._getCenterLayerPoint();this._startCenter=n.add(o)._divideBy(2),this._startDist=n.distanceTo(o),this._moved=!1,"spreadsheet"===i.getDocType()?this._zooming=!1:this._zooming=!0,this._centerOffset=a.subtract(this._startCenter),i.stop(),s.DomEvent.on(e,"touchmove",this._onTouchMove,this).on(e,"touchend",this._onTouchEnd,this),s.DomEvent.preventDefault(t)}},_onTouchMove:function(t){if(t.touches&&2===t.touches.length&&this._zooming){var e=this._map,i=e.mouseEventToLayerPoint(t.touches[0]),n=e.mouseEventToLayerPoint(t.touches[1]);if(this._scale=i.distanceTo(n)/this._startDist,this._delta=i._add(n)._divideBy(2)._subtract(this._startCenter),!e.options.bounceAtZoomLimits){var o=e.getScaleZoom(this._scale);if(o<=e.getMinZoom()&&this._scale<1||o>=e.getMaxZoom()&&this._scale>1)return}this._moved||(e.fire("movestart").fire("zoomstart"),this._moved=!0),s.Util.cancelAnimFrame(this._animRequest),this._animRequest=s.Util.requestAnimFrame(this._updateOnMove,this,!0,this._map._container),s.DomEvent.preventDefault(t)}},_updateOnMove:function(){var t=this._map;"center"===t.options.touchZoom?this._center=t.getCenter():this._center=t.layerPointToLatLng(this._getTargetCenter()),this._zoom=t.getScaleZoom(this._scale),(1!==this._scale||0!==this._delta.x||0!==this._delta.y)&&t._animateZoom(this._center,this._zoom,!1,!0)},_onTouchEnd:function(){if(!this._moved||!this._zooming)return void(this._zooming=!1);this._zooming=!1,s.Util.cancelAnimFrame(this._animRequest),s.DomEvent.off(e,"touchmove",this._onTouchMove).off(e,"touchend",this._onTouchEnd);var t=this._map,i=t.getZoom(),n=this._zoom-i,o=t._limitZoom(n>0?Math.ceil(this._zoom):Math.floor(this._zoom));t._animateZoom(this._center,o,!0,!0)},_getTargetCenter:function(){var t=this._centerOffset.subtract(this._delta).divideBy(this._scale);return this._startCenter.add(t)}}),s.Map.addInitHook("addHandler","touchZoom",s.Map.TouchZoom),s.Map.mergeOptions({tap:!0,tapTolerance:15}),s.Map.Tap=s.Handler.extend({addHooks:function(){s.DomEvent.on(this._map._container,"touchstart",this._onDown,this)},removeHooks:function(){s.DomEvent.off(this._map._container,"touchstart",this._onDown,this)},_onDown:function(t){if(t.touches){if(s.DomEvent.preventDefault(t),this._fireClick=!0,t.touches.length>1)return this._fireClick=!1,void clearTimeout(this._holdTimeout);var i=t.touches[0],n=i.target;this._startPos=this._newPos=new s.Point(i.clientX,i.clientY),n.tagName&&"a"===n.tagName.toLowerCase()&&s.DomUtil.addClass(n,"leaflet-active"),this._holdTimeout=setTimeout(s.bind(function(){this._isTapValid()&&(this._fireClick=!1,this._onUp(),this._simulateEvent("contextmenu",i))},this),1e3),this._simulateEvent("mousedown",i),s.DomEvent.on(e,{touchmove:this._onMove,touchend:this._onUp},this)}},_onUp:function(t){if(clearTimeout(this._holdTimeout),s.DomEvent.off(e,{touchmove:this._onMove,touchend:this._onUp},this),this._fireClick&&t&&t.changedTouches){var i=t.changedTouches[0],n=i.target;n&&n.tagName&&"a"===n.tagName.toLowerCase()&&s.DomUtil.removeClass(n,"leaflet-active"),this._simulateEvent("mouseup",i),this._isTapValid()&&this._simulateEvent("click",i)}},_isTapValid:function(){return this._newPos.distanceTo(this._startPos)<=this._map.options.tapTolerance},_onMove:function(t){var e=t.touches[0];this._newPos=new s.Point(e.clientX,e.clientY)},_simulateEvent:function(i,n){var s=e.createEvent("MouseEvents");s._simulated=!0,n.target._simulatedClick=!0,s.initMouseEvent(i,!0,!0,t,1,n.screenX,n.screenY,n.clientX,n.clientY,!1,!1,!1,!1,0,null),n.target.dispatchEvent(s)}}),s.Browser.touch&&!s.Browser.pointer&&s.Map.addInitHook("addHandler","tap",s.Map.Tap),s.Map.mergeOptions({boxZoom:!0}),s.Map.BoxZoom=s.Handler.extend({initialize:function(t){this._map=t,this._container=t._container,this._pane=t._panes.overlayPane},addHooks:function(){s.DomEvent.on(this._container,"mousedown",this._onMouseDown,this)},removeHooks:function(){s.DomEvent.off(this._container,"mousedown",this._onMouseDown,this)},moved:function(){return this._moved},_onMouseDown:function(t){return!t.shiftKey||1!==t.which&&0!==t.button?!1:(this._moved=!1,s.DomUtil.disableTextSelection(),s.DomUtil.disableImageDrag(),this._startPoint=this._map.mouseEventToContainerPoint(t),void s.DomEvent.on(e,{contextmenu:s.DomEvent.stop,mousemove:this._onMouseMove,mouseup:this._onMouseUp,keydown:this._onKeyDown},this))},_onMouseMove:function(t){this._moved||(this._moved=!0,this._box=s.DomUtil.create("div","leaflet-zoom-box",this._container),s.DomUtil.addClass(this._container,"leaflet-crosshair"),this._map.fire("boxzoomstart")),this._point=this._map.mouseEventToContainerPoint(t);var e=new s.Bounds(this._point,this._startPoint),i=e.getSize();s.DomUtil.setPosition(this._box,e.min),this._box.style.width=i.x+"px",this._box.style.height=i.y+"px"},_finish:function(){this._moved&&(s.DomUtil.remove(this._box),s.DomUtil.removeClass(this._container,"leaflet-crosshair")),s.DomUtil.enableTextSelection(),s.DomUtil.enableImageDrag(),s.DomEvent.off(e,{contextmenu:s.DomEvent.stop,mousemove:this._onMouseMove,mouseup:this._onMouseUp,keydown:this._onKeyDown},this)},_onMouseUp:function(t){(1===t.which||0===t.button)&&(this._finish(),!this._moved)},_onKeyDown:function(t){27===t.keyCode&&this._finish()}}),s.Map.addInitHook("addHandler","boxZoom",s.Map.BoxZoom),s.Map.mergeOptions({keyboard:!0,keyboardPanOffset:20,keyboardZoomOffset:1}),s.Map.Keyboard=s.Handler.extend({keyModifier:{shift:4096,ctrl:8192,alt:16384,ctrlMac:32768},keymap:{8:1283,9:1282,13:1280,16:null,17:null,18:null,19:null,20:null,27:1281,32:1284,33:1030,34:1031,35:1029,36:1028,37:1026,38:1025,39:1027,40:1024,45:1285,46:1286,48:256,49:257,50:258,51:259,52:260,53:261,54:262,55:263,56:264,57:265,65:512,66:513,67:514,68:515,69:516,70:517,71:518,72:519,73:520,74:521,75:522,76:523,77:524,78:525,79:526,80:527,81:528,82:529,83:530,84:531,85:532,86:533,87:534,88:535,89:536,90:537,91:null,92:null,93:null,96:256,97:257,98:258,99:259,100:260,101:261,102:262,103:263,104:264,105:265,106:1289,107:1287,109:1288,110:1309,111:1290,112:768,113:769,114:770,115:771,116:772,117:773,118:774,119:775,120:776,121:777,122:778,144:1313,145:1314,173:1288,186:1317,187:1295,188:1292,189:1288,190:null,191:null,192:null,219:null,220:null,221:null,222:null},handleOnKeyDownKeys:{8:!0,9:!0,19:!0,20:!0,27:!0,33:!0,34:!0,35:!0,36:!0,37:!0,38:!0,39:!0,40:!0,45:!0,46:!0},keyCodes:{pageUp:33,pageDown:34,enter:13},navigationKeyCodes:{left:[37],right:[39],down:[40],up:[38],zoomIn:[187,107,61,171],zoomOut:[189,109,173]},initialize:function(t){this._map=t,this._setPanOffset(t.options.keyboardPanOffset),this._setZoomOffset(t.options.keyboardZoomOffset),this.modifier=0},addHooks:function(){var t=this._map._container;-1===t.tabIndex&&(t.tabIndex="0"),this._map.on("mousedown",this._onMouseDown,this),this._map.on("keydown keyup keypress",this._onKeyDown,this),this._map.on("compositionstart compositionupdate compositionend textInput",this._onKeyDown,this)},removeHooks:function(){this._map.off("mousedown",this._onMouseDown,this),this._map.off("keydown keyup keypress",this._onKeyDown,this),this._map.off("compositionstart compositionupdate compositionend textInput",this._onKeyDown,this)},_handleOnKeyDown:function(t,e){return e&this.keyModifier.shift&&(45===t||46===t)?!1:this.handleOnKeyDownKeys[t]},_setPanOffset:function(t){var e,i,n=this._panKeys={},s=this.navigationKeyCodes;for(e=0,i=s.left.length;i>e;e++)n[s.left[e]]=[-1*t,0];for(e=0,i=s.right.length;i>e;e++)n[s.right[e]]=[t,0];for(e=0,i=s.down.length;i>e;e++)n[s.down[e]]=[0,t];for(e=0,i=s.up.length;i>e;e++)n[s.up[e]]=[0,-1*t]},_setZoomOffset:function(t){var e,i,n=this._zoomKeys={},s=this.navigationKeyCodes;for(e=0,i=s.zoomIn.length;i>e;e++)n[s.zoomIn[e]]=t;for(e=0,i=s.zoomOut.length;i>e;e++)n[s.zoomOut[e]]=-t},_onMouseDown:function(){"edit"!==this._map._permission&&this._map._container.focus()},_toUNOKeyCode:function(t){return this.keymap[t]||t},_onKeyDown:function(t){if(!this._map.slideShow||!this._map.slideShow.fullscreen){var e=this._map._docLayer;this.modifier=0;var n=t.originalEvent.shiftKey?this.keyModifier.shift:0,o=t.originalEvent.ctrlKey?this.keyModifier.ctrl:0,a=t.originalEvent.altKey?this.keyModifier.alt:0,r=t.originalEvent.metaKey?this.keyModifier.ctrl:0,l=t.originalEvent.location;if(this._keyHandled=this._keyHandled||!1,this.modifier=n|o|a|r,o&&a){if("keydown"===t.type&&2===l)return void(this._prevCtrlAltLocation=l);if(1===l&&(this._prevCtrlAltLocation=i),2===this._prevCtrlAltLocation&&0===l){if("keypress"!==t.type)return;o=a=this.modifier=0}}if(!o&&!r||!this._handleCtrlCommand(t)){var h=t.originalEvent.charCode,d=t.originalEvent.keyCode;if(("compositionstart"===t.type||"compositionupdate"===t.type)&&(this._isComposing=!0),"compositionend"===t.type){this._isComposing=!1;for(var u=[],c=0;c<t.originalEvent.data.length;c++)u.push(t.originalEvent.data[c].charCodeAt());this._map._textArea.value=""}this._isComposing||"keyup"!==t.type||(this._map._textArea.value="");var p=this._toUNOKeyCode(d);if(this.modifier&&(p|=this.modifier,"keyup"!==t.type&&(this.modifier!==n||32===d&&!e._isCursorVisible)))return e._postKeyboardEvent("input",h,p),void t.originalEvent.preventDefault();if("edit"===this._map._permission){if(e._resetPreFetching(),"keydown"===t.type)this._keyHandled=!1,this._bufferedTextInputEvent=null,this._handleOnKeyDown(d,this.modifier)&&0===h&&e._postKeyboardEvent("input",h,p);else if("keypress"!==t.type&&"compositionend"!==t.type||this._handleOnKeyDown(d,this.modifier)&&0===h){if("textInput"===t.type)this._bufferedTextInputEvent=t;else if("keyup"===t.type){if(!this._keyHandled&&this._bufferedTextInputEvent){var _=this._bufferedTextInputEvent.originalEvent.data;h=t.originalEvent.keyCode;for(var u=[],c=0;c<_.length;c++)u.push(_[c].charCodeAt());e._postKeyboardEvents("input",u,Array.apply(null,Array(u.length)).map(Number.prototype.valueOf,0))}e._postKeyboardEvent("up",h,p),this._keyHandled=!0,this._bufferedTextInputEvent=null}}else h===d&&13!==h&&(d=0,p=this._toUNOKeyCode(d)),e._debug&&e._debugKeypressQueue.push(+new Date),"compositionend"===t.type?e._postKeyboardEvents("input",u,Array.apply(null,Array(u.length)).map(Number.prototype.valueOf,0)):e._postKeyboardEvent("input",h,p),this._keyHandled=!0;9===d&&t.originalEvent.preventDefault()}else{if(!(this.modifier||33!==t.originalEvent.keyCode&&34!==t.originalEvent.keyCode))return;if("keydown"===t.type){var m=t.originalEvent.keyCode,g=this._map;if(m in this._panKeys&&!t.originalEvent.shiftKey){if(g._panAnim&&g._panAnim._inProgress)return;g.fire("scrollby",{x:this._panKeys[m][0],y:this._panKeys[m][1]})}else m in this._panKeys&&t.originalEvent.shiftKey&&0!==e._selections.getLayers().length?e._postKeyboardEvent("input",h,p):m in this._zoomKeys&&g.setZoom(g.getZoom()+(t.shiftKey?3:1)*this._zoomKeys[m])}}s.DomEvent.stopPropagation(t.originalEvent)}}},_handleCtrlCommand:function(t){if("keydown"!==t.type&&"c"!==t.originalEvent.key&&"v"!==t.originalEvent.key&&"x"!==t.originalEvent.key&&99!==t.originalEvent.keyCode&&118!==t.originalEvent.keyCode&&120!==t.originalEvent.keyCode)return t.originalEvent.preventDefault(),!0;if(67!==t.originalEvent.keyCode&&86!==t.originalEvent.keyCode&&88!==t.originalEvent.keyCode&&99!==t.originalEvent.keyCode&&118!==t.originalEvent.keyCode&&120!==t.originalEvent.keyCode&&"c"!==t.originalEvent.key&&"v"!==t.originalEvent.key&&"x"!==t.originalEvent.key&&t.originalEvent.preventDefault(),t.originalEvent.ctrlKey&&t.originalEvent.shiftKey&&"?"===t.originalEvent.key)return map.showLOKeyboardHelp(),t.originalEvent.preventDefault(),!0;if(t.originalEvent.ctrlKey&&("z"===t.originalEvent.key||"Z"===t.originalEvent.key))return this._map._socket.sendMessage("uno .uno:Undo"),t.originalEvent.preventDefault(),!0;if(t.originalEvent.ctrlKey&&("y"===t.originalEvent.key||"Y"===t.originalEvent.key))return this._map._socket.sendMessage("uno .uno:Redo"),t.originalEvent.preventDefault(),!0;if(t.originalEvent.altKey||t.originalEvent.shiftKey){if("c"===t.originalEvent.key&&t.originalEvent.altKey)return this._map._socket.sendMessage("uno .uno:InsertAnnotation"),!0;if(t.originalEvent.shiftKey){if(t.originalEvent.altKey)switch(t.originalEvent.keyCode){case 68:this._map._docLayer.toggleTileDebugMode()}}else switch(t.originalEvent.keyCode){case 53:return this._map._socket.sendMessage("uno .uno:Strikeout"),!0;case 70:return this._map._socket.sendMessage("uno .uno:InsertFootnote"),!0;case 67:case 77:return this._map._socket.sendMessage("uno .uno:InsertAnnotation"),!0;case 68:return this._map._socket.sendMessage("uno .uno:InsertEndnote"),!0}return!1}switch(t.originalEvent.keyCode){case 51:return"spreadsheet"===this._map.getDocType()?(this._map._socket.sendMessage("uno .uno:SetOptimalColumnWidthDirect"),this._map._socket.sendMessage("commandvalues command=.uno:ViewRowColumnHeaders"),!0):!1;case 53:return"spreadsheet"===this._map.getDocType()?(this._map._socket.sendMessage("uno .uno:Strikeout"),!0):!1;case 67:case 88:case 99:case 120:case 91:case 93:return this._map._docLayer._textArea.value="dummy text",this._map._docLayer._textArea.focus(),this._map._docLayer._textArea.select(),!0;case 80:return this._map.print(),!0;case 83:return this._map.save(!0,!0),!0;case 86:case 118:return!0;case 112:return this._map._socket.sendMessage("uno .uno:NoteVisible"),!0;case 188:return this._map._socket.sendMessage("uno .uno:SubScript"),!0;case 190:return this._map._socket.sendMessage("uno .uno:SuperScript"),!0}return"keypress"!==t.type||!t.originalEvent.ctrlKey&&!t.originalEvent.metaKey||"c"!==t.originalEvent.key&&"v"!==t.originalEvent.key&&"x"!==t.originalEvent.key?!1:!0}}),s.Map.addInitHook("addHandler","keyboard",s.Map.Keyboard),s.extend(s.DomEvent,{addMultiClickListener:function(t,e,i){function n(t){var i=Date.now(),n=0;s&&(n=i-(s[s.length-1]||i));var a=n>0&&o>=n,r=!1;if(s.length>1&&a){var l=s[s.length-1]-s[s.length-2];r=l>0&&o>=l}if(r){var h=!1;if(s.length>2&&r){var d=s[s.length-2]-s[s.length-3];h=d>0&&o>=d}var u={type:h?"qdrplclick":"trplclick",clientX:t.clientX,clientY:t.clientY,button:t.button,target:t.target};e(u)}for(s.push(i);s.length>3;)s.shift()}var s=[],o=250;return t["_leaflet_click"+i]=n,t.addEventListener("click",n,!1),this},removeMultiClickListener:function(t,e){return t.removeEventListener("click",t["_leaflet_click"+e],!1),this}}),s.Map.mergeOptions({mouse:!0}),s.Map.Mouse=s.Handler.extend({initialize:function(t){this._map=t,this._mouseEventsQueue=[],this._prevMousePos=null},addHooks:function(){this._map.on("mousedown mouseup mouseover mouseout mousemove dblclick trplclick qdrplclick",this._onMouseEvent,this)},removeHooks:function(){this._map.off("mousedown mouseup mouseover mouseout mousemove dblclick trplclick qdrplclick",this._onMouseEvent,this)},LOButtons:{left:1,middle:2,right:4},JSButtons:{left:0,middle:1,right:2},_onMouseEvent:function(t){var i=this._map._docLayer;if(!(!i||this._map.slideShow&&this._map.slideShow.fullscreen)){if(i._graphicMarker){if(i._graphicMarker.isDragged)return;if(!i._isEmptyRectangle(i._graphicSelection)&&i._graphicMarker.getBounds().contains(t.latlng))if("mousedown"===t.type)this._prevMousePos=t.latlng;else if("mousemove"===t.type&&this._mouseDown&&!this._prevMousePos)this._prevMousePos=t.latlng;else if("mousemove"===t.type&&this._prevMousePos){var n=s.latLng(t.latlng.lat-this._prevMousePos.lat,t.latlng.lng-this._prevMousePos.lng);this._prevMousePos=t.latlng;var o=i._graphicMarker.getBounds().getCenter(),a=s.latLng(o.lat+n.lat,o.lng+n.lng);i._graphicMarker.editing&&i._graphicMarker.editing._move(a)}else"mouseup"===t.type&&(this._prevMousePos=null)}for(var r in i._selectionHandles)if(i._selectionHandles[r].isDragged)return;var l=0,h=t.originalEvent.shiftKey?this._map.keyboard.keyModifier.shift:0,d=t.originalEvent.ctrlKey?this._map.keyboard.keyModifier.ctrl:0,u=t.originalEvent.altKey?this._map.keyboard.keyModifier.alt:0,c=t.originalEvent.metaKey?this._map.keyboard.keyModifier.ctrlMac:0;l=h|d|u|c;var p=0;p|=t.originalEvent.button===this.JSButtons.left?this.LOButtons.left:0,p|=t.originalEvent.button===this.JSButtons.middle?this.LOButtons.middle:0,p|=t.originalEvent.button===this.JSButtons.right?this.LOButtons.right:0;var _=this._map._mouseEnteringLeaving;if(_&&"mouseover"===t.type&&this._mouseDown)s.DomEvent.off(e,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.off(e,"mouseup",this._onMouseUpOutside,this),s.DomEvent.off(this._map._resizeDetector.contentWindow,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.off(this._map._resizeDetector.contentWindow,"mouseup",this._onMouseUpOutside,this);else if("mousedown"===t.type){i._resetPreFetching(),this._mouseDown=!0,this._holdMouseEvent&&clearTimeout(this._holdMouseEvent);var m=i._latLngToTwips(t.latlng);this._mouseEventsQueue.push(s.bind(function(){this._postMouseEvent("buttondown",m.x,m.y,1,p,l)},i)),this._holdMouseEvent=setTimeout(s.bind(this._executeMouseEvents,this),500)}else if("mouseup"===t.type){if(this._mouseDown=!1,this._map.dragging.enabled()&&0===this._mouseEventsQueue.length)return;if(clearTimeout(this._holdMouseEvent),this._holdMouseEvent=null,this._clickTime&&Date.now()-this._clickTime<=250)return this._mouseEventsQueue=[],this._clickCount++,void(this._clickCount<4&&(this._clickTime=Date.now()));this._clickTime=Date.now(),this._clickCount=1,m=i._latLngToTwips(t.latlng);var g=250;"edit"===this._map._permission&&(g=0),this._mouseEventsQueue.push(s.bind(function(){var t=this._map._docLayer;this._mouseEventsQueue=[],t._postMouseEvent("buttonup",m.x,m.y,1,p,l),t._textArea.focus()},this)),this._holdMouseEvent=setTimeout(s.bind(this._executeMouseEvents,this),g);for(r in i._selectionHandles){var f=i._selectionHandles[r];f._icon&&s.DomUtil.removeClass(f._icon,"leaflet-not-clickable")}this._map.fire("scrollvelocity",{vx:0,vy:0})}else if("mousemove"===t.type&&this._mouseDown){if(this._holdMouseEvent){if(clearTimeout(this._holdMouseEvent),this._holdMouseEvent=null,this._map.dragging.enabled())return void(this._mouseEventsQueue=[]);for(var v=0;v<this._mouseEventsQueue.length;v++)this._mouseEventsQueue[v]();this._mouseEventsQueue=[]}if(!this._map.dragging.enabled()){m=i._latLngToTwips(t.latlng),i._postMouseEvent("move",m.x,m.y,1,p,l);for(r in i._selectionHandles)f=i._selectionHandles[r],f._icon&&s.DomUtil.addClass(f._icon,"leaflet-not-clickable");this._map.fire("handleautoscroll",{pos:t.containerPoint,map:this._map})}}else if("mousemove"!==t.type||this._mouseDown)if("dblclick"===t.type||"trplclick"===t.type||"qdrplclick"===t.type){m=i._latLngToTwips(t.latlng);var y={dblclick:2,trplclick:3,qdrplclick:4},w=y[t.type];i._postMouseEvent("buttondown",m.x,m.y,w,p,l),i._postMouseEvent("buttonup",m.x,m.y,w,p,l)}else _&&"mouseout"===t.type&&this._mouseDown&&(s.DomEvent.on(this._map._resizeDetector.contentWindow,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.on(this._map._resizeDetector.contentWindow,"mouseup",this._onMouseUpOutside,this),s.DomEvent.on(e,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.on(e,"mouseup",this._onMouseUpOutside,this));else clearTimeout(this._mouseOverTimeout),m=i._latLngToTwips(t.latlng),this._mouseOverTimeout=setTimeout(s.bind(function(){i._postMouseEvent("move",m.x,m.y,1,0,l)},this),100)}},_executeMouseEvents:function(){this._holdMouseEvent=null;for(var t=0;t<this._mouseEventsQueue.length;t++)this._mouseEventsQueue[t]();this._mouseEventsQueue=[]},_onMouseMoveOutside:function(t){this._map._handleDOMEvent(t),this._map.dragging.enabled()&&this._map.dragging._draggable._onMove(t)},_onMouseUpOutside:function(t){this._mouseDown=!1,s.DomEvent.off(e,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.off(e,"mouseup",this._onMouseUpOutside,this),s.DomEvent.off(this._map._resizeDetector.contentWindow,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.off(this._map._resizeDetector.contentWindow,"mouseup",this._onMouseUpOutside,this),this._map._handleDOMEvent(t),this._map.dragging.enabled()&&this._map.dragging._draggable._onUp(t)}}),s.Map.addInitHook("addHandler","mouse",s.Map.Mouse),s.Map.mergeOptions({printHandler:!0}),s.Map.Print=s.Handler.extend({initialize:function(t){this._map=t},addHooks:function(){this._map.on("filedownloadready",this._onFileReady,this)},removeHooks:function(){this._map.off("filedownloadready",this._onFileReady,this)},_onFileReady:function(t){var e=new XMLHttpRequest;e.onreadystatechange=s.bind(function(){4===e.readyState&&200===e.status&&this._onInitPrint(e)},this),e.open("GET",t.url,!0),e.responseType="blob",e.send()},_onInitPrint:function(t){var i=new Blob([t.response],{type:"application/pdf"}),n=URL.createObjectURL(i);this._printIframe=s.DomUtil.create("iframe","",e.body),this._printIframe.onload=s.bind(this._onIframeLoaded,this),s.DomUtil.setStyle(this._printIframe,"visibility","hidden"),s.DomUtil.setStyle(this._printIframe,"position","fixed"),s.DomUtil.setStyle(this._printIframe,"right","0"),s.DomUtil.setStyle(this._printIframe,"bottom","0"),this._printIframe.src=n},_onIframeLoaded:function(){this._printIframe.contentWindow.focus(),this._printIframe.contentWindow.print(),setTimeout(s.bind(this._closePrintIframe,this,this._printIframe),3e5)},_closePrintIframe:function(t){s.DomUtil.remove(t),this._map.focus()}}),s.Map.addInitHook("addHandler","printHandler",s.Map.Print),s.Map.mergeOptions({slideShow:!0}),s.Map.SlideShow=s.Handler.extend({initialize:function(t){this._map=t},addHooks:function(){this._map.on("fullscreen",this._onFullScreen,this),this._map.on("slidedownloadready",this._onSlideDownloadReady,this)},removeHooks:function(){this._map.off("fullscreen",this._onFullScreen,this),this._map.off("slidedownloadready",this._onSlideDownloadReady,this)},_onFullScreen:function(){this._slideShow=s.DomUtil.create("iframe","leaflet-slideshow",this._map._container),this._slideShow.src=this._map.options.webserver+"/loleaflet/dist/loading.html",this._slideShow.requestFullscreen?this._slideShow.requestFullscreen():this._slideShow.msRequestFullscreen?this._slideShow.msRequestFullscreen():this._slideShow.mozRequestFullScreen?this._slideShow.mozRequestFullScreen():this._slideShow.webkitRequestFullscreen&&this._slideShow.webkitRequestFullscreen(),s.DomEvent.on(e,"fullscreenchange webkitfullscreenchange mozfullscreenchange msfullscreenchange",this._onFullScreenChange,this),this.fullscreen=!0,this._map.downloadAs("slideshow.svg","svg",null,"slideshow")},_onFullScreenChange:function(){this.fullscreen=e.fullscreen||e.webkitIsFullScreen||e.mozFullScreen||e.msFullscreenElement,this.fullscreen||s.DomUtil.remove(this._slideShow)},_onSlideDownloadReady:function(t){this._slideShow.src=t.url,this._slideShow.contentWindow.focus(),clearInterval(this._slideShow.contentWindow.spinnerInterval)}}),s.Map.addInitHook("addHandler","slideShow",s.Map.SlideShow),s.Map.mergeOptions({fileInserter:!0}),s.Map.FileInserter=s.Handler.extend({initialize:function(t){this._map=t,this._childId=null,this._toInsert={};var i=e.createElement("a");i.href=t.options.server,this._url=t.options.webserver+"/"+t.options.urlPrefix+"/"+encodeURIComponent(t.options.doc)+"/insertfile"},addHooks:function(){this._map.on("insertfile",this._onInsertFile,this),this._map.on("childid",this._onChildIdMsg,this)},removeHooks:function(){this._map.off("insertfile",this._onInsertFile,this),this._map.off("childid",this._onChildIdMsg,this)},_onInsertFile:function(t){this._childId?this._sendFile(Date.now(),t.file):(this._map._socket.sendMessage("getchildid"),this._toInsert[Date.now()]=t.file)},_onChildIdMsg:function(t){this._childId=t.id;for(var e in this._toInsert)this._sendFile(e,this._toInsert[e]);this._toInsert={}},_sendFile:function(t,e){var i=this._url,n=new XMLHttpRequest,s=this._map._socket,o=this._map;this._map.showBusy(_("Uploading..."),!1),n.onreadystatechange=function(){4===n.readyState&&200===n.status&&(o.hideBusy(),s.sendMessage("insertfile name="+t+" type=graphic"))},n.open("POST",i,!0);var a=new FormData;a.append("name",t),a.append("childid",this._childId),a.append("file",e),n.send(a)}}),s.Map.addInitHook("addHandler","fileInserter",s.Map.FileInserter),s.Map.WOPI=s.Handler.extend({PostMessageOrigin:!1,DocumentLoadedTime:!1,HidePrintOption:!1,HideSaveOption:!1,HideExportOption:!1,DisablePrint:!1,DisableExport:!1,DisableCopy:!1,_appLoadedConditions:{doclayerinit:!1,updatepermission:!1,viewinfo:!1},_appLoaded:!1,initialize:function(t){this._map=t},addHooks:function(){this._map.on("postMessage",this._postMessage,this),this._map.on("doclayerinit",this._postLoaded,this),this._map.on("updatepermission",this._postLoaded,this),this._map.on("viewinfo",this._postLoaded,this),this._map.on("wopiprops",this._setWopiProps,this),s.DomEvent.on(t,"message",this._postMessageListener,this)},removeHooks:function(){this._map.off("postMessage",this._postMessage,this),this._map.off("doclayerinit",this._postLoaded,this),this._map.off("updatepermission",this._postLoaded,this),this._map.off("viewinfo",this._postLoaded,this),this._map.off("wopiprops",this._setWopiProps,this),s.DomEvent.off(t,"message",this._postMessageListener,this)},_setWopiProps:function(t){t.PostMessageOrigin&&(this.PostMessageOrigin=t.PostMessageOrigin),this.HidePrintOption=!!t.HidePrintOption,this.HideSaveOption=!!t.HideSaveOption,this.HideExportOption=!!t.HideExportOption,this.DisablePrint=!!t.DisablePrint,this.DisableExport=!!t.DisableExport,this.DisableCopy=!!t.DisableCopy,this._map.fire("postMessage",{msgId:"App_LoadingStatus",args:{Status:"Frame_Ready"}})},resetAppLoaded:function(){this._appLoaded=!1;for(var t in this._appLoadedConditions)this._appLoadedConditions[t]=!1},_postLoaded:function(t){if(!this._appLoaded){"doclayerinit"===t.type&&(this.DocumentLoadedTime=Date.now()),this._appLoadedConditions[t.type]=!0;for(var e in this._appLoadedConditions)if(!this._appLoadedConditions[e])return;this._appLoaded=!0,this._map.fire("postMessage",{msgId:"App_LoadingStatus",args:{Status:"Document_Loaded",DocumentLoadedTime:this.DocumentLoadedTime}})}},_postMessageListener:function(e){if(t.WOPIPostmessageReady){var i=JSON.parse(e.data);if("Set_Settings"===i.MessageId){if(i.Values){var n=i.Values.AlwaysActive;this._map.options.alwaysActive=!!n}}else if("Get_Views"===i.MessageId){var s=[];for(var o in this._map._viewInfo)s.push({ViewId:o,UserName:this._map._viewInfo[o].username,UserId:this._map._viewInfo[o].userid,Color:this._map._viewInfo[o].color});this._postMessage({msgId:"Get_Views_Resp",args:s})}else if("Close_Session"===i.MessageId)this._map._socket.sendMessage("closedocument");else if("Action_Save"===i.MessageId){var a=i.Values&&i.Values.DontTerminateEdit,r=i.Values&&i.Values.DontSaveIfUnmodified;this._map.save(a,r)}else if("Action_Print"===i.MessageId)this._map.print();else if("Action_Export"===i.MessageId){if(i.Values){var l=i.Values.Format,h=title.substr(0,title.lastIndexOf("."))||title;h=""===h?"document":h,this._map.downloadAs(h+"."+l,l)}}else if("Get_Export_Formats"===i.MessageId){var d=[];for(var u in this._map._docLayer._exportFormats)d.push({Label:this._map._docLayer._exportFormats[u].label,Format:this._map._docLayer._exportFormats[u].format});this._postMessage({msgId:"Get_Export_Formats_Resp",args:d})}}},_postMessage:function(e){if(this.enabled){var i=e.msgId,n=e.args||{};if(this.PostMessageOrigin&&t.parent!==t.self){var s={MessageId:i,SendTime:Date.now(),Values:n};t.parent.postMessage(JSON.stringify(s),this.PostMessageOrigin)}}}}),s.Map.addInitHook("addHandler","wopi",s.Map.WOPI),s.Handler.MarkerDrag=s.Handler.extend({initialize:function(t){this._marker=t},addHooks:function(){var t=this._marker._icon;this._draggable||(this._draggable=new s.Draggable(t,t,!0)),this._draggable.on({dragstart:this._onDragStart,drag:this._onDrag,dragend:this._onDragEnd},this).enable(),s.DomUtil.addClass(t,"leaflet-marker-draggable")},removeHooks:function(){this._draggable.off({dragstart:this._onDragStart,drag:this._onDrag,dragend:this._onDragEnd},this).disable(),this._marker._icon&&s.DomUtil.removeClass(this._marker._icon,"leaflet-marker-draggable")},moved:function(){return this._draggable&&this._draggable._moved},_onDragStart:function(){this._marker.closePopup().fire("movestart").fire("dragstart")},_onDrag:function(t){var e=this._marker,i=e._shadow,n=s.DomUtil.getPosition(e._icon),o=e._map.layerPointToLatLng(n);i&&s.DomUtil.setPosition(i,n),e._latlng=o,t.latlng=o,e.fire("move",t).fire("drag",t)},_onDragEnd:function(t){this._marker.fire("moveend").fire("dragend",t)}}),s.Control=s.Class.extend({options:{position:"topright"},initialize:function(t){s.setOptions(this,t)},getPosition:function(){return this.options.position},setPosition:function(t){var e=this._map;return e&&e.removeControl(this),this.options.position=t,e&&e.addControl(this),this},getContainer:function(){return this._container},addTo:function(t){this.remove(),this._map=t;var e=this._container=this.onAdd(t),i=this.getPosition(),n=t._controlCorners[i];return s.DomUtil.addClass(e,"leaflet-control"),-1!==i.indexOf("bottom")?n.insertBefore(e,n.firstChild):n.appendChild(e),this},remove:function(){return this._map?(s.DomUtil.remove(this._container),this.onRemove&&this.onRemove(this._map),this._map=null,this):this},isVisible:function(){if(!this._map)return!1;var t=this._map._controlCorners[this.options.position];return t.hasChildNodes()},_refocusOnMap:function(){this._map.focus()}}),s.control=function(t){return new s.Control(t)},s.Map.include({addControl:function(t){t._map=this;var e=t.onAdd(this),i=s.DomUtil.get(this.options.toolbarContainer);return this._controls||(this._controls=[]),i&&e&&(i.appendChild(e),this._controls.push({div:e})),this},removeControl:function(t){return t.remove(),this},removeControls:function(){this._controls&&this._controls.forEach(function(t){s.DomUtil.remove(t.div)})},_initControlPos:function(){function t(t,o){var a=i+t+" "+i+o;e[t+o]=s.DomUtil.create("div",a,n)}var e=this._controlCorners={},i="leaflet-",n=this._controlContainer=s.DomUtil.create("div",i+"control-container",this._container);t("top","left"),t("top","middle"),t("top","right"),t("bottom","left"),t("bottom","right")},_clearControlPos:function(){s.DomUtil.remove(this._controlContainer)}}),s.Control.PartsPreview=s.Control.extend({options:{autoUpdate:!0},onAdd:function(t){
this._previewInitialized=!1,this._previewTiles=[],this._partsPreviewCont=s.DomUtil.get("slide-sorter"),t.on("updateparts",this._updateDisabled,this),t.on("updatepart",this._updatePart,this),t.on("tilepreview",this._updatePreview,this),t.on("insertpage",this._insertPreview,this),t.on("deletepage",this._deletePreview,this)},_updateDisabled:function(t){var e=t.parts,n=t.selectedPart,o=t.docType;if("text"!==o&&("presentation"===o||"drawing"===o))if(this._previewInitialized){t.partNames!==i&&this._syncPreviews(t);for(var a=0;e>a;a++)s.DomUtil.removeClass(this._previewTiles[a],"preview-img-selected");s.DomUtil.addClass(this._previewTiles[n],"preview-img-selected")}else{var r=this._map.options.documentContainer;s.DomUtil.addClass(r,"parts-preview-document"),setTimeout(s.bind(function(){this._map.invalidateSize(),$(".scroll-container").mCustomScrollbar("update")},this),500);for(var l=0;e>l;l++)this._previewTiles.push(this._createPreview(l,t.partNames[l]));s.DomUtil.addClass(this._previewTiles[n],"preview-img-selected"),this._previewInitialized=!0}},_createPreview:function(t,e){var i=s.DomUtil.create("div","preview-frame",this._partsPreviewCont);s.DomUtil.create("span","preview-helper",i);var n="preview-img",o=s.DomUtil.create("img",n,i);return o.hash=e,o.src=s.Icon.Default.imagePath+"/preview_placeholder.png",s.DomEvent.on(o,"click",s.DomEvent.stopPropagation).on(o,"click",s.DomEvent.stop).on(o,"click",this._setPart,this).on(o,"click",this._refocusOnMap,this),this._map.getPreview(t,t,180,180,{autoUpdate:this.options.autoUpdate}),o},_setPart:function(t){var e=$("#slide-sorter .mCSB_container .preview-frame").index(t.target.parentNode);null!==e&&this._map.setPart(parseInt(e))},_updatePart:function(t){"presentation"===t.docType&&t.part>=0&&this._map.getPreview(t.part,t.part,180,180,{autoUpdate:this.options.autoUpdate})},_syncPreviews:function(t){var e=0,i=t.parts;if(i!==this._previewTiles.length)if(1===Math.abs(i-this._previewTiles.length)){if(i>this._previewTiles.length)for(e=0;i>e;e++){if(e===this._previewTiles.length){this._insertPreview({selectedPart:e-1,hashCode:t.partNames[e]});break}if(this._previewTiles[e].hash!==t.partNames[e]){this._insertPreview({selectedPart:e,hashCode:t.partNames[e]});break}}else for(e=0;e<this._previewTiles.length;e++)if(e===t.partNames.length||this._previewTiles[e].hash!==t.partNames[e]){this._deletePreview({selectedPart:e});break}}else{for(;this._previewTiles.length<t.partNames.length;)this._insertPreview({selectedPart:this._previewTiles.length-1,hashCode:t.partNames[this._previewTiles.length]});for(;this._previewTiles.length>t.partNames.length;)this._deletePreview({selectedPart:this._previewTiles.length-1});for(e=0;e<t.partNames.length;e++)this._previewTiles[e].hash=t.partNames[e],this._previewTiles[e].src=s.Icon.Default.imagePath+"/preview_placeholder.png",this._map.getPreview(e,e,180,180,{autoUpdate:this.options.autoUpdate})}else for(e=0;i>e;e++)this._previewTiles[e].hash!==t.partNames[e]&&(this._previewTiles[e].hash=t.partNames[e])},_updatePreview:function(t){("presentation"===this._map.getDocType()||"drawing"===this._map.getDocType())&&(this._previewTiles[t.id].onload=function(){$("#slide-sorter").mCustomScrollbar({axis:"y",theme:"dark-thick",scrollInertia:0,alwaysShowScrollbar:1})},this._previewTiles[t.id].src=t.tile)},_updatePreviewIds:function(){$("#slide-sorter").mCustomScrollbar("update")},_insertPreview:function(t){if("presentation"===this._map.getDocType()){var e=t.selectedPart+1,n=this._createPreview(e,t.hashCode===i?null:t.hashCode);this._previewTiles.splice(e,0,n);var s=this._previewTiles[t.selectedPart].parentNode,o=n.parentNode;s.parentNode.insertBefore(o,s.nextSibling),this._updatePreviewIds()}},_deletePreview:function(t){if("presentation"===this._map.getDocType()){var e=this._previewTiles[t.selectedPart].parentNode;s.DomUtil.remove(e),this._previewTiles.splice(t.selectedPart,1),this._updatePreviewIds()}}}),s.control.partsPreview=function(t){return new s.Control.PartsPreview(t)},s.Control.Header=s.Control.extend({options:{cursor:"col-resize"},initialize:function(){this._clicks=0,this._current=-1,this._selection={start:-1,end:-1}},mouseInit:function(t){s.DomEvent.on(t,"mousedown",this._onMouseDown,this)},select:function(t){t&&!s.DomUtil.hasClass(t,"spreadsheet-header-selected")&&s.DomUtil.addClass(t,"spreadsheet-header-selected")},unselect:function(t){t&&s.DomUtil.hasClass(t,"spreadsheet-header-selected")&&s.DomUtil.removeClass(t,"spreadsheet-header-selected")},clearSelection:function(t){for(var e=t.children,i=this._selection.start;i<=this._selection.end;i++)this.unselect(e[i]);this._selection.start=this._selection.end=-1,this.select(e[this._current])},updateSelection:function(t,e,i){for(var n=t.children,s=0,o=0,a=-1,r=-1,l=!1,h=0,d=n.length;d>h;h++)if(s=h>0?n[h-1].size:0,o=n[h].size,e>=s&&o>=e&&(l=!0,a=h),l&&this.select(n[h]),i>=s&&o>=i){r=h;break}if(-1!==this._current&&-1!==a&&-1!==r&&(this._current<a||this._current>r)&&this.unselect(n[this._current]),-1!==this._selection.start&&-1!==a&&a>this._selection.start)for(h=this._selection.start;a>h;h++)this.unselect(n[h]);if(-1!==this._selection.end&&-1!==r&&r<this._selection.end)for(h=r+1;h<=this._selection.end;h++)this.unselect(n[h]);this._selection.start=a,this._selection.end=r},updateCurrent:function(t,e){var i=t.children;if(0>e)return this.unselect(i[this._current]),void(this._current=-1);for(var n=0,s=0,o=0,a=i.length;a>o;o++)if(n=o>0?i[o-1].size:0,s=i[o].size,e>=n&&s>=e){-1===this._selection.start&&-1===this._selection.end&&(this.unselect(i[this._current]),this.select(i[o])),this._current=o;break}},_onMouseDown:function(t){var i=t.target||t.srcElement;if(!i||this._dragging)return!1;s.DomUtil.disableImageDrag(),s.DomUtil.disableTextSelection(),s.DomEvent.stopPropagation(t),s.DomEvent.on(e,"mousemove",this._onMouseMove,this),s.DomEvent.on(e,"mouseup",this._onMouseUp,this);var n=i.parentNode.getBoundingClientRect();this._start=new s.Point(n.left,n.top),this._offset=new s.Point(n.right-t.clientX,n.bottom-t.clientY),this._item=i,this.onDragStart(this.item,this._start,this._offset,t)},_onMouseMove:function(t){this._dragging=!0,s.DomEvent.preventDefault(t);var e=t.target||t.srcElement;e.style.cursor!==this.options.cursor&&(s.DomUtil.hasClass(e,"spreadsheet-header-column-text")||s.DomUtil.hasClass(e,"spreadsheet-header-row-text"))&&(e.style.cursor=this.options.cursor),this.onDragMove(this._item,this._start,this._offset,t)},_onMouseUp:function(t){s.DomEvent.off(e,"mousemove",this._onMouseMove,this),s.DomEvent.off(e,"mouseup",this._onMouseUp,this),s.DomUtil.enableImageDrag(),s.DomUtil.enableTextSelection(),this._dragging?(this.onDragEnd(this._item,this._start,this._offset,t),this._clicks=0):(this.onDragClick(this._item,++this._clicks,t),setTimeout(s.bind(this.initialize,this),400)),this._item=this._start=this._offset=null,this._dragging=!1},onDragStart:function(){},onDragMove:function(){},onDragEnd:function(){},onDragClick:function(){}}),s.Control.ColumnHeader=s.Control.Header.extend({options:{cursor:"col-resize"},onAdd:function(t){t.on("updatepermission",this._onUpdatePermission,this),this._initialized=!1},_initialize:function(){this._initialized=!0,this._map.on("scrolloffset",this.offsetScrollPosition,this),this._map.on("updatescrolloffset",this.setScrollPosition,this),this._map.on("updateviewport",this.setViewPort,this),this._map.on("viewrowcolumnheaders",this.viewRowColumnHeaders,this),this._map.on("updateselectionheader",this._onUpdateSelection,this),this._map.on("clearselectionheader",this._onClearSelection,this),this._map.on("updatecurrentheader",this._onUpdateCurrentColumn,this);var t=s.DomUtil.get("spreadsheet-row-column-frame"),e=s.DomUtil.create("div","spreadsheet-header-corner",t);s.DomEvent.addListener(e,"click",this._onCornerHeaderClick,this);var i=s.DomUtil.create("div","spreadsheet-header-columns-container",t);this._columns=s.DomUtil.create("div","spreadsheet-header-columns",i),this._position=0,this._totalWidth=0,this._viewPort=0;var n=this;$.contextMenu({selector:".spreadsheet-header-column-text",className:"loleaflet-font",items:{insertcolbefore:{name:_("Insert column before"),callback:function(t,e){var i=e.$trigger.attr("rel").split("spreadsheet-column-")[1];n.insertColumn.call(n,i)}},deleteselectedcol:{name:_("Delete column"),callback:function(t,e){var i=e.$trigger.attr("rel").split("spreadsheet-column-")[1];n.deleteColumn.call(n,i)}},optimalwidth:{name:_("Optimal Width")+"...",callback:function(t,e){var i=e.$trigger.attr("rel").split("spreadsheet-column-")[1];n.optimalWidth.call(n,i)}},hideColumn:{name:_("Hide Columns"),callback:function(t,e){var i=e.$trigger.attr("rel").split("spreadsheet-column-")[1];n.hideColumn.call(n,i)}},showColumn:{name:_("Show Columns"),callback:function(t,e){var i=e.$trigger.attr("rel").split("spreadsheet-column-")[1];n.showColumn.call(n,i)}}},zIndex:10})},optimalWidth:function(t){this._dialog||(this._dialog=s.control.metricInput(this._onDialogResult,this,this._map._docLayer.twipsToHMM(this._map._docLayer.STD_EXTRA_WIDTH),{title:_("Optimal Column Width")})),0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._dialog.addTo(this._map),this._map.enable(!1),this._dialog.show()},insertColumn:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._map.sendUnoCommand(".uno:InsertColumns")},deleteColumn:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._map.sendUnoCommand(".uno:DeleteColumns")},hideColumn:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._map.sendUnoCommand(".uno:HideColumn")},showColumn:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._map.sendUnoCommand(".uno:ShowColumn")},setViewPort:function(t){this._viewPort=t.columns.viewPort,this._totalWidth=t.columns.totalWidth},setScrollPosition:function(t){var e=-t.x;this._position=Math.min(0,e),s.DomUtil.setStyle(this._columns,"left",this._position+"px")},offsetScrollPosition:function(t){var e=t.x;this._position=Math.min(0,Math.max(this._position-e,-(this._totalWidth-this._viewPort))),s.DomUtil.setStyle(this._columns,"left",this._position+"px")},_onClearSelection:function(t){this.clearSelection(this._columns)},_onUpdateSelection:function(t){this.updateSelection(this._columns,t.start.x,t.end.x)},_onUpdateCurrentColumn:function(t){this.updateCurrent(this._columns,t.x)},viewRowColumnHeaders:function(t){this.fillColumns(t.data.columns,t.converter,t.context)},fillColumns:function(t,e,i){var n,o,a,r,l,h;for(s.DomUtil.empty(this._columns),n=0;n<t.length;n++){a=t[n].size-(n>0?t[n-1].size:0),o=new s.Point(a,a),r=s.DomUtil.create("div","spreadsheet-header-column",this._columns),l=s.DomUtil.create("div","spreadsheet-header-column-text",r),h=s.DomUtil.create("div","spreadsheet-header-column-resize",r),r.size=t[n].size;var d=t[n].text;l.setAttribute("rel","spreadsheet-column-"+d),l.innerHTML=d,a=Math.round(e.call(i,o).x)-1,0>=a?s.DomUtil.setStyle(r,"display","none"):10>a?(l.column=n+1,l.width=a,s.DomUtil.setStyle(r,"width",a+"px"),s.DomUtil.setStyle(r,"cursor","col-resize"),s.DomUtil.setStyle(l,"cursor","col-resize"),s.DomUtil.setStyle(h,"display","none"),this.mouseInit(l)):(h.column=n+1,h.width=a,s.DomUtil.setStyle(r,"width",a+"px"),s.DomUtil.setStyle(l,"width",a-3+"px"),s.DomUtil.setStyle(h,"width","3px"),this.mouseInit(h)),s.DomEvent.addListener(l,"click",this._onColumnHeaderClick,this)}$(".spreadsheet-header-column-text").length>0&&$(".spreadsheet-header-column-text").contextMenu("edit"===this._map._permission)},_colAlphaToNumber:function(t){for(var e=0,i="A".charCodeAt(),n=0;n<t.length;n++){var s=t[t.length-n-1];e+=(s.charCodeAt()-i+1)*Math.pow(26,n)}return e},_selectColumn:function(t,e){var i=this._colAlphaToNumber(t),n={Col:{type:"unsigned short",value:parseInt(i-1)},Modifier:{type:"unsigned short",value:e}};this._map.sendUnoCommand(".uno:SelectColumn ",n)},_onColumnHeaderClick:function(t){var e=t.target.getAttribute("rel").split("spreadsheet-column-")[1],i=0;t.shiftKey&&(i+=this._map.keyboard.keyModifier.shift),t.ctrlKey&&(i+=this._map.keyboard.keyModifier.ctrl),this._selectColumn(e,i)},_onCornerHeaderClick:function(){this._map.sendUnoCommand(".uno:SelectAll")},_onDialogResult:function(t){if("submit"===t.type&&!isNaN(t.value)){var e={aExtraWidth:{type:"unsigned short",value:t.value}};this._map.sendUnoCommand(".uno:SetOptimalColumnWidth",e)}this._map.enable(!0)},_getVertLatLng:function(t,e,i){var n=this._map.mouseEventToContainerPoint({clientX:t.x,clientY:t.y}),o=this._map.mouseEventToContainerPoint(i);return[this._map.containerPointToLatLng(new s.Point(Math.max(n.x,o.x+e.x),0)),this._map.containerPointToLatLng(new s.Point(Math.max(n.x,o.x+e.x),this._map.getSize().y))]},onDragStart:function(t,e,i,n){this._vertLine?this._vertLine.setLatLngs(this._getVertLatLng(e,i,n)):this._vertLine=s.polyline(this._getVertLatLng(e,i,n),{color:"darkblue",weight:1}),this._map.addLayer(this._vertLine)},onDragMove:function(t,e,i,n){this._vertLine&&this._vertLine.setLatLngs(this._getVertLatLng(e,i,n))},onDragEnd:function(t,e,i,n){var o=new s.Point(n.clientX+i.x,n.clientY),a=this._map._docLayer._pixelsToTwips(o.subtract(e));if(t.width!=a.x){var r={Column:{type:"unsigned short",value:t.parentNode&&t.parentNode.nextSibling&&"none"===s.DomUtil.getStyle(t.parentNode.nextSibling,"display")?t.column+1:t.column},Width:{type:"unsigned short",value:Math.max(a.x,0)}};this._map.sendUnoCommand(".uno:ColumnWidth",r)}this._map.removeLayer(this._vertLine)},onDragClick:function(t,e,i){if(this._map.removeLayer(this._vertLine),2===e){var n={Col:{type:"unsigned short",value:t.column-1},Modifier:{type:"unsigned short",value:0}};this._map.sendUnoCommand(".uno:SelectColumn ",n),this._map.sendUnoCommand(".uno:SetOptimalColumnWidthDirect")}},_onUpdatePermission:function(t){"spreadsheet"===this._map.getDocType()&&(this._initialized||this._initialize(),$(".spreadsheet-header-column-text").length>0&&$(".spreadsheet-header-column-text").contextMenu("edit"===t.perm))}}),s.control.columnHeader=function(t){return new s.Control.ColumnHeader(t)},s.Control.RowHeader=s.Control.Header.extend({options:{cursor:"row-resize"},onAdd:function(t){t.on("updatepermission",this._onUpdatePermission,this),this._initialized=!1},_initialize:function(){this._initialized=!0,this._map.on("scrolloffset",this.offsetScrollPosition,this),this._map.on("updatescrolloffset",this.setScrollPosition,this),this._map.on("updateviewport",this.setViewPort,this),this._map.on("viewrowcolumnheaders",this.viewRowColumnHeaders,this),this._map.on("updateselectionheader",this._onUpdateSelection,this),this._map.on("clearselectionheader",this._onClearSelection,this),this._map.on("updatecurrentheader",this._onUpdateCurrentRow,this);var t=s.DomUtil.get("spreadsheet-row-column-frame"),e=s.DomUtil.create("div","spreadsheet-header-rows-container",t);this._rows=s.DomUtil.create("div","spreadsheet-header-rows",e),this._position=0,this._totalHeight=0,this._viewPort=0;var i=this;$.contextMenu({selector:".spreadsheet-header-row-text",className:"loleaflet-font",items:{insertrowabove:{name:_("Insert row above"),callback:function(t,e){var n=parseInt(e.$trigger.attr("rel").split("spreadsheet-row-")[1]);i.insertRow.call(i,n)}},deleteselectedrow:{name:_("Delete row"),callback:function(t,e){var n=parseInt(e.$trigger.attr("rel").split("spreadsheet-row-")[1]);i.deleteRow.call(i,n)}},optimalheight:{name:_("Optimal Height")+"...",callback:function(t,e){var n=parseInt(e.$trigger.attr("rel").split("spreadsheet-row-")[1]);i.optimalHeight.call(i,n)}},hideRow:{name:_("Hide Rows"),callback:function(t,e){var n=parseInt(e.$trigger.attr("rel").split("spreadsheet-row-")[1]);i.hideRow.call(i,n)}},showRow:{name:_("Show Rows"),callback:function(t,e){var n=parseInt(e.$trigger.attr("rel").split("spreadsheet-row-")[1]);i.showRow.call(i,n)}}},zIndex:10})},optimalHeight:function(t){this._dialog||(this._dialog=s.control.metricInput(this._onDialogResult,this,0,{title:_("Optimal Row Height")})),0===this._map._docLayer._selections.getLayers().length&&this._selectRow(t,0),this._dialog.addTo(this._map),this._map.enable(!1),this._dialog.show()},insertRow:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectRow(t,0),this._map.sendUnoCommand(".uno:InsertRows")},deleteRow:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectRow(t,0),this._map.sendUnoCommand(".uno:DeleteRows")},hideRow:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectRow(t,0),this._map.sendUnoCommand(".uno:HideRow")},showRow:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._map.sendUnoCommand(".uno:ShowRow")},setViewPort:function(t){this._viewPort=t.rows.viewPort,this._totalHeight=t.rows.totalHeight},setScrollPosition:function(t){var e=-t.y;this._position=Math.min(0,e),s.DomUtil.setStyle(this._rows,"top",this._position+"px")},offsetScrollPosition:function(t){var e=t.y;this._position=Math.min(0,Math.max(this._position-e,-(this._totalHeight-this._viewPort))),s.DomUtil.setStyle(this._rows,"top",this._position+"px")},_onClearSelection:function(t){this.clearSelection(this._rows)},_onUpdateSelection:function(t){this.updateSelection(this._rows,t.start.y,t.end.y)},_onUpdateCurrentRow:function(t){this.updateCurrent(this._rows,t.y)},viewRowColumnHeaders:function(t){this.fillRows(t.data.rows,t.converter,t.context)},fillRows:function(t,e,i){var n,o,a,r,l,h;for(s.DomUtil.empty(this._rows),n=0;n<t.length;n++){a=t[n].size-(n>0?t[n-1].size:0),o=new s.Point(a,a),r=s.DomUtil.create("div","spreadsheet-header-row",this._rows),l=s.DomUtil.create("div","spreadsheet-header-row-text",r),h=s.DomUtil.create("div","spreadsheet-header-row-resize",r),r.size=t[n].size;var d=t[n].text;l.setAttribute("rel","spreadsheet-row-"+d),l.innerHTML=d,a=Math.round(e.call(i,o).y)-1,0>=a?s.DomUtil.setStyle(r,"display","none"):10>a?(l.row=n+1,l.height=a,s.DomUtil.setStyle(r,"height",a+"px"),s.DomUtil.setStyle(r,"cursor","row-resize"),s.DomUtil.setStyle(l,"line-height",a+"px"),s.DomUtil.setStyle(l,"cursor","row-resize"),s.DomUtil.setStyle(h,"display","none"),this.mouseInit(l)):(h.row=n+1,h.height=a,s.DomUtil.setStyle(r,"height",a+"px"),s.DomUtil.setStyle(l,"line-height",a-3+"px"),s.DomUtil.setStyle(l,"height",a-3+"px"),s.DomUtil.setStyle(h,"height","3px"),this.mouseInit(h)),s.DomEvent.addListener(l,"click",this._onRowHeaderClick,this)}$(".spreadsheet-header-row-text").length>0&&$(".spreadsheet-header-row-text").contextMenu("edit"===this._map._permission)},_selectRow:function(t,e){var i={Row:{type:"long",value:parseInt(t-1)},Modifier:{type:"unsigned short",value:e}};this._map.sendUnoCommand(".uno:SelectRow ",i)},_onRowHeaderClick:function(t){var e=t.target.getAttribute("rel").split("spreadsheet-row-")[1],i=0;t.shiftKey&&(i+=this._map.keyboard.keyModifier.shift),t.ctrlKey&&(i+=this._map.keyboard.keyModifier.ctrl),this._selectRow(e,i)},_onDialogResult:function(t){if("submit"===t.type&&!isNaN(t.value)){var e={aExtraHeight:{type:"unsigned short",value:t.value}};this._map.sendUnoCommand(".uno:SetOptimalRowHeight",e)}this._map.enable(!0)},_getHorzLatLng:function(t,e,i){var n=this._map.mouseEventToContainerPoint({clientX:t.x,clientY:t.y}),o=this._map.mouseEventToContainerPoint(i);return[this._map.containerPointToLatLng(new s.Point(0,Math.max(n.y,o.y+e.y))),this._map.containerPointToLatLng(new s.Point(this._map.getSize().x,Math.max(n.y,o.y+e.y)))]},onDragStart:function(t,e,i,n){this._horzLine?this._horzLine.setLatLngs(this._getHorzLatLng(e,i,n)):this._horzLine=s.polyline(this._getHorzLatLng(e,i,n),{color:"darkblue",weight:1}),this._map.addLayer(this._horzLine)},onDragMove:function(t,e,i,n){this._horzLine&&this._horzLine.setLatLngs(this._getHorzLatLng(e,i,n))},onDragEnd:function(t,e,i,n){var o=new s.Point(n.clientX,n.clientY+i.y),a=this._map._docLayer._pixelsToTwips(o.subtract(e));if(t.height!=a.y){var r={Row:{type:"unsigned short",value:t.parentNode&&t.parentNode.nextSibling&&"none"===s.DomUtil.getStyle(t.parentNode.nextSibling,"display")?t.row+1:t.row},Height:{type:"unsigned short",value:Math.max(a.y,0)}};this._map.sendUnoCommand(".uno:RowHeight",r)}this._map.removeLayer(this._horzLine)},onDragClick:function(t,e,i){if(this._map.removeLayer(this._horzLine),2===e){var n={Row:{type:"long",value:t.row-1},Modifier:{type:"unsigned short",value:0}},s={aExtraHeight:{type:"unsigned short",value:0}};this._map.sendUnoCommand(".uno:SelectRow",n),this._map.sendUnoCommand(".uno:SetOptimalRowHeight",s)}},_onUpdatePermission:function(t){"spreadsheet"===this._map.getDocType()&&(this._initialized||this._initialize(),$(".spreadsheet-header-row-text").length>0&&$(".spreadsheet-header-row-text").contextMenu("edit"===t.perm))}}),s.control.rowHeader=function(t){return new s.Control.RowHeader(t)},s.Control.MetricInput=s.Control.extend({options:{position:"topmiddle",title:""},initialize:function(t,e,i,n){s.setOptions(this,n),this._callback=t,this._context=e,this._default=i},onAdd:function(t){return this._initLayout(),this._container},_initLayout:function(){var t="leaflet-control-layers",i=this._container=s.DomUtil.create("div",t);i.style.visibility="hidden";var n=s.DomUtil.create("a","leaflet-popup-close-button",i);n.href="#close",n.innerHTML="&#215;",s.DomEvent.on(n,"click",this._onCloseButtonClick,this);var o=s.DomUtil.create("div","leaflet-popup-content-wrapper",i),a=s.DomUtil.create("div","leaflet-popup-content",o),r=e.createElement("span");r.innerHTML="<b>"+this.options.title+" "+_("(100th/mm)")+"</b>",a.appendChild(r),a.appendChild(e.createElement("br")),a.appendChild(e.createElement("br"));var l=e.createElement("span");l.innerHTML=_("Add: "),a.appendChild(l);var h=this._input=e.createElement("input");h.type="text",h.value=this._default,a.appendChild(h),a.appendChild(e.createElement("br")),a.appendChild(e.createElement("br"));var d=e.createElement("input");d.type="checkbox",d.checked=!0,s.DomEvent.on(d,"click",this._onDefaultClick,this),a.appendChild(d);var u=e.createElement("span");u.innerHTML=_("Default value"),a.appendChild(u),a.appendChild(e.createElement("br")),a.appendChild(e.createElement("br"));var c=e.createElement("input");c.type="button",c.value=_("Submit"),s.DomEvent.on(c,"click",this._onOKButtonClick,this),a.appendChild(c)},onRemove:function(t){this._input=null},show:function(){this._container.style.marginLeft=-this._container.offsetWidth/2+"px",this._container.style.visibility="",this._input.focus()},_onDefaultClick:function(t){this._input.value=this._default},_onOKButtonClick:function(t){var e=parseFloat(this._input.value);this.remove(),this._callback.call(this._context,{type:"submit",value:e})},_onCloseButtonClick:function(t){this.remove(),this._callback.call(this._context,{type:"close"})}}),s.control.metricInput=function(t,e,i,n){return new s.Control.MetricInput(t,e,i,n)},s.Control.DocumentRepair=s.Control.extend({options:{position:"topright"},initialize:function(t){s.setOptions(this,t)},onAdd:function(t){return this._initLayout(),this._container},_initLayout:function(){this._container=s.DomUtil.create("div","leaflet-control-layers"),this._container.style.visibility="hidden";var t=s.DomUtil.create("a","leaflet-popup-close-button",this._container);t.href="#close",t.innerHTML="&#215;",s.DomEvent.on(t,"click",this._onCloseClick,this);var i=s.DomUtil.create("div","leaflet-popup-content-wrapper",this._container),n=s.DomUtil.create("div","leaflet-popup-content",i),o=e.createElement("span");o.innerHTML="<b>"+_("Repair Document")+"</b>",n.appendChild(o),n.appendChild(e.createElement("br")),n.appendChild(e.createElement("br"));var a=s.DomUtil.create("table","",n),r=this._tbody=s.DomUtil.create("tbody","",a),l=s.DomUtil.create("tr","",r),h=s.DomUtil.create("th","",l);h.appendChild(e.createTextNode(_("Type"))),h=s.DomUtil.create("th","",l),h.appendChild(e.createTextNode(_("Index"))),h=s.DomUtil.create("th","",l),h.appendChild(e.createTextNode(_("Comment"))),h=s.DomUtil.create("th","",l),h.appendChild(e.createTextNode(_("User name"))),h=s.DomUtil.create("th","",l),h.appendChild(e.createTextNode(_("Timestamp")));var d=e.createElement("input");d.type="button",d.value=_("Jump to state"),s.DomEvent.on(d,"click",this._onJumpClick,this),n.appendChild(e.createElement("br")),n.appendChild(e.createElement("br")),n.appendChild(d)},createAction:function(t,i,n,o,a){var r=s.DomUtil.create("tr","",this._tbody),l=s.DomUtil.create("td","",r);l.appendChild(e.createTextNode(t)),l=s.DomUtil.create("td","",r),l.appendChild(e.createTextNode(i)),l=s.DomUtil.create("td","",r),l.appendChild(e.createTextNode(n)),l=s.DomUtil.create("td","",r),l.appendChild(e.createTextNode(o)),l=s.DomUtil.create("td","",r);var h=jQuery.timeago(a.replace(/,.*/,"Z")),d=e.createElement("span");d.title=a,d.appendChild(e.createTextNode(h)),l.appendChild(d),s.DomEvent.on(r,"click",this._onRowClick,this),s.DomEvent.on(r,"dblclick",this._onJumpClick,this)},fillAction:function(t,e){for(var i=0;i<t.length;++i){var n=t[i].userName?t[i].userName:"";parseInt(t[i].viewId)===this._map._docLayer._viewId&&(n=_("You")),this.createAction(e,t[i].index,t[i].comment,n,t[i].dateTime)}},fillActions:function(t){this.fillAction(t.Redo.actions,"Redo"),this.fillAction(t.Undo.actions,"Undo")},show:function(){this._tbody.setAttribute("style","max-height:"+this._map.getSize().y/2+"px"),this._container.style.visibility=""},_selectRow:function(t){this._selected&&s.DomUtil.removeClass(this._selected,"leaflet-popup-selected"),this._selected=t,s.DomUtil.addClass(this._selected,"leaflet-popup-selected")},_onCloseClick:function(t){this._map.enable(!0),this._refocusOnMap(),this.remove()},_onRowClick:function(t){t.currentTarget&&this._selected!==t.currentTarget&&this._selectRow(t.currentTarget)},_onJumpClick:function(t){if(this._selected){var e=this._selected.childNodes[0].innerHTML,i=parseInt(this._selected.childNodes[1].innerHTML),n={Repair:{type:"boolean",value:!0}};n[e]={type:"unsigned short",value:i+1},this._map.sendUnoCommand(".uno:"+e,n),this._onCloseClick()}}}),s.control.documentRepair=function(t){return new s.Control.DocumentRepair(t)},s.Control.CharacterMap=s.Control.extend({options:{position:"topright"},unicodeBlocks:[{name:_("None"),start:0,end:0},{name:_("Basic Latin"),start:33,end:127},{name:_("Latin-1"),start:128,end:255},{name:_("Latin Extended-A"),start:256,end:383},{name:_("Latin Extended-B"),start:384,end:591},{name:_("IPA Extensions"),start:592,end:687},{name:_("Spacing Modifier Letters"),start:688,end:767},{name:_("Combining Diacritical Marks"),start:768,end:879},{name:_("Basic Greek"),start:880,end:1023},{name:_("Cyrillic"),start:1024,end:1279},{name:_("Armenian"),start:1328,end:1423},{name:_("Basic Hebrew"),start:1424,end:1535},{name:_("Basic Arabic"),start:1536,end:1791},{name:_("Syriac"),start:1792,end:1871},{name:_("Thaana"),start:1920,end:1983},{name:_("Devanagari"),start:2304,end:2431},{name:_("Bengali"),start:2432,end:2559},{name:_("Gurmukhi"),start:2560,end:2687},{name:_("Gujarati"),start:2688,end:2815},{name:_("Odia"),start:2816,end:2943},{name:_("Tamil"),start:2944,end:3071},{name:_("Telugu"),start:3072,end:3199},{name:_("Kannada"),start:3200,end:3327},{name:_("Malayalam"),start:3328,end:3455},{name:_("Sinhala"),start:3456,end:3583},{name:_("Thai"),start:3584,end:3711},{name:_("Lao"),start:3712,end:3839},{name:_("Tibetan"),start:3840,end:4095},{name:_("Myanmar"),start:4096,end:4255},{name:_("Basic Georgian"),start:4256,end:4351},{name:_("Hangul Jamo"),start:4352,end:4607},{name:_("Ethiopic"),start:4608,end:4863},{name:_("Cherokee"),start:5024,end:5119},{name:_("Canadian Aboriginal Syllables"),start:5120,end:5375},{name:_("Ogham"),start:5760,end:5791},{name:_("Runic"),start:5792,end:5887},{name:_("Khmer"),start:6016,end:6143},{name:_("Mongolian"),start:6144,end:6319},{name:_("Latin Extended Additional"),start:7680,end:7935},{name:_("Greek Extended"),start:7936,end:8191},{name:_("General Punctuation"),start:8192,end:8303},{name:_("Superscripts and Subscripts"),start:8304,end:8351},{name:_("Currency Symbols"),start:8352,end:8399},{name:_("Combining Diacritical Symbols"),start:8400,end:8447},{name:_("Letterlike Symbols"),start:8448,end:8527},{name:_("Number Forms"),start:8528,end:8591},{name:_("Arrows"),start:8592,end:8703},{name:_("Mathematical Operators"),start:8704,end:8959},{name:_("Miscellaneous Technical"),start:8960,end:9215},{name:_("Control Pictures"),start:9216,end:9279},{name:_("Optical Character Recognition"),start:9280,end:9311},{name:_("Enclosed Alphanumerics"),start:9312,end:9471},{name:_("Box Drawing"),start:9472,end:9599},{name:_("Block Elements"),start:9600,end:9631},{name:_("Geometric Shapes"),start:9632,end:9727},{name:_("Miscellaneous Symbols"),start:9728,end:9983},{name:_("Dingbats"),start:9984,end:10175},{name:_("Braille Patterns"),start:10240,end:10495},{name:_("CJK Radicals Supplement"),start:11904,end:12031},{name:_("Kangxi Radicals"),start:12032,end:12255},{name:_("Ideographic Description Characters"),start:12272,end:12287},{name:_("CJK Symbols and Punctuation"),start:12288,end:12351},{name:_("Hiragana"),start:12352,end:12447},{name:_("Katakana"),start:12448,end:12543},{name:_("Bopomofo"),start:12544,end:12591},{name:_("Hangul Compatibility Jamo"),start:12592,end:12687},{name:_("Kanbun"),start:12688,end:12703},{name:_("Bopomofo Extended"),start:12704,end:12735},{name:_("Enclosed CJK Letters and Months"),start:12800,end:13055},{name:_("CJK Compatibility"),start:13056,end:13311},{name:_("CJK Unified Ideographs Extension A"),start:13312,end:13567},{name:_("CJK Unified Ideographs"),start:19968,end:20223},{name:_("Yi Syllables"),start:40960,end:41215},{name:_("Yi Radicals"),start:42128,end:42191},{name:_("Hangul"),start:44032,end:44287},{name:_("High Surrogates"),start:55296,end:55551},{name:_("High Private Use Surrogates"),start:56192,end:56319},{name:_("Low Surrogates"),start:56320,end:56575},{name:_("Private Use Area"),start:57344,end:57599},{name:_("CJK Compatibility Ideographs"),start:63744,end:63999},{name:_("Alphabetic Presentation Forms"),start:64256,end:64335},{name:_("Arabic Presentation Forms-A"),start:64336,end:64511},{name:_("Combining Half Marks"),start:65056,end:65071},{name:_("CJK Compatibility Forms"),start:65072,end:65103},{name:_("Small Form Variants"),start:65104,end:65135},{name:_("Arabic Presentation Forms-B"),start:65136,end:65262},{name:_("Specials"),start:65279,end:65279},{name:_("Halfwidth and Fullwidth Forms"),start:65280,end:65519},{name:_("Old Italic"),start:66304,end:66351},{name:_("Gothic"),start:66352,end:66383},{name:_("Deseret"),start:66560,end:66639},{name:_("Byzantine Musical Symbols"),start:118784,end:119039},{name:_("Musical Symbols"),start:119040,end:119295},{name:_("Musical Symbols"),start:119808,end:120831},{name:_("CJK Unified Ideographs Extension B"),start:131072,end:131327},{name:_("CJK Compatibility Ideographs Supplement"),start:194560,end:194815},{name:_("Tags"),start:917504,end:917631},{name:_("Cyrillic Supplement"),start:1280,end:1327},{name:_("Tagalog"),start:5888,end:5919},{name:_("Hanunoo"),start:5920,end:5951},{name:_("Buhid"),start:5952,end:5983},{name:_("Tagbanwa"),start:5984,end:6015},{name:_("Miscellaneous Mathematical Symbols-A"),start:10176,end:10223},{name:_("Supplemental Arrows-A"),start:10224,end:10239},{name:_("Supplemental Arrows-B"),start:10496,end:10623},{name:_("Miscellaneous Mathematical Symbols-B"),start:10624,end:10751},{name:_("Supplemental Mathematical Operators"),start:10752,end:11007},{name:_("Katakana Phonetics Extensions"),start:12784,end:12799},{name:_("Variation Selectors"),start:65024,end:65039},{name:_("Supplementary Private Use Area-A"),start:983040,end:983295},{name:_("Supplementary Private Use Area-B"),start:1048576,end:1048831},{name:_("Limbu"),start:6400,end:6479},{name:_("Tai Le"),start:6480,end:6527},{name:_("Khmer Symbols"),start:6624,end:6655},{name:_("Phonetic Extensions"),start:7424,end:7551},{name:_("Miscellaneous Symbols And Arrows"),start:11008,end:11263
},{name:_("Yijing Hexagram Symbols"),start:19904,end:19967},{name:_("Linear B Syllabary"),start:65536,end:65663},{name:_("Linear B Ideograms"),start:65664,end:65791},{name:_("Aegean Numbers"),start:65792,end:65855},{name:_("Ugaritic"),start:66432,end:66463},{name:_("Shavian"),start:66640,end:66687},{name:_("Osmanya"),start:66688,end:66735},{name:_("Cypriot Syllabary"),start:67584,end:67647},{name:_("Tai Xuan Jing Symbols"),start:119552,end:119647},{name:_("Variation Selectors Supplement"),start:917760,end:917999},{name:_("Ancient Greek Musical Notation"),start:119296,end:119375},{name:_("Ancient Greek Numbers"),start:65856,end:65935},{name:_("Arabic Supplement"),start:1872,end:1919},{name:_("Buginese"),start:6656,end:6687},{name:_("CJK Strokes"),start:12736,end:12783},{name:_("Combining Diacritical Marks Supplement"),start:7616,end:7679},{name:_("Coptic"),start:11392,end:11519},{name:_("Ethiopic Extended"),start:11648,end:11743},{name:_("Ethiopic Supplement"),start:4992,end:5023},{name:_("Georgian Supplement"),start:11520,end:11567},{name:_("Glagolitic"),start:11264,end:11359},{name:_("Kharoshthi"),start:68096,end:68191},{name:_("Modifier Tone Letters"),start:42752,end:42783},{name:_("New Tai Lue"),start:6528,end:6623},{name:_("Old Persian"),start:66464,end:66527},{name:_("Phonetic Extensions Supplement"),start:7552,end:7615},{name:_("Supplemental Punctuation"),start:11776,end:11903},{name:_("Syloti Nagri"),start:43008,end:43055},{name:_("Tifinagh"),start:11568,end:11647},{name:_("Vertical Forms"),start:65040,end:65055},{name:_("Nko"),start:1984,end:2047},{name:_("Balinese"),start:6912,end:7039},{name:_("Latin Extended-C"),start:11360,end:11391},{name:_("Latin Extended-D"),start:42784,end:43007},{name:_("Phags-Pa"),start:43072,end:43135},{name:_("Phoenician"),start:67840,end:67871},{name:_("Cuneiform"),start:73728,end:73983},{name:_("Cuneiform Numbers And Punctuation"),start:74752,end:74879},{name:_("Counting Rod Numerals"),start:119648,end:119679},{name:_("Sundanese"),start:7040,end:7103},{name:_("Lepcha"),start:7168,end:7247},{name:_("Ol Chiki"),start:7248,end:7295},{name:_("Cyrillic Extended-A"),start:11744,end:11775},{name:_("Vai"),start:42240,end:42495},{name:_("Cyrillic Extended-B"),start:42560,end:42655},{name:_("Saurashtra"),start:43136,end:43231},{name:_("Kayah Li"),start:43264,end:43311},{name:_("Rejang"),start:43312,end:43359},{name:_("Cham"),start:43520,end:43615},{name:_("Ancient Symbols"),start:65936,end:65999},{name:_("Phaistos Disc"),start:66e3,end:66047},{name:_("Lycian"),start:66176,end:66207},{name:_("Carian"),start:66208,end:66271},{name:_("Lydian"),start:67872,end:67903},{name:_("Mahjong Tiles"),start:126976,end:127023},{name:_("Domino Tiles"),start:127024,end:127135},{name:_("Samaritan"),start:2048,end:2111},{name:_("Canadian Aboriginal Syllabics Extended"),start:6320,end:6399},{name:_("Tai Tham"),start:6688,end:6831},{name:_("Vedic Extensions"),start:7376,end:7423},{name:_("Lisu"),start:42192,end:42239},{name:_("Bamum"),start:42656,end:42751},{name:_("Common Indic Number Forms"),start:43056,end:43071},{name:_("Devanagari Extended"),start:43232,end:43263},{name:_("Hangul Jamo Extended-A"),start:43360,end:43391},{name:_("Javanese"),start:43392,end:43487},{name:_("Myanmar Extended-A"),start:43616,end:43647},{name:_("Tai Viet"),start:43648,end:43743},{name:_("Meetei Mayek"),start:43968,end:44031},{name:_("Hangul Jamo Extended-B"),start:55216,end:55295},{name:_("Imperial Aramaic"),start:67648,end:67679},{name:_("Old South Arabian"),start:68192,end:68223},{name:_("Avestan"),start:68352,end:68415},{name:_("Inscriptional Parthian"),start:68416,end:68447},{name:_("Inscriptional Pahlavi"),start:68448,end:68479},{name:_("Old Turkic"),start:68608,end:68687},{name:_("Rumi Numeral Symbols"),start:69216,end:69247},{name:_("Kaithi"),start:69760,end:69839},{name:_("Egyptian Hieroglyphs"),start:77824,end:78079},{name:_("Enclosed Alphanumeric Supplement"),start:127232,end:127487},{name:_("Enclosed Ideographic Supplement"),start:127488,end:127743},{name:_("CJK Unified Ideographs Extension C"),start:173824,end:174079},{name:_("Mandaic"),start:2112,end:2143},{name:_("Batak"),start:7104,end:7167},{name:_("Ethiopic Extended-A"),start:43776,end:43823},{name:_("Brahmi"),start:69632,end:69759},{name:_("Bamum Supplement"),start:92160,end:92223},{name:_("Kana Supplement"),start:110592,end:110847},{name:_("Playing Cards"),start:127136,end:127231},{name:_("Miscellaneous Symbols And Pictographs"),start:127744,end:127999},{name:_("Emoticons"),start:128512,end:128591},{name:_("Transport And Map Symbols"),start:128640,end:128767},{name:_("Alchemical Symbols"),start:128768,end:128895},{name:_("CJK Unified Ideographs Extension D"),start:177984,end:178175},{name:_("Arabic Extended-A"),start:2208,end:2303},{name:_("Arabic Mathematical Alphabetic Symbols"),start:126464,end:126719},{name:_("Chakma"),start:69888,end:69967},{name:_("Meetei Mayek Extensions"),start:43744,end:43775},{name:_("Meroitic Cursive"),start:68e3,end:68095},{name:_("Meroitic Hieroglyphs"),start:67968,end:67999},{name:_("Miao"),start:93952,end:94111},{name:_("Sharada"),start:70016,end:70111},{name:_("Sora Sompeng"),start:69840,end:69887},{name:_("Sundanese Supplement"),start:7360,end:7375},{name:_("Takri"),start:71296,end:71375},{name:_("Bassa Vah"),start:92880,end:92927},{name:_("Caucasian Albanian"),start:66864,end:66927},{name:_("Coptic Epact Numbers"),start:66272,end:66303},{name:_("Combining Diacritical Marks Extended"),start:6832,end:6911},{name:_("Duployan"),start:113664,end:113823},{name:_("Elbasan"),start:66816,end:66863},{name:_("Geometric Shapes Extended"),start:128896,end:129023},{name:_("Grantha"),start:70400,end:70527},{name:_("Khojki"),start:70144,end:70223},{name:_("Khudawadi"),start:70320,end:70399},{name:_("Latin Extended-E"),start:43824,end:43887},{name:_("Linear A"),start:67072,end:67327},{name:_("Mahajani"),start:69968,end:70015},{name:_("Manichaean"),start:68288,end:68351},{name:_("Mende Kikakui"),start:124928,end:125151},{name:_("Modi"),start:71168,end:71263},{name:_("Mro"),start:92736,end:92783},{name:_("Myanmar Extended-B"),start:43488,end:43519},{name:_("Nabataean"),start:67712,end:67759},{name:_("Old North Arabian"),start:68224,end:68255},{name:_("Old Permic"),start:66384,end:66431},{name:_("Ornamental Dingbats"),start:128592,end:128639},{name:_("Pahawh Hmong"),start:92928,end:93071},{name:_("Palmyrene"),start:67680,end:67711},{name:_("Pau Cin Hau"),start:72384,end:72447},{name:_("Psalter Pahlavi"),start:68480,end:68527},{name:_("Shorthand Format Controls"),start:113824,end:113839},{name:_("Siddham"),start:71040,end:71167},{name:_("Sinhala Archaic Numbers"),start:70112,end:70143},{name:_("Supplemental Arrows-C"),start:129024,end:129279},{name:_("Tirhuta"),start:70784,end:70879},{name:_("Warang Citi"),start:71840,end:71935},{name:_("Ahom"),start:71424,end:71487},{name:_("Anatolian Hieroglyphs"),start:82944,end:83199},{name:_("Cherokee Supplement"),start:43888,end:43967},{name:_("CJK Unified Ideographs Extension E"),start:178208,end:183983},{name:_("CJK Unified Ideographs Extension E"),start:178208,end:178431},{name:_("Early Dynastic Cuneiform"),start:74880,end:75007},{name:_("Hatran"),start:67808,end:67839},{name:_("Multani"),start:70272,end:70319},{name:_("Old Hungarian"),start:68736,end:68863},{name:_("Supplemental Symbols And Pictographs"),start:129280,end:129535},{name:_("Sutton Signwriting"),start:120832,end:121087}],cacheSubset:{},cacheGlyph:{},fillCharacters:function(i){var n,o,a,r,l=this.unicodeBlocks[i].start,h=this.unicodeBlocks[i].end,d=t.encodeURIComponent(this._fontNames.options[this._fontNames.selectedIndex].value),u=0;for(s.DomUtil.empty(this._tbody);h>=l;)u%20===0&&(n=s.DomUtil.create("tr","",this._tbody)),o=s.DomUtil.create("td","",n),r=t.encodeURIComponent(String.fromCharCode(l)),this.cacheGlyph[d+r]?a=this.cacheGlyph[d+r]:(a=e.createElement("img"),a.data=l,a.src=s.Icon.Default.imagePath+"/loading.gif",this.cacheGlyph[d+r]=a,this._map._socket.sendMessage("renderfont font="+d+" char="+r)),s.DomEvent.on(o,"click",this._onSymbolClick,this),s.DomEvent.on(o,"dblclick",this._onSymbolDblClick,this),o.appendChild(a),l++,u++},fillDropDown:function(t,i,n,o,a){s.DomUtil.empty(t);for(var r,l=0,h=i.length;h>l;l++)r=e.createElement("option"),o.call(a,r,i,l),t.appendChild(r);t.selectedIndex=n},fillFontNames:function(t,e){this.fillDropDown(this._fontNames,t,e,function(t,e,i){t.innerHTML=e[i].innerHTML},this),this._onFontNamesChange()},initialize:function(t){s.setOptions(this,t)},onAdd:function(t){return this._initLayout(),t.on("commandvalues",this._onFontSubset,this),t.on("renderfont",this._onRenderFontPreview,this),this._container},onRemove:function(t){t.off("commandvalues",this._onFontSubset,this),t.off("renderfont",this._onRenderFontPreview,this)},show:function(){this._content.setAttribute("style","max-height:"+(this._map.getSize().y-50)+"px"),this._container.style.visibility=""},_initLayout:function(){this._container=s.DomUtil.create("div","leaflet-control-layers"),this._container.style.visibility="hidden";var t=s.DomUtil.create("a","leaflet-popup-close-button",this._container);t.href="#close",t.innerHTML="&#215;",s.DomEvent.on(t,"click",this._onCloseClick,this);var i=s.DomUtil.create("div","leaflet-popup-content-wrapper",this._container),n=this._content=s.DomUtil.create("div","leaflet-popup-content loleaflet-scrolled",i),o=e.createElement("span");o.innerHTML="<b>"+_("Special Characters")+"</b>",n.appendChild(o),n.appendChild(e.createElement("br")),n.appendChild(e.createElement("br"));var a=s.DomUtil.create("span","loleaflet-controls",n);a.innerHTML="<b>"+_("Font Name:")+"</b>",n.appendChild(e.createElement("br")),this._fontNames=s.DomUtil.create("select","loleaflet-controls",n),s.DomEvent.on(this._fontNames,"change",this._onFontNamesChange,this),n.appendChild(e.createElement("br")),n.appendChild(e.createElement("br")),a=s.DomUtil.create("span","loleaflet-controls",n),a.innerHTML="<b>"+_("Subset:")+"</b>",n.appendChild(e.createElement("br")),this._unicodeSubset=s.DomUtil.create("select","loleaflet-controls",n),s.DomEvent.on(this._unicodeSubset,"change",this._onUnicodeSubsetChange,this),n.appendChild(e.createElement("br")),n.appendChild(e.createElement("br"));var r=s.DomUtil.create("table","loleaflet-character",n);this._tbody=s.DomUtil.create("tbody","",r),n.appendChild(e.createElement("br")),n.appendChild(e.createElement("br")),a=s.DomUtil.create("span","loleaflet-controls",n),a.innerHTML="<b>"+_("Selected Character:")+"</b>",this._preview=s.DomUtil.create("img","",n),n.appendChild(e.createElement("br")),n.appendChild(e.createElement("br")),a=s.DomUtil.create("span","loleaflet-controls",n),a.innerHTML="<b>"+_("Hexadecimal:")+"</b>",this._hexa=s.DomUtil.create("span","loleaflet-controls",n),n.appendChild(e.createElement("br")),n.appendChild(e.createElement("br"));var l=s.DomUtil.create("input","loleaflet-controls",n);l.type="button",l.value=_("Insert"),s.DomEvent.on(l,"click",this._onInsertClick,this),l=s.DomUtil.create("input","loleaflet-controls",n),l.type="button",l.value=_("Cancel"),s.DomEvent.on(l,"click",this._onCancelClick,this)},_onCancelClick:function(t){this._onCloseClick(t)},_onCloseClick:function(t){this._map.enable(!0),this._refocusOnMap(),this.remove()},_onFontNamesChange:function(e){var i=this._fontNames.options[this._fontNames.selectedIndex].value;this.cacheSubset[i]?(this.fillDropDown(this._unicodeSubset,this.cacheSubset[i],0,function(t,e,i){t.tag=e[i],t.innerHTML=this.unicodeBlocks[e[i]].name},this),this._onUnicodeSubsetChange()):this._map._socket.sendMessage("commandvalues command=.uno:FontSubset&name="+t.encodeURIComponent(i))},_onFontSubset:function(t){".uno:FontSubset"===t.commandName&&t.commandValues?(this.cacheSubset[this._fontNames.options[this._fontNames.selectedIndex].value]=t.commandValues,this.fillDropDown(this._unicodeSubset,t.commandValues,0,function(t,e,i){t.tag=e[i],t.innerHTML=this.unicodeBlocks[e[i]].name},this),this._onUnicodeSubsetChange()):(s.DomUtil.remove(this._fontNames.options[this._fontNames.selectedIndex]),this._onFontNamesChange())},_onInsertClick:function(t){this._sendSymbol(),this._onCloseClick(t)},_onRenderFontPreview:function(t){this.cacheGlyph[t.font+t["char"]]&&(this.cacheGlyph[t.font+t["char"]].src=t.img)},_onSymbolClick:function(e){var i=e.target||e.srcElement,n=t.encodeURIComponent(this._fontNames.options[this._fontNames.selectedIndex].value),o=t.encodeURIComponent(String.fromCharCode(i.data));this._hexa.data=i.data,this.cacheGlyph[n+o]?this._preview.src=this.cacheGlyph[n+o].src:this._preview.src=s.Icon.Default.imagePath+"/loading.gif",this._hexa.innerHTML="U+"+this._hexa.data.toString(16).toUpperCase()},_onSymbolDblClick:function(t){var e=t.target||t.srcElement;this._hexa.data=e.data,this._sendSymbol(),setTimeout(s.bind(function(){this._onCloseClick()},this),0)},_sendSymbol:function(){if(this._hexa.data){var t={Symbols:{type:"string",value:String.fromCharCode(this._hexa.data)},FontName:{type:"string",value:this._fontNames.options[this._fontNames.selectedIndex].value}};this._map.sendUnoCommand(".uno:InsertSymbol",t)}},_onUnicodeSubsetChange:function(t){this.fillCharacters(this._unicodeSubset.options[this._unicodeSubset.selectedIndex].tag)}}),s.control.characterMap=function(t){return new s.Control.CharacterMap(t)},s.Control.ContextMenu=s.Control.extend({options:{SEPARATOR:"---------",whitelist:{general:["Cut","Copy","Paste","PasteSpecialMenu","PasteUnformatted","NumberingStart","ContinueNumbering","IncrementLevel","DecrementLevel","OpenHyperlinkOnCursor","CopyHyperlinkLocation","RemoveHyperlink","AnchorMenu","SetAnchorToPage","SetAnchorToPara","SetAnchorAtChar","SetAnchorToChar","SetAnchorToFrame","WrapMenu","WrapOff","WrapOn","WrapIdeal","WrapLeft","WrapRight","WrapThrough","WrapThroughTransparent","WrapContour","WrapAnchorOnly","ArrangeFrameMenu","ArrangeMenu","BringToFront","ObjectForwardOne","ObjectBackOne","SendToBack","RotateMenu","RotateLeft","RotateRight"],text:["TableInsertMenu","InsertRowsBefore","InsertRowsAfter","InsertColumnsBefore","InsertColumnsAfter","TableDeleteMenu","DeleteRows","DeleteColumns","DeleteTable","MergeCells","SetOptimalColumnWidth","SetOptimalRowWidth","UpdateCurIndex","RemoveTableOf","ReplyComment","DeleteComment","DeleteAuthor","DeleteAllNotes"],spreadsheet:["MergeCells","SplitCells","InsertAnnotation","EditAnnotation","DeleteNote","ShowNote","HideNote","RecalcPivotTable"],presentation:[],drawing:[]}},onAdd:function(t){this._prevMousePos=null,t.on("locontextmenu",this._onContextMenu,this),t.on("mousedown",this._onMouseDown,this),t.on("keydown",this._onKeyDown,this)},_onMouseDown:function(t){this._prevMousePos={x:t.originalEvent.pageX,y:t.originalEvent.pageY},$.contextMenu("destroy",".leaflet-layer")},_onKeyDown:function(t){27===t.originalEvent.keyCode&&$.contextMenu("destroy",".leaflet-layer")},_onContextMenu:function(t){if("edit"===map._permission){var e=this._createContextMenuStructure(t);$.contextMenu({selector:".leaflet-layer",className:"loleaflet-font",trigger:"none",build:function(){return{callback:function(t){map.sendUnoCommand(t),map.focus()},items:e}}}),$(".leaflet-layer").contextMenu(this._prevMousePos)}},_createContextMenuStructure:function(t){var e,n=map.getDocType(),s={},o=1,a=!1;for(var r in t.menu){var l=t.menu[r];if("false"!==l.enabled)if("separator"===l.type)a&&(s["sep"+o++]=this.options.SEPARATOR),a=!1;else if("command"===l.type){var h=l.command.substring(5);if(!(-1!==this.options.whitelist.general.indexOf(h)||"text"===n&&-1!==this.options.whitelist.text.indexOf(h)||"spreadsheet"===n&&-1!==this.options.whitelist.spreadsheet.indexOf(h)||"presentation"===n&&-1!==this.options.whitelist.presentation.indexOf(h)||"drawing"===n&&-1!==this.options.whitelist.drawing.indexOf(h)))continue;e=l.text.replace("~",""),e=e.replace("Â°","°"),"DeleteAuthor"===h&&(e=e.replace(e.substring("Delete All Comments by ".length),"This Author")),s[l.command]={name:_(e)},"checkmark"===l.checktype?"true"===l.checked&&(s[l.command].icon="lo-checkmark"):"radio"===l.checktype&&"true"===l.checked&&(s[l.command].icon="radio"),a=!0}else if("menu"===l.type){e=l.text.replace("~","");var d=this._createContextMenuStructure(l);if(0===Object.keys(d).length)continue;s[l.command]={name:_(e),items:d},a=!0}}var u=Object.keys(s)[Object.keys(s).length-1];return u!==i&&u.startsWith("sep")&&delete s[u],s}}),s.control.contextMenu=function(t){return new s.Control.ContextMenu(t)},s.Control.Menubar=s.Control.extend({options:{text:[{name:_("File"),id:"file",type:"menu",menu:[{name:_("Save"),id:"save",type:"unocommand",uno:".uno:Save"},{name:_("Print"),id:"print",type:"action"},{name:_("See revision history"),id:"rev-history",type:"action"},{name:_("Download as"),id:"downloadas",type:"menu",menu:[{name:_("PDF Document (.pdf)"),id:"downloadas-pdf",type:"action"},{name:_("ODF text document (.odt)"),id:"downloadas-odt",type:"action"},{name:_("Microsoft Word 2003 (.doc)"),id:"downloadas-doc",type:"action"},{name:_("Microsoft Word (.docx)"),id:"downloadas-docx",type:"action"}]}]},{name:_("Edit"),type:"menu",menu:[{name:_("Repair"),id:"repair",type:"action"},{name:_("Undo"),type:"unocommand",uno:".uno:Undo"},{name:_("Redo"),type:"unocommand",uno:".uno:Redo"},{type:"separator"},{name:_("Cut"),type:"unocommand",uno:".uno:Cut"},{name:_("Copy"),type:"unocommand",uno:".uno:Copy"},{name:_("Paste"),type:"unocommand",uno:".uno:Paste"},{type:"separator"},{name:_("Select all"),type:"unocommand",uno:".uno:SelectAll"}]},{name:_("View"),id:"view",type:"menu",menu:[{name:_("Full screen"),id:"fullscreen",type:"action"},{type:"separator"},{name:_("Zoom in"),id:"zoomin",type:"action"},{name:_("Zoom out"),id:"zoomout",type:"action"},{name:_("Reset zoom"),id:"zoomreset",type:"action"}]},{name:_("Insert"),type:"menu",menu:[{name:_("Image"),id:"insertgraphic",type:"action"},{name:_("Comment"),type:"unocommand",uno:".uno:InsertAnnotation"},{type:"separator"},{name:_("Footnote"),type:"unocommand",uno:".uno:InsertFootnote"},{name:_("Endnote"),type:"unocommand",uno:".uno:InsertEndnote"},{type:"separator"},{name:_("Page break"),type:"unocommand",uno:".uno:InsertPageBreak"},{name:_("Column break"),type:"unocommand",uno:".uno:InsertColumnBreak"},{type:"separator"},{name:_("Special character..."),id:"specialcharacter",type:"action"},{name:_("Formatting mark"),type:"menu",menu:[{name:_("Non-breaking space"),type:"unocommand",uno:".uno:InsertNonBreakingSpace"},{name:_("Non-breaking hyphen"),type:"unocommand",uno:".uno:InsertHardHyphen"},{name:_("Soft hyphen"),type:"unocommand",uno:".uno:InsertSoftHyphen"},{name:_("No-width optional break"),type:"unocommand",uno:".uno:InsertZWSP"},{name:_("No-width no break"),type:"unocommand",uno:".uno:InsertZWNBSP"},{name:_("Left-to-right mark"),type:"unocommand",uno:".uno:InsertLRM"},{name:_("Right-to-left mark"),type:"unocommand",uno:".uno:InsertRLM"}]}]},{name:_("Format"),type:"menu",menu:[{name:_("Text"),type:"menu",menu:[{name:_("Bold"),type:"unocommand",uno:".uno:Bold"},{name:_("Italic"),type:"unocommand",uno:".uno:Italic"},{name:_("Underline"),type:"unocommand",uno:".uno:Underline"},{name:_("Double underline"),type:"unocommand",uno:".uno:UnderlineDouble"},{name:_("Strikethrough"),type:"unocommand",uno:".uno:Strikeout"},{name:_("Overline"),type:"unocommand",uno:".uno:Overline"},{type:"separator"},{name:_("Superscript"),type:"unocommand",uno:".uno:SuperScript"},{name:_("Subscript"),type:"unocommand",uno:".uno:SubScript"},{name:_("ꜱᴍᴀʟʟ ᴄᴀᴘꜱ"),type:"unocommand",uno:".uno:SmallCaps"},{type:"separator"},{name:_("Shadow"),type:"unocommand",uno:".uno:Shadowed"},{name:_("Outline"),type:"unocommand",uno:".uno:OutlineFont"},{type:"separator"},{name:_("Increase size"),type:"unocommand",uno:".uno:Grow"},{name:_("Decrease size"),type:"unocommand",uno:".uno:Shrink"},{type:"separator"},{name:_("UPPERCASE"),type:"unocommand",uno:".uno:ChangeCaseToUpper"},{name:_("lowercase"),type:"unocommand",uno:".uno:ChangeCaseToLower"},{name:_("Cycle case"),type:"unocommand",uno:".uno:ChangeCaseRotateCase"},{type:"separator"},{name:_("Sentence case"),type:"unocommand",uno:".uno:ChangeCaseToSentenceCase"},{name:_("Capitalize Every Word"),type:"unocommand",uno:".uno:ChangeCaseToTitleCase"},{name:_("tOGGLE cASE"),type:"unocommand",uno:".uno:ChangeCaseToToggleCase"}]},{name:_("Text orientation"),type:"menu",menu:[{name:_("Set paragraph left-to-right"),type:"unocommand",uno:".uno:ParaLeftToRight"},{name:_("Set paragraph right-to-left"),type:"unocommand",uno:".uno:ParaRightToLeft"}]},{name:_("Spacing"),type:"menu",menu:[{name:_("Line spacing: 1"),type:"unocommand",uno:".uno:SpacePara1"},{name:_("Line spacing: 1.5"),type:"unocommand",uno:".uno:SpacePara15"},{name:_("Line spacing: 2"),type:"unocommand",uno:".uno:SpacePara2"},{type:"separator"},{name:_("Increase paragraph spacing"),type:"unocommand",uno:".uno:ParaspaceIncrease"},{name:_("Decrease paragraph spacing"),type:"unocommand",uno:".uno:ParaspaceDecrease"},{type:"separator"},{name:_("Increase indent"),type:"unocommand",uno:".uno:IncrementIndent"},{name:_("Decrease indent"),type:"unocommand",uno:".uno:DecrementIndent"}]},{name:_("Align"),type:"menu",menu:[{name:_("Left"),type:"unocommand",uno:".uno:CommonAlignLeft"},{name:_("Centered"),type:"unocommand",uno:".uno:CommonAlignHorizontalCenter"},{name:_("Right"),type:"unocommand",uno:".uno:CommonAlignRight"},{name:_("Justified"),type:"unocommand",uno:".uno:CommonAlignJustified"},{type:"separator"},{name:_("Top"),type:"unocommand",uno:".uno:CommonAlignTop"},{name:_("Center"),type:"unocommand",uno:".uno:CommonAlignVerticalcenter"},{name:_("Bottom"),type:"unocommand",uno:".uno:CommonAlignBottom"}]},{name:_("Lists"),type:"menu",menu:[{name:_("Bullets on/off"),type:"unocommand",uno:".uno:DefaultBullet"},{name:_("Numbering on/off"),type:"unocommand",uno:".uno:DefaultNumbering"},{type:"separator"},{name:_("Demote one level"),type:"unocommand",uno:".uno:DecrementLevel"},{name:_("Promote one level"),type:"unocommand",uno:".uno:IncrementLevel"},{name:_("Demote one level with subpoints"),type:"unocommand",uno:".uno:DecrementSublevels"},{name:_("Promote one level with subpoints"),type:"unocommand",uno:".uno:IncrementSubLevels"},{type:"separator"},{name:_("Move down"),type:"unocommand",uno:".uno:MoveDown"},{name:_("Move up"),type:"unocommand",uno:".uno:MoveUp"},{name:_("Move down with subpoints"),type:"unocommand",uno:".uno:MoveDownSubItems"},{name:_("Move up with subpoints"),type:"unocommand",uno:".uno:MoveUpSubItems"},{type:"separator"},{name:_("Insert unnumbered entry"),type:"unocommand",uno:".uno:InsertNeutralParagraph"},{name:_("Restart numbering"),type:"unocommand",uno:".uno:NumberingStart"},{type:"separator"},{name:_("To next paragraph in level"),type:"unocommand",uno:".uno:JumpDownThisLevel"},{name:_("To previous paragraph in level"),type:"unocommand",uno:".uno:JumpUpThisLevel"},{name:_("Continue previous numbering"),type:"unocommand",uno:".uno:ContinueNumbering"}]},{name:_("Clear direct formatting"),type:"unocommand",uno:".uno:ResetAttributes"},{name:_("Page"),type:"menu",menu:[{name:"A4, "+_("Portrait"),type:"action",id:"a4portrait"},{name:"A4, "+_("Landscape"),type:"action",id:"a4landscape"},{name:"A5, "+_("Portrait"),type:"action",id:"a5portrait"},{name:"A5, "+_("Landscape"),type:"action",id:"a5landscape"},{name:"Letter, "+_("Portrait"),type:"action",id:"letterportrait"},{name:"Letter, "+_("Landscape"),type:"action",id:"letterlandscape"},{name:"Legal, "+_("Portrait"),type:"action",id:"legalportrait"},{name:"Legal, "+_("Landscape"),type:"action",id:"legallandscape"}]}]},{name:_("Tables"),type:"menu",menu:[{name:_("Insert"),type:"menu",menu:[{name:_("Rows before"),type:"unocommand",uno:".uno:InsertRowsBefore"},{name:_("Rows after"),type:"unocommand",uno:".uno:InsertRowsAfter"},{type:"separator"},{name:_("Columns left"),type:"unocommand",uno:".uno:InsertColumnsBefore"},{name:_("Columns right"),type:"unocommand",uno:".uno:InsertColumnsAfter"}]},{name:_("Delete"),type:"menu",menu:[{name:_("Rows"),type:"unocommand",uno:".uno:DeleteRows"},{name:_("Columns"),type:"unocommand",uno:".uno:DeleteColumns"},{name:_("Table"),type:"unocommand",uno:".uno:DeleteTable"}]},{name:_("Select"),type:"menu",menu:[{name:_("Table"),type:"unocommand",uno:".uno:SelectTable"},{name:_("Row"),type:"unocommand",uno:".uno:EntireRow"},{name:_("Column"),type:"unocommand",uno:".uno:EntireColumn"},{name:_("Cell"),type:"unocommand",uno:".uno:EntireCell"}]},{name:_("Merge cells"),type:"unocommand",uno:".uno:MergeCells"}]},{name:_("Help"),id:"help",type:"menu",menu:[{name:_("Keyboard shortcuts"),id:"keyboard-shortcuts",type:"action"},{name:_("About"),id:"about",type:"action"}]},{name:_("Close document"),id:"closedocument",type:"action"}],presentation:[{name:_("File"),id:"file",type:"menu",menu:[{name:_("Save"),id:"save",type:"unocommand",uno:".uno:Save"},{name:_("Print"),id:"print",type:"action"},{name:_("See revision history"),id:"rev-history",type:"action"},{name:_("Download as"),id:"downloadas",type:"menu",menu:[{name:_("PDF Document (.pdf)"),id:"downloadas-pdf",type:"action"},{name:_("ODF presentation (.odp)"),id:"downloadas-odp",type:"action"},{name:_("Microsoft Powerpoint 2003 (.ppt)"),id:"downloadas-ppt",type:"action"},{name:_("Microsoft Powerpoint (.pptx)"),id:"downloadas-pptx",type:"action"}]}]},{name:_("Edit"),type:"menu",menu:[{name:_("Undo"),type:"unocommand",uno:".uno:Undo"},{name:_("Redo"),type:"unocommand",uno:".uno:Redo"},{type:"separator"},{name:_("Cut"),type:"unocommand",uno:".uno:Cut"},{name:_("Copy"),type:"unocommand",uno:".uno:Copy"},{name:_("Paste"),type:"unocommand",uno:".uno:Paste"},{type:"separator"},{name:_("Select all"),type:"unocommand",uno:".uno:SelectAll"}]},{name:_("View"),id:"view",type:"menu",menu:[{name:_("Full screen"),id:"fullscreen",type:"action"},{type:"separator"},{name:_("Zoom in"),id:"zoomin",type:"action"},{name:_("Zoom out"),id:"zoomout",type:"action"},{name:_("Reset zoom"),id:"zoomreset",type:"action"}]},{name:_("Insert"),type:"menu",menu:[{name:_("Image"),id:"insertgraphic",type:"action"},{type:"separator"},{name:_("Special character..."),id:"specialcharacter",type:"action"}]},{name:_("Tables"),type:"menu",menu:[{name:_("Insert"),type:"menu",menu:[{name:_("Rows before"),type:"unocommand",uno:".uno:InsertRowsBefore"},{name:_("Rows after"),type:"unocommand",uno:".uno:InsertRowsAfter"},{type:"separator"},{name:_("Columns left"),type:"unocommand",uno:".uno:InsertColumnsBefore"},{name:_("Columns right"),type:"unocommand",uno:".uno:InsertColumnsAfter"}]},{name:_("Delete"),type:"menu",menu:[{name:_("Rows"),type:"unocommand",uno:".uno:DeleteRows"},{name:_("Columns"),type:"unocommand",uno:".uno:DeleteColumns"}]},{name:_("Merge cells"),type:"unocommand",uno:".uno:MergeCells"}]},{name:_("Slide"),type:"menu",menu:[{name:_("New slide"),id:"insertpage",type:"action"},{name:_("Duplicate slide"),id:"duplicatepage",type:"action"},{name:_("Delete slide"),id:"deletepage",type:"action"},{type:"separator"},{name:_("Fullscreen presentation"),id:"fullscreen-presentation",type:"action"}]},{name:_("Help"),id:"help",type:"menu",menu:[{name:_("Keyboard shortcuts"),id:"keyboard-shortcuts",type:"action"},{name:_("About"),id:"about",type:"action"}]},{name:_("Close document"),id:"closedocument",type:"action"}],spreadsheet:[{name:_("File"),id:"file",type:"menu",menu:[{name:_("Save"),id:"save",type:"unocommand",uno:".uno:Save"},{name:_("Print"),id:"print",type:"action"},{name:_("See revision history"),id:"rev-history",type:"action"},{name:_("Download as"),id:"downloadas",type:"menu",menu:[{name:_("PDF Document (.pdf)"),id:"downloadas-pdf",type:"action"},{name:_("ODF spreadsheet (.ods)"),id:"downloadas-ods",type:"action"},{name:_("Microsoft Excel 2003 (.xls)"),id:"downloadas-xls",type:"action"},{name:_("Microsoft Excel (.xlsx)"),id:"downloadas-xlsx",type:"action"}]}]},{name:_("Edit"),type:"menu",menu:[{name:_("Undo"),type:"unocommand",uno:".uno:Undo"},{name:_("Redo"),type:"unocommand",uno:".uno:Redo"},{type:"separator"},{name:_("Cut"),type:"unocommand",uno:".uno:Cut"},{name:_("Copy"),type:"unocommand",uno:".uno:Copy"},{name:_("Paste"),type:"unocommand",uno:".uno:Paste"},{type:"separator"},{name:_("Select all"),type:"unocommand",uno:".uno:SelectAll"}]},{name:_("View"),id:"view",type:"menu",menu:[{name:_("Full screen"),id:"fullscreen",type:"action"}]},{name:_("Insert"),type:"menu",menu:[{name:_("Image"),id:"insertgraphic",type:"action"},{name:_("Comment"),type:"unocommand",uno:".uno:InsertAnnotation"},{type:"separator"},{name:_("Row"),type:"unocommand",uno:".uno:InsertRows"},{name:_("Column"),type:"unocommand",uno:".uno:InsertColumns"},{type:"separator"},{name:_("Special character..."),id:"specialcharacter",type:"action"}]},{name:_("Cells"),type:"menu",menu:[{name:_("Insert row"),type:"unocommand",uno:".uno:InsertRows"},{name:_("Insert column"),type:"unocommand",uno:".uno:InsertColumns"},{type:"separator"},{name:_("Delete row"),type:"unocommand",uno:".uno:DeleteRows"},{name:_("Delete column"),type:"unocommand",uno:".uno:DeleteColumns"}]},{name:_("Help"),id:"help",type:"menu",menu:[{name:_("Keyboard shortcuts"),id:"keyboard-shortcuts",type:"action"},{name:_("About"),id:"about",type:"action"}]},{name:_("Close document"),id:"closedocument",type:"action"}],commandStates:{},allowedReadonlyMenus:["file","downloadas","view","help"],allowedViewModeActions:["downloadas-pdf","downloadas-odt","downloadas-doc","downloadas-docx","downloadas-odp","downloadas-ppt","downloadas-pptx","downloadas-ods","downloadas-xls","downloadas-xlsx","fullscreen","zoomin","zoomout","zoomreset","about","keyboard-shortcuts"]},onAdd:function(t){this._initialized=!1,this._menubarCont=s.DomUtil.get("main-menu"),t.on("doclayerinit",this._onDocLayerInit,this),t.on("commandstatechanged",this._onCommandStateChanged,this)},_onCommandStateChanged:function(t){("enabled"===t.state||"disabled"===t.state)&&(this.options.commandStates[t.commandName]=t.state)},_onDocLayerInit:function(){var e=this._map.getDocType();"text"===e?this._initializeMenu(this.options.text):"spreadsheet"===e?this._initializeMenu(this.options.spreadsheet):("presentation"===e||"drawing"===e)&&this._initializeMenu(this.options.presentation),$("#main-menu").smartmenus({hideOnClick:!0,showOnClick:!0,hideTimeout:0,hideDuration:0,showDuration:0,showTimeout:0,collapsibleHideDuration:0,subIndicatorsPos:"append",subIndicatorsText:"&#8250;"}),$("#main-menu").attr("tabindex",0),$("#main-menu").bind("select.smapi",{self:this},this._onItemSelected),$("#main-menu").bind("beforeshow.smapi",{self:this},this._beforeShow),$("#main-menu").bind("click.smapi",{self:this},this._onClicked),$(function(){var e=$("#main-menu-state");e.length&&(e.change(function(t){var e=$("#main-menu");this.checked?e.hide().slideDown(250,function(){e.css("display","")}):e.show().slideUp(250,function(){e.css("display","")})}),$(t).bind("beforeunload unload",function(){e[0].checked&&e[0].click()}))}),this._initialized=!0},_onClicked:function(t,e){$(e).hasClass("highlighted")&&$("#main-menu").smartmenus("menuHideAll")},_beforeShow:function(e,i){var n=e.data.self,s=$(i).children().children("a").not(".has-submenu"),o=t.navigator.userAgent,a=o.indexOf("MSIE "),r=o.indexOf("Trident/"),l=o.indexOf("Edge/");$(s).each(function(){var t=this,e=$(t).data("type"),i=$(t).data("id");if("edit"===map._permission){if("unocommand"===e){var s=$(t).data("uno");"disabled"===n.options.commandStates[s]?$(t).addClass("disabled"):$(t).removeClass("disabled")}else if("action"===e)if("fullscreen"===i&&(a>0||r>0||l>0)){$(t).addClass("disabled");var o=n.options.allowedViewModeActions.indexOf("fullscreen");o>0&&n.options.allowedViewModeActions.splice(o,1)}else $(t).removeClass("disabled")}else if("unocommand"===e)$(t).addClass("disabled");else if("action"===e){var h=!1;for(var d in n.options.allowedViewModeActions)if(n.options.allowedViewModeActions[d]===i){h=!0;break}h?$(t).removeClass("disabled"):$(t).addClass("disabled")}})},_executeAction:function(t){if("print"===t)map.print();else if(t.startsWith("downloadas-")){var i=t.substring("downloadas-".length),n=title.substr(0,title.lastIndexOf("."))||title;
n=""===n?"document":n,map.downloadAs(n+"."+i,i)}else if("insertgraphic"===t)s.DomUtil.get("insertgraphic").click();else if("specialcharacter"===t){var o=$(".fonts-select option"),a=$(".fonts-select").prop("selectedIndex");map._docLayer._onSpecialChar(o,a)}else"zoomin"===t&&map.getZoom()<map.getMaxZoom()?map.zoomIn(1):"zoomout"===t&&map.getZoom()>map.getMinZoom()?map.zoomOut(1):"zoomreset"===t?map.setZoom(map.options.zoom):"fullscreen"===t?e.fullscreenElement||e.mozFullscreenElement||e.msFullscreenElement||e.webkitFullscreenElement?e.exitFullscreen?e.exitFullscreen():e.msExitFullscreen?e.msExitFullscreen():e.mozCancelFullScreen?e.mozCancelFullScreen():e.webkitExitFullscreen&&e.webkitExitFullscreen():e.documentElement.requestFullscreen?e.documentElement.requestFullscreen():e.documentElement.msRequestFullscreen?e.documentElement.msRequestFullscreen():e.documentElement.mozRequestFullScreen?e.documentElement.mozRequestFullScreen():e.documentElement.webkitRequestFullscreen&&e.documentElement.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT):"fullscreen-presentation"===t&&"presentation"===map.getDocType()?map.fire("fullscreen"):"insertpage"===t?map.insertPage():"duplicatepage"===t?map.duplicatePage():"deletepage"===t?vex.dialog.confirm({message:_("Are you sure you want to delete this slide?"),callback:this._onDeleteSlide},this):"about"===t?map.showLOAboutDialog():"keyboard-shortcuts"===t?map.showLOKeyboardHelp():"rev-history"===t?map.fire("postMessage",{msgId:"rev-history"}):"closedocument"===t?(map.fire("postMessage",{msgId:"UI_Close",args:{EverModified:map._everModified}}),map.remove()):"repair"===t?map._socket.sendMessage("commandvalues command=.uno:DocumentRepair"):"a4portrait"===t?(map.sendUnoCommand('.uno:AttributePageSize {"AttributePageSize.Width":{"type":"long", "value": "21000"},"AttributePageSize.Height":{"type":"long", "value": "29700"}}'),map.sendUnoCommand('.uno:AttributePage {"AttributePage.Landscape":{"type":"boolean", "value": "false"}}')):"a4landscape"===t?(map.sendUnoCommand('.uno:AttributePageSize {"AttributePageSize.Height":{"type":"long", "value": "21000"},"AttributePageSize.Width":{"type":"long", "value": "29700"}}'),map.sendUnoCommand('.uno:AttributePage {"AttributePage.Landscape":{"type":"boolean", "value": "true"}}')):"a5portrait"===t?(map.sendUnoCommand('.uno:AttributePageSize {"AttributePageSize.Width":{"type":"long", "value": "14800"},"AttributePageSize.Height":{"type":"long", "value": "21000"}}'),map.sendUnoCommand('.uno:AttributePage {"AttributePage.Landscape":{"type":"boolean", "value": "false"}}')):"a5landscape"===t?(map.sendUnoCommand('.uno:AttributePageSize {"AttributePageSize.Height":{"type":"long", "value": "14800"},"AttributePageSize.Width":{"type":"long", "value": "21000"}}'),map.sendUnoCommand('.uno:AttributePage {"AttributePage.Landscape":{"type":"boolean", "value": "true"}}')):"letterportrait"===t?(map.sendUnoCommand('.uno:AttributePageSize {"AttributePageSize.Width":{"type":"long", "value": "21950"},"AttributePageSize.Height":{"type":"long", "value": "27940"}}'),map.sendUnoCommand('.uno:AttributePage {"AttributePage.Landscape":{"type":"boolean", "value": "false"}}')):"letterlandscape"===t?(map.sendUnoCommand('.uno:AttributePageSize {"AttributePageSize.Height":{"type":"long", "value": "21950"},"AttributePageSize.Width":{"type":"long", "value": "27940"}}'),map.sendUnoCommand('.uno:AttributePage {"AttributePage.Landscape":{"type":"boolean", "value": "true"}}')):"legalportrait"===t?(map.sendUnoCommand('.uno:AttributePageSize {"AttributePageSize.Width":{"type":"long", "value": "21590"},"AttributePageSize.Height":{"type":"long", "value": "35560"}}'),map.sendUnoCommand('.uno:AttributePage {"AttributePage.Landscape":{"type":"boolean", "value": "false"}}')):"legallandscape"===t&&(map.sendUnoCommand('.uno:AttributePageSize {"AttributePageSize.Height":{"type":"long", "value": "21590"},"AttributePageSize.Width":{"type":"long", "value": "35560"}}'),map.sendUnoCommand('.uno:AttributePage {"AttributePage.Landscape":{"type":"boolean", "value": "true"}}'))},_onDeleteSlide:function(t){t&&map.deletePage()},_onItemSelected:function(t,e){var i=t.data.self,n=$(e).data("type");if("unocommand"===n){var s=$(e).data("uno");map.sendUnoCommand(s)}else if("action"===n){var o=$(e).data("id");i._executeAction(o)}map.focus()},_createMenu:function(t){var e=[];for(var i in t){if("readonly"===map._permission&&"menu"===t[i].type){var n=!1;for(var o in this.options.allowedReadonlyMenus)if(this.options.allowedReadonlyMenus[o]===t[i].id){n=!0;break}if(!n)continue}if(("action"!==t[i].type||("rev-history"!==t[i].id||revHistoryEnabled)&&("closedocument"!==t[i].id||closebutton))&&!("print"===t[i].id&&this._map.wopi.HidePrintOption||"save"===t[i].id&&this._map.wopi.HideSaveOption)){if(t[i].id&&t[i].id.startsWith("downloadas-")){var a=t[i].id.substring("downloadas-".length);if(this._map._docLayer.registerExportFormat(t[i].name,a),this._map.wopi.HideExportOption)continue}var r=s.DomUtil.create("li","");t[i].id&&(r.id="menu-"+t[i].id,"closedocument"===t[i].id&&"readonly"===map._permission&&s.DomUtil.addClass(r,"readonly"));var l=s.DomUtil.create("a","",r);if(l.innerHTML=t[i].name,"menu"===t[i].type){var h=s.DomUtil.create("ul","",r),d=this._createMenu(t[i].menu);if(!d.length)continue;for(var o in d)h.appendChild(d[o])}else"unocommand"===t[i].type?($(l).data("type","unocommand"),$(l).data("uno",t[i].uno)):"separator"===t[i].type?$(l).addClass("separator"):"action"===t[i].type&&($(l).data("type","action"),$(l).data("id",t[i].id));e.push(r)}}return e},_initializeMenu:function(t){var e=this._createMenu(t);for(var i in e)this._menubarCont.appendChild(e[i])}}),s.control.menubar=function(t){return new s.Control.Menubar(t)},s.Control.Tabs=s.Control.extend({onAdd:function(t){t.on("updatepermission",this._onUpdatePermission,this),this._initialized=!1},_onUpdatePermission:function(t){"spreadsheet"===this._map.getDocType()&&(this._initialized||this._initialize(),setTimeout(function(){$(".spreadsheet-tab").contextMenu("edit"===t.perm)},1e3))},_initialize:function(){this._initialized=!0,this._tabsInitialized=!1,this._spreadsheetTabs={};var t=map.options.documentContainer;this._tabsCont=s.DomUtil.create("div","spreadsheet-tabs-container",t.parentElement),$.contextMenu({selector:".spreadsheet-tab",className:"loleaflet-font",callback:function(t,e){var i=parseInt(e.$trigger.attr("id").split("spreadsheet-tab")[1]);"insertsheetbefore"===t&&map.insertPage(i),"insertsheetafter"===t&&map.insertPage(i+1)},items:{insertsheetbefore:{name:_("Insert sheet before this")},insertsheetafter:{name:_("Insert sheet after this")},deletesheet:{name:_("Delete sheet"),callback:function(t,e){var i=parseInt(e.$trigger.attr("id").split("spreadsheet-tab")[1]);vex.dialog.confirm({message:_("Are you sure you want to delete sheet, %sheet% ?").replace("%sheet%",e.$trigger.text()),callback:function(t){t&&map.deletePage(i)}})}},renamesheet:{name:_("Rename sheet"),callback:function(t,e){var i=parseInt(e.$trigger.attr("id").split("spreadsheet-tab")[1]);vex.dialog.open({message:_("Enter new sheet name"),input:'<input name="sheetname" type="text" required />',callback:function(t){map.renamePage(t.sheetname,i)}})}}},zIndex:1e3}),map.on("updateparts",this._updateDisabled,this)},_updateDisabled:function(t){var e=t.parts,i=t.selectedPart,n=t.docType;if("text"!==n&&"spreadsheet"===n){if(!this._tabsInitialized){var o=this._map.options.documentContainer;s.DomUtil.addClass(o,"spreadsheet-document"),setTimeout(s.bind(function(){this._map.invalidateSize(),$(".scroll-container").mCustomScrollbar("update"),$(".scroll-container").mCustomScrollbar("scrollTo",[0,0])},this),100),this._tabsInitialized=!0}if("partNames"in t){for(;this._tabsCont.firstChild;)this._tabsCont.removeChild(this._tabsCont.firstChild);var a=s.DomUtil.create("div","spreadsheet-tab-scroll",this._tabsCont);a.id="spreadsheet-tab-scroll";for(var r=0;e>r;r++){var l="spreadsheet-tab"+r,h=s.DomUtil.create("div","spreadsheet-tab",a);h.innerHTML=t.partNames[r],h.id=l,s.DomEvent.on(h,"click",s.DomEvent.stopPropagation).on(h,"click",s.DomEvent.stop).on(h,"click",this._setPart,this).on(h,"click",this._refocusOnMap,this),this._spreadsheetTabs[l]=h}}for(var d in this._spreadsheetTabs){var u=parseInt(d.match(/\d+/g)[0]);s.DomUtil.removeClass(this._spreadsheetTabs[d],"spreadsheet-tab-selected"),u===i&&s.DomUtil.addClass(this._spreadsheetTabs[d],"spreadsheet-tab-selected")}}},_setPart:function(t){var e=t.target.id.match(/\d+/g)[0];null!==e&&this._map.setPart(parseInt(e))}}),s.control.tabs=function(t){return new s.Control.Tabs(t)},s.Control.PermissionSwitch=s.Control.extend({options:{position:"topleft"},onAdd:function(t){var i="leaflet-control-editviewswitch",n=s.DomUtil.create("label",i+" leaflet-bar");return this._checkBox=s.DomUtil.create("input","editview-cb",n),this._checkBox.type="checkbox",s.DomEvent.on(this._checkBox,"change",this._onChange,this),t.on("updatepermission",this._onUpdatePermission,this),n.appendChild(e.createTextNode("Enable editing")),n},_onChange:function(){this._checkBox.checked?this._map.setPermission("edit"):this._map.setPermission("view"),this._refocusOnMap()},_onUpdatePermission:function(t){"edit"===t.perm?(this._checkBox.checked=!0,this._checkBox.disabled=!1):"view"===t.perm?(this._checkBox.checked=!1,this._checkBox.disabled=!1):"readonly"===t.perm&&(this._checkBox.checked=!1,this._checkBox.disabled=!0)}}),s.control.permissionSwitch=function(t){return new s.Control.PermissionSwitch(t)},s.Control.Selection=s.Control.extend({options:{position:"topleft"},onAdd:function(t){var i="leaflet-control-editviewswitch",n=s.DomUtil.create("label",i+" leaflet-bar");return this._checkBox=s.DomUtil.create("input","editview-cb",n),this._checkBox.type="checkbox",s.DomEvent.on(this._checkBox,"change",this._onChange,this),t.on("updatepermission",this._onUpdatePermission,this),n.appendChild(e.createTextNode("Enable Selection")),n},_onChange:function(){this._checkBox.checked?this._map.enableSelection():this._map.disableSelection(),this._refocusOnMap()},_onUpdatePermission:function(t){"edit"===t.perm?(this._checkBox.checked=!1,this._checkBox.disabled=!0):"view"===t.perm?(this._checkBox.checked=!1,this._checkBox.disabled=!1):"readonly"===t.perm&&(this._checkBox.checked=!1,this._checkBox.disabled=!1)}}),s.control.selection=function(t){return new s.Control.Selection(t)},s.Control.Scroll=s.Control.extend({onAdd:function(t){this._scrollContainer=s.DomUtil.create("div","scroll-container",t._container.parentElement),this._mockDoc=s.DomUtil.create("div","",this._scrollContainer),this._mockDoc.id="mock-doc",t.on("scrollto",this._onScrollTo,this),t.on("scrollby",this._onScrollBy,this),t.on("scrollvelocity",this._onScrollVelocity,this),t.on("handleautoscroll",this._onHandleAutoScroll,this),t.on("docsize",this._onUpdateSize,this),t.on("updatescrolloffset",this._onUpdateScrollOffset,this);var e=this;$(".scroll-container").mCustomScrollbar({axis:"yx",theme:"dark-thick",scrollInertia:0,callbacks:{onScroll:function(){e._onScrollEnd(this)},whileScrolling:function(){e._onScroll(this)},alwaysTriggerOffsets:!1}})},_onScroll:function(t){if(this._map._enabled){if(this._ignoreScroll)return void(this._ignoreScroll=null);this._prevScrollY===i&&(this._prevScrollY=0),this._prevScrollX===i&&(this._prevScrollX=0);var e=new s.Point(-t.mcs.left-this._prevScrollX,-t.mcs.top-this._prevScrollY);e.equals(new s.Point(0,0))||(this._prevScrollY=-t.mcs.top,this._prevScrollX=-t.mcs.left,this._map.scroll(e.x,e.y),this._map.fire("scrolloffset",e))}},_onScrollEnd:function(t){this._prevScrollY=-t.mcs.top,this._prevScrollX=-t.mcs.left},_onScrollTo:function(t){$(".scroll-container").mCustomScrollbar("scrollTo",[t.y,t.x])},_onScrollBy:function(t){t.y*=-1;var e="+="+t.y;t.y<0&&(e="-="+Math.abs(t.y)),t.x*=-1;var i="+="+t.x;t.x<0&&(i="-="+Math.abs(t.x)),$(".scroll-container").mCustomScrollbar("scrollTo",[e,i])},_onScrollVelocity:function(t){0===t.vx&&0===t.vy?(clearInterval(this._autoScrollTimer),this._autoScrollTimer=null,this._map.isAutoScrolling=!1):(clearInterval(this._autoScrollTimer),this._map.isAutoScrolling=!0,this._autoScrollTimer=setInterval(s.bind(function(){this._onScrollBy({x:t.vx,y:t.vy})},this),100))},_onHandleAutoScroll:function(t){var e=0,i=0;t.pos.y>t.map._size.y-50?i=50:t.pos.y<50&&(i=-50),t.pos.x>t.map._size.x-50?e=50:t.pos.x<50&&(e=-50),this._onScrollVelocity({vx:e,vy:i})},_onUpdateSize:function(t){var e=Math.ceil(parseFloat(s.DomUtil.getStyle(this._mockDoc,"width"))),i=Math.ceil(parseFloat(s.DomUtil.getStyle(this._mockDoc,"height"))),n=Math.ceil(t.x),o=Math.ceil(t.y);"text"===this._map.getDocType()&&i>o&&(this._ignoreScroll=!0),s.DomUtil.setStyle(this._mockDoc,"width",t.x+"px"),s.DomUtil.setStyle(this._mockDoc,"height",t.y+"px"),e!==n&&i===o&&$(".scroll-container").mCustomScrollbar("update")},_onUpdateScrollOffset:function(t){this._ignoreScroll=null,$(".scroll-container").mCustomScrollbar("stop"),this._prevScrollY=t.y,this._prevScrollX=t.x,$(".scroll-container").mCustomScrollbar("scrollTo",[t.y,t.x],{callbacks:!1,timeout:0})}}),s.control.scroll=function(t){return new s.Control.Scroll(t)},s.Control.Dialog=s.Control.extend({onAdd:function(t){t.on("error",this._onError,this),t.on("warn",this._onError,this),t.on("print",this._onPrint,this)},_onError:function(t){if(vex.dialogID>0&&!this._map._fatal&&vex.close(vex.dialogID),t.msg)vex.dialog.alert(t.msg);else if(t.cmd&&t.kind){var e="The server encountered a '"+t.kind+"' error while parsing the '"+t.cmd+"' command.";vex.dialog.alert(e)}vex.dialogID=vex.globalID-1},_onPrint:function(t){var e=t.url;vex.dialog.confirm({message:"Download PDF export?",callback:s.bind(function(t){t&&(this._map._fileDownloader.src=e)},this)})}}),s.control.dialog=function(t){return new s.Control.Dialog(t)},s.Control.Attribution=s.Control.extend({options:{position:"bottomright",prefix:'<a href="http://leafletjs.com" title="A JS library for interactive maps">Leaflet</a>'},initialize:function(t){s.setOptions(this,t)},onAdd:function(t){return this._container||(this._container=s.DomUtil.create("div","leaflet-control-attribution"),s.DomEvent.disableClickPropagation(this._container)),this._update(),this._container},setPrefix:function(t){return this.options.prefix=t,this._update(),this},_update:function(){this._map&&(this._container.innerHTML=this.options.prefix)}}),s.control.attribution=function(t){return new s.Control.Attribution(t)},s.Control.Scale=s.Control.extend({options:{position:"bottomleft",maxWidth:100,metric:!0,imperial:!0},onAdd:function(t){var e="leaflet-control-scale",i=s.DomUtil.create("div",e),n=this.options;return this._addScales(n,e+"-line",i),t.on(n.updateWhenIdle?"moveend":"move",this._update,this),t.whenReady(this._update,this),i},onRemove:function(t){t.off(this.options.updateWhenIdle?"moveend":"move",this._update,this)},_addScales:function(t,e,i){t.metric&&(this._mScale=s.DomUtil.create("div",e,i)),t.imperial&&(this._iScale=s.DomUtil.create("div",e,i))},_update:function(){var t=this._map,e=t.getSize().y/2,i=s.CRS.Earth.distance(t.containerPointToLatLng([0,e]),t.containerPointToLatLng([this.options.maxWidth,e]));this._updateScales(i)},_updateScales:function(t){this.options.metric&&t&&this._updateMetric(t),this.options.imperial&&t&&this._updateImperial(t)},_updateMetric:function(t){var e=this._getRoundNum(t),i=1e3>e?e+" m":e/1e3+" km";this._updateScale(this._mScale,i,e/t)},_updateImperial:function(t){var e,i,n,s=3.2808399*t;s>5280?(e=s/5280,i=this._getRoundNum(e),this._updateScale(this._iScale,i+" mi",i/e)):(n=this._getRoundNum(s),this._updateScale(this._iScale,n+" ft",n/s))},_updateScale:function(t,e,i){t.style.width=Math.round(this.options.maxWidth*i)+"px",t.innerHTML=e},_getRoundNum:function(t){var e=Math.pow(10,(Math.floor(t)+"").length-1),i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:1,e*i}}),s.control.scale=function(t){return new s.Control.Scale(t)},s.Control.Layers=s.Control.extend({options:{collapsed:!0,position:"topright",autoZIndex:!0,hideSingleBase:!1},initialize:function(t,e,i){s.setOptions(this,i),this._layers={},this._lastZIndex=0,this._handlingClick=!1;for(var n in t)this._addLayer(t[n],n);for(n in e)this._addLayer(e[n],n,!0)},onAdd:function(){return this._initLayout(),this._update(),this._container},addBaseLayer:function(t,e){return this._addLayer(t,e),this._update()},addOverlay:function(t,e){return this._addLayer(t,e,!0),this._update()},removeLayer:function(t){return t.off("add remove",this._onLayerChange,this),delete this._layers[s.stamp(t)],this._update()},_initLayout:function(){var t="leaflet-control-layers",e=this._container=s.DomUtil.create("div",t);e.setAttribute("aria-haspopup",!0),s.Browser.touch?s.DomEvent.on(e,"click",s.DomEvent.stopPropagation):s.DomEvent.disableClickPropagation(e).disableScrollPropagation(e);var i=this._form=s.DomUtil.create("form",t+"-list");if(this.options.collapsed){s.Browser.android||s.DomEvent.on(e,{mouseenter:this._expand,mouseleave:this._collapse},this);var n=this._layersLink=s.DomUtil.create("a",t+"-toggle",e);n.href="#",n.title="Layers",s.Browser.touch?s.DomEvent.on(n,"click",s.DomEvent.stop).on(n,"click",this._expand,this):s.DomEvent.on(n,"focus",this._expand,this),s.DomEvent.on(i,"click",function(){setTimeout(s.bind(this._onInputClick,this),0)},this),this._map.on("click",this._collapse,this)}else this._expand();this._baseLayersList=s.DomUtil.create("div",t+"-base",i),this._separator=s.DomUtil.create("div",t+"-separator",i),this._overlaysList=s.DomUtil.create("div",t+"-overlays",i),e.appendChild(i)},_addLayer:function(t,e,i){t.on("add remove",this._onLayerChange,this);var n=s.stamp(t);this._layers[n]={layer:t,name:e,overlay:i},this.options.autoZIndex&&t.setZIndex&&(this._lastZIndex++,t.setZIndex(this._lastZIndex))},_update:function(){if(!this._container)return this;s.DomUtil.empty(this._baseLayersList),s.DomUtil.empty(this._overlaysList);var t,e,i,n,o=0;for(i in this._layers)n=this._layers[i],this._addItem(n),e=e||n.overlay,t=t||!n.overlay,o+=n.overlay?0:1;return this.options.hideSingleBase&&(t=t&&o>1,this._baseLayersList.style.display=t?"":"none"),this._separator.style.display=e&&t?"":"none",this},_onLayerChange:function(t){this._handlingClick||this._update();var e=this._layers[s.stamp(t.target)].overlay,i=e?"add"===t.type?"overlayadd":"overlayremove":"add"===t.type?"baselayerchange":null;i&&this._map.fire(i,t.target)},_createRadioElement:function(t,i){var n='<input type="radio" class="leaflet-control-layers-selector" name="'+t+'"'+(i?' checked="checked"':"")+"/>",s=e.createElement("div");return s.innerHTML=n,s.firstChild},_addItem:function(t){var i,n=e.createElement("label"),o=this._map.hasLayer(t.layer);t.overlay?(i=e.createElement("input"),i.type="checkbox",i.className="leaflet-control-layers-selector",i.defaultChecked=o):i=this._createRadioElement("leaflet-base-layers",o),i.layerId=s.stamp(t.layer),s.DomEvent.on(i,"click",this._onInputClick,this);var a=e.createElement("span");a.innerHTML=" "+t.name,n.appendChild(i),n.appendChild(a);var r=t.overlay?this._overlaysList:this._baseLayersList;return r.appendChild(n),n},_onInputClick:function(){var t,e,i,n=this._form.getElementsByTagName("input"),s=[],o=[];this._handlingClick=!0;for(var a=0,r=n.length;r>a;a++)t=n[a],e=this._layers[t.layerId].layer,i=this._map.hasLayer(e),t.checked&&!i?s.push(e):!t.checked&&i&&o.push(e);for(a=0;a<o.length;a++)this._map.removeLayer(o[a]);for(a=0;a<s.length;a++)this._map.addLayer(s[a]);this._handlingClick=!1,this._refocusOnMap()},_expand:function(){s.DomUtil.addClass(this._container,"leaflet-control-layers-expanded")},_collapse:function(){s.DomUtil.removeClass(this._container,"leaflet-control-layers-expanded")}}),s.control.layers=function(t,e,i){return new s.Control.Layers(t,e,i)},s.Map.include({search:function(t,e,n){e===i&&(e=!1),n===i&&(n=0),this._docLayer._searchResults&&t!==this._docLayer._searchTerm&&this._docLayer._clearSearchResults();var o={"SearchItem.SearchString":{type:"string"},"SearchItem.Backward":{type:"boolean"}};this.fire("clearselection");var a=this.project(this.getBounds().getNorthWest()),r=this.project(this.options.maxBounds.getNorthWest()),l=this.unproject(new s.Point(Math.max(a.x,r.x),Math.max(a.y,r.y))),h=this._docLayer._latLngToTwips(l);o["SearchItem.SearchString"].value=t,o["SearchItem.Backward"].value=e,o["SearchItem.SearchStartPointX"]={},o["SearchItem.SearchStartPointX"].type="long",o["SearchItem.SearchStartPointX"].value=h.x,o["SearchItem.SearchStartPointY"]={},o["SearchItem.SearchStartPointY"].type="long",o["SearchItem.SearchStartPointY"].value=h.y,o["SearchItem.Command"]={},o["SearchItem.Command"].type="long",o["SearchItem.Command"].value=n,this._socket.sendMessage("uno .uno:ExecuteSearch "+JSON.stringify(o))},highlightAll:function(t){this._docLayer._searchResults&&t===this._docLayer._searchTerm||this.search(t,!1,1)},resetSelection:function(){this._docLayer._clearSearchResults(),this._socket.sendMessage("resetselection")}}),s.Map.include({setPermission:function(t){this._permission=t,"edit"===t?(this._socket.sendMessage("requestloksession"),s.Browser.touch||this.dragging.disable()):("view"===t||"readonly"===t)&&(this.dragging.enable(),this._docLayer._onUpdateCursor(),this._docLayer._clearSelections(),this._docLayer._onUpdateTextSelection()),this.fire("updatepermission",{perm:t})},enableSelection:function(){"edit"!==this._permission&&(this._socket.sendMessage("requestloksession"),this.dragging.disable())},disableSelection:function(){"edit"!==this._permission&&this.dragging.enable()},isSelectionEnabled:function(){return!this.dragging.enabled()},getPermission:function(){return this._permission}}),s.Map.include({unoToolbarCommands:[".uno:StyleApply",".uno:CharFontName"],_modalDialogOptions:{overlayClose:!0,opacity:80,overlayCss:{backgroundColor:"#000"},containerCss:{overflow:"hidden",backgroundColor:"#fff",padding:"20px",border:"2px solid #000"}},applyFont:function(t){if("edit"===this.getPermission()){var e='uno .uno:CharFontName {"CharFontName.FamilyName": {"type": "string", "value": "'+t+'"}}';this._socket.sendMessage(e)}},applyFontSize:function(t){if("edit"===this.getPermission()){var e='uno .uno:FontHeight {"FontHeight.Height": {"type": "float", "value": "'+t+'"}}';this._socket.sendMessage(e)}},getToolbarCommandValues:function(t){return this._docLayer?this._docLayer._toolbarCommandValues[t]:i},downloadAs:function(t,e,n,s){if(!this._fatal){if(s=s||"export","print"===s&&this.wopi.DisablePrint||"export"===s&&this.wopi.DisableExport)return void this.hideBusy();(e===i||null===e)&&(e=""),(n===i||null===n)&&(n=""),this.showBusy(_("Downloading..."),!1),this._socket.sendMessage("downloadas name="+t+" id="+s+" format="+e+" options="+n)}},print:function(){this.showBusy(_("Downloading..."),!1),this.downloadAs("print.pdf","pdf",null,"print")},saveAs:function(t,e,n){(e===i||null===e)&&(e=""),(n===i||null===n)&&(n=""),this.showBusy(_("Saving..."),!1),this._socket.sendMessage("saveas url="+t+" format="+e+" options=TakeOwnership,"+n)},applyStyle:function(t,e){if(!t||!e)return void this.fire("error",{cmd:"setStyle",kind:"incorrectparam"});if("edit"===this._permission){var i='uno .uno:StyleApply {"Style":{"type":"string", "value": "'+t+'"},"FamilyName":{"type":"string", "value":"'+e+'"}}';this._socket.sendMessage(i)}},applyLayout:function(t){if(!t)return void this.fire("error",{cmd:"setLayout",kind:"incorrectparam"});if("edit"===this._permission){var e='uno .uno:AssignLayout {"WhatPage":{"type":"unsigned short", "value": "'+this.getCurrentPartNumber()+'"},"WhatLayout":{"type":"unsigned short", "value": "'+t+'"}}';this._socket.sendMessage(e)}},save:function(t,e){var i={DontTerminateEdit:{type:"boolean",value:!!t},DontSaveIfUnmodified:{type:"boolean",value:!!e}};this.sendUnoCommand(".uno:Save",i)},sendUnoCommand:function(t,e){"edit"===this._permission&&this._socket.sendMessage("uno "+t+(e?" "+JSON.stringify(e):""))},toggleCommandState:function(t){"edit"===this._permission&&(t.startsWith(".uno:")||(t=".uno:"+t),this.sendUnoCommand(t))},insertFile:function(t){this.fire("insertfile",{file:t})},cellEnterString:function(t){var e={StringName:{type:"string",value:t},DontCommit:{type:"boolean",value:!0}};this.sendUnoCommand(".uno:EnterString ",e)},renderFont:function(e){this._socket.sendMessage("renderfont font="+t.encodeURIComponent(e))},showLOKeyboardHelp:function(){var i=t.innerWidth/2;$.get("/loleaflet/dist/loleaflet-help.html",function(t){vex.open({content:t,showCloseButton:!0,escapeButtonCloses:!0,overlayClosesOnClick:!0,contentCSS:{width:i+"px"},buttons:{},afterOpen:function(t){"text"===map.getDocType()?e.getElementById("text-shortcuts").style.display="block":"spreadsheet"===map.getDocType()?e.getElementById("spreadsheet-shortcuts").style.display="block":("presentation"===map.getDocType()||"drawing"===map.getDocType())&&(e.getElementById("presentation-shortcuts").style.display="block");var i,n,s=t.find("h1");for(i=0,n=s.length;n>i;i++)s[i].firstChild.nodeValue=s[i].firstChild.nodeValue.toLocaleString();for(s=t.find("h2"),i=0,n=s.length;n>i;i++)s[i].firstChild.nodeValue=s[i].firstChild.nodeValue.toLocaleString();for(s=t.find("td"),i=0,n=s.length;n>i;i++)s[i].firstChild.nodeValue=s[i].firstChild.nodeValue.toLocaleString();$(".vex-content").attr("tabindex",-1),$(".vex-content").focus(),$(".vex-overlay").css({"pointer-events":"none"}),$(".vex").click(function(){vex.close(t.data().vex.id)}),$(".vex-content").click(function(t){t.stopPropagation()})},beforeClose:function(){map.focus()}})})},showLOAboutDialog:function(){var e=$("#about-dialog").clone().css({display:"block"}),i="undefined"!=typeof brandProductName?brandProductName:"LibreOffice Online";e.find("#product-name").text(i);var n=_("This version of %productName is powered by");e.find("#product-string").text(n.replace("%productName",i));var s=t.innerWidth/2;vex.open({content:e,showCloseButton:!0,escapeButtonCloses:!0,overlayClosesOnClick:!0,contentCSS:{width:s+"px"},buttons:{},afterOpen:function(t){map.enable(!1),$(".vex-overlay").css({"pointer-events":"none"}),$(".vex").click(function(){vex.close(t.data().vex.id)}),$(".vex-content").click(function(t){t.stopPropagation()})},beforeClose:function(){map.enable(!0)}})}}),s.Map.include({setPart:function(t){var e=this._docLayer;if(e._prevSelectedPart=e._selectedPart,"prev"===t)e._selectedPart>0&&(e._selectedPart-=1);else if("next"===t)e._selectedPart<e._parts-1&&(e._selectedPart+=1);else{if(!("number"==typeof t&&t>=0&&t<e._parts))return;e._selectedPart=t}e._isCursorOverlayVisible&&this._socket.sendMessage("resetselection"),this.fire("updateparts",{selectedPart:e._selectedPart,parts:e._parts,docType:e._docType}),this._socket.sendMessage("setclientpart part="+e._selectedPart),e.eachView(e._viewCursors,e._onUpdateViewCursor,e),e.eachView(e._cellViewCursors,e._onUpdateCellViewCursor,e),e.eachView(e._graphicViewMarkers,e._onUpdateGraphicViewSelection,e),e.eachView(e._viewSelections,e._onUpdateTextViewSelection,e),e._clearSelections(),e._updateOnChangePart(),e._pruneTiles(),e._prevSelectedPartNeedsUpdate=!0,e._invalidatePreview&&e._invalidatePreview(),"spreadsheet"===e._docType&&this._socket.sendMessage("commandvalues command=.uno:ViewRowColumnHeaders"),e._drawSearchResults(),this.focus()},getPreview:function(t,e,i,n,s){this._docPreviews||(this._docPreviews={});var o=s?!!s.autoUpdate:!1,a=s?!!s.broadcast:!1;this._docPreviews[t]={id:t,index:e,maxWidth:i,maxHeight:n,autoUpdate:o};var r=this._docLayer;if("text"===r._docType){if(e>=r._partPageRectanglesTwips.length)return;var l=0,h=r._partPageRectanglesTwips[e].min.x,d=r._partPageRectanglesTwips[e].min.y,u=r._partPageRectanglesTwips[e].max.x-h,c=r._partPageRectanglesTwips[e].max.y-d}else l=e,h=0,d=0,u=r._docWidthTwips,c=r._docHeightTwips;var p=u/c,_=i/n;_>p?i=Math.round(u*n/c):n=Math.round(c*i/u),this._socket.sendMessage("tile part="+l+" width="+i+" height="+n+" tileposx="+h+" tileposy="+d+" tilewidth="+u+" tileheight="+c+" id="+t+" broadcast="+(a?"yes":"no"))},getCustomPreview:function(t,e,i,n,s,o,a,r,l){this._docPreviews||(this._docPreviews={});var h=l?l.autoUpdate:!1;this._docPreviews[t]={id:t,part:e,width:i,height:n,tilePosX:s,tilePosY:o,tileWidth:a,tileHeight:r,autoUpdate:h},this._socket.sendMessage("tile part="+e+" width="+i+" height="+n+" tileposx="+s+" tileposy="+o+" tilewidth="+a+" tileheight="+r+" id="+t+" broadcast=no")},removePreviewUpdate:function(t){this._docPreviews&&this._docPreviews[t]&&(this._docPreviews[t].autoUpdate=!1)},goToPage:function(t){var e=this._docLayer;if("prev"===t?e._currentPage>0&&(e._currentPage-=1):"next"===t?e._currentPage<e._pages-1&&(e._currentPage+=1):"number"==typeof t&&t>=0&&t<e._pages&&(e._currentPage=t),"edit"!==this._permission&&e._partPageRectanglesPixels.length>e._currentPage){var i=e._partPageRectanglesPixels[e._currentPage],n=new s.Point(i.min.x+(i.max.x-i.min.x)/2,i.min.y);n.y-=this.getSize().y/4,this.scrollTop(n.y,{update:!0}),this.scrollLeft(n.x,{update:!0})}else this._socket.sendMessage("setpage page="+e._currentPage);this.fire("pagenumberchanged",{currentPage:e._currentPage,pages:e._pages,docType:e._docType})},insertPage:function(t){if("presentation"===this.getDocType())this._socket.sendMessage("uno .uno:InsertPage");else{if("spreadsheet"!==this.getDocType())return;var e={Name:{type:"string",value:""},Index:{type:"long",value:t+1}};this._socket.sendMessage("uno .uno:Insert "+JSON.stringify(e))}var i=this._docLayer;this.fire("insertpage",{selectedPart:i._selectedPart,parts:i._parts}),i._parts++,"number"==typeof t?this.setPart(t):this.setPart("next")},duplicatePage:function(){if("presentation"===this.getDocType()){this._socket.sendMessage("uno .uno:DuplicatePage");var t=this._docLayer;this.fire("insertpage",{selectedPart:t._selectedPart,parts:t._parts}),t._parts++,this.setPart("next")}},deletePage:function(t){if("presentation"===this.getDocType())this._socket.sendMessage("uno .uno:DeletePage");else{if("spreadsheet"!==this.getDocType())return;var e={Index:{type:"long",value:t+1}};this._socket.sendMessage("uno .uno:Remove "+JSON.stringify(e))}var i=this._docLayer;1!==i._parts&&(this.fire("deletepage",{selectedPart:i._selectedPart,parts:i._parts}),i._parts--,i._selectedPart>=i._parts&&i._selectedPart--,"number"==typeof t?this.setPart(t):this.setPart(i._selectedPart))},renamePage:function(t,e){if("spreadsheet"===this.getDocType()){var i={Name:{type:"string",value:t},Index:{type:"long",value:e+1}};this._socket.sendMessage("uno .uno:Name "+JSON.stringify(i)),this.setPart(this._docLayer,e)}},getNumberOfPages:function(){return this._docLayer._pages},getNumberOfParts:function(){return this._docLayer._parts},getCurrentPageNumber:function(){return this._docLayer._currentPage},getCurrentPartNumber:function(){return this._docLayer._selectedPart},getDocSize:function(){return this._docLayer._docPixelSize},getPageSizes:function(){return{twips:this._docLayer._partPageRectanglesTwips,pixels:this._docLayer._partPageRectanglesPixels}},getDocType:function(){return this._docLayer?this._docLayer._docType:null}}),s.Map.include({scroll:function(t,e,i){"number"==typeof t&&"number"==typeof e&&(this._setUpdateOffsetEvt(i),this.panBy(new s.Point(t,e),{animate:!1}))},scrollDown:function(t,e){this.scroll(0,t,e)},scrollRight:function(t,e){this.scroll(t,0,e)},scrollOffset:function(){var t=this.project(this.getCenter()),e=t.subtract(this.getSize().divideBy(2)),i={};return i.x=e.x<0?0:Math.round(e.x),i.y=e.y<0?0:Math.round(e.y),i},scrollTop:function(t,e){this._setUpdateOffsetEvt(e);var i=this.scrollOffset();this.panBy(new s.Point(0,t-i.y),{animate:!1})},scrollLeft:function(t,e){this._setUpdateOffsetEvt(e);var i=this.scrollOffset();this.panBy(new s.Point(t-i.x,0),{animate:!1})},_setUpdateOffsetEvt:function(t){t&&t.update===!0?this.on("moveend",this._docLayer._updateScrollOffset,this._docLayer):this.off("moveend",this._docLayer._updateScrollOffset,this._docLayer)},fitWidthZoom:function(t){this._docLayer&&this._docLayer._fitWidthZoom(null,t)}}),s.Styles={styleMappings:{Default:"Default",Result:"Result",Result2:"Result2",Heading:"Heading",Heading1:"Heading1",Default:"Default",Report:"Report",standard:"Default",
objectwitharrow:"Object with arrow",objectwithshadow:"Object with shadow",objectwithoutfill:"Object without fill","Object with no fill and no line":"Object with no fill and no line",text:"Text",textbody:"Text body",textbodyjustfied:"Text body justified",textbodyindent:"First line indent",title:"Title",title1:"Title1",title2:"Title2",headline:"Heading",headline1:"Heading1",headline2:"Heading2",measure:"Dimension Line",Normal:"Normal","Heading 1":"Heading 1","Heading 2":"Heading 2","Heading 3":"Heading 3","Numbering Symbols":"Numbering Symbols",Bullets:"Bullets","Table Contents":"Table Contents",Quotations:"Quotations",Index:"Index",Caption:"Caption",List:"List","Text Body":"Text Body","default":"default",gray1:"gray1",gray2:"gray2",gray3:"gray3",bw1:"bw1",bw2:"bw2",bw3:"bw3",orange1:"orange1",orange2:"orange2",orange3:"orange3",turquoise1:"turquoise1",turquoise2:"turquoise2",turquoise3:"turquoise3",blue1:"blue1",blue2:"blue2",blue3:"blue3",sun1:"sun1",sun2:"sun2",sun3:"sun3",earth1:"earth1",earth2:"earth2",earth3:"earth3",green1:"green1",green2:"green2",green3:"green3",seetang1:"seetang1",seetang2:"seetang2",seetang3:"seetang3",lightblue1:"lightblue1",lightblue2:"lightblue2",lightblue3:"lightblue3",yellow1:"yellow1",yellow2:"yellow2",yellow3:"yellow3","default":"default",bw:"bw",orange:"orange",turquoise:"turquoise",blue:"blue",sun:"sun",earth:"earth",green:"green",seetang:"seetang",lightblue:"lightblue",yellow:"yellow",background:"Background",backgroundobjects:"Background objects",notes:"Notes",outline1:"Outline 1",outline2:"Outline 2",outline3:"Outline 3",outline4:"Outline 4",outline5:"Outline 5",outline6:"Outline 6",outline7:"Outline 7",outline8:"Outline 8",outline9:"Outline 9",subtitle:"Subtitle",title:"Title","Clear formatting":"Clear formatting","Default Style":"Default Style","Bullet Symbols":"Bullets","Numbering Symbols":"Numbering Symbols","Footnote Symbol":"Footnote Characters","Page Number":"Page Number","Caption characters":"Caption Characters","Drop Caps":"Drop Caps","Internet link":"Internet Link","Visited Internet Link":"Visited Internet Link",Placeholder:"Placeholder","Index Link":"Index Link","Endnote Symbol":"Endnote Characters","Line numbering":"Line Numbering","Main index entry":"Main Index Entry","Footnote anchor":"Footnote Anchor","Endnote anchor":"Endnote Anchor",Rubies:"Rubies","Vertical Numbering Symbols":"Vertical Numbering Symbols",Emphasis:"Emphasis",Citation:"Quotation","Strong Emphasis":"Strong Emphasis","Source Text":"Source Text",Example:"Example","User Entry":"User Entry",Variable:"Variable",Definition:"Definition",Teletype:"Teletype","Text body":"Text Body",Quotations:"Quotations",Title:"Title",Subtitle:"Subtitle","Heading 1":"Heading 1","Heading 2":"Heading 2","Heading 3":"Heading 3",Standard:"Default Style",Heading:"Heading",List:"List",Caption:"Caption",Index:"Index","Table Contents":"Table Contents","First line indent":"First Line Indent","Hanging indent":"Hanging Indent","Text body indent":"Text Body Indent",Salutation:"Complimentary Close",Signature:"Signature","List Indent":"List Indent",Marginalia:"Marginalia","Heading 4":"Heading 4","Heading 5":"Heading 5","Heading 6":"Heading 6","Heading 7":"Heading 7","Heading 8":"Heading 8","Heading 9":"Heading 9","Heading 10":"Heading 10","Numbering 1 Start":"Numbering 1 Start","Numbering 1":"Numbering 1","Numbering 1 End":"Numbering 1 End","Numbering 1 Cont.":"Numbering 1 Cont.","Numbering 2 Start":"Numbering 2 Start","Numbering 2":"Numbering 2","Numbering 2 End":"Numbering 2 End","Numbering 2 Cont.":"Numbering 2 Cont.","Numbering 3 Start":"Numbering 3 Start","Numbering 3":"Numbering 3","Numbering 3 End":"Numbering 3 End","Numbering 3 Cont.":"Numbering 3 Cont.","Numbering 4 Start":"Numbering 4 Start","Numbering 4":"Numbering 4","Numbering 4 End":"Numbering 4 End","Numbering 4 Cont.":"Numbering 4 Cont.","Numbering 5 Start":"Numbering 5 Start","Numbering 5":"Numbering 5","Numbering 5 End":"Numbering 5 End","Numbering 5 Cont.":"Numbering 5 Cont.","List 1 Start":"List 1 Start","List 1":"List 1","List 1 End":"List 1 End","List 1 Cont.":"List 1 Cont.","List 2 Start":"List 2 Start","List 2":"List 2","List 2 End":"List 2 End","List 2 Cont.":"List 2 Cont.","List 3 Start":"List 3 Start","List 3":"List 3","List 3 End":"List 3 End","List 3 Cont.":"List 3 Cont.","List 4 Start":"List 4 Start","List 4":"List 4","List 4 End":"List 4 End","List 4 Cont.":"List 4 Cont.","List 5 Start":"List 5 Start","List 5":"List 5","List 5 End":"List 5 End","List 5 Cont.":"List 5 Cont.","Index Heading":"Index Heading","Index 1":"Index 1","Index 2":"Index 2","Index 3":"Index 3","Index Separator":"Index Separator","Contents Heading":"Contents Heading","Contents 1":"Contents 1","Contents 2":"Contents 2","Contents 3":"Contents 3","Contents 4":"Contents 4","Contents 5":"Contents 5","User Index Heading":"User Index Heading","User Index 1":"User Index 1","User Index 2":"User Index 2","User Index 3":"User Index 3","User Index 4":"User Index 4","User Index 5":"User Index 5","Contents 6":"Contents 6","Contents 7":"Contents 7","Contents 8":"Contents 8","Contents 9":"Contents 9","Contents 10":"Contents 10","Illustration Index Heading":"Illustration Index Heading","Illustration Index 1":"Illustration Index 1","Object index heading":"Object Index Heading","Object index 1":"Object Index 1","Table index heading":"Table Index Heading","Table index 1":"Table Index 1","Bibliography Heading":"Bibliography Heading","Bibliography 1":"Bibliography 1","User Index 6":"User Index 6","User Index 7":"User Index 7","User Index 8":"User Index 8","User Index 9":"User Index 9","User Index 10":"User Index 10",Header:"Header","Header left":"Header Left","Header right":"Header Right",Footer:"Footer","Footer left":"Footer Left","Footer right":"Footer Right","Table Heading":"Table Heading",Illustration:"Illustration",Table:"Table",Text:"Text","Frame contents":"Frame Contents",Footnote:"Footnote",Addressee:"Addressee",Sender:"Sender",Endnote:"Endnote",Drawing:"Drawing","Preformatted Text":"Preformatted Text","Horizontal Line":"Horizontal Line","List Contents":"List Contents","List Heading":"List Heading",Standard:"Default Style","First Page":"First Page","Left Page":"Left Page","Right Page":"Right Page",Envelope:"Envelope",Index:"Index",HTML:"HTML",Footnote:"Footnote",Endnote:"Endnote",Landscape:"Landscape",Graphics:"Graphics",Frame:"Frame",OLE:"OLE",Formula:"Formula",Marginalia:"Marginalia",Watermark:"Watermark",Labels:"Labels","Numbering 1":"Numbering 1","Numbering 2":"Numbering 2","Numbering 3":"Numbering 3","Numbering 4":"Numbering 4","Numbering 5":"Numbering 5","List 1":"List 1","List 2":"List 2","List 3":"List 3","List 4":"List 4","List 5":"List 5"},impressMapping:{Titel:"title",Untertitel:"subtitle","Gliederung 1":"outline1","Gliederung 2":"outline2","Gliederung 3":"outline3","Gliederung 4":"outline4","Gliederung 5":"outline5","Gliederung 6":"outline6","Gliederung 7":"outline7","Gliederung 8":"outline8","Gliederung 9":"outline9",Hintergrund:"background",Hintergrundobjekte:"backgroundobjects",Notizen:"notes"},impressLayout:[{id:0,text:"Title Slide"},{id:1,text:"Title, Content"},{id:3,text:"Title and 2 Content"},{id:19,text:"Title Only"},{id:20,text:"Blank Slide"},{id:32,text:"Centered Text"},{id:12,text:"Title, Content and 2 Content"},{id:15,text:"Title, 2 Content and Content"},{id:16,text:"Title, 2 Content over Content"},{id:14,text:"Title, Content over Content"},{id:18,text:"Title, 4 Content"},{id:34,text:"Title, 6 Content"},{id:27,text:"Vertical Title, Text, Chart"},{id:28,text:"Vertical Title, Vertical Text"},{id:29,text:"Title, Vertical Text"},{id:30,text:"Title, Vertical Text, Clipart"}],insertMode:{"true":"Insert","false":"Overwrite"},selectionMode:["Standard selection","Extending selection","Adding selection","Block selection"]},s.PosAnimation=s.Evented.extend({run:function(t,e,i,n){this.stop(),this._el=t,this._inProgress=!0,this._duration=i||.25,this._duration=0,this._easeOutPower=1/Math.max(n||.5,.2),this._startPos=s.DomUtil.getPosition(t),this._offset=e.subtract(this._startPos),this._startTime=+new Date,this.fire("start"),this._animate()},stop:function(){this._inProgress&&(this._step(!0),this._complete())},_animate:function(){this._animId=s.Util.requestAnimFrame(this._animate,this),this._step()},_step:function(t){var e=+new Date-this._startTime,i=1e3*this._duration;i>e?this._runFrame(this._easeOut(e/i),t):(this._runFrame(1),this._complete())},_runFrame:function(t,e){var i=this._startPos.add(this._offset.multiplyBy(t));e&&i._round(),s.DomUtil.setPosition(this._el,i),this.fire("step")},_complete:function(){s.Util.cancelAnimFrame(this._animId),this._inProgress=!1,this.fire("end")},_easeOut:function(t){return 1-Math.pow(1-t,this._easeOutPower)}}),s.Map.include({setView:function(t,e,n){if(e=e===i?this._zoom:this._limitZoom(e),t=this._limitCenter(s.latLng(t),e,this.options.maxBounds),n=n||{},this.stop(),this._loaded&&!n.reset&&n!==!0){n.animate!==i&&(n.zoom=s.extend({animate:n.animate},n.zoom),n.pan=s.extend({animate:n.animate},n.pan));var o=this._zoom!==e?this._tryAnimatedZoom&&this._tryAnimatedZoom(t,e,n.zoom):this._tryAnimatedPan(t,n.pan);if(o)return clearTimeout(this._sizeTimer),this}return this._resetView(t,e),this},panBy:function(t,e){if(t=s.point(t).round(),e=e||{},!t.x&&!t.y)return this;if(e.animate!==!0&&!this.getSize().contains(t))return this._resetView(this.unproject(this.project(this.getCenter()).add(t)),this.getZoom()),this;if(this._panAnim||(this._panAnim=new s.PosAnimation,this._panAnim.on({step:this._onPanTransitionStep,end:this._onPanTransitionEnd},this)),e.noMoveStart||this.fire("movestart"),e.animate!==!1){s.DomUtil.addClass(this._mapPane,"leaflet-pan-anim");var i=this._getMapPanePos().subtract(t);this._panAnim.run(this._mapPane,i,e.duration||.25,e.easeLinearity)}else this._rawPanBy(t),this.fire("move").fire("moveend");return this},_onPanTransitionStep:function(){this.fire("move")},_onPanTransitionEnd:function(){s.DomUtil.removeClass(this._mapPane,"leaflet-pan-anim"),this.fire("moveend")},_tryAnimatedPan:function(t,e){var i=this._getCenterOffset(t)._floor();return(e&&e.animate)===!0||this.getSize().contains(i)?(this.panBy(i,e),(e&&e.animate)!==!1):!1}}),s.Map.mergeOptions({zoomAnimation:!0,zoomAnimationThreshold:4});var l=s.DomUtil.TRANSITION&&s.Browser.any3d&&!s.Browser.mobileOpera;l&&s.Map.addInitHook(function(){this._zoomAnimated=this.options.zoomAnimation,this._zoomAnimated&&(this._createAnimProxy(),s.DomEvent.on(this._proxy,s.DomUtil.TRANSITION_END,this._catchTransitionEnd,this))}),s.Map.include(l?{_createAnimProxy:function(){var t=this._proxy=s.DomUtil.create("div","leaflet-proxy leaflet-zoom-animated");this._panes.mapPane.appendChild(t),this.on("zoomanim",function(e){var i=s.DomUtil.TRANSFORM,n=t.style[i];s.DomUtil.setTransform(t,this.project(e.center,e.zoom),this.getZoomScale(e.zoom,1)),n===t.style[i]&&this._animatingZoom&&this._onZoomTransitionEnd()},this),this.on("load moveend",function(){var e=this.getCenter(),i=this.getZoom();s.DomUtil.setTransform(t,this.project(e,i),this.getZoomScale(i,1))},this)},_catchTransitionEnd:function(t){this._animatingZoom&&t.propertyName.indexOf("transform")>=0&&this._onZoomTransitionEnd()},_nothingToAnimate:function(){return!this._container.getElementsByClassName("leaflet-zoom-animated").length},_tryAnimatedZoom:function(t,e,i){if(this._animatingZoom)return!0;if(i=i||{},!this._zoomAnimated||i.animate===!1||this._nothingToAnimate()||Math.abs(e-this._zoom)>this.options.zoomAnimationThreshold)return!1;var n=this.getZoomScale(e),o=this._getCenterOffset(t)._divideBy(1-1/n);return i.animate===!0||this.getSize().contains(o)?(s.Util.requestAnimFrame(function(){this.fire("movestart").fire("zoomstart")._animateZoom(t,e,!0)},this),!0):!1},_animateZoom:function(t,e,i,n){i&&(this._animatingZoom=!0,this._animateToCenter=t,this._animateToZoom=e,s.DomUtil.addClass(this._mapPane,"leaflet-zoom-anim")),this.fire("zoomanim",{center:t,zoom:e,scale:this.getZoomScale(e),origin:this.latLngToLayerPoint(t),offset:this._getCenterOffset(t).multiplyBy(-1),noUpdate:n})},_onZoomTransitionEnd:function(){this._animatingZoom=!1,s.DomUtil.removeClass(this._mapPane,"leaflet-zoom-anim"),this._resetView(this._animateToCenter,this._animateToZoom,!0,!0)}}:{}),s.Map.include({flyTo:function(t,e){function n(t){var e=(f*f-g*g+(t?-1:1)*w*w*v*v)/(2*(t?f:g)*w*v);return Math.log(Math.sqrt(e*e+1)-e)}function o(t){return(Math.exp(t)-Math.exp(-t))/2}function a(t){return(Math.exp(t)+Math.exp(-t))/2}function r(t){return o(t)/a(t)}function l(t){return g*(a(b)/a(b+y*t))}function h(t){return g*(a(b)*r(b+y*t)-o(b))/w}function d(t){return 1-Math.pow(1-t,1.5)}function u(){var i=(Date.now()-C)/P,n=d(i)*x;1>=i?(this._flyToFrame=s.Util.requestAnimFrame(u,this),this._resetView(this.unproject(c.add(p.subtract(c).multiplyBy(h(n)/v)),m),this.getScaleZoom(g/l(n),m),!0,!0)):this._resetView(t,e,!0,!0)}this.stop();var c=this.project(this.getCenter()),p=this.project(t),_=this.getSize(),m=this._zoom;t=s.latLng(t),e=e===i?m:e;var g=Math.max(_.x,_.y),f=g*this.getZoomScale(m,e),v=p.distanceTo(c),y=1.42,w=y*y,b=n(0),C=Date.now(),x=(n(1)-b)/y,P=1e3*x*.8;this.fire("zoomstart"),u.call(this)}}),s.Map.include({_defaultLocateOptions:{timeout:1e4,watch:!1},locate:function(t){if(t=this._locateOptions=s.extend({},this._defaultLocateOptions,t),!navigator.geolocation)return this._handleGeolocationError({code:0,message:"Geolocation not supported."}),this;var e=s.bind(this._handleGeolocationResponse,this),i=s.bind(this._handleGeolocationError,this);return t.watch?this._locationWatchId=navigator.geolocation.watchPosition(e,i,t):navigator.geolocation.getCurrentPosition(e,i,t),this},stopLocate:function(){return navigator.geolocation&&navigator.geolocation.clearWatch(this._locationWatchId),this._locateOptions&&(this._locateOptions.setView=!1),this},_handleGeolocationError:function(t){var e=t.code,i=t.message||(1===e?"permission denied":2===e?"position unavailable":"timeout");this._locateOptions.setView&&!this._loaded&&this.fitWorld(),this.fire("locationerror",{code:e,message:"Geolocation error: "+i+"."})},_handleGeolocationResponse:function(t){var e=t.coords.latitude,i=t.coords.longitude,n=new s.LatLng(e,i),o=n.toBounds(t.coords.accuracy),a=this._locateOptions;if(a.setView){var r=this.getBoundsZoom(o);this.setView(n,a.maxZoom?Math.min(r,a.maxZoom):r)}var l={latlng:n,bounds:o,timestamp:t.timestamp};for(var h in t.coords)"number"==typeof t.coords[h]&&(l[h]=t.coords[h]);this.fire("locationfound",l)}})}(window,document);