/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.security.cert.CertPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.AppVerifier;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.dialogresults.BasicDialogValue;
import net.sourceforge.jnlp.security.dialogresults.YesNoSandbox;
import net.sourceforge.jnlp.tools.CertInformation;
import net.sourceforge.jnlp.tools.JarCertVerifier;

public class PluginAppVerifier
implements AppVerifier {
    @Override
    public boolean hasAlreadyTrustedPublisher(Map<CertPath, CertInformation> certs, Map<String, Integer> signedJars) {
        boolean allPublishersTrusted = true;
        for (String jarName : signedJars.keySet()) {
            int numbSignableEntries = signedJars.get(jarName);
            boolean publisherTrusted = false;
            for (CertInformation certInfo : certs.values()) {
                if (!certInfo.isSignerOfJar(jarName) || numbSignableEntries != certInfo.getNumJarEntriesSigned(jarName) || !certInfo.isPublisherAlreadyTrusted()) continue;
                publisherTrusted = true;
                break;
            }
            allPublishersTrusted &= publisherTrusted;
        }
        return allPublishersTrusted;
    }

    @Override
    public boolean hasRootInCacerts(Map<CertPath, CertInformation> certs, Map<String, Integer> signedJars) {
        boolean allRootCAsTrusted = true;
        for (String jarName : signedJars.keySet()) {
            int numbSignableEntries = signedJars.get(jarName);
            boolean rootCATrusted = false;
            for (CertInformation certInfo : certs.values()) {
                if (!certInfo.isSignerOfJar(jarName) || numbSignableEntries != certInfo.getNumJarEntriesSigned(jarName) || !certInfo.isRootInCacerts()) continue;
                rootCATrusted = true;
                break;
            }
            allRootCAsTrusted &= rootCATrusted;
        }
        return allRootCAsTrusted;
    }

    @Override
    public boolean isFullySigned(Map<CertPath, CertInformation> certs, Map<String, Integer> signedJars) {
        boolean isFullySigned = true;
        for (String jarName : signedJars.keySet()) {
            int numbSignableEntries = signedJars.get(jarName);
            boolean isSigned = false;
            for (CertInformation certInfo : certs.values()) {
                if (!certInfo.isSignerOfJar(jarName) || numbSignableEntries != certInfo.getNumJarEntriesSigned(jarName)) continue;
                isSigned = true;
                break;
            }
            isFullySigned &= isSigned;
        }
        return isFullySigned;
    }

    @Override
    public void checkTrustWithUser(JNLPClassLoader.SecurityDelegate securityDelegate, JarCertVerifier jcv, JNLPFile file) throws LaunchException {
        List<CertPath> certPaths = this.buildCertPathsList(jcv);
        ArrayList<CertPath> alreadyApprovedByUser = new ArrayList<CertPath>();
        for (String jarName : jcv.getJarSignableEntries().keySet()) {
            CertInformation info;
            boolean trustFoundOrApproved = false;
            for (CertPath cPathApproved : alreadyApprovedByUser) {
                jcv.setCurrentlyUsedCertPath(cPathApproved);
                info = jcv.getCertInformation(cPathApproved);
                if (!info.isSignerOfJar(jarName) || !alreadyApprovedByUser.contains(cPathApproved)) continue;
                trustFoundOrApproved = true;
                break;
            }
            if (trustFoundOrApproved) continue;
            for (CertPath cPath : certPaths) {
                jcv.setCurrentlyUsedCertPath(cPath);
                info = jcv.getCertInformation(cPath);
                if (!info.isSignerOfJar(jarName)) continue;
                if (info.isPublisherAlreadyTrusted()) {
                    trustFoundOrApproved = true;
                    alreadyApprovedByUser.add(cPath);
                    break;
                }
                SecurityDialogs.AccessType dialogType = info.isRootInCacerts() && !info.hasSigningIssues() ? SecurityDialogs.AccessType.VERIFIED : (info.isRootInCacerts() ? SecurityDialogs.AccessType.SIGNING_ERROR : SecurityDialogs.AccessType.UNVERIFIED);
                YesNoSandbox action = SecurityDialogs.showCertWarningDialog(dialogType, file, jcv, securityDelegate);
                if (action == null || !action.toBoolean()) continue;
                if (action.compareValue(BasicDialogValue.Primitive.SANDBOX)) {
                    securityDelegate.setRunInSandbox();
                }
                alreadyApprovedByUser.add(cPath);
                trustFoundOrApproved = true;
                break;
            }
            if (trustFoundOrApproved) continue;
            throw new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCancelOnUserRequest"), "");
        }
    }

    public List<CertPath> buildCertPathsList(JarCertVerifier jcv) {
        List<CertPath> certPathsList = jcv.getCertsList();
        ArrayList<CertPath> returnList = new ArrayList<CertPath>();
        for (CertPath cPath : certPathsList) {
            if (returnList.contains(cPath) || !jcv.getCertInformation(cPath).isPublisherAlreadyTrusted()) continue;
            returnList.add(cPath);
        }
        for (CertPath cPath : certPathsList) {
            if (returnList.contains(cPath) || !jcv.getCertInformation(cPath).isRootInCacerts() || jcv.getCertInformation(cPath).hasSigningIssues()) continue;
            returnList.add(cPath);
        }
        for (CertPath cPath : certPathsList) {
            if (returnList.contains(cPath) || !jcv.getCertInformation(cPath).isRootInCacerts() || !jcv.getCertInformation(cPath).hasSigningIssues()) continue;
            returnList.add(cPath);
        }
        for (CertPath cPath : certPathsList) {
            if (returnList.contains(cPath)) continue;
            returnList.add(cPath);
        }
        return returnList;
    }
}

