/*
   Copyright (c) 2017 Marco Martin <mart@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

import QtQuick 2.1
import QtQuick.Layouts 1.1
import QtQuick.Controls 1.0 as QtControls
import org.kde.kirigami 2.1 as Kirigami

Kirigami.ApplicationItem {
    id: root
    implicitWidth: wideScreen ? Kirigami.Units.gridUnit * 24 :  Kirigami.Units.gridUnit * 12
    pageStack.initialPage: mainColumn
    pageStack.defaultColumnWidth: wideScreen ? root.width / 2 : root.width

    wideScreen: pageStack.depth > 1 && systemsettings.width > Kirigami.Units.gridUnit * 70
    CategoriesPage {
        id: mainColumn
    }

    SubCategoryPage {
        id: subCategoryColumn
    }
    Kirigami.Separator {
        z: 999
        anchors {
            top: parent.top
            right: parent.right
            bottom: parent.bottom
        }
    }
}
