/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;

public abstract class AddImageryPanel
extends JPanel {
    protected final JosmTextArea rawUrl = new JosmTextArea(3, 40).transferFocusOnTab();
    protected final JosmTextField name = new JosmTextField();
    protected final transient Collection<ContentValidationListener> listeners = new ArrayList<ContentValidationListener>();

    protected AddImageryPanel() {
        this(new GridBagLayout());
    }

    protected AddImageryPanel(LayoutManager layout) {
        super(layout);
        this.registerValidableComponent(this.name);
    }

    protected final void registerValidableComponent(AbstractButton component) {
        component.addChangeListener(e -> this.notifyListeners());
    }

    protected final void registerValidableComponent(JTextComponent component) {
        component.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddImageryPanel.this.notifyListeners();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddImageryPanel.this.notifyListeners();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddImageryPanel.this.notifyListeners();
            }
        });
    }

    protected abstract ImageryInfo getImageryInfo();

    protected static String sanitize(String s) {
        return s.replaceAll("[\r\n]+", "").trim();
    }

    protected static String sanitize(String s, ImageryInfo.ImageryType type) {
        String ret = s;
        String imageryType = type.getTypeString() + ':';
        if (ret.startsWith(imageryType)) {
            ret = ret.substring(imageryType.length());
        }
        return AddImageryPanel.sanitize(ret);
    }

    protected final String getImageryName() {
        return AddImageryPanel.sanitize(this.name.getText());
    }

    protected final String getImageryRawUrl() {
        return AddImageryPanel.sanitize(this.rawUrl.getText());
    }

    protected abstract boolean isImageryValid();

    public final void addContentValidationListener(ContentValidationListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    private void notifyListeners() {
        for (ContentValidationListener l : this.listeners) {
            l.contentChanged(this.isImageryValid());
        }
    }

    @FunctionalInterface
    public static interface ContentValidationListener {
        public void contentChanged(boolean var1);
    }
}

