/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.annotation;

import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.owl.model.util.DateFormatter;
import org.protege.editor.owl.model.util.ISO8601Formatter;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.DublinCoreVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCreationMetadataPreferencesManager {
    private static final Logger logger = LoggerFactory.getLogger(EntityCreationMetadataPreferencesManager.class);
    private final Preferences preferences;
    private static final String CREATED_BY_ANNOTATION_ENABLED_KEY = "created.by.enabled";
    private static final String CREATED_BY_ANNOTATION_PROPERTY_IRI_KEY = "created.by.annotation.iri";
    private static final String CREATED_BY_USE_ORCID = "created.by.use.orcid";
    private static final String CREATION_DATE_ANNOTATION_ENABLED_KEY = "creation.date.enabled";
    private static final String CREATION_DATE_ANNOTATION_PROPERTY_IRI_KEY = "creation.date.annotation.iri";
    private static final String DATE_FORMATTER_CLASS_KEY = "creation.date.formatter";
    private DateFormatter dateFormatter = null;

    public EntityCreationMetadataPreferencesManager(Preferences preferences) {
        this.preferences = preferences;
    }

    public boolean isCreatedByAnnotationEnabled() {
        return this.preferences.getBoolean(CREATED_BY_ANNOTATION_ENABLED_KEY, false);
    }

    public void setCreatedByAnnotationEnabled(boolean enabled) {
        this.preferences.putBoolean(CREATED_BY_ANNOTATION_ENABLED_KEY, enabled);
    }

    public boolean isCreationDateAnnotationEnabled() {
        return this.preferences.getBoolean(CREATION_DATE_ANNOTATION_ENABLED_KEY, false);
    }

    public boolean isCreatedByValueOrcid() {
        return this.preferences.getBoolean(CREATED_BY_USE_ORCID, false);
    }

    public void setCreatedByValueOrcid(boolean b) {
        this.preferences.putBoolean(CREATED_BY_USE_ORCID, b);
    }

    public void setCreationDateAnnotationEnabled(boolean enabled) {
        this.preferences.putBoolean(CREATION_DATE_ANNOTATION_ENABLED_KEY, enabled);
    }

    public IRI getCreatedByAnnotationPropertyIRI() {
        return this.getIRI(CREATED_BY_ANNOTATION_PROPERTY_IRI_KEY, DublinCoreVocabulary.CREATOR.getIRI());
    }

    public void setCreatedByAnnotationPropertyIRI(IRI iri) {
        this.preferences.putString(CREATED_BY_ANNOTATION_PROPERTY_IRI_KEY, iri.toString());
    }

    public IRI getCreationDateAnnotationPropertyIRI() {
        return this.getIRI(CREATION_DATE_ANNOTATION_PROPERTY_IRI_KEY, DublinCoreVocabulary.DATE.getIRI());
    }

    public void setCreationDateAnnotationPropertyIRI(IRI iri) {
        this.preferences.putString(CREATION_DATE_ANNOTATION_PROPERTY_IRI_KEY, iri.toString());
    }

    public DateFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = this.instantiateDateFormatter();
        }
        return this.dateFormatter;
    }

    private DateFormatter instantiateDateFormatter() {
        String formatterClass = this.preferences.getString(DATE_FORMATTER_CLASS_KEY, ISO8601Formatter.class.getName());
        try {
            Class<?> cls = Class.forName(formatterClass);
            return (DateFormatter)cls.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("Could not create date formatter: {}", (Object)e.getMessage(), (Object)e);
            return new ISO8601Formatter();
        }
    }

    public void setDateFormatter(DateFormatter dateFormatter) {
        this.preferences.putString(DATE_FORMATTER_CLASS_KEY, dateFormatter.getClass().getName());
        this.dateFormatter = dateFormatter;
    }

    private IRI getIRI(String key, IRI defaultIRI) {
        String value = this.preferences.getString(key, null);
        if (value != null) {
            return IRI.create((String)value);
        }
        return defaultIRI;
    }
}

