/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import org.protege.editor.owl.ui.renderer.layout.LinkBox;
import org.protege.editor.owl.ui.renderer.layout.LinkSpan;
import org.protege.editor.owl.ui.renderer.layout.PageObject;

public class Line
extends PageObject {
    private AttributedString attributedString;
    private TextLayout textLayout;
    private Map<LinkBox, AttributedString> linkMap = new HashMap<LinkBox, AttributedString>();

    public Line(AttributedString attributedString) {
        this.attributedString = attributedString;
    }

    public void addLink(LinkSpan linkSpan, int linkStart, int linkEnd) {
        Rectangle linkBounds = this.textLayout.getLogicalHighlightShape(linkStart, linkEnd).getBounds();
        linkBounds.translate(0, (int)(this.textLayout.getAscent() + this.textLayout.getLeading()));
        AttributedString linkString = new AttributedString(this.attributedString.getIterator());
        linkString.addAttribute(TextAttribute.FOREGROUND, Color.MAGENTA.darker(), linkStart, linkEnd);
        linkString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, linkStart, linkEnd);
        LinkBox linkBox = new LinkBox(linkSpan.getLink());
        linkBox.setBounds(linkBounds);
        this.add(linkBox);
    }

    @Override
    public void layout(FontRenderContext fontRenderContext) {
        this.textLayout = new TextLayout(this.attributedString.getIterator(), fontRenderContext);
        int textHeight = (int)(this.textLayout.getAscent() + this.textLayout.getDescent() + this.textLayout.getLeading());
        int totalHeight = textHeight + this.getInsetsTop() + this.getInsetsBottom();
        this.setHeight(totalHeight);
    }

    @Override
    public void paintContent(Graphics2D g2) {
        float v = this.getBaseline();
        AttributedString toRender = this.attributedString;
        g2.drawString(toRender.getIterator(), 0.0f, v);
    }

    private float getBaseline() {
        return this.textLayout.getAscent() + this.textLayout.getLeading();
    }
}

