/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dom;

import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNodeList
implements NodeList,
Iterable<Node> {
    private NodeList list;

    public SimpleNodeList(NodeList list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.list = list;
    }

    public SimpleNodeList(List<Node> nodes) {
        this(nodes.toArray(new Node[0]));
    }

    public SimpleNodeList(Node ... nodes) {
        final Node[] n = new Node[nodes == null ? 0 : nodes.length];
        System.arraycopy(nodes, 0, n, 0, n.length);
        this.list = new NodeList(){

            public int getLength() {
                return n.length;
            }

            public Node item(int index) {
                return n[index];
            }
        };
    }

    @Override
    public Node item(int index) {
        return this.list.item(index);
    }

    @Override
    public int getLength() {
        return this.list.getLength();
    }

    @Override
    public Iterator<Node> iterator() {
        return new Iterator<Node>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < SimpleNodeList.this.getLength();
            }

            @Override
            public Node next() {
                return SimpleNodeList.this.item(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

