/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer.bmng;

import java.awt.geom.Point2D;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class SLMapServerInfo
extends TileFactoryInfo {
    private static final int pyramid_top = 9;
    private static final int midpoint = 5;
    private static final int normal_tile_size = 675;

    public SLMapServerInfo() {
        this("http://maps.joshy.net/tiles/bmng_tiles_3");
    }

    public SLMapServerInfo(String baseURL) {
        super(0, 8, 9, 675, true, false, baseURL, "", "", "");
        this.setDefaultZoomLevel(0);
    }

    public int getMidpoint() {
        return 5;
    }

    public int getTileSize(int zoom) {
        int size = super.getTileSize(zoom);
        if (zoom < 5) {
            return size;
        }
        for (int i = 0; i < zoom + 1 - 5; ++i) {
            size /= 2;
        }
        return size;
    }

    public int getMapWidthInTilesAtZoom(int zoom) {
        if (zoom < 5) {
            return (int)Math.pow(2.0, 5 - zoom);
        }
        return 2;
    }

    public int getMapHeightInTilesAtZoom(int zoom) {
        return this.getMapWidthInTilesAtZoom(zoom) / 2;
    }

    public String getTileUrl(int x, int y, int zoom) {
        int ty = y;
        int tx = x;
        int width_in_tiles = this.getMapWidthInTilesAtZoom(zoom);
        if (ty < 0) {
            return null;
        }
        if (zoom < 5 ? ty >= width_in_tiles / 2 : ty != 0) {
            return null;
        }
        String url = this.baseURL + "/" + zoom + "/" + ty + "/" + tx + ".jpg";
        return url;
    }

    public Point2D getBitmapCoordinate(double latitude, double longitude, int zoom) {
        double size_in_pixels = this.getMapWidthInTilesAtZoom(zoom) * this.getTileSize(zoom);
        double ppd = size_in_pixels / 360.0;
        double centerX = this.getTileSize(zoom) * this.getMapWidthInTilesAtZoom(zoom) / 2;
        double centerY = this.getTileSize(zoom) * this.getMapHeightInTilesAtZoom(zoom) / 2;
        double x = longitude * ppd + centerX;
        double y = -latitude * ppd + centerY;
        return new Point2D.Double(x, y);
    }

    public GeoPosition getPosition(Point2D pix, int zoom) {
        double size_in_pixels = this.getMapWidthInTilesAtZoom(zoom) * this.getTileSize(zoom);
        double ppd = size_in_pixels / 360.0;
        double centerX = this.getTileSize(zoom) * this.getMapWidthInTilesAtZoom(zoom) / 2;
        double centerY = this.getTileSize(zoom) * this.getMapHeightInTilesAtZoom(zoom) / 2;
        double lon = (pix.getX() - centerX) / ppd;
        double lat = -(pix.getY() - centerY) / ppd;
        return new GeoPosition(lat, lon);
    }
}

