/*
 * Decompiled with CFR 0.152.
 */
package gps.convert;

import gps.convert.ExternalUtils;
import gps.convert.GeoidIF;

public final class Geoid
implements GeoidIF {
    private static final byte[] geoid_delta = new byte[703];

    public static final GeoidIF getInstance() {
        return new Geoid();
    }

    private Geoid() {
    }

    public final double wgs84Separation(double d, double d2) {
        int n = (int)Math.floor((d + 90.0) / 10.0);
        int n2 = (int)Math.floor((d2 + 180.0) / 10.0);
        int n3 = n < 18 ? n + 1 : n;
        int n4 = n2 < 36 ? n2 + 1 : n2;
        try {
            return ExternalUtils.bilinear((double)n2 * 10.0 - 180.0, (double)n * 10.0 - 90.0, (double)n4 * 10.0 - 180.0, (double)n3 * 10.0 - 90.0, d2, d, geoid_delta[n2 + n * 37], geoid_delta[n4 + n * 37], geoid_delta[n2 + n3 * 37], geoid_delta[n4 + n3 * 37]);
        }
        catch (Exception exception) {
            return -999.0;
        }
    }

    static {
        int n = 0;
        while (true) {
            if (n >= 703) break;
            Geoid.geoid_delta[n] = (byte)"\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00e2\u00cb\u00ca\u00c9\u00cc\u00d0\u00d6\u00da\u00da\u00e3\u00e6\u00e6\u00e8\u00e9\u00eb\u00ed\u00f0\u00f4\u00f8\u00fc\u00ff\u0001\u0004\u0004\u0006\u0005\u0004\u0002\u00fa\u00f1\u00e8\u00df\u00d8\u00d0\u00ce\u00cb\u00cc\u00cb\u00c3\u00c4\u00c3\u00c9\u00cf\u00d4\u00da\u00e1\u00e7\u00f0\u00fa\u0001\u0004\u0005\u0004\u0002\u0006\f\u0010\u0010\u0011\u0015\u0014\u001a\u001a\u0016\u0010\n\u00ff\u00f0\u00e3\u00dc\u00d2\u00c9\u00ca\u00c5\u00c3\u00d3\u00d5\u00db\u00e0\u00e2\u00e6\u00e9\u00ea\u00f0\u00f6\u00fe\n\u0014\u0014\u0015\u0018\u0016\u0011\u0010\u0013\u0019\u001e##!\u001e\u001b\n\u00fe\u00f2\u00e9\u00e2\u00df\u00e3\u00dd\u00d5\u00d3\u00f1\u00ee\u00ee\u00f0\u00ef\u00f1\u00f6\u00f6\u00f8\u00fe\u0006\u000e\r\u0003\u0003\n\u0014\u001b\u0019\u001a\"'--&'\u001c\r\u00ff\u00f1\u00ea\u00ea\u00ee\u00f1\u00f2\u00f6\u00f1\u0015\u0006\u0001\u00f9\u00f4\u00f4\u00f4\u00f6\u00f9\u00ff\b\u0017\u000f\u00fe\u00fa\u0006\u0015\u0018\u0012\u001a\u001f!')\u001e\u0018\r\u00fe\u00ec\u00e0\u00df\u00e5\u00f2\u00fe\u0005\u0014\u0015.\u0016\u0005\u00fe\u00f8\u00f3\u00f6\u00f9\u00fc\u0001\t \u0010\u0004\u00f8\u0004\f\u000f\u0016\u001b\"\u001d\u000e\u000f\u000f\u0007\u00f7\u00e7\u00db\u00d9\u00e9\u00f2\u000f!\"-.3\u001b\n\u0000\u00f7\u00f5\u00fb\u00fe\u00fd\u00ff\t#\u0014\u00fb\u00fa\u00fb\u0000\r\u0011\u0017\u0015\b\u00f7\u00f6\u00f5\u00ec\u00d8\u00d1\u00d3\u00e7\u0005\u0017-:9?3$\u0016\u000b\u0006\u00ff\u00f8\u00f6\u00f8\u00f5\u00f7\u0001 \u0004\u00ee\u00f3\u00f7\u0004\u000e\f\r\u00fe\u00f2\u00e7\u00e0\u00da\u00c4\u00b5\u00c1\u00e6\u0000#4DL@4$\u0016\u0010\u0011\r\u0001\u00f4\u00e9\u00ec\u00f2\u00fd\u000e\n\u00f1\u00e5\u00ee\u0003\f\u0014\u0012\f\u00f3\u00f7\u00e4\u00cf\u00c2\u00a7\u009a\u00c1\u00f7!:IJ?2 \u0016\r\f\u000b\u0002\u00f5\u00e4\u00da\u00e3\u00f6\u0003\u0001\u00f5\u00d7\u00d6\u00f0\u0003\u0011!\u0016\u0017\u0002\u00fd\u00f9\u00dc\u00c5\u00a6\u00a1\u00c1\u00e8\f5<:.$\u001a\r\u0005\n\u0007\u00f9\u00e9\u00d9\u00d1\u00de\u00f7\u00f6\u00ec\u00d3\u00d0\u00e0\u00f7\u0011\u0019\u001f\u001f\u001a\u000f\u0006\u0001\u00e3\u00d4\u00c3\u00bd\u00c5\u00dc\u00f5\u0015'1'\u0016\n\u0005\u00f9\u00fb\u00f8\u00f1\u00e4\u00d8\u00d6\u00e3\u00ea\u00e6\u00e0\u00cd\u00d8\u00ef\u0011\u001f\",$\u001c\u001d\u0011\f\u00ec\u00f1\u00d8\u00df\u00de\u00de\u00e4\u0007\u001d+\u0014\u0004\u00fa\u00f9\u00f4\u00f6\u00f3\u00ec\u00e1\u00de\u00eb\u00f0\u00e6\u00de\u00df\u00dd\u00e6\u0002!;4340#(!\u00f7\u00e4\u00d9\u00d0\u00c5\u00ce\u00e4\u0003\u0017%\u0012\u00ff\u00f5\u00f4\u00f8\b\b\u0001\u00f5\u00ed\u00f0\u00ee\u00ea\u00dd\u00d8\u00e6\u00f4\u0018-?>;/0*\u001c\f\u00f6\u00ed\u00df\u00d5\u00d6\u00d5\u00e3\u00fe\u0011\u0017\u0016\u0006\u0002\u00f8\u0002\t\u0011\n\r\u0001\u00f2\u00e2\u00d9\u00d2\u00d6\u00eb\u0006\u001d1A<9/)\u0015\u0012\u000e\u0007\u00fd\u00ea\u00e3\u00e0\u00e0\u00e6\u00f1\u00fe\r\u0011\u0013\u0006\u0002\u0002\u0002\u0001\u00ff\u00fd\u00f9\u00f2\u00e8\u00e5\u00e7\u00ed\u0003\u0018%/<=:3+\u001d\u0014\f\u0005\u00fe\u00f6\u00f2\u00f4\u00f6\u00f2\u00f4\u00fa\u00fe\u0003\u0006\u0004\u0002\u0003\u0001\u00fe\u00fd\u00fd\u00fd\u00ff\u0003\u0001\u0005\t\u000b\u0013\u001b\u001f\"!\"!\"\u001c\u0017\u0011\r\t\u0004\u0004\u0001\u00fe\u00fe\u0000\u0002\u0003\u0002\u0001\u0001\u0003\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r\r".charAt(n);
            ++n;
        }
    }
}

