/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.j2se.app.utils;

import bt747.sys.Generic;
import gps.convert.ExternalUtils;
import gps.convert.GeoidIF;
import java.io.InputStream;

public final class Geoid
implements GeoidIF {
    private static byte[] geoid_delta;
    private static GeoidIF instance;

    public static final GeoidIF getInstance() {
        if (instance == null) {
            Geoid.init();
            if (geoid_delta != null) {
                instance = new Geoid();
            }
        }
        return instance;
    }

    private Geoid() {
    }

    private static final boolean init() {
        InputStream inputStream = null;
        try {
            if (geoid_delta == null) {
                inputStream = Geoid.class.getResourceAsStream("/net/sf/bt747/j2se/app/utils/geoid1DEG.bin");
                if (inputStream.available() != 64440) {
                    Generic.debug("/net/sf/bt747/j2se/app/utils/geoid1DEG.bin is bad size - expected 64440 got " + inputStream.available(), null);
                } else {
                    int n;
                    byte[] byArray = new byte[64440];
                    int n2 = 0;
                    do {
                        if ((n = inputStream.read(byArray, n2, 64440)) <= 0) continue;
                        n2 += n;
                    } while (n2 < 64440 && n >= 0);
                    inputStream.close();
                    geoid_delta = byArray;
                }
                inputStream.close();
            }
        }
        catch (Exception exception) {
            try {
                inputStream.close();
            }
            catch (Exception exception2) {}
            geoid_delta = null;
            Generic.debug("Geoid resource loading", exception);
        }
        System.err.println();
        return geoid_delta != null;
    }

    public final double wgs84Separation(double d, double d2) {
        int n = (int)Math.floor(d + 89.0);
        int n2 = (int)Math.floor(d2 + 180.0);
        if (n > 178) {
            n = 178;
        }
        int n3 = n < 178 ? n + 1 : 178;
        int n4 = n2 + 1;
        if (n < 0) {
            n = 0;
        }
        double d3 = (double)n2 - 180.0;
        double d4 = (double)n4 - 180.0;
        double d5 = (double)n - 89.0;
        double d6 = (double)n3 - 89.0;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 359) {
            n2 -= 360;
        }
        if (n4 > 359) {
            n4 -= 360;
        }
        try {
            return ExternalUtils.bilinear(d3, d5, d4, d6, d2, d, geoid_delta[n2 + n * 360], geoid_delta[n4 + n * 360], geoid_delta[n2 + n3 * 360], geoid_delta[n4 + n3 * 360]);
        }
        catch (Exception exception) {
            return -999.0;
        }
    }
}

