/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.IOException;
import java.net.SocketPermission;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.Permissions;
import java.security.Policy;
import java.security.URIParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Build;
import org.elasticsearch.SecureSM;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.ESPolicy;
import org.elasticsearch.bootstrap.ElasticsearchUncaughtExceptionHandler;
import org.elasticsearch.bootstrap.FilePermissionUtils;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.cli.Command;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.transport.TcpTransport;

final class Security {
    private Security() {
    }

    static void configure(Environment environment, boolean filterBadDefaults) throws IOException, NoSuchAlgorithmException {
        Policy.setPolicy(new ESPolicy(Security.createPermissions(environment), Security.getPluginPermissions(environment), filterBadDefaults));
        String[] classesThatCanExit = new String[]{ElasticsearchUncaughtExceptionHandler.PrivilegedHaltAction.class.getName().replace("$", "\\$"), Command.class.getName()};
        System.setSecurityManager((SecurityManager)new SecureSM(classesThatCanExit));
        Security.selfTest();
    }

    @SuppressForbidden(reason="proper use of URL")
    static Map<String, Policy> getPluginPermissions(Environment environment) throws IOException, NoSuchAlgorithmException {
        Throwable throwable;
        DirectoryStream<Path> stream;
        HashMap<String, Policy> map = new HashMap<String, Policy>();
        LinkedHashSet<Path> pluginsAndModules = new LinkedHashSet<Path>();
        if (Files.exists(environment.pluginsFile(), new LinkOption[0])) {
            stream = Files.newDirectoryStream(environment.pluginsFile());
            throwable = null;
            try {
                for (Path plugin : stream) {
                    if (pluginsAndModules.add(plugin)) continue;
                    throw new IllegalStateException("duplicate plugin: " + plugin);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        if (Files.exists(environment.modulesFile(), new LinkOption[0])) {
            stream = Files.newDirectoryStream(environment.modulesFile());
            throwable = null;
            try {
                for (Path module : stream) {
                    if (pluginsAndModules.add(module)) continue;
                    throw new IllegalStateException("duplicate module: " + module);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        for (Path plugin : pluginsAndModules) {
            Path policyFile = plugin.resolve("plugin-security.policy");
            if (!Files.exists(policyFile, new LinkOption[0])) continue;
            LinkedHashSet<URL> codebases = new LinkedHashSet<URL>();
            DirectoryStream<Path> jarStream = Files.newDirectoryStream(plugin, "*.jar");
            Object object = null;
            try {
                for (Path jar : jarStream) {
                    URL url = jar.toRealPath(new LinkOption[0]).toUri().toURL();
                    if (codebases.add(url)) continue;
                    throw new IllegalStateException("duplicate module/plugin: " + url);
                }
            }
            catch (Throwable throwable6) {
                object = throwable6;
                throw throwable6;
            }
            finally {
                if (jarStream != null) {
                    if (object != null) {
                        try {
                            jarStream.close();
                        }
                        catch (Throwable throwable7) {
                            ((Throwable)object).addSuppressed(throwable7);
                        }
                    } else {
                        jarStream.close();
                    }
                }
            }
            Policy policy = Security.readPolicy(policyFile.toUri().toURL(), codebases);
            for (URL url : codebases) {
                if (map.put(url.getFile(), policy) == null) continue;
                throw new IllegalStateException("per-plugin permissions already granted for jar file: " + url);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Policy readPolicy(URL policyFile, Set<URL> codebases) {
        Policy policy;
        ArrayList<String> propertiesSet = new ArrayList<String>();
        try {
            for (URL url : codebases) {
                String shortName = PathUtils.get(url.toURI()).getFileName().toString();
                if (!shortName.endsWith(".jar")) continue;
                String property = "codebase." + shortName;
                if (shortName.startsWith("elasticsearch-rest-client")) {
                    String esVersion = Version.CURRENT + (Build.CURRENT.isSnapshot() ? "-SNAPSHOT" : "");
                    int index = property.indexOf("-" + esVersion + ".jar");
                    assert (index >= 0);
                    String restClientAlias = property.substring(0, index);
                    propertiesSet.add(restClientAlias);
                    System.setProperty(restClientAlias, url.toString());
                }
                propertiesSet.add(property);
                String previous = System.setProperty(property, url.toString());
                if (previous == null) continue;
                throw new IllegalStateException("codebase property already set: " + shortName + "->" + previous);
            }
            policy = Policy.getInstance("JavaPolicy", new URIParameter(policyFile.toURI()));
        }
        catch (Throwable throwable) {
            try {
                for (String property : propertiesSet) {
                    System.clearProperty(property);
                }
                throw throwable;
            }
            catch (URISyntaxException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("unable to parse policy file `" + policyFile + "`", e);
            }
        }
        for (String property : propertiesSet) {
            System.clearProperty(property);
        }
        return policy;
    }

    static Permissions createPermissions(Environment environment) throws IOException {
        Permissions policy = new Permissions();
        Security.addClasspathPermissions(policy);
        Security.addFilePermissions(policy, environment);
        Security.addBindPermissions(policy, environment.settings());
        return policy;
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static void addClasspathPermissions(Permissions policy) throws IOException {
        for (URL url : JarHell.parseClassPath()) {
            Path path;
            try {
                path = PathUtils.get(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                FilePermissionUtils.addDirectoryPath(policy, "class.path", path, "read,readlink");
                continue;
            }
            FilePermissionUtils.addSingleFilePath(policy, path, "read,readlink");
        }
    }

    static void addFilePermissions(Permissions policy, Environment environment) throws IOException {
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.binFile(), "read,readlink");
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.libFile(), "read,readlink");
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.modulesFile(), "read,readlink");
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.pluginsFile(), "read,readlink");
        FilePermissionUtils.addDirectoryPath(policy, "path.conf'", environment.configFile(), "read,readlink");
        FilePermissionUtils.addDirectoryPath(policy, "java.io.tmpdir", environment.tmpFile(), "read,readlink,write,delete");
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_LOGS_SETTING.getKey(), environment.logsFile(), "read,readlink,write,delete");
        if (environment.sharedDataFile() != null) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_SHARED_DATA_SETTING.getKey(), environment.sharedDataFile(), "read,readlink,write,delete");
        }
        HashSet<Path> dataFilesPaths = new HashSet<Path>();
        for (Path path : environment.dataFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete");
            try {
                Path realPath = path.toRealPath(new LinkOption[0]);
                if (dataFilesPaths.add(realPath)) continue;
                throw new IllegalStateException("path [" + realPath + "] is duplicated by [" + path + "]");
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to access [" + path + "]", e);
            }
        }
        for (Path path : environment.repoFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_REPO_SETTING.getKey(), path, "read,readlink,write,delete");
        }
        if (environment.pidFile() != null) {
            FilePermissionUtils.addSingleFilePath(policy, environment.pidFile(), "delete");
        }
    }

    private static void addBindPermissions(Permissions policy, Settings settings) {
        Security.addSocketPermissionForHttp(policy, settings);
        Security.addSocketPermissionForTransportProfiles(policy, settings);
        Security.addSocketPermissionForTribeNodes(policy, settings);
    }

    private static void addSocketPermissionForHttp(Permissions policy, Settings settings) {
        String httpRange = HttpTransportSettings.SETTING_HTTP_PORT.get(settings).getPortRangeString();
        Security.addSocketPermissionForPortRange(policy, httpRange);
    }

    private static void addSocketPermissionForTransportProfiles(Permissions policy, Settings settings) {
        Set<TcpTransport.ProfileSettings> profiles = TcpTransport.getProfileSettings(settings);
        HashSet<String> uniquePortRanges = new HashSet<String>();
        for (TcpTransport.ProfileSettings profile : profiles) {
            if (!uniquePortRanges.add(profile.portOrRange)) continue;
            Security.addSocketPermissionForPortRange(policy, profile.portOrRange);
        }
    }

    private static void addSocketPermissionForTransport(Permissions policy, Settings settings) {
        String transportRange = TcpTransport.PORT.get(settings);
        Security.addSocketPermissionForPortRange(policy, transportRange);
    }

    private static void addSocketPermissionForTribeNodes(Permissions policy, Settings settings) {
        for (Settings tribeNodeSettings : settings.getGroups("tribe", true).values()) {
            if (NetworkModule.HTTP_ENABLED.exists(tribeNodeSettings) && NetworkModule.HTTP_ENABLED.get(tribeNodeSettings).booleanValue()) {
                Security.addSocketPermissionForHttp(policy, tribeNodeSettings);
            }
            Security.addSocketPermissionForTransport(policy, tribeNodeSettings);
        }
    }

    private static void addSocketPermissionForPortRange(Permissions policy, String portRange) {
        policy.add(new SocketPermission("*:" + portRange, "listen,resolve"));
    }

    static void ensureDirectoryExists(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path.getFileSystem().provider().checkAccess(path.toRealPath(new LinkOption[0]), AccessMode.READ);
        } else {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                NotDirectoryException e2 = new NotDirectoryException(path.toString());
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    @SuppressForbidden(reason="accesses jvm default tempdir as a self-test")
    static void selfTest() throws IOException {
        try {
            Path p = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                Files.delete(p);
            }
            catch (IOException iOException) {}
        }
        catch (SecurityException problem) {
            throw new SecurityException("Security misconfiguration: cannot access java.io.tmpdir", problem);
        }
    }
}

