/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;

public class SynonymTokenFilterFactory
extends AbstractTokenFilterFactory {
    @Deprecated
    protected final boolean ignoreCase;
    protected final String format;
    protected final boolean expand;
    protected final Settings settings;
    @Deprecated
    protected final TokenizerFactory tokenizerFactory;

    public SynonymTokenFilterFactory(IndexSettings indexSettings, Environment env, AnalysisRegistry analysisRegistry, String name, Settings settings) throws IOException {
        super(indexSettings, name, settings);
        this.settings = settings;
        this.ignoreCase = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "ignore_case", false, this.deprecationLogger);
        if (indexSettings.getIndexVersionCreated().onOrAfter(Version.V_6_0_0_beta1) && settings.get("ignore_case") != null) {
            this.deprecationLogger.deprecated("This tokenize synonyms with whatever tokenizer and token filters appear before it in the chain. If you need ignore case with this filter, you should set lowercase filter before this", new Object[0]);
        }
        this.expand = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "expand", true, this.deprecationLogger);
        if (indexSettings.getIndexVersionCreated().before(Version.V_6_0_0_beta1)) {
            TokenizerFactory tokenizerFactory;
            String tokenizerName = settings.get("tokenizer", "whitespace");
            AnalysisModule.AnalysisProvider<TokenizerFactory> tokenizerFactoryFactory = analysisRegistry.getTokenizerProvider(tokenizerName, indexSettings);
            if (tokenizerFactoryFactory == null) {
                throw new IllegalArgumentException("failed to find tokenizer [" + tokenizerName + "] for synonym token filter");
            }
            this.tokenizerFactory = tokenizerFactory = tokenizerFactoryFactory.get(indexSettings, env, tokenizerName, AnalysisRegistry.getSettingsFromIndexSettings(indexSettings, "index.analysis.tokenizer." + tokenizerName));
        } else {
            this.tokenizerFactory = null;
        }
        this.format = settings.get("format", "");
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        throw new IllegalStateException("Call createPerAnalyzerSynonymFactory to specialize this factory for an analysis chain first");
    }

    protected Reader getRulesFromSettings(Environment env) {
        Reader rulesReader;
        if (this.settings.getAsArray("synonyms", null) != null) {
            List<String> rulesList = Analysis.getWordList(env, this.settings, "synonyms");
            StringBuilder sb = new StringBuilder();
            for (String line : rulesList) {
                sb.append(line).append(System.lineSeparator());
            }
            rulesReader = new FastStringReader(sb.toString());
        } else if (this.settings.get("synonyms_path") != null) {
            rulesReader = Analysis.getReaderFromFile(env, this.settings, "synonyms_path");
        } else {
            throw new IllegalArgumentException("synonym requires either `synonyms` or `synonyms_path` to be configured");
        }
        return rulesReader;
    }

    Factory createPerAnalyzerSynonymFactory(Analyzer analyzerForParseSynonym, Environment env) {
        return new Factory("synonym", analyzerForParseSynonym, this.getRulesFromSettings(env));
    }

    public class Factory
    implements TokenFilterFactory {
        private final String name;
        private final SynonymMap synonymMap;

        public Factory(String name, Analyzer analyzerForParseSynonym, Reader rulesReader) {
            this.name = name;
            Analyzer analyzer = SynonymTokenFilterFactory.this.tokenizerFactory != null ? new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    Tokenizer tokenizer = SynonymTokenFilterFactory.this.tokenizerFactory.create();
                    Tokenizer stream = SynonymTokenFilterFactory.this.ignoreCase ? new LowerCaseFilter((TokenStream)tokenizer) : tokenizer;
                    return new Analyzer.TokenStreamComponents(tokenizer, (TokenStream)stream);
                }
            } : analyzerForParseSynonym;
            try {
                WordnetSynonymParser parser;
                if ("wordnet".equalsIgnoreCase(SynonymTokenFilterFactory.this.format)) {
                    parser = new WordnetSynonymParser(true, SynonymTokenFilterFactory.this.expand, analyzer);
                    parser.parse(rulesReader);
                } else {
                    parser = new SolrSynonymParser(true, SynonymTokenFilterFactory.this.expand, analyzer);
                    ((SolrSynonymParser)parser).parse(rulesReader);
                }
                this.synonymMap = parser.build();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to build synonyms", e);
            }
            finally {
                if (SynonymTokenFilterFactory.this.tokenizerFactory != null) {
                    analyzer.close();
                }
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public TokenStream create(TokenStream tokenStream) {
            return this.synonymMap.fst == null ? tokenStream : new SynonymFilter(tokenStream, this.synonymMap, SynonymTokenFilterFactory.this.ignoreCase);
        }
    }
}

