/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.BlockParent;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockContainerLayoutManager;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.util.ListUtil;

public class FlowLayoutManager
extends BlockStackingLayoutManager {
    private static Log log = LogFactory.getLog(FlowLayoutManager.class);
    private final BlockParent[] currentAreas = new BlockParent[6];
    private boolean handlingFloat;

    public FlowLayoutManager(PageSequenceLayoutManager pslm, Flow node) {
        super(node);
        this.setGeneratesBlockArea(true);
        this.setParent(pslm);
    }

    @Override
    public List getNextKnuthElements(LayoutContext context, int alignment) {
        return this.getNextKnuthElements(context, alignment, null, null);
    }

    List getNextKnuthElements(LayoutContext context, int alignment, Position restartPosition, LayoutManager restartLM) {
        LayoutManager currentChildLM;
        boolean isRestart;
        LinkedList<ListElement> elements = new LinkedList<ListElement>();
        boolean doReset = isRestart = restartPosition != null;
        Stack<LayoutManager> lmStack = new Stack<LayoutManager>();
        if (isRestart) {
            currentChildLM = restartPosition.getLM();
            if (currentChildLM == null) {
                throw new IllegalStateException("Cannot find layout manager to restart from");
            }
            if (restartLM != null && restartLM.getParent() == this) {
                currentChildLM = restartLM;
            } else {
                while (currentChildLM.getParent() != this) {
                    lmStack.push(currentChildLM);
                    currentChildLM = currentChildLM.getParent();
                }
                doReset = false;
            }
            this.setCurrentChildLM(currentChildLM);
        } else {
            currentChildLM = this.getChildLM();
        }
        while (currentChildLM != null) {
            if (!isRestart || doReset) {
                if (doReset) {
                    currentChildLM.reset();
                }
                if (this.addChildElements(elements, currentChildLM, context, alignment, null, null, null) != null) {
                    return elements;
                }
            } else {
                if (this.addChildElements(elements, currentChildLM, context, alignment, lmStack, restartPosition, restartLM) != null) {
                    return elements;
                }
                doReset = true;
            }
            currentChildLM = this.getChildLM();
        }
        SpaceResolver.resolveElementList(elements);
        this.setFinished(true);
        assert (!elements.isEmpty());
        return elements;
    }

    private List<ListElement> addChildElements(List<ListElement> elements, LayoutManager childLM, LayoutContext context, int alignment, Stack<LayoutManager> lmStack, Position position, LayoutManager restartAtLM) {
        if (this.handleSpanChange(childLM, context)) {
            SpaceResolver.resolveElementList(elements);
            return elements;
        }
        LayoutContext childLC = this.makeChildLayoutContext(context);
        List<ListElement> childElements = this.getNextChildElements(childLM, context, childLC, alignment, lmStack, position, restartAtLM);
        if (elements.isEmpty()) {
            context.updateKeepWithPreviousPending(childLC.getKeepWithPreviousPending());
        }
        if (!elements.isEmpty() && !ElementListUtils.startsWithForcedBreak(childElements)) {
            this.addInBetweenBreak(elements, context, childLC);
        }
        context.updateKeepWithNextPending(childLC.getKeepWithNextPending());
        elements.addAll(childElements);
        if (ElementListUtils.endsWithForcedBreak(elements)) {
            if (childLM.isFinished() && !this.hasNextChildLM()) {
                this.setFinished(true);
            }
            SpaceResolver.resolveElementList(elements);
            return elements;
        }
        return null;
    }

    private boolean handleSpanChange(LayoutManager childLM, LayoutContext context) {
        int span = 95;
        int disableColumnBalancing = 48;
        if (childLM instanceof BlockLayoutManager) {
            span = ((BlockLayoutManager)childLM).getBlockFO().getSpan();
            disableColumnBalancing = ((BlockLayoutManager)childLM).getBlockFO().getDisableColumnBalancing();
        } else if (childLM instanceof BlockContainerLayoutManager) {
            span = ((BlockContainerLayoutManager)childLM).getBlockContainerFO().getSpan();
            disableColumnBalancing = ((BlockContainerLayoutManager)childLM).getBlockContainerFO().getDisableColumnBalancing();
        }
        int currentSpan = context.getCurrentSpan();
        if (currentSpan != span) {
            if (span == 5) {
                context.setDisableColumnBalancing(disableColumnBalancing);
            }
            log.debug((Object)("span change from " + currentSpan + " to " + span));
            context.signalSpanChange(span);
            return true;
        }
        return false;
    }

    @Override
    protected LayoutContext makeChildLayoutContext(LayoutContext context) {
        LayoutContext childLC = LayoutContext.newInstance();
        childLC.setStackLimitBP(context.getStackLimitBP());
        childLC.setRefIPD(context.getRefIPD());
        childLC.setWritingMode(this.getCurrentPage().getSimplePageMaster().getWritingMode());
        return childLC;
    }

    @Override
    protected List<ListElement> getNextChildElements(LayoutManager childLM, LayoutContext context, LayoutContext childLC, int alignment, Stack<LayoutManager> lmStack, Position restartPosition, LayoutManager restartLM) {
        List<ListElement> childElements = lmStack == null ? childLM.getNextKnuthElements(childLC, alignment) : childLM.getNextKnuthElements(childLC, alignment, lmStack, restartPosition, restartLM);
        assert (!childElements.isEmpty());
        LinkedList<ListElement> tempList = childElements;
        childElements = new LinkedList<ListElement>();
        this.wrapPositionElements(tempList, childElements);
        return childElements;
    }

    @Override
    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        log.debug((Object)(" FLM.negotiateBPDAdjustment> " + adj));
        Position lastPosition = lastElement.getPosition();
        if (lastPosition instanceof NonLeafPosition) {
            NonLeafPosition savedPos = (NonLeafPosition)lastPosition;
            lastElement.setPosition(savedPos.getPosition());
            int returnValue = ((BlockLevelLayoutManager)lastElement.getLayoutManager()).negotiateBPDAdjustment(adj, lastElement);
            lastElement.setPosition(savedPos);
            log.debug((Object)(" FLM.negotiateBPDAdjustment> result " + returnValue));
            return returnValue;
        }
        return 0;
    }

    @Override
    public void discardSpace(KnuthGlue spaceGlue) {
        log.debug((Object)" FLM.discardSpace> ");
        Position gluePosition = spaceGlue.getPosition();
        if (gluePosition instanceof NonLeafPosition) {
            NonLeafPosition savedPos = (NonLeafPosition)gluePosition;
            spaceGlue.setPosition(savedPos.getPosition());
            ((BlockLevelLayoutManager)spaceGlue.getLayoutManager()).discardSpace(spaceGlue);
            spaceGlue.setPosition(savedPos);
        }
    }

    @Override
    public Keep getKeepTogether() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public List<KnuthElement> getChangedKnuthElements(List oldList, int alignment) {
        ListIterator oldListIterator = oldList.listIterator();
        LinkedList<KnuthPenalty> returnedList = new LinkedList<KnuthPenalty>();
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        ListElement prevElement = null;
        KnuthElement currElement = null;
        int fromIndex = 0;
        while (oldListIterator.hasNext()) {
            KnuthElement oldElement = (KnuthElement)oldListIterator.next();
            if (oldElement.getPosition() instanceof NonLeafPosition) {
                oldElement.setPosition(oldElement.getPosition().getPosition());
                continue;
            }
            oldListIterator.remove();
        }
        oldListIterator = oldList.listIterator();
        while (oldListIterator.hasNext()) {
            currElement = (KnuthElement)oldListIterator.next();
            if (prevElement != null && prevElement.getLayoutManager() != currElement.getLayoutManager()) {
                BlockLevelLayoutManager prevLM = (BlockLevelLayoutManager)prevElement.getLayoutManager();
                BlockLevelLayoutManager blockLevelLayoutManager = (BlockLevelLayoutManager)currElement.getLayoutManager();
                returnedList.addAll(prevLM.getChangedKnuthElements(oldList.subList(fromIndex, oldListIterator.previousIndex()), alignment));
                fromIndex = oldListIterator.previousIndex();
                if (prevLM.mustKeepWithNext() || blockLevelLayoutManager.mustKeepWithPrevious()) {
                    returnedList.add(new KnuthPenalty(0, 1000, false, new Position(this), false));
                } else if (!((KnuthElement)ListUtil.getLast(returnedList)).isGlue()) {
                    returnedList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
            }
            prevElement = currElement;
        }
        if (currElement != null) {
            BlockLevelLayoutManager currLM = (BlockLevelLayoutManager)currElement.getLayoutManager();
            returnedList.addAll(currLM.getChangedKnuthElements(oldList.subList(fromIndex, oldList.size()), alignment));
        }
        for (KnuthElement knuthElement : returnedList) {
            KnuthElement returnedElement = knuthElement;
            if (returnedElement.getLayoutManager() != this) {
                returnedElement.setPosition(new NonLeafPosition((LayoutManager)this, returnedElement.getPosition()));
            }
            returnList.add(returnedElement);
        }
        return returnList;
    }

    @Override
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.flush();
    }

    @Override
    public void addChildArea(Area childArea) {
        if (childArea instanceof BlockParent && this.handlingFloat()) {
            BlockParent bp = (BlockParent)childArea;
            bp.setXOffset(this.getPSLM().getStartIntrusionAdjustment());
        }
        this.getParentArea(childArea);
        this.addChildToArea(childArea, this.currentAreas[childArea.getAreaClass()]);
    }

    @Override
    public Area getParentArea(Area childArea) {
        BlockParent parentArea = null;
        int aclass = childArea.getAreaClass();
        if (aclass == 0 || aclass == 5) {
            parentArea = this.getCurrentPV().getCurrentFlow();
        } else if (aclass == 3) {
            parentArea = this.getCurrentPV().getBodyRegion().getBeforeFloat();
        } else if (aclass == 4) {
            parentArea = this.getCurrentPV().getBodyRegion().getFootnote();
        } else {
            throw new IllegalStateException("(internal error) Invalid area class (" + aclass + ") requested.");
        }
        this.currentAreas[aclass] = parentArea;
        this.setCurrentArea(parentArea);
        return parentArea;
    }

    @Override
    public int getContentAreaIPD() {
        int flowIPD = this.getPSLM().getCurrentColumnWidth();
        return flowIPD;
    }

    @Override
    public int getContentAreaBPD() {
        return this.getCurrentPV().getBodyRegion().getBPD();
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    public void handleFloatOn() {
        this.handlingFloat = true;
    }

    public void handleFloatOff() {
        this.handlingFloat = false;
    }

    @Override
    public boolean handlingFloat() {
        return this.handlingFloat;
    }
}

