/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.pdf.extensions.PDFActionExtension;
import org.apache.fop.render.pdf.extensions.PDFArrayExtension;
import org.apache.fop.render.pdf.extensions.PDFCatalogExtension;
import org.apache.fop.render.pdf.extensions.PDFCollectionEntryExtension;
import org.apache.fop.render.pdf.extensions.PDFCollectionExtension;
import org.apache.fop.render.pdf.extensions.PDFDictionaryAttachment;
import org.apache.fop.render.pdf.extensions.PDFDictionaryExtension;
import org.apache.fop.render.pdf.extensions.PDFDictionaryType;
import org.apache.fop.render.pdf.extensions.PDFDocumentInformationExtension;
import org.apache.fop.render.pdf.extensions.PDFEmbeddedFileAttachment;
import org.apache.fop.render.pdf.extensions.PDFExtensionAttachment;
import org.apache.fop.render.pdf.extensions.PDFLayerExtension;
import org.apache.fop.render.pdf.extensions.PDFNavigatorExtension;
import org.apache.fop.render.pdf.extensions.PDFObjectType;
import org.apache.fop.render.pdf.extensions.PDFPageExtension;
import org.apache.fop.render.pdf.extensions.PDFPagePieceExtension;
import org.apache.fop.render.pdf.extensions.PDFReferenceExtension;
import org.apache.fop.render.pdf.extensions.PDFVTExtension;
import org.apache.fop.util.ContentHandlerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class PDFExtensionHandler
extends DefaultHandler
implements ContentHandlerFactory.ObjectSource {
    protected static final Log log = LogFactory.getLog(PDFExtensionHandler.class);
    private PDFExtensionAttachment returnedObject;
    private ContentHandlerFactory.ObjectBuiltListener listener;
    private Attributes lastAttributes;
    private Stack<PDFCollectionExtension> collections = new Stack();
    private boolean captureContent;
    private StringBuffer characters;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("apache:fop:extensions:pdf".equals(uri)) {
            if (localName.equals("embedded-file")) {
                this.lastAttributes = new AttributesImpl(attributes);
                return;
            } else if (PDFDictionaryType.Action.elementName().equals(localName)) {
                String type;
                PDFActionExtension action = new PDFActionExtension();
                String id = attributes.getValue("id");
                if (id != null) {
                    action.setProperty("id", id);
                }
                if ((type = attributes.getValue("type")) != null) {
                    action.setProperty("type", type);
                }
                this.collections.push(action);
                return;
            } else if (PDFObjectType.Array.elementName().equals(localName)) {
                PDFArrayExtension array = new PDFArrayExtension();
                String key = attributes.getValue("key");
                if (key != null) {
                    array.setKey(key);
                }
                this.collections.push(array);
                return;
            } else if (PDFDictionaryType.Catalog.elementName().equals(localName)) {
                PDFCatalogExtension catalog = new PDFCatalogExtension();
                this.collections.push(catalog);
                return;
            } else if (PDFDictionaryType.Dictionary.elementName().equals(localName)) {
                PDFDictionaryExtension dictionary = new PDFDictionaryExtension();
                String key = attributes.getValue("key");
                if (key != null) {
                    dictionary.setKey(key);
                }
                this.collections.push(dictionary);
                return;
            } else if (PDFDictionaryType.Layer.elementName().equals(localName)) {
                PDFLayerExtension layer = new PDFLayerExtension();
                String id = attributes.getValue("id");
                if (id != null) {
                    layer.setProperty("id", id);
                }
                this.collections.push(layer);
                return;
            } else if (PDFDictionaryType.Navigator.elementName().equals(localName)) {
                PDFNavigatorExtension navigator = new PDFNavigatorExtension();
                String id = attributes.getValue("id");
                if (id != null) {
                    navigator.setProperty("id", id);
                }
                this.collections.push(navigator);
                return;
            } else if (PDFDictionaryType.Page.elementName().equals(localName)) {
                PDFPageExtension page = new PDFPageExtension();
                String pageNumbers = attributes.getValue("page-numbers");
                if (pageNumbers != null) {
                    page.setProperty("page-numbers", pageNumbers);
                }
                this.collections.push(page);
                return;
            } else if (PDFDictionaryType.Info.elementName().equals(localName)) {
                PDFDocumentInformationExtension info = new PDFDocumentInformationExtension();
                this.collections.push(info);
                return;
            } else if (PDFDictionaryType.VT.elementName().equals(localName)) {
                PDFVTExtension dictionary = new PDFVTExtension();
                this.collections.push(dictionary);
                return;
            } else if (PDFDictionaryType.PagePiece.elementName().equals(localName)) {
                PDFPagePieceExtension dictionary = new PDFPagePieceExtension();
                this.collections.push(dictionary);
                return;
            } else {
                String refid;
                if (!PDFObjectType.hasValueOfElementName(localName)) throw new SAXException("Unhandled element " + localName + " in namespace: " + uri);
                PDFCollectionEntryExtension entry = PDFObjectType.Reference.elementName().equals(localName) ? new PDFReferenceExtension() : new PDFCollectionEntryExtension(PDFObjectType.valueOfElementName(localName));
                String key = attributes.getValue("key");
                if (key != null) {
                    entry.setKey(key);
                }
                if (entry instanceof PDFReferenceExtension && (refid = attributes.getValue("refid")) != null) {
                    ((PDFReferenceExtension)entry).setReferenceId(refid);
                }
                if (this.collections.empty()) return;
                PDFCollectionExtension collection = this.collections.peek();
                collection.addEntry(entry);
                if (entry instanceof PDFReferenceExtension) return;
                this.captureContent = true;
            }
            return;
        } else {
            log.warn((Object)("Unhandled element " + localName + " in namespace: " + uri));
        }
    }

    @Override
    public void characters(char[] data, int start, int length) throws SAXException {
        if (this.captureContent) {
            if (this.characters == null) {
                this.characters = new StringBuffer(length < 16 ? 16 : length);
            }
            this.characters.append(data, start, length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("apache:fop:extensions:pdf".equals(uri)) {
            if ("embedded-file".equals(localName)) {
                String name = this.lastAttributes.getValue("filename");
                String src = this.lastAttributes.getValue("src");
                String desc = this.lastAttributes.getValue("description");
                this.lastAttributes = null;
                this.returnedObject = new PDFEmbeddedFileAttachment(name, src, desc);
            } else if (PDFDictionaryType.hasValueOfElementName(localName)) {
                if (this.collections.empty() || !(this.collections.peek() instanceof PDFDictionaryExtension)) throw new SAXException(new IllegalStateException("collections stack is empty or not a dictionary"));
                PDFDictionaryExtension dictionary = (PDFDictionaryExtension)this.collections.pop();
                if (!this.collections.empty()) {
                    PDFCollectionExtension collectionOuter = this.collections.peek();
                    collectionOuter.addEntry(dictionary);
                } else {
                    if (dictionary.getDictionaryType() == PDFDictionaryType.Dictionary) throw new SAXException(new IllegalStateException("generic dictionary not permitted at outer level"));
                    this.returnedObject = new PDFDictionaryAttachment(dictionary);
                }
            } else if (PDFObjectType.Array.elementName().equals(localName)) {
                if (this.collections.empty() || !(this.collections.peek() instanceof PDFArrayExtension)) throw new SAXException(new IllegalStateException("collections stack is empty or not an array"));
                PDFArrayExtension array = (PDFArrayExtension)this.collections.pop();
                if (this.collections.empty()) throw new SAXException(new IllegalStateException("array not permitted at outer level"));
                PDFCollectionExtension collectionOuter = this.collections.peek();
                collectionOuter.addEntry(array);
            } else if (PDFObjectType.hasValueOfElementName(localName)) {
                if (this.collections.empty()) throw new SAXException(new IllegalStateException("entry not permitted at outer level"));
                PDFCollectionExtension collection = this.collections.peek();
                PDFCollectionEntryExtension entry = collection.getLastEntry();
                if (entry == null) throw new SAXException(new IllegalStateException("no current entry"));
                if (this.characters != null) {
                    entry.setValue(this.characters.toString());
                    this.characters = null;
                }
            }
        }
        this.captureContent = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.listener != null) {
            this.listener.notifyObjectBuilt(this.getObject());
        }
    }

    @Override
    public Object getObject() {
        return this.returnedObject;
    }

    @Override
    public void setObjectBuiltListener(ContentHandlerFactory.ObjectBuiltListener listener) {
        this.listener = listener;
    }
}

