/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class Flag {
    public static final int WIDTH = 150;
    public static final int HEIGHT = 100;
    public static final double SQRT_3 = Math.sqrt(3.0);
    public static final double DECORATION_SIZE = 14.285714285714286;
    public static final double CHEVRON_X = SQRT_3 * 100.0 / 2.0;
    public static final double STAR_SIZE = 7.000000000000001;
    public static final double CROSS_OFFSET = 28.571428571428573;
    public static final double BEND_X = 14.285714285714286;
    public static final double BEND_Y = 14.285714285714286 / SQRT_3;
    private static final GeneralPath star = Flag.getStar();
    private static final int[][] layout = new int[51][2];
    private List<Color> backgroundColors = new ArrayList<Color>();
    private Color unionColor = Color.BLUE;
    private Color starColor = Color.WHITE;
    private Color decorationColor = Color.WHITE;
    private Background background = Background.FESSES;
    private Decoration decoration = Decoration.NONE;
    private UnionShape unionShape = UnionShape.RECTANGLE;
    private UnionPosition unionPosition = UnionPosition.CANTON;
    private int stars = 13;
    private int stripes = 13;

    public Flag(Background background, Decoration decoration, UnionPosition unionPosition) {
        this(background, decoration, unionPosition, UnionShape.RECTANGLE);
    }

    public Flag(Background background, Decoration decoration, UnionPosition unionPosition, UnionShape unionShape) {
        this.background = background;
        this.decoration = decoration;
        this.unionPosition = unionPosition;
        this.unionShape = unionShape;
    }

    public Background getBackground() {
        return this.background;
    }

    public Flag setBackground(Background background) {
        this.background = background;
        return this;
    }

    public Decoration getDecoration() {
        return this.decoration;
    }

    public Flag setDecoration(Decoration decoration) {
        this.decoration = decoration;
        return this;
    }

    public UnionPosition getUnionPosition() {
        return this.unionPosition;
    }

    public Flag setUnionPosition(UnionPosition position) {
        this.unionPosition = position;
        return this;
    }

    public UnionShape getUnionShape() {
        return this.unionShape;
    }

    public Flag setUnionShape(UnionShape shape) {
        this.unionShape = shape;
        return this;
    }

    public List<Color> getBackgroundColors() {
        return this.backgroundColors;
    }

    public Flag setBackgroundColors(List<Color> backgroundColors) {
        this.backgroundColors = backgroundColors;
        return this;
    }

    public Flag setBackgroundColors(Color ... colors) {
        this.backgroundColors.clear();
        for (Color color : colors) {
            if (color == null) continue;
            this.backgroundColors.add(color);
        }
        return this;
    }

    public Color getUnionColor() {
        return this.unionColor;
    }

    public Flag setUnionColor(Color unionColor) {
        this.unionColor = unionColor;
        return this;
    }

    public Color getDecorationColor() {
        return this.decorationColor;
    }

    public Flag setDecorationColor(Color decorationColor) {
        this.decorationColor = decorationColor;
        return this;
    }

    public Color getStarColor() {
        return this.starColor;
    }

    public Flag setStarColor(Color starColor) {
        this.starColor = starColor;
        return this;
    }

    public int getStars() {
        return this.stars;
    }

    public Flag setStars(int stars) {
        this.stars = stars;
        return this;
    }

    public int getStripes() {
        return this.stripes;
    }

    public Flag setStripes(int stripes) {
        this.stripes = stripes;
        return this;
    }

    public BufferedImage getImage() {
        BufferedImage image = new BufferedImage(150, 100, 1);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.backgroundColors.isEmpty()) {
            this.backgroundColors.add(Color.BLACK);
        }
        switch (this.background) {
            case FESSES: 
            case PALES: {
                if (this.stripes < 1) {
                    this.drawBackground(g);
                    break;
                }
                this.drawStripes(g, this.background.alignment, this.stripes);
                break;
            }
            case PLAIN: {
                this.drawBackground(g);
                break;
            }
            case QUARTERLY: {
                this.drawQuarters(g);
                break;
            }
            case PER_BEND: {
                this.drawPerBend(g, false);
                break;
            }
            case PER_BEND_SINISTER: {
                this.drawPerBend(g, true);
                break;
            }
            case PER_SALTIRE: {
                this.drawPerSaltire(g);
                break;
            }
        }
        GeneralPath decorationShape = null;
        switch (this.decoration) {
            case GREEK_CROSS: 
            case CROSS: 
            case SCANDINAVIAN_CROSS: {
                decorationShape = this.getCross(this.decoration);
                break;
            }
            case CHEVRON: {
                decorationShape = this.getTriangle(UnionShape.CHEVRON, false);
                break;
            }
            case PALL: {
                decorationShape = this.getPall();
                break;
            }
            case BEND: {
                decorationShape = this.getBend(false);
                break;
            }
            case BEND_SINISTER: {
                decorationShape = this.getBend(true);
                break;
            }
            case SALTIRE: {
                decorationShape = this.getBend(true);
                decorationShape.append(this.getBend(false), false);
                break;
            }
            case SALTIRE_AND_CROSS: {
                decorationShape = this.getBend(true);
                decorationShape.append(this.getBend(false), false);
                decorationShape.append(this.getCross(Decoration.CROSS), false);
                break;
            }
        }
        if (decorationShape != null) {
            g.setColor(this.decorationColor);
            g.fill(decorationShape);
        }
        if (this.unionPosition == null || this.unionPosition == UnionPosition.NONE) {
            return image;
        }
        GeneralPath union = null;
        GeneralPath starShape = null;
        if (this.unionShape == null && this.decoration != null) {
            this.unionShape = this.decoration.unionShape;
        }
        switch (this.unionShape) {
            case RECTANGLE: {
                Rectangle2D.Double rectangle = this.getRectangle();
                union = new GeneralPath(rectangle);
                starShape = this.getUnionRectangle(rectangle);
                break;
            }
            case CHEVRON: {
                union = this.getTriangle(this.unionShape, this.decoration == Decoration.PALL);
                starShape = this.getUnionTriangle(true);
                break;
            }
            case BEND: {
                union = this.getTriangle(this.unionShape, this.decoration == Decoration.BEND || this.decoration == Decoration.BEND_SINISTER);
                starShape = this.getUnionTriangle(false);
                this.transformBend(union);
                this.transformBend(starShape);
                break;
            }
            case RHOMBUS: {
                union = this.getRhombus();
                starShape = this.getUnionRhombus();
                break;
            }
            case TRIANGLE: {
                union = this.getTriangle(this.unionShape, this.decoration == Decoration.SALTIRE);
                starShape = this.getUnionTriangle(true);
                this.transformTriangle(union);
                this.transformTriangle(starShape);
                break;
            }
        }
        if (union != null && this.unionColor != null) {
            g.setColor(this.unionColor);
            g.fill(union);
        }
        if (starShape != null) {
            g.setColor(this.starColor);
            g.fill(starShape);
        }
        g.dispose();
        return image;
    }

    private GeneralPath getUnionRectangle(Rectangle2D.Double union) {
        GeneralPath unionPath;
        if (union == null) {
            return null;
        }
        if (this.stars < 14) {
            double radius = 0.3 * Math.min(union.height, union.width);
            unionPath = this.getCircleOfStars(radius);
        } else {
            unionPath = this.getGridOfStars(union);
        }
        double x = union.x + union.width / 2.0;
        double y = union.y + union.height / 2.0;
        this.center(unionPath, x, y);
        return unionPath;
    }

    private GeneralPath getUnionTriangle(boolean isosceles) {
        boolean small = this.decoration == Decoration.PALL || this.decoration == Decoration.BEND || this.decoration == Decoration.BEND_SINISTER;
        double x = 0.0;
        double y = 0.0;
        double r = 0.0;
        if (this.unionShape == UnionShape.CHEVRON) {
            x = CHEVRON_X;
            y = 100.0;
            if (small) {
                x -= 14.285714285714286;
                y -= 2.0 * BEND_Y;
            }
            r = SQRT_3 * y / 6.0;
        } else if (this.unionShape == UnionShape.TRIANGLE) {
            if (this.unionPosition == UnionPosition.LEFT || this.unionPosition == UnionPosition.RIGHT) {
                x = 75.0;
                y = 100.0;
                if (small) {
                    x -= 14.285714285714286;
                    y -= 2.0 * BEND_Y;
                }
                r = SQRT_3 * y / 6.0;
            } else {
                x = 50.0;
                y = 150.0;
                if (small) {
                    x -= BEND_Y;
                    y -= 28.571428571428573;
                }
                double h = y / 2.0;
                double c = Math.sqrt(h * h + x * x);
                r = x * y / (y + 2.0 * c);
            }
        } else {
            x = 150.0;
            y = 100.0;
            if (small) {
                x -= 14.285714285714286;
                y -= BEND_Y;
            }
            double c = Math.sqrt(x * x + y * y);
            double A = x * y / 2.0;
            r = 2.0 * A / (x + y + c);
        }
        double radius = r * 0.6;
        GeneralPath unionPath = new GeneralPath();
        if (this.stars < 14) {
            unionPath = this.getCircleOfStars(radius);
            if (isosceles) {
                if (this.unionPosition == UnionPosition.LEFT || this.unionPosition == UnionPosition.RIGHT) {
                    this.center(unionPath, r, 50.0);
                } else {
                    this.center(unionPath, r, 75.0);
                }
            } else {
                this.center(unionPath, r, r);
            }
        } else {
            int sum = 0;
            int rows = 1;
            while (sum < this.stars) {
                sum += rows;
                ++rows;
            }
            int missing = sum - this.stars;
            double slope = y / x;
            double dx = x / (double)rows;
            double xx = dx / 2.0;
            double height = y - xx * slope;
            double offset = 0.0;
            double dy = height / (double)(--rows);
            for (int index = rows; index > 0; --index) {
                if (isosceles) {
                    height = y - xx * slope;
                    dy = height / (double)index;
                    offset = (100.0 - height) / 2.0;
                }
                double yy = dy / 2.0;
                int count = index;
                if (missing > 0) {
                    count = index - missing;
                    yy += (double)(missing / 2) * dy;
                    missing = 0;
                }
                for (int star = 0; star < count; ++star) {
                    unionPath.append(this.getStar(xx, yy + offset), false);
                    yy += dy;
                }
                xx += dx;
            }
        }
        return unionPath;
    }

    private GeneralPath transformBend(GeneralPath triangle) {
        if (this.unionPosition == UnionPosition.TOP) {
            if (this.decoration == Decoration.BEND) {
                triangle.transform(AffineTransform.getScaleInstance(-1.0, 1.0));
                triangle.transform(AffineTransform.getTranslateInstance(150.0, 0.0));
            } else if (this.decoration == Decoration.BEND_SINISTER) {
                // empty if block
            }
        } else if (this.unionPosition == UnionPosition.BOTTOM) {
            if (this.decoration == Decoration.BEND) {
                triangle.transform(AffineTransform.getScaleInstance(1.0, -1.0));
                triangle.transform(AffineTransform.getTranslateInstance(0.0, 100.0));
            } else if (this.decoration == Decoration.BEND_SINISTER) {
                triangle.transform(AffineTransform.getQuadrantRotateInstance(2));
                triangle.transform(AffineTransform.getTranslateInstance(150.0, 100.0));
            }
        }
        return triangle;
    }

    private GeneralPath transformTriangle(GeneralPath triangle) {
        switch (this.unionPosition) {
            case TOP: {
                triangle.transform(AffineTransform.getQuadrantRotateInstance(1));
                triangle.transform(AffineTransform.getTranslateInstance(150.0, 0.0));
                break;
            }
            case BOTTOM: {
                triangle.transform(AffineTransform.getQuadrantRotateInstance(3));
                triangle.transform(AffineTransform.getTranslateInstance(0.0, 100.0));
                break;
            }
            case RIGHT: {
                triangle.transform(AffineTransform.getScaleInstance(-1.0, 1.0));
                triangle.transform(AffineTransform.getTranslateInstance(150.0, 0.0));
                break;
            }
        }
        return triangle;
    }

    private GeneralPath getUnionRhombus() {
        GeneralPath unionPath = new GeneralPath();
        int count = 1;
        int square = 1;
        while (square < this.stars) {
            square = ++count * count;
        }
        int rows = this.stars / count;
        if (rows * count < this.stars) {
            ++rows;
        }
        int starCount = 0;
        double a = 60.714285714285715;
        double b = 50.0 - BEND_Y;
        if (this.stars < 14) {
            double c = Math.sqrt(a * a + b * b);
            double r = a * b / c;
            double radius = 0.6 * r;
            unionPath = this.getCircleOfStars(radius);
            this.center(unionPath, 75.0, 50.0);
        } else {
            double dx = a / (double)count;
            double dy = b / (double)count;
            double dx1 = a / (double)rows;
            double dy1 = b / (double)rows;
            block1: for (int index = 0; index < rows; ++index) {
                double x = 14.285714285714286 + dx + (double)index * dx1;
                double y = 50.0 - (double)index * dy1;
                for (int star = 0; star < count; ++star) {
                    unionPath.append(this.getStar(x, y), false);
                    if (++starCount == this.stars) break block1;
                    x += dx;
                    y += dy;
                }
            }
        }
        return unionPath;
    }

    private double getStripeWidth(Alignment alignment) {
        return alignment == Alignment.HORIZONTAL ? 150.0 : 150.0 / (double)this.stripes;
    }

    private double getStripeHeight(Alignment alignment) {
        return alignment == Alignment.VERTICAL ? 100.0 : 100.0 / (double)this.stripes;
    }

    private void drawBackground(Graphics2D g) {
        g.setColor(this.backgroundColors.get(0));
        g.fillRect(0, 0, 150, 100);
    }

    private void drawStripes(Graphics2D g, Alignment alignment, int stripes) {
        int colors = this.backgroundColors.size();
        double stripeWidth = this.getStripeWidth(alignment);
        double stripeHeight = this.getStripeHeight(alignment);
        double x = alignment == Alignment.VERTICAL ? stripeWidth : 0.0;
        double y = alignment == Alignment.HORIZONTAL ? stripeHeight : 0.0;
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        for (int index = 0; index < stripes; ++index) {
            g.setColor(this.backgroundColors.get(index % colors));
            rectangle.setRect((double)index * x, (double)index * y, stripeWidth, stripeHeight);
            g.fill(rectangle);
        }
    }

    private void drawQuarters(Graphics2D g) {
        int colors = this.backgroundColors.size();
        int[] x = new int[]{0, 1, 1, 0};
        int[] y = new int[]{0, 0, 1, 1};
        double halfWidth = 75.0;
        double halfHeight = 50.0;
        double offset = this.decoration == Decoration.SCANDINAVIAN_CROSS ? 28.571428571428573 : 0.0;
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        for (int index = 0; index < 4; ++index) {
            g.setColor(this.backgroundColors.get(index % colors));
            rectangle.setRect((double)x[index] * halfWidth - offset, (double)y[index] * halfHeight, halfWidth + (double)x[index] * offset, halfHeight);
            g.fill(rectangle);
        }
    }

    private void drawPerBend(Graphics2D g, boolean sinister) {
        this.drawBackground(g);
        int colors = this.backgroundColors.size();
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 100.0f);
        path.lineTo(sinister ? 150.0f : 0.0f, 0.0f);
        path.lineTo(150.0f, 100.0f);
        g.setColor(this.backgroundColors.get(1 % colors));
        g.fill(path);
    }

    private void drawPerSaltire(Graphics2D g) {
        int colors = this.backgroundColors.size();
        GeneralPath path = new GeneralPath();
        int[] x = new int[]{0, 150, 150, 0};
        int[] y = new int[]{0, 0, 100, 100};
        double halfWidth = 75.0;
        double halfHeight = 50.0;
        for (int index = 0; index < 4; ++index) {
            path.moveTo(x[index], y[index]);
            path.lineTo(halfWidth, halfHeight);
            int nextIndex = (index + 1) % 4;
            path.lineTo(x[nextIndex], y[nextIndex]);
            g.setColor(this.backgroundColors.get(index % colors));
            g.fill(path);
            path.reset();
        }
    }

    private GeneralPath getCross(Decoration decoration) {
        double quarterWidth = 67.85714285714286;
        double quarterHeight = 42.857142857142854;
        double offset = 0.0;
        double width = 150.0;
        double height = 100.0;
        switch (decoration) {
            case SCANDINAVIAN_CROSS: {
                offset = 28.571428571428573;
                break;
            }
            case GREEK_CROSS: {
                width = height = (double)Math.min(150, 100) - 28.571428571428573;
                break;
            }
        }
        GeneralPath cross = new GeneralPath();
        cross.append(new Rectangle2D.Double((150.0 - width) / 2.0, quarterHeight, width, 14.285714285714286), false);
        cross.append(new Rectangle2D.Double(quarterWidth - offset, (100.0 - height) / 2.0, 14.285714285714286, height), false);
        return cross;
    }

    private GeneralPath getBend(boolean sinister) {
        GeneralPath path = new GeneralPath();
        if (sinister) {
            path.moveTo(0.0f, 100.0f);
            path.lineTo(0.0, 100.0 - BEND_Y);
            path.lineTo(135.71428571428572, 0.0);
            path.lineTo(150.0f, 0.0f);
            path.lineTo(150.0, BEND_Y);
            path.lineTo(14.285714285714286, 100.0);
        } else {
            path.moveTo(0.0f, 0.0f);
            path.lineTo(14.285714285714286, 0.0);
            path.lineTo(150.0, 100.0 - BEND_Y);
            path.lineTo(150.0f, 100.0f);
            path.lineTo(135.71428571428572, 100.0);
            path.lineTo(0.0, BEND_Y);
        }
        return path;
    }

    private GeneralPath getPall() {
        double y1 = 42.857142857142854;
        double y2 = 57.142857142857146;
        double x = 14.285714285714286 + y1 * SQRT_3;
        GeneralPath path = new GeneralPath(this.getTriangle(UnionShape.CHEVRON, true));
        path.lineTo(0.0f, 100.0f);
        path.lineTo(14.285714285714286, 100.0);
        path.lineTo(x, y2);
        path.lineTo(150.0, y2);
        path.lineTo(150.0, y1);
        path.lineTo(x, y1);
        path.lineTo(14.285714285714286, 0.0);
        path.lineTo(0.0f, 0.0f);
        return path;
    }

    private GeneralPath getTriangle(UnionShape unionShape, boolean small) {
        GeneralPath path = new GeneralPath();
        double x = 0.0;
        double y = 0.0;
        if (small) {
            x = 14.285714285714286;
            y = BEND_Y;
        }
        switch (unionShape) {
            case BEND: {
                path.moveTo(0.0, 100.0 - y);
                path.lineTo(0.0f, 0.0f);
                path.lineTo(150.0 - x, 0.0);
                break;
            }
            case CHEVRON: {
                path.moveTo(0.0, y);
                path.lineTo(CHEVRON_X - x, 50.0);
                path.lineTo(0.0, 100.0 - y);
                break;
            }
            case TRIANGLE: {
                if (this.unionPosition == UnionPosition.LEFT || this.unionPosition == UnionPosition.RIGHT) {
                    path.moveTo(0.0, y);
                    path.lineTo(75.0 - x, 50.0);
                    path.lineTo(0.0, 100.0 - y);
                    break;
                }
                path.moveTo(0.0, x);
                path.lineTo(50.0 - y, 75.0);
                path.lineTo(0.0, 150.0 - x);
                break;
            }
        }
        return path;
    }

    private GeneralPath getRhombus() {
        GeneralPath rhombus = new GeneralPath();
        rhombus.moveTo(75.0, BEND_Y);
        rhombus.lineTo(135.71428571428572, 50.0);
        rhombus.lineTo(75.0, 100.0 - BEND_Y);
        rhombus.lineTo(14.285714285714286, 50.0);
        return rhombus;
    }

    private Rectangle2D.Double getRectangle() {
        if (this.unionPosition == null || this.unionPosition == UnionPosition.NONE) {
            return null;
        }
        Rectangle2D.Double union = new Rectangle2D.Double();
        if (this.unionPosition.alignment == Alignment.VERTICAL) {
            if (this.background.alignment == Alignment.VERTICAL && this.stripes < 3) {
                union.width = 150 / this.stripes;
                if (this.stripes == 2 && this.unionPosition == UnionPosition.RIGHT) {
                    union.x = 75.0;
                }
            } else {
                union.width = 50.0;
                union.x = (double)this.unionPosition.index * union.width;
            }
            union.height = 100.0;
        } else if (this.unionPosition.alignment == Alignment.HORIZONTAL) {
            if (this.background.alignment == Alignment.HORIZONTAL && this.stripes < 3) {
                union.height = 100 / this.stripes;
                if (this.stripes == 2 && this.unionPosition == UnionPosition.BOTTOM) {
                    union.y = 50.0;
                }
            } else {
                union.height = 33.0;
                union.y = (double)this.unionPosition.index * union.height;
            }
            union.width = 150.0;
        } else {
            union.width = 75.0;
            union.height = 50.0;
            if (this.background.alignment == Alignment.HORIZONTAL) {
                union.height = this.stripes < 3 ? 50.0 : (double)(this.stripes / 2) * this.getStripeHeight(this.background.alignment);
            } else if (this.background.alignment == Alignment.VERTICAL) {
                double d = union.width = this.stripes < 3 ? 75.0 : (double)(this.stripes / 2) * this.getStripeWidth(this.background.alignment);
            }
            if (this.decoration == Decoration.GREEK_CROSS || this.decoration == Decoration.CROSS) {
                union.width = 67.85714285714286;
                union.height = 42.857142857142854;
            } else if (this.decoration == Decoration.SCANDINAVIAN_CROSS) {
                union.width = 39.28571428571429;
                union.height = 42.857142857142854;
            }
        }
        return union;
    }

    private static GeneralPath getStar() {
        int[] vertex;
        GeneralPath star = new GeneralPath(1);
        double angle = 1.2566370614359172;
        double radius = 3.5000000000000004;
        double x = 0.0;
        double y = -radius;
        star.moveTo(x, y);
        for (int i : vertex = new int[]{2, 4, 1, 3}) {
            double phi = (double)i * angle;
            x = radius * Math.sin(phi);
            y = -radius * Math.cos(phi);
            star.lineTo(x, y);
        }
        star.closePath();
        return star;
    }

    public GeneralPath getStar(double x, double y) {
        return this.getStar(-1.0, x, y);
    }

    public GeneralPath getStar(double scale, double x, double y) {
        GeneralPath newStar = new GeneralPath(star);
        if (scale > 0.0) {
            newStar.transform(AffineTransform.getScaleInstance(scale, scale));
        }
        newStar.transform(AffineTransform.getTranslateInstance(x, y));
        return newStar;
    }

    private void center(GeneralPath path, double x, double y) {
        double dx = x - path.getBounds().getX() - path.getBounds().getWidth() / 2.0;
        double dy = y - path.getBounds().getY() - path.getBounds().getHeight() / 2.0;
        path.transform(AffineTransform.getTranslateInstance(dx, dy));
    }

    private GeneralPath getCircleOfStars(double radius) {
        double phi = Math.PI * 2 / (double)this.stars;
        GeneralPath unionPath = new GeneralPath();
        if (this.stars != 0) {
            if (this.stars == 1) {
                unionPath = this.getStar(2.0, 0.0, 0.0);
            } else if (this.stars == 2) {
                unionPath.append(this.getStar(1.5, -radius, 0.0), false);
                unionPath.append(this.getStar(1.5, radius, 0.0), false);
            } else {
                for (int i = 0; i < this.stars; ++i) {
                    double x = -radius - radius * Math.sin((double)i * phi);
                    double y = -radius * Math.cos((double)i * phi);
                    unionPath.append(this.getStar(x, y), false);
                }
            }
        }
        return unionPath;
    }

    public GeneralPath getGridOfStars(Rectangle2D.Double union) {
        int[] bars = new int[2];
        for (int count = this.stars; count < 51; ++count) {
            if (layout[count][0] <= 0) continue;
            bars = layout[count];
            break;
        }
        int maxCols = Math.max(bars[0], bars[1]);
        int rows = 2;
        int sum = bars[0] + bars[1];
        while (sum < this.stars) {
            sum += bars[rows % 2];
            ++rows;
        }
        double hSpace = union.getWidth() / (double)(2 * maxCols);
        double vSpace = union.getHeight() / (double)(2 * rows);
        double y = 0.0;
        GeneralPath grid = new GeneralPath();
        int count = 1;
        for (int row = 0; row < rows; ++row) {
            int cols = bars[row % 2];
            double x = cols == maxCols ? 0.0 : hSpace;
            for (int col = 0; col < cols && count <= this.stars; ++count, ++col) {
                grid.append(this.getStar(x, y), false);
                x += 2.0 * hSpace;
            }
            y += 2.0 * vSpace;
        }
        return grid;
    }

    static {
        for (int[] bars : new int[][]{{5, 4}, {5, 6}, {6, 5}, {5, 5}}) {
            int sum = bars[0] + bars[1];
            boolean even = true;
            while (sum < 51) {
                Flag.layout[sum] = bars;
                if (even) {
                    sum += bars[0];
                    even = false;
                    continue;
                }
                sum += bars[1];
                even = true;
            }
        }
    }

    public static enum UnionPosition {
        LEFT(Alignment.VERTICAL, 0),
        CENTER(Alignment.VERTICAL, 1),
        RIGHT(Alignment.VERTICAL, 2),
        TOP(Alignment.HORIZONTAL, 0),
        MIDDLE(Alignment.HORIZONTAL, 1),
        BOTTOM(Alignment.HORIZONTAL, 2),
        CANTON(Alignment.NONE, 0),
        NONE(null, 0);

        public final Alignment alignment;
        public final int index;

        private UnionPosition(Alignment alignment, int index) {
            this.alignment = alignment;
            this.index = index;
        }
    }

    public static enum UnionShape {
        RECTANGLE,
        TRIANGLE,
        CHEVRON,
        BEND,
        RHOMBUS;

    }

    public static enum Decoration {
        NONE(new UnionPosition[0]),
        CROSS(UnionPosition.CANTON),
        GREEK_CROSS(UnionPosition.CANTON),
        SCANDINAVIAN_CROSS(UnionPosition.CANTON),
        CHEVRON(UnionShape.CHEVRON, UnionPosition.LEFT),
        PALL(UnionShape.CHEVRON, UnionPosition.LEFT),
        BEND(UnionShape.BEND, UnionPosition.TOP, UnionPosition.BOTTOM),
        BEND_SINISTER(UnionShape.BEND, UnionPosition.TOP, UnionPosition.BOTTOM),
        SALTIRE(UnionShape.CHEVRON, UnionPosition.TOP, UnionPosition.BOTTOM, UnionPosition.LEFT, UnionPosition.RIGHT),
        SALTIRE_AND_CROSS(UnionPosition.CANTON);

        public UnionShape unionShape = UnionShape.RECTANGLE;
        public Set<UnionPosition> unionPositions = EnumSet.of(UnionPosition.NONE);

        private Decoration(UnionPosition ... positions) {
            for (UnionPosition position : positions) {
                this.unionPositions.add(position);
            }
        }

        private Decoration(UnionShape shape, UnionPosition ... positions) {
            this(positions);
            this.unionShape = shape;
        }
    }

    public static enum Background {
        PLAIN(Alignment.NONE),
        QUARTERLY(Alignment.NONE),
        PALES(Alignment.VERTICAL),
        FESSES(Alignment.HORIZONTAL),
        PER_BEND(Alignment.NONE),
        PER_BEND_SINISTER(Alignment.NONE),
        PER_SALTIRE(Alignment.NONE);

        public final Alignment alignment;

        private Background(Alignment alignment) {
            this.alignment = alignment;
        }
    }

    public static enum Alignment {
        NONE,
        HORIZONTAL,
        VERTICAL;

    }
}

