/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.StringTemplate;

public final class MonarchDialog
extends FreeColDialog<Boolean> {
    public MonarchDialog(FreeColClient freeColClient, JFrame frame, Monarch.MonarchAction action, StringTemplate template, String monarchKey) {
        super(freeColClient, frame);
        String hdrKey;
        String noId;
        ImageLibrary lib = freeColClient.getGUI().getImageLibrary();
        String messageId = action.getTextKey();
        if (!Messages.containsKey(messageId)) {
            throw new IllegalStateException("Unrecognized monarch action: " + (Object)((Object)action));
        }
        String yesId = action.getYesKey();
        if (!Messages.containsKey(yesId)) {
            yesId = null;
        }
        if (!Messages.containsKey(noId = action.getNoKey())) {
            noId = "close";
        }
        if (!Messages.containsKey(hdrKey = action.getHeaderKey())) {
            hdrKey = "monarchDialog.default";
        }
        JLabel header = Utility.localizedHeaderLabel(hdrKey, 10, FontLibrary.FontSize.MEDIUM);
        MigPanel panel = new MigPanel(new MigLayout("wrap 2, insets 10", "[]20[]"));
        panel.add((Component)header, "span, align center, wrap 20");
        if (action == Monarch.MonarchAction.RAISE_TAX_ACT || action == Monarch.MonarchAction.RAISE_TAX_WAR) {
            JButton helpButton = Utility.localizedButton("help");
            helpButton.addActionListener(ae -> this.getGUI().showColopediaPanel("colopedia.concepts.taxes"));
            panel.add((Component)helpButton, "tag help");
        }
        JTextArea text = template == null ? Utility.localizedTextArea(messageId, 30) : Utility.localizedTextArea(StringTemplate.copy(messageId, template), 30);
        panel.add(text);
        panel.setSize(panel.getPreferredSize());
        List c = MonarchDialog.choices();
        if (yesId != null) {
            c.add(new ChoiceItem<Boolean>(Messages.message(yesId), Boolean.TRUE).okOption());
        }
        c.add(new ChoiceItem<Boolean>(Messages.message(noId), Boolean.FALSE).cancelOption().defaultOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, false, panel, new ImageIcon(lib.getMiscImage(monarchKey)), c);
    }
}

