/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ChangeStateMessage
extends DOMMessage {
    private final String unitId;
    private final String stateString;

    public ChangeStateMessage(Unit unit, Unit.UnitState state) {
        super(ChangeStateMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.stateString = String.valueOf((Object)state);
    }

    public ChangeStateMessage(Game game, Element element) {
        super(ChangeStateMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.stateString = element.getAttribute("state");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit.UnitState state;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            state = Enum.valueOf(Unit.UnitState.class, this.stateString);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!unit.checkSetState(state)) {
            return DOMMessage.clientError("Unit " + this.unitId + " can not change state: " + unit.getState().toString() + " -> " + this.stateString);
        }
        return server.getInGameController().changeState(serverPlayer, unit, state);
    }

    @Override
    public Element toXMLElement() {
        return ChangeStateMessage.createMessage(ChangeStateMessage.getXMLElementTagName(), "unit", this.unitId, "state", this.stateString);
    }

    public static String getXMLElementTagName() {
        return "changeState";
    }
}

