/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ChooseFoundingFatherMessage
extends DOMMessage {
    private final List<FoundingFather> fathers;
    private String foundingFatherId;

    public ChooseFoundingFatherMessage(List<FoundingFather> fathers, FoundingFather ff) {
        super(ChooseFoundingFatherMessage.getXMLElementTagName());
        this.fathers = new ArrayList<FoundingFather>();
        this.fathers.addAll(fathers);
        this.setFather(ff);
    }

    public ChooseFoundingFatherMessage(Game game, Element element) {
        super(ChooseFoundingFatherMessage.getXMLElementTagName());
        Specification spec = game.getSpecification();
        this.fathers = new ArrayList<FoundingFather>();
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            String id = element.getAttribute(type.toString());
            if (id == null || id.isEmpty()) continue;
            FoundingFather ff = spec.getFoundingFather(id);
            this.fathers.add(ff);
        }
        this.foundingFatherId = element.getAttribute("foundingFather");
    }

    public final FoundingFather getFather(Game game) {
        return this.foundingFatherId == null ? null : game.getSpecification().getFoundingFather(this.foundingFatherId);
    }

    public final ChooseFoundingFatherMessage setFather(FoundingFather ff) {
        this.foundingFatherId = ff == null ? null : ff.getId();
        return this;
    }

    public final List<FoundingFather> getFathers() {
        return this.fathers;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerGame game = server.getGame();
        ServerPlayer serverPlayer = server.getPlayer(connection);
        List<FoundingFather> offered = serverPlayer.getOfferedFathers();
        FoundingFather ff = this.getFather(game);
        if (!serverPlayer.canRecruitFoundingFather()) {
            return DOMMessage.clientError("Player can not recruit fathers: " + serverPlayer.getId());
        }
        if (ff == null) {
            return DOMMessage.clientError("No founding father selected");
        }
        if (!offered.contains(ff)) {
            return DOMMessage.clientError("Founding father not offered: " + ff.getId());
        }
        serverPlayer.updateCurrentFather(ff);
        return null;
    }

    @Override
    public Element toXMLElement() {
        Element result = ChooseFoundingFatherMessage.createMessage(ChooseFoundingFatherMessage.getXMLElementTagName(), new String[0]);
        for (FoundingFather f : this.getFathers()) {
            result.setAttribute(f.getType().toString(), f.getId());
        }
        if (this.foundingFatherId != null) {
            result.setAttribute("foundingFather", this.foundingFatherId);
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "chooseFoundingFather";
    }
}

