/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;

class TokenStream {
    private static final int EOF_CHAR = -1;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private boolean dirtyLine;
    String regExpFlags;
    private String string = "";
    private double number;
    private boolean isOctal;
    private boolean isHex;
    private int quoteChar;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private ObjToIntMap allStrings = new ObjToIntMap(50);
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private int lineStart = 0;
    private int lineEndChar = -1;
    int lineno;
    private String sourceString;
    private Reader sourceReader;
    private char[] sourceBuffer;
    private int sourceEnd;
    int sourceCursor;
    int cursor;
    int tokenBeg;
    int tokenEnd;
    Token.CommentType commentType;
    private boolean xmlIsAttribute;
    private boolean xmlIsTagContent;
    private int xmlOpenTagsCount;
    private Parser parser;
    private String commentPrefix = "";
    private int commentCursor = -1;

    TokenStream(Parser parser, Reader reader, String string, int n) {
        this.parser = parser;
        this.lineno = n;
        if (reader != null) {
            if (string != null) {
                Kit.codeBug();
            }
            this.sourceReader = reader;
            this.sourceBuffer = new char[512];
            this.sourceEnd = 0;
        } else {
            if (string == null) {
                Kit.codeBug();
            }
            this.sourceString = string;
            this.sourceEnd = string.length();
        }
        this.cursor = 0;
        this.sourceCursor = 0;
    }

    String tokenToString(int n) {
        return "";
    }

    static boolean isKeyword(String string) {
        return 0 != TokenStream.stringToKeyword(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int stringToKeyword(String string) {
        int n = 120;
        int n2 = 115;
        int n3 = 121;
        int n4 = 116;
        int n5 = 31;
        int n6 = 118;
        int n7 = 113;
        int n8 = 127;
        int n9 = 44;
        int n10 = 119;
        int n11 = 109;
        int n12 = 112;
        int n13 = 52;
        int n14 = 153;
        int n15 = 30;
        int n16 = 42;
        int n17 = 4;
        int n18 = 114;
        int n19 = 43;
        int n20 = 45;
        int n21 = 32;
        int n22 = 122;
        int n23 = 126;
        int n24 = 117;
        int n25 = 123;
        int n26 = 72;
        int n27 = 127;
        int n28 = 127;
        int n29 = 127;
        int n30 = 124;
        int n31 = 127;
        int n32 = 127;
        int n33 = 154;
        int n34 = 160;
        int n35 = 127;
        int n36 = 127;
        int n37 = 127;
        int n38 = 127;
        int n39 = 125;
        int n40 = 127;
        int n41 = 127;
        int n42 = 127;
        int n43 = 127;
        int n44 = 53;
        int n45 = 127;
        int n46 = 127;
        int n47 = 127;
        int n48 = 127;
        int n49 = 127;
        int n50 = 127;
        int n51 = 127;
        int n52 = 127;
        int n53 = 127;
        int n54 = 127;
        int n55 = 127;
        int n56 = 127;
        int n57 = 50;
        int n58 = 127;
        int n59 = 127;
        int n60 = 81;
        int n61 = 127;
        String string2 = string;
        int n62 = 0;
        String string3 = null;
        block0 : switch (string2.length()) {
            case 2: {
                char c = string2.charAt(1);
                if (c == 'f') {
                    if (string2.charAt(0) != 'i') break;
                    return 112;
                }
                if (c == 'n') {
                    if (string2.charAt(0) != 'i') break;
                    return 52;
                }
                if (c != 'o' || string2.charAt(0) != 'd') break;
                return 118;
            }
            case 3: {
                switch (string2.charAt(0)) {
                    case 'f': {
                        if (string2.charAt(2) != 'r' || string2.charAt(1) != 'o') break;
                        return 119;
                    }
                    case 'i': {
                        if (string2.charAt(2) != 't' || string2.charAt(1) != 'n') break;
                        return 127;
                    }
                    case 'l': {
                        if (string2.charAt(2) != 't' || string2.charAt(1) != 'e') break;
                        return 153;
                    }
                    case 'n': {
                        if (string2.charAt(2) != 'w' || string2.charAt(1) != 'e') break;
                        return 30;
                    }
                    case 't': {
                        if (string2.charAt(2) != 'y' || string2.charAt(1) != 'r') break;
                        return 81;
                    }
                    case 'v': {
                        if (string2.charAt(2) != 'r' || string2.charAt(1) != 'a') break;
                        return 122;
                    }
                }
                break;
            }
            case 4: {
                switch (string2.charAt(0)) {
                    case 'b': {
                        string3 = "byte";
                        n62 = 127;
                        break;
                    }
                    case 'c': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 's' || string2.charAt(1) != 'a') break;
                            return 115;
                        }
                        if (c != 'r' || string2.charAt(2) != 'a' || string2.charAt(1) != 'h') break;
                        return 127;
                    }
                    case 'e': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 's' || string2.charAt(1) != 'l') break;
                            return 113;
                        }
                        if (c != 'm' || string2.charAt(2) != 'u' || string2.charAt(1) != 'n') break;
                        return 127;
                    }
                    case 'g': {
                        string3 = "goto";
                        n62 = 127;
                        break;
                    }
                    case 'l': {
                        string3 = "long";
                        n62 = 127;
                        break;
                    }
                    case 'n': {
                        string3 = "null";
                        n62 = 42;
                        break;
                    }
                    case 't': {
                        char c = string2.charAt(3);
                        if (c == 'e') {
                            if (string2.charAt(2) != 'u' || string2.charAt(1) != 'r') break;
                            return 45;
                        }
                        if (c != 's' || string2.charAt(2) != 'i' || string2.charAt(1) != 'h') break;
                        return 43;
                    }
                    case 'v': {
                        string3 = "void";
                        n62 = 126;
                        break;
                    }
                    case 'w': {
                        string3 = "with";
                        n62 = 123;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (string2.charAt(2)) {
                    case 'a': {
                        string3 = "class";
                        n62 = 127;
                        break;
                    }
                    case 'e': {
                        char c = string2.charAt(0);
                        if (c == 'b') {
                            string3 = "break";
                            n62 = 120;
                            break;
                        }
                        if (c != 'y') break;
                        string3 = "yield";
                        n62 = 72;
                        break;
                    }
                    case 'i': {
                        string3 = "while";
                        n62 = 117;
                        break;
                    }
                    case 'l': {
                        string3 = "false";
                        n62 = 44;
                        break;
                    }
                    case 'n': {
                        char c = string2.charAt(0);
                        if (c == 'c') {
                            string3 = "const";
                            n62 = 154;
                            break;
                        }
                        if (c != 'f') break;
                        string3 = "final";
                        n62 = 127;
                        break;
                    }
                    case 'o': {
                        char c = string2.charAt(0);
                        if (c == 'f') {
                            string3 = "float";
                            n62 = 127;
                            break;
                        }
                        if (c != 's') break;
                        string3 = "short";
                        n62 = 127;
                        break;
                    }
                    case 'p': {
                        string3 = "super";
                        n62 = 127;
                        break;
                    }
                    case 'r': {
                        string3 = "throw";
                        n62 = 50;
                        break;
                    }
                    case 't': {
                        string3 = "catch";
                        n62 = 124;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (string2.charAt(1)) {
                    case 'a': {
                        string3 = "native";
                        n62 = 127;
                        break;
                    }
                    case 'e': {
                        char c = string2.charAt(0);
                        if (c == 'd') {
                            string3 = "delete";
                            n62 = 31;
                            break;
                        }
                        if (c != 'r') break;
                        string3 = "return";
                        n62 = 4;
                        break;
                    }
                    case 'h': {
                        string3 = "throws";
                        n62 = 127;
                        break;
                    }
                    case 'm': {
                        string3 = "import";
                        n62 = 127;
                        break;
                    }
                    case 'o': {
                        string3 = "double";
                        n62 = 127;
                        break;
                    }
                    case 't': {
                        string3 = "static";
                        n62 = 127;
                        break;
                    }
                    case 'u': {
                        string3 = "public";
                        n62 = 127;
                        break;
                    }
                    case 'w': {
                        string3 = "switch";
                        n62 = 114;
                        break;
                    }
                    case 'x': {
                        string3 = "export";
                        n62 = 127;
                        break;
                    }
                    case 'y': {
                        string3 = "typeof";
                        n62 = 32;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (string2.charAt(1)) {
                    case 'a': {
                        string3 = "package";
                        n62 = 127;
                        break block0;
                    }
                    case 'e': {
                        string3 = "default";
                        n62 = 116;
                        break block0;
                    }
                    case 'i': {
                        string3 = "finally";
                        n62 = 125;
                        break block0;
                    }
                    case 'o': {
                        string3 = "boolean";
                        n62 = 127;
                        break block0;
                    }
                    case 'r': {
                        string3 = "private";
                        n62 = 127;
                        break block0;
                    }
                    case 'x': {
                        string3 = "extends";
                        n62 = 127;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (string2.charAt(0)) {
                    case 'a': {
                        string3 = "abstract";
                        n62 = 127;
                        break block0;
                    }
                    case 'c': {
                        string3 = "continue";
                        n62 = 121;
                        break block0;
                    }
                    case 'd': {
                        string3 = "debugger";
                        n62 = 160;
                        break block0;
                    }
                    case 'f': {
                        string3 = "function";
                        n62 = 109;
                        break block0;
                    }
                    case 'v': {
                        string3 = "volatile";
                        n62 = 127;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = string2.charAt(0);
                if (c == 'i') {
                    string3 = "interface";
                    n62 = 127;
                    break;
                }
                if (c == 'p') {
                    string3 = "protected";
                    n62 = 127;
                    break;
                }
                if (c != 't') break;
                string3 = "transient";
                n62 = 127;
                break;
            }
            case 10: {
                char c = string2.charAt(1);
                if (c == 'm') {
                    string3 = "implements";
                    n62 = 127;
                    break;
                }
                if (c != 'n') break;
                string3 = "instanceof";
                n62 = 53;
                break;
            }
            case 12: {
                string3 = "synchronized";
                n62 = 127;
            }
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            return 0;
        }
        if (n62 != 0) return n62 & 0xFF;
        return 0;
    }

    final String getSourceString() {
        return this.sourceString;
    }

    final int getLineno() {
        return this.lineno;
    }

    final String getString() {
        return this.string;
    }

    final char getQuoteChar() {
        return (char)this.quoteChar;
    }

    final double getNumber() {
        return this.number;
    }

    final boolean isNumberOctal() {
        return this.isOctal;
    }

    final boolean isNumberHex() {
        return this.isHex;
    }

    final boolean eof() {
        return this.hitEOF;
    }

    final int getToken() throws IOException {
        boolean bl;
        int n;
        do {
            if ((n = this.getChar()) == -1) {
                this.tokenBeg = this.cursor - 1;
                this.tokenEnd = this.cursor;
                return 0;
            }
            if (n != 10) continue;
            this.dirtyLine = false;
            this.tokenBeg = this.cursor - 1;
            this.tokenEnd = this.cursor;
            return 1;
        } while (TokenStream.isJSSpace(n));
        if (n != 45) {
            this.dirtyLine = true;
        }
        this.tokenBeg = this.cursor - 1;
        this.tokenEnd = this.cursor;
        if (n == 64) {
            return 147;
        }
        boolean bl2 = false;
        if (n == 92) {
            n = this.getChar();
            if (n == 117) {
                bl = true;
                bl2 = true;
                this.stringBufferTop = 0;
            } else {
                bl = false;
                this.ungetChar(n);
                n = 92;
            }
        } else {
            bl = Character.isJavaIdentifierStart((char)n);
            if (bl) {
                this.stringBufferTop = 0;
                this.addToString(n);
            }
        }
        if (bl) {
            int n2;
            boolean bl3 = bl2;
            while (true) {
                if (bl2) {
                    int n3 = 0;
                    for (n2 = 0; n2 != 4 && (n3 = Kit.xDigitToInt(n = this.getChar(), n3)) >= 0; ++n2) {
                    }
                    if (n3 < 0) {
                        this.parser.addError("msg.invalid.escape");
                        return -1;
                    }
                    this.addToString(n3);
                    bl2 = false;
                    continue;
                }
                n = this.getChar();
                if (n == 92) {
                    n = this.getChar();
                    if (n == 117) {
                        bl2 = true;
                        bl3 = true;
                        continue;
                    }
                    this.parser.addError("msg.illegal.character");
                    return -1;
                }
                if (n == -1 || n == 65279 || !Character.isJavaIdentifierPart((char)n)) break;
                this.addToString(n);
            }
            this.ungetChar(n);
            String string = this.getStringFromBuffer();
            if (!bl3) {
                n2 = TokenStream.stringToKeyword(string);
                if (n2 != 0) {
                    if ((n2 == 153 || n2 == 72) && this.parser.compilerEnv.getLanguageVersion() < 170) {
                        this.string = n2 == 153 ? "let" : "yield";
                        n2 = 39;
                    }
                    this.string = (String)this.allStrings.intern(string);
                    if (n2 != 127) {
                        return n2;
                    }
                    if (!this.parser.compilerEnv.isReservedKeywordAsIdentifier()) {
                        return n2;
                    }
                }
            } else if (TokenStream.isKeyword(string)) {
                string = this.convertLastCharToHex(string);
            }
            this.string = (String)this.allStrings.intern(string);
            return 39;
        }
        if (TokenStream.isDigit(n) || n == 46 && TokenStream.isDigit(this.peekChar())) {
            double d;
            String string;
            this.isOctal = false;
            this.stringBufferTop = 0;
            int n4 = 10;
            this.isOctal = false;
            this.isHex = false;
            if (n == 48) {
                n = this.getChar();
                if (n == 120 || n == 88) {
                    n4 = 16;
                    this.isHex = true;
                    n = this.getChar();
                } else if (TokenStream.isDigit(n)) {
                    n4 = 8;
                    this.isOctal = true;
                } else {
                    this.addToString(48);
                }
            }
            if (n4 == 16) {
                while (0 <= Kit.xDigitToInt(n, 0)) {
                    this.addToString(n);
                    n = this.getChar();
                }
            } else {
                while (48 <= n && n <= 57) {
                    if (n4 == 8 && n >= 56) {
                        this.parser.addWarning("msg.bad.octal.literal", n == 56 ? "8" : "9");
                        n4 = 10;
                    }
                    this.addToString(n);
                    n = this.getChar();
                }
            }
            boolean bl4 = true;
            if (n4 == 10 && (n == 46 || n == 101 || n == 69)) {
                bl4 = false;
                if (n == 46) {
                    do {
                        this.addToString(n);
                    } while (TokenStream.isDigit(n = this.getChar()));
                }
                if (n == 101 || n == 69) {
                    this.addToString(n);
                    n = this.getChar();
                    if (n == 43 || n == 45) {
                        this.addToString(n);
                        n = this.getChar();
                    }
                    if (!TokenStream.isDigit(n)) {
                        this.parser.addError("msg.missing.exponent");
                        return -1;
                    }
                    do {
                        this.addToString(n);
                    } while (TokenStream.isDigit(n = this.getChar()));
                }
            }
            this.ungetChar(n);
            this.string = string = this.getStringFromBuffer();
            if (n4 == 10 && !bl4) {
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.parser.addError("msg.caught.nfe");
                    return -1;
                }
            } else {
                d = ScriptRuntime.stringToNumber(string, 0, n4);
            }
            this.number = d;
            return 40;
        }
        if (n == 34 || n == 39) {
            this.quoteChar = n;
            this.stringBufferTop = 0;
            n = this.getChar(false);
            block46: while (n != this.quoteChar) {
                if (n == 10 || n == -1) {
                    this.ungetChar(n);
                    this.tokenEnd = this.cursor;
                    this.parser.addError("msg.unterminated.string.lit");
                    return -1;
                }
                if (n == 92) {
                    n = this.getChar();
                    switch (n) {
                        case 98: {
                            n = 8;
                            break;
                        }
                        case 102: {
                            n = 12;
                            break;
                        }
                        case 110: {
                            n = 10;
                            break;
                        }
                        case 114: {
                            n = 13;
                            break;
                        }
                        case 116: {
                            n = 9;
                            break;
                        }
                        case 118: {
                            n = 11;
                            break;
                        }
                        case 117: {
                            int n5;
                            int n6 = this.stringBufferTop;
                            this.addToString(117);
                            int n7 = 0;
                            for (n5 = 0; n5 != 4; ++n5) {
                                n = this.getChar();
                                n7 = Kit.xDigitToInt(n, n7);
                                if (n7 < 0) continue block46;
                                this.addToString(n);
                            }
                            this.stringBufferTop = n6;
                            n = n7;
                            break;
                        }
                        case 120: {
                            n = this.getChar();
                            int n7 = Kit.xDigitToInt(n, 0);
                            if (n7 < 0) {
                                this.addToString(120);
                                continue block46;
                            }
                            int n5 = n;
                            n = this.getChar();
                            n7 = Kit.xDigitToInt(n, n7);
                            if (n7 < 0) {
                                this.addToString(120);
                                this.addToString(n5);
                                continue block46;
                            }
                            n = n7;
                            break;
                        }
                        case 10: {
                            n = this.getChar();
                            continue block46;
                        }
                        default: {
                            if (48 > n || n >= 56) break;
                            int n5 = n - 48;
                            n = this.getChar();
                            if (48 <= n && n < 56) {
                                n5 = 8 * n5 + n - 48;
                                n = this.getChar();
                                if (48 <= n && n < 56 && n5 <= 31) {
                                    n5 = 8 * n5 + n - 48;
                                    n = this.getChar();
                                }
                            }
                            this.ungetChar(n);
                            n = n5;
                        }
                    }
                }
                this.addToString(n);
                n = this.getChar(false);
            }
            String string = this.getStringFromBuffer();
            this.string = (String)this.allStrings.intern(string);
            return 41;
        }
        switch (n) {
            case 59: {
                return 82;
            }
            case 91: {
                return 83;
            }
            case 93: {
                return 84;
            }
            case 123: {
                return 85;
            }
            case 125: {
                return 86;
            }
            case 40: {
                return 87;
            }
            case 41: {
                return 88;
            }
            case 44: {
                return 89;
            }
            case 63: {
                return 102;
            }
            case 58: {
                if (this.matchChar(58)) {
                    return 144;
                }
                return 103;
            }
            case 46: {
                if (this.matchChar(46)) {
                    return 143;
                }
                if (this.matchChar(40)) {
                    return 146;
                }
                return 108;
            }
            case 124: {
                if (this.matchChar(124)) {
                    return 104;
                }
                if (this.matchChar(61)) {
                    return 91;
                }
                return 9;
            }
            case 94: {
                if (this.matchChar(61)) {
                    return 92;
                }
                return 10;
            }
            case 38: {
                if (this.matchChar(38)) {
                    return 105;
                }
                if (this.matchChar(61)) {
                    return 93;
                }
                return 11;
            }
            case 61: {
                if (this.matchChar(61)) {
                    if (this.matchChar(61)) {
                        return 46;
                    }
                    return 12;
                }
                return 90;
            }
            case 33: {
                if (this.matchChar(61)) {
                    if (this.matchChar(61)) {
                        return 47;
                    }
                    return 13;
                }
                return 26;
            }
            case 60: {
                if (this.matchChar(33)) {
                    if (this.matchChar(45)) {
                        if (this.matchChar(45)) {
                            this.tokenBeg = this.cursor - 4;
                            this.skipLine();
                            this.commentType = Token.CommentType.HTML;
                            return 161;
                        }
                        this.ungetCharIgnoreLineEnd(45);
                    }
                    this.ungetCharIgnoreLineEnd(33);
                }
                if (this.matchChar(60)) {
                    if (this.matchChar(61)) {
                        return 94;
                    }
                    return 18;
                }
                if (this.matchChar(61)) {
                    return 15;
                }
                return 14;
            }
            case 62: {
                if (this.matchChar(62)) {
                    if (this.matchChar(62)) {
                        if (this.matchChar(61)) {
                            return 96;
                        }
                        return 20;
                    }
                    if (this.matchChar(61)) {
                        return 95;
                    }
                    return 19;
                }
                if (this.matchChar(61)) {
                    return 17;
                }
                return 16;
            }
            case 42: {
                if (this.matchChar(61)) {
                    return 99;
                }
                return 23;
            }
            case 47: {
                this.markCommentStart();
                if (this.matchChar(47)) {
                    this.tokenBeg = this.cursor - 2;
                    this.skipLine();
                    this.commentType = Token.CommentType.LINE;
                    return 161;
                }
                if (this.matchChar(42)) {
                    boolean bl5 = false;
                    this.tokenBeg = this.cursor - 2;
                    if (this.matchChar(42)) {
                        bl5 = true;
                        this.commentType = Token.CommentType.JSDOC;
                    } else {
                        this.commentType = Token.CommentType.BLOCK_COMMENT;
                    }
                    while (true) {
                        if ((n = this.getChar()) == -1) {
                            this.tokenEnd = this.cursor - 1;
                            this.parser.addError("msg.unterminated.comment");
                            return 161;
                        }
                        if (n == 42) {
                            bl5 = true;
                            continue;
                        }
                        if (n == 47) {
                            if (!bl5) continue;
                            this.tokenEnd = this.cursor;
                            return 161;
                        }
                        bl5 = false;
                        this.tokenEnd = this.cursor;
                    }
                }
                if (this.matchChar(61)) {
                    return 100;
                }
                return 24;
            }
            case 37: {
                if (this.matchChar(61)) {
                    return 101;
                }
                return 25;
            }
            case 126: {
                return 27;
            }
            case 43: {
                if (this.matchChar(61)) {
                    return 97;
                }
                if (this.matchChar(43)) {
                    return 106;
                }
                return 21;
            }
            case 45: {
                if (this.matchChar(61)) {
                    n = 98;
                } else if (this.matchChar(45)) {
                    if (!this.dirtyLine && this.matchChar(62)) {
                        this.markCommentStart("--");
                        this.skipLine();
                        this.commentType = Token.CommentType.HTML;
                        return 161;
                    }
                    n = 107;
                } else {
                    n = 22;
                }
                this.dirtyLine = true;
                return n;
            }
        }
        this.parser.addError("msg.illegal.character");
        return -1;
    }

    private static boolean isAlpha(int n) {
        if (n <= 90) {
            return 65 <= n;
        }
        return 97 <= n && n <= 122;
    }

    static boolean isDigit(int n) {
        return 48 <= n && n <= 57;
    }

    static boolean isJSSpace(int n) {
        if (n <= 127) {
            return n == 32 || n == 9 || n == 12 || n == 11;
        }
        return n == 160 || n == 65279 || Character.getType((char)n) == 12;
    }

    private static boolean isJSFormatChar(int n) {
        return n > 127 && Character.getType((char)n) == 16;
    }

    void readRegExp(int n) throws IOException {
        int n2;
        int n3 = this.tokenBeg;
        this.stringBufferTop = 0;
        if (n == 100) {
            this.addToString(61);
        } else if (n != 24) {
            Kit.codeBug();
        }
        boolean bl = false;
        while ((n2 = this.getChar()) != 47 || bl) {
            if (n2 == 10 || n2 == -1) {
                this.ungetChar(n2);
                this.tokenEnd = this.cursor - 1;
                this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
                this.parser.reportError("msg.unterminated.re.lit");
                return;
            }
            if (n2 == 92) {
                this.addToString(n2);
                n2 = this.getChar();
            } else if (n2 == 91) {
                bl = true;
            } else if (n2 == 93) {
                bl = false;
            }
            this.addToString(n2);
        }
        int n4 = this.stringBufferTop;
        while (true) {
            if (this.matchChar(103)) {
                this.addToString(103);
                continue;
            }
            if (this.matchChar(105)) {
                this.addToString(105);
                continue;
            }
            if (this.matchChar(109)) {
                this.addToString(109);
                continue;
            }
            if (!this.matchChar(121)) break;
            this.addToString(121);
        }
        this.tokenEnd = n3 + this.stringBufferTop + 2;
        if (TokenStream.isAlpha(this.peekChar())) {
            this.parser.reportError("msg.invalid.re.flag");
        }
        this.string = new String(this.stringBuffer, 0, n4);
        this.regExpFlags = new String(this.stringBuffer, n4, this.stringBufferTop - n4);
    }

    String readAndClearRegExpFlags() {
        String string = this.regExpFlags;
        this.regExpFlags = null;
        return string;
    }

    boolean isXMLAttribute() {
        return this.xmlIsAttribute;
    }

    int getFirstXMLToken() throws IOException {
        this.xmlOpenTagsCount = 0;
        this.xmlIsAttribute = false;
        this.xmlIsTagContent = false;
        if (!this.canUngetChar()) {
            return -1;
        }
        this.ungetChar(60);
        return this.getNextXMLToken();
    }

    int getNextXMLToken() throws IOException {
        this.tokenBeg = this.cursor;
        this.stringBufferTop = 0;
        int n = this.getChar();
        while (n != -1) {
            if (this.xmlIsTagContent) {
                switch (n) {
                    case 62: {
                        this.addToString(n);
                        this.xmlIsTagContent = false;
                        this.xmlIsAttribute = false;
                        break;
                    }
                    case 47: {
                        this.addToString(n);
                        if (this.peekChar() != 62) break;
                        n = this.getChar();
                        this.addToString(n);
                        this.xmlIsTagContent = false;
                        --this.xmlOpenTagsCount;
                        break;
                    }
                    case 123: {
                        this.ungetChar(n);
                        this.string = this.getStringFromBuffer();
                        return 145;
                    }
                    case 34: 
                    case 39: {
                        this.addToString(n);
                        if (this.readQuotedString(n)) break;
                        return -1;
                    }
                    case 61: {
                        this.addToString(n);
                        this.xmlIsAttribute = true;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.addToString(n);
                        break;
                    }
                    default: {
                        this.addToString(n);
                        this.xmlIsAttribute = false;
                    }
                }
                if (!this.xmlIsTagContent && this.xmlOpenTagsCount == 0) {
                    this.string = this.getStringFromBuffer();
                    return 148;
                }
            } else {
                block8 : switch (n) {
                    case 60: {
                        this.addToString(n);
                        n = this.peekChar();
                        switch (n) {
                            case 33: {
                                n = this.getChar();
                                this.addToString(n);
                                n = this.peekChar();
                                switch (n) {
                                    case 45: {
                                        n = this.getChar();
                                        this.addToString(n);
                                        n = this.getChar();
                                        if (n == 45) {
                                            this.addToString(n);
                                            if (this.readXmlComment()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    case 91: {
                                        n = this.getChar();
                                        this.addToString(n);
                                        if (this.getChar() == 67 && this.getChar() == 68 && this.getChar() == 65 && this.getChar() == 84 && this.getChar() == 65 && this.getChar() == 91) {
                                            this.addToString(67);
                                            this.addToString(68);
                                            this.addToString(65);
                                            this.addToString(84);
                                            this.addToString(65);
                                            this.addToString(91);
                                            if (this.readCDATA()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    default: {
                                        if (this.readEntity()) break block8;
                                        return -1;
                                    }
                                }
                            }
                            case 63: {
                                n = this.getChar();
                                this.addToString(n);
                                if (this.readPI()) break block8;
                                return -1;
                            }
                            case 47: {
                                n = this.getChar();
                                this.addToString(n);
                                if (this.xmlOpenTagsCount == 0) {
                                    this.stringBufferTop = 0;
                                    this.string = null;
                                    this.parser.addError("msg.XML.bad.form");
                                    return -1;
                                }
                                this.xmlIsTagContent = true;
                                --this.xmlOpenTagsCount;
                                break;
                            }
                            default: {
                                this.xmlIsTagContent = true;
                                ++this.xmlOpenTagsCount;
                                break;
                            }
                        }
                        break;
                    }
                    case 123: {
                        this.ungetChar(n);
                        this.string = this.getStringFromBuffer();
                        return 145;
                    }
                    default: {
                        this.addToString(n);
                    }
                }
            }
            n = this.getChar();
        }
        this.tokenEnd = this.cursor;
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return -1;
    }

    private boolean readQuotedString(int n) throws IOException {
        int n2 = this.getChar();
        while (n2 != -1) {
            this.addToString(n2);
            if (n2 == n) {
                return true;
            }
            n2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readXmlComment() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 45 && this.peekChar() == 45) {
                n = this.getChar();
                this.addToString(n);
                if (this.peekChar() != 62) continue;
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readCDATA() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 93 && this.peekChar() == 93) {
                n = this.getChar();
                this.addToString(n);
                if (this.peekChar() != 62) continue;
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readEntity() throws IOException {
        int n = 1;
        int n2 = this.getChar();
        while (n2 != -1) {
            this.addToString(n2);
            switch (n2) {
                case 60: {
                    ++n;
                    break;
                }
                case 62: {
                    if (--n != 0) break;
                    return true;
                }
            }
            n2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readPI() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 63 && this.peekChar() == 62) {
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private String getStringFromBuffer() {
        this.tokenEnd = this.cursor;
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int n) {
        int n2 = this.stringBufferTop;
        if (n2 == this.stringBuffer.length) {
            char[] cArray = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, cArray, 0, n2);
            this.stringBuffer = cArray;
        }
        this.stringBuffer[n2] = (char)n;
        this.stringBufferTop = n2 + 1;
    }

    private boolean canUngetChar() {
        return this.ungetCursor == 0 || this.ungetBuffer[this.ungetCursor - 1] != 10;
    }

    private void ungetChar(int n) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = n;
        --this.cursor;
    }

    private boolean matchChar(int n) throws IOException {
        int n2 = this.getCharIgnoreLineEnd();
        if (n2 == n) {
            this.tokenEnd = this.cursor;
            return true;
        }
        this.ungetCharIgnoreLineEnd(n2);
        return false;
    }

    private int peekChar() throws IOException {
        int n = this.getChar();
        this.ungetChar(n);
        return n;
    }

    private int getChar() throws IOException {
        return this.getChar(true);
    }

    private int getChar(boolean bl) throws IOException {
        int n;
        block12: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    ++this.cursor;
                    n = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    ++this.cursor;
                    n = this.sourceBuffer[this.sourceCursor++];
                }
                if (this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && n == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (n <= 127) {
                    if (n == 10 || n == 13) {
                        this.lineEndChar = n;
                        n = 10;
                    }
                    break block12;
                }
                if (n == 65279) {
                    return n;
                }
                if (!bl || !TokenStream.isJSFormatChar(n)) break;
            }
            if (ScriptRuntime.isJSLineTerminator(n)) {
                this.lineEndChar = n;
                n = 10;
            }
        }
        return n;
    }

    private int getCharIgnoreLineEnd() throws IOException {
        int n;
        block9: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                return this.ungetBuffer[--this.ungetCursor];
            }
            do {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    ++this.cursor;
                    n = this.sourceString.charAt(this.sourceCursor++);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    ++this.cursor;
                    n = this.sourceBuffer[this.sourceCursor++];
                }
                if (n <= 127) {
                    if (n == 10 || n == 13) {
                        this.lineEndChar = n;
                        n = 10;
                    }
                    break block9;
                }
                if (n != 65279) continue;
                return n;
            } while (TokenStream.isJSFormatChar(n));
            if (ScriptRuntime.isJSLineTerminator(n)) {
                this.lineEndChar = n;
                n = 10;
            }
        }
        return n;
    }

    private void ungetCharIgnoreLineEnd(int n) {
        this.ungetBuffer[this.ungetCursor++] = n;
        --this.cursor;
    }

    private void skipLine() throws IOException {
        int n;
        while ((n = this.getChar()) != -1 && n != 10) {
        }
        this.ungetChar(n);
        this.tokenEnd = this.cursor;
    }

    final int getOffset() {
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        }
        return n;
    }

    private final int charAt(int n) {
        if (n < 0) {
            return -1;
        }
        if (this.sourceString != null) {
            if (n >= this.sourceEnd) {
                return -1;
            }
            return this.sourceString.charAt(n);
        }
        if (n >= this.sourceEnd) {
            int n2 = this.sourceCursor;
            try {
                if (!this.fillSourceBuffer()) {
                    return -1;
                }
            }
            catch (IOException iOException) {
                return -1;
            }
            n -= n2 - this.sourceCursor;
        }
        return this.sourceBuffer[n];
    }

    private final String substring(int n, int n2) {
        if (this.sourceString != null) {
            return this.sourceString.substring(n, n2);
        }
        int n3 = n2 - n;
        return new String(this.sourceBuffer, n, n3);
    }

    final String getLine() {
        int n = this.sourceCursor;
        if (this.lineEndChar >= 0) {
            if (this.lineEndChar == 10 && this.charAt(--n - 1) == 13) {
                --n;
            }
        } else {
            int n2;
            int n3 = n - this.lineStart;
            while ((n2 = this.charAt(this.lineStart + n3)) != -1 && !ScriptRuntime.isJSLineTerminator(n2)) {
                ++n3;
            }
            n = this.lineStart + n3;
        }
        return this.substring(this.lineStart, n);
    }

    final String getLine(int n, int[] nArray) {
        int n2;
        assert (n >= 0 && n <= this.cursor);
        assert (nArray.length == 2);
        int n3 = this.cursor + this.ungetCursor - n;
        int n4 = this.sourceCursor;
        if (n3 > n4) {
            return null;
        }
        int n5 = 0;
        int n6 = 0;
        while (n3 > 0) {
            assert (n4 > 0);
            n2 = this.charAt(n4 - 1);
            if (ScriptRuntime.isJSLineTerminator(n2)) {
                if (n2 == 10 && this.charAt(n4 - 2) == 13) {
                    --n3;
                    --n4;
                }
                ++n6;
                n5 = n4 - 1;
            }
            --n3;
            --n4;
        }
        n2 = 0;
        int n7 = 0;
        while (n4 > 0) {
            int n8 = this.charAt(n4 - 1);
            if (ScriptRuntime.isJSLineTerminator(n8)) {
                n2 = n4;
                break;
            }
            --n4;
            ++n7;
        }
        nArray[0] = this.lineno - n6 + (this.lineEndChar >= 0 ? 1 : 0);
        nArray[1] = n7;
        if (n6 == 0) {
            return this.getLine();
        }
        return this.substring(n2, n5);
    }

    private boolean fillSourceBuffer() throws IOException {
        int n;
        if (this.sourceString != null) {
            Kit.codeBug();
        }
        if (this.sourceEnd == this.sourceBuffer.length) {
            if (this.lineStart != 0 && !this.isMarkingComment()) {
                System.arraycopy(this.sourceBuffer, this.lineStart, this.sourceBuffer, 0, this.sourceEnd - this.lineStart);
                this.sourceEnd -= this.lineStart;
                this.sourceCursor -= this.lineStart;
                this.lineStart = 0;
            } else {
                char[] cArray = new char[this.sourceBuffer.length * 2];
                System.arraycopy(this.sourceBuffer, 0, cArray, 0, this.sourceEnd);
                this.sourceBuffer = cArray;
            }
        }
        if ((n = this.sourceReader.read(this.sourceBuffer, this.sourceEnd, this.sourceBuffer.length - this.sourceEnd)) < 0) {
            return false;
        }
        this.sourceEnd += n;
        return true;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getTokenBeg() {
        return this.tokenBeg;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public int getTokenLength() {
        return this.tokenEnd - this.tokenBeg;
    }

    public Token.CommentType getCommentType() {
        return this.commentType;
    }

    private void markCommentStart() {
        this.markCommentStart("");
    }

    private void markCommentStart(String string) {
        if (this.parser.compilerEnv.isRecordingComments() && this.sourceReader != null) {
            this.commentPrefix = string;
            this.commentCursor = this.sourceCursor - 1;
        }
    }

    private boolean isMarkingComment() {
        return this.commentCursor != -1;
    }

    final String getAndResetCurrentComment() {
        if (this.sourceString != null) {
            if (this.isMarkingComment()) {
                Kit.codeBug();
            }
            return this.sourceString.substring(this.tokenBeg, this.tokenEnd);
        }
        if (!this.isMarkingComment()) {
            Kit.codeBug();
        }
        StringBuilder stringBuilder = new StringBuilder(this.commentPrefix);
        stringBuilder.append(this.sourceBuffer, this.commentCursor, this.getTokenLength() - this.commentPrefix.length());
        this.commentCursor = -1;
        return stringBuilder.toString();
    }

    private String convertLastCharToHex(String string) {
        int n = string.length() - 1;
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
        stringBuffer.append("\\u");
        String string2 = Integer.toHexString(string.charAt(n));
        for (int i = 0; i < 4 - string2.length(); ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

