

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Include Only Points Within Distance of Arc (arc){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Include Only Points Within Distance of Arc (arc)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="filter_polygon.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_radius.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_arc"></a>Include Only Points Within Distance of Arc (arc)</h2></div></div></div><p> 
This filter keeps or removes waypoints based on their proximity to an arc, 
which is a series of connected line segments similar to a route or a track 
but without any associated data other than the coordinates.  Optionally, it
can move each non-deleted waypoint over the closest segment of the arc.
</p><p> 
The arc may defined in a file whose name must be provided with the 
<code class="option">file</code>, or the tracks or routes that have already been read.  That file contains pairs of coordinates for the 
vertices of the arc, one coordinate pair per line.  Comments may be
included by preceding them with a '#' character.  An arc file looks 
something like this sample:
</p><pre class="screen">	  
# Lima Road/SR3 north of Fort Wayne, Indiana 	  
41.150064468    -85.166207433 	  
41.150064468    -85.165371895 	  
41.149034500    -85.165157318 	  
41.147832870    -85.164771080 	  
41.146631241    -85.164384842 	  
41.144270897    -85.163655281 	  
41.141953468    -85.162882805
</pre><p> 
An arc file may optionally contain gaps in the arc.  You may specify 
such a gap by inserting a line containing "#break" either on a line by 
itself or after the coordinates of the starting point of the new arc segment.
</p><div class="example"><a id="example_arc_filter"></a><p class="title"><strong>Example 4.3. Using the arc filter</strong></p><div class="example-contents"><p>
Assuming the arc above is in a file called 
<code class="filename">lima_rd.txt</code>, the following command line
would include only points within one mile of the section of Lima Road 
covered by the arc.
</p><p><strong class="userinput"><code>gpsbabel -i geo -f 1.loc -x arc,file=lima_rd.txt,distance=1 -o mapsend -F 2.wpt</code></strong></p></div></div><br class="example-break" /><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_arc_o_file"></a>file option</h3></div></div></div><p>
      File containing vertices of arc.
    </p><p>
This option specifies the name of the file containing the arc to use for
filtering.  The format of the file is as described above.
</p><p>
GPSBabel supports converting any route or track to a file usable by this
filter; simply read it in the normal way and write it using the 
<a class="link" href="fmt_arc.html" title="GPSBabel arc filter file (arc)">arc</a> file format.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_arc_o_rte"></a>rte option</h3></div></div></div><p>
      Route(s) are vertices of arc.
    </p><p>
When this option is specified the routes contains the vertices of the arc.
If there are several routes then it is assumed that there is a gap between
each of them.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_arc_o_trk"></a>trk option</h3></div></div></div><p>
      Track(s) are vertices of arc.
    </p><p>
When this option is specified the tracks contains the vertices of the arc.
If there are several tracks then it is assumed that there is a gap between
each of them.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_arc_o_distance"></a>distance option</h3></div></div></div><p>
      Maximum distance from arc.
    </p><p>
This option is not required, but if it is not specified the distance 
defaults to zero miles, which isn't very useful.
</p><p>
This option specifies the maximum distance a point may be from the arc 
without being discarded.  Points that are closer to the arc are kept, while
points that are further away are discarded.
</p><p>
Distances may be specified in miles (3M) or kilometers (5K).  If no units
are specified, the distance is assumed to be in miles.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_arc_o_exclude"></a>exclude option</h3></div></div></div><p>
      Exclude points close to the arc.
    </p><p>
When this option is specified, the usual sense of the arc filter is reversed. 
That is, points that are closer than <code class="varname">distance</code> are discarded
while points that are further away are kept.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_arc_o_points"></a>points option</h3></div></div></div><p>
      Use distance from vertices not lines.
    </p><p>
When this option is specified, only points that are within the specified 
distance of one of the vertices of the arc are kept.  This differs from the
normal mode of operation in that in the normal mode, points that are close to
the lines between points are also kept.
</p><p>
This option makes the arc filter act like a multi-point version of the
<a class="link" href="filter_radius.html" title="Include Only Points Within Radius (radius)">radius</a> filter.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_arc_o_project"></a>project option</h3></div></div></div><p>
      Move waypoints to its projection on lines or vertices.
    </p><p>
When this option is specified, each non deleted waypoint is moved over the
closest segment, or over the nearest point if <code class="option">points</code> option
is used.
</p><p>
With <code class="option">rte</code> and <code class="option">trk</code> optinos, if
is possible, altitude, creation_time and microsecond fields of waypoints
are updated by interpolation.
</p><p>
This is most useful if you are trying to obtain the closest points in
a road to some places. Or if you want to know the step times on some
places over the tracks. Also to transform waypoints in Garmin course points
(see <a class="link" href="fmt_gtrnctr.html" title="Garmin Training Center (.tcx) (gtrnctr)">gtrnctr</a> and
<a class="link" href="fmt_garmin.html" title="Garmin serial/USB protocol (garmin)">garmin</a> format).
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="filter_polygon.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_radius.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Include Only Points Inside Polygon (polygon) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Include Only Points Within Radius (radius)</td></tr></table></div>
  
      {/literal}{/block}
  