/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.autoplay;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.Field;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.function.autoplay.PointInfo;
import tim.prune.function.autoplay.PointList;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.IconManager;
import tim.prune.gui.WholeNumberField;

public class AutoplayFunction
extends GenericFunction
implements Runnable {
    private JDialog _dialog = null;
    private WholeNumberField _durationField = null;
    private JCheckBox _useTimestampsCheckbox = null;
    private JButton _rewindButton = null;
    private JButton _pauseButton = null;
    private JButton _playButton = null;
    private boolean _needToRecalculate = true;
    private PointList _pointList = null;
    private boolean _running = false;
    private long _startTime = 0L;

    public AutoplayFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.autoplay";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
            this._dialog.setResizable(false);
            this._dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    AutoplayFunction.this._running = false;
                    super.windowClosing(windowEvent);
                }
            });
        }
        this._app.getTrackInfo().selectPoint(-1);
        this.enableButtons(false, true);
        boolean bl = this._app.getTrackInfo().getTrack().hasData(Field.TIMESTAMP);
        this._useTimestampsCheckbox.setEnabled(bl);
        if (!bl) {
            this._useTimestampsCheckbox.setSelected(false);
        }
        this._needToRecalculate = true;
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        guiGridLayout.add(new JLabel(String.valueOf(I18nManager.getText("dialog.autoplay.duration")) + " :"));
        this._durationField = new WholeNumberField(3);
        this._durationField.setValue(60);
        this._durationField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutoplayFunction.this.onParamsChanged();
            }
        });
        guiGridLayout.add(this._durationField);
        jPanel2.setAlignmentX(0.5f);
        jPanel.add(jPanel2);
        this._useTimestampsCheckbox = new JCheckBox(I18nManager.getText("dialog.autoplay.usetimestamps"));
        this._useTimestampsCheckbox.setAlignmentX(0.5f);
        jPanel.add(this._useTimestampsCheckbox);
        this._useTimestampsCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutoplayFunction.this.onParamsChanged();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        this._rewindButton = new JButton(IconManager.getImageIcon("rewind.png"));
        jPanel3.add(this._rewindButton);
        this._rewindButton.setToolTipText(I18nManager.getText("dialog.autoplay.rewind"));
        this._rewindButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutoplayFunction.this.onRewindPressed();
            }
        });
        this._pauseButton = new JButton(IconManager.getImageIcon("pause.png"));
        jPanel3.add(this._pauseButton);
        this._pauseButton.setToolTipText(I18nManager.getText("dialog.autoplay.pause"));
        this._pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutoplayFunction.this.onPausePressed();
            }
        });
        this._playButton = new JButton(IconManager.getImageIcon("play.png"));
        jPanel3.add(this._playButton);
        this._playButton.setToolTipText(I18nManager.getText("dialog.autoplay.play"));
        this._playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutoplayFunction.this.onPlayPressed();
            }
        });
        jPanel3.setAlignmentX(0.5f);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private void onParamsChanged() {
        this.onRewindPressed();
        this.enableButtons(false, this._durationField.getValue() > 0);
        this._needToRecalculate = true;
    }

    private void onRewindPressed() {
        this._running = false;
        if (this._pointList != null) {
            this._pointList.set(0L);
            this._app.getTrackInfo().selectPoint(this._pointList.getCurrentPointIndex());
        }
    }

    private void onPausePressed() {
        this._running = false;
        this.enableButtons(false, true);
    }

    private void onPlayPressed() {
        if (this._needToRecalculate) {
            this.recalculateTimes();
        }
        this.enableButtons(true, false);
        if (this._pointList.isAtStart() || this._pointList.isFinished()) {
            this._pointList.set(0L);
            this._startTime = System.currentTimeMillis();
        } else {
            this._startTime = System.currentTimeMillis() - this._pointList.getCurrentMilliseconds();
        }
        new Thread(this).start();
    }

    private void recalculateTimes() {
        this._pointList = this._useTimestampsCheckbox.isSelected() ? AutoplayFunction.generatePointListUsingTimes(this._app.getTrackInfo().getTrack(), this._durationField.getValue()) : AutoplayFunction.generatePointListUsingIndexes(this._app.getTrackInfo().getTrack().getNumPoints(), this._durationField.getValue());
        this._needToRecalculate = false;
    }

    private void enableButtons(boolean bl, boolean bl2) {
        this._pauseButton.setEnabled(bl);
        this._playButton.setEnabled(bl2);
    }

    private static PointList generatePointListUsingTimes(Track track, int n) {
        TreeSet<PointInfo> treeSet = new TreeSet<PointInfo>();
        int n2 = track.getNumPoints();
        int n3 = 0;
        while (n3 < n2) {
            PointInfo pointInfo = new PointInfo(track.getPoint(n3), n3);
            if (pointInfo.getTimestamp() != null) {
                treeSet.add(pointInfo);
            }
            ++n3;
        }
        Timestamp timestamp = null;
        long l = 0L;
        n2 = treeSet.size();
        PointList pointList = new PointList(n2);
        for (PointInfo pointInfo : treeSet) {
            if (timestamp != null) {
                l = pointInfo.getSegmentFlag() ? (l += 1000L) : (l += pointInfo.getTimestamp().getMillisecondsSince(timestamp));
            }
            timestamp = pointInfo.getTimestamp();
            pointList.setPoint(l, pointInfo.getIndex());
        }
        pointList.normalize(n);
        return pointList;
    }

    private static PointList generatePointListUsingIndexes(int n, int n2) {
        PointList pointList = new PointList(n);
        int n3 = 0;
        while (n3 < n) {
            pointList.setPoint(n3, n3);
            ++n3;
        }
        pointList.normalize(n2);
        return pointList;
    }

    public void run() {
        this._running = true;
        this._app.getTrackInfo().selectPoint(this._pointList.getCurrentPointIndex());
        while (this._running && !this._pointList.isFinished()) {
            this._pointList.set(System.currentTimeMillis() - this._startTime);
            int n = this._pointList.getCurrentPointIndex();
            this._app.getTrackInfo().selectPoint(n);
            long l = this._pointList.getMillisUntilNextPoint(System.currentTimeMillis() - this._startTime);
            if (l < 20L) {
                l = 20L;
            }
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        this._running = false;
        this.enableButtons(false, true);
    }
}

