/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import tim.prune.App;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.RangeStats;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.compress.MarkAndDeleteFunction;

public class MarkLiftsFunction
extends MarkAndDeleteFunction {
    public MarkLiftsFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.marklifts";
    }

    protected boolean getShouldSplitSegments() {
        return true;
    }

    public void begin() {
        DataPoint dataPoint;
        int n = 0;
        Track track = this._app.getTrackInfo().getTrack();
        int n2 = track.getNumPoints();
        boolean[] blArray = new boolean[n2];
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            dataPoint = track.getPoint(n4);
            if (dataPoint != null && !dataPoint.isWaypoint() && dataPoint.hasAltitude() && dataPoint.hasTimestamp()) {
                int n5 = n4 + 1;
                DataPoint dataPoint2 = track.getPoint(n5);
                while (dataPoint2 != null && dataPoint2.hasAltitude() && dataPoint2.hasTimestamp() && !dataPoint2.isWaypoint() && dataPoint2.getTimestamp().getSecondsSince(dataPoint.getTimestamp()) < 120L) {
                    dataPoint2 = track.getPoint(++n5);
                }
                if (dataPoint2 != null && dataPoint2.hasAltitude() && dataPoint2.hasTimestamp() && !dataPoint2.isWaypoint() && n5 > n4 + 10 && this.looksLikeLiftRange(track, n4, n5)) {
                    int n6 = n4;
                    if (n3 >= 0 && (this.looksLikeLiftRange(track, n3, n4) || this.looksLikeLiftRange(track, n3, n5))) {
                        n6 = n3;
                    }
                    int n7 = n6;
                    while (n7 <= n5) {
                        blArray[n7] = true;
                        ++n7;
                    }
                    n3 = n6;
                    n4 = (n4 + n5) / 2;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            dataPoint = track.getPoint(n4);
            if (!dataPoint.isWaypoint()) {
                dataPoint.setMarkedForDeletion(blArray[n4]);
            }
            if (blArray[n4]) {
                ++n;
            }
            ++n4;
        }
        UpdateMessageBroker.informSubscribers();
        if (n > 0) {
            this.optionallyDeleteMarkedPoints(n);
        }
    }

    private boolean looksLikeLiftRange(Track track, int n, int n2) {
        int n3;
        RangeStats rangeStats = new RangeStats(track, n, n2);
        int n4 = rangeStats.getTotalAltitudeRange().getDescent(UnitSetLibrary.UNITS_METRES);
        if (n4 < 20 && (n3 = rangeStats.getTotalAltitudeRange().getClimb(UnitSetLibrary.UNITS_METRES)) > n4 * 10) {
            double d;
            DataPoint dataPoint = track.getPoint(n);
            DataPoint dataPoint2 = track.getPoint(n2);
            double d2 = rangeStats.getTotalDistance();
            if (d2 / (d = Distance.convertRadiansToDistance(DataPoint.calculateRadiansBetween(dataPoint, dataPoint2))) < 1.02) {
                return true;
            }
        }
        return false;
    }
}

