/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.text.NumberFormat;
import tim.prune.I18nManager;

public abstract class DisplayUtils {
    private static final NumberFormat FORMAT_ONE_DP = NumberFormat.getNumberInstance();
    private static final NumberFormat FORMAT_FLEX;

    static {
        FORMAT_ONE_DP.setMaximumFractionDigits(1);
        FORMAT_ONE_DP.setMinimumFractionDigits(1);
        FORMAT_FLEX = NumberFormat.getNumberInstance();
    }

    public static String buildDurationString(long l) {
        if (l <= 0L) {
            return "";
        }
        if (l < 60L) {
            return l + I18nManager.getText("display.range.time.secs");
        }
        if (l < 3600L) {
            return l / 60L + I18nManager.getText("display.range.time.mins") + " " + l % 60L + I18nManager.getText("display.range.time.secs");
        }
        if (l < 86400L) {
            return l / 60L / 60L + I18nManager.getText("display.range.time.hours") + " " + l / 60L % 60L + I18nManager.getText("display.range.time.mins");
        }
        if (l < 432000L) {
            return l / 86400L + I18nManager.getText("display.range.time.days") + " " + l / 60L / 60L % 24L + I18nManager.getText("display.range.time.hours");
        }
        if (l < 86400000L) {
            return l / 86400L + I18nManager.getText("display.range.time.days");
        }
        return "big";
    }

    public static String formatOneDp(double d) {
        return FORMAT_ONE_DP.format(d);
    }

    public static String roundedNumber(double d) {
        int n = 0;
        if (d < 1.0) {
            n = 3;
        } else if (d < 10.0) {
            n = 2;
        } else if (d < 100.0) {
            n = 1;
        }
        FORMAT_FLEX.setMaximumFractionDigits(n);
        FORMAT_FLEX.setMinimumFractionDigits(n);
        return FORMAT_FLEX.format(d);
    }

    public static String makeTimeString(int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = n >= 0 && n <= 24 ? n : 0;
        stringBuilder.append(n4);
        stringBuilder.append(':');
        int n5 = n3 = n2 >= 0 && n2 <= 59 ? n2 : 0;
        if (n3 <= 9) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }
}

