/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.util.buffer;

import java.io.IOException;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.buffer.ArrayBuffer;
import org.simpleframework.util.buffer.Buffer;
import org.simpleframework.util.buffer.BufferException;

public class ArrayAllocator
implements Allocator {
    private int limit;
    private int size;

    public ArrayAllocator() {
        this(512);
    }

    public ArrayAllocator(int size) {
        this(size, 0x100000);
    }

    public ArrayAllocator(int size, int limit) {
        this.limit = Math.max(size, limit);
        this.size = size;
    }

    public Buffer allocate() throws IOException {
        return this.allocate(this.size);
    }

    public Buffer allocate(int size) throws IOException {
        if (size > this.limit) {
            throw new BufferException("Specified size %s beyond limit", size);
        }
        return new ArrayBuffer(size, this.limit);
    }

    public void close() throws IOException {
    }
}

