/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiKeyword;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpressionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.impl.GeneratedMarkerVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeGenerator;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.CharTable;

public class JavaTreeGenerator
implements TreeGenerator {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.JavaTreeGenerator");
    private static final JavaParserUtil.ParserWrapper MOD_LIST = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseModifierList(builder);
        }
    };
    static final Key<PsiClass> REFERENCED_CLASS_KEY = Key.create("REFERENCED_CLASS_KEY");
    static final Key<PsiMember> REFERENCED_MEMBER_KEY = Key.create("REFERENCED_MEMBER_KEY");

    @Override
    @Nullable
    public TreeElement generateTreeFor(@NotNull PsiElement original, @NotNull CharTable table, @NotNull PsiManager manager) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaTreeGenerator", "generateTreeFor"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaTreeGenerator", "generateTreeFor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaTreeGenerator", "generateTreeFor"));
        }
        if (original instanceof PsiKeyword || original instanceof PsiIdentifier) {
            String text2 = original.getText();
            return JavaTreeGenerator.createLeafFromText(text2, table, manager, original, ((PsiJavaToken)original).getTokenType());
        }
        if (original instanceof PsiModifierList) {
            String text3 = original.getText();
            assert (text3 != null) : "Text is null for " + original + "; " + original.getClass();
            LanguageLevel level = PsiUtil.getLanguageLevel(original);
            DummyHolder holder = DummyHolderFactory.createHolder(original.getManager(), new JavaDummyElement(text3, MOD_LIST, level), null);
            TreeElement modifierListElement = holder.getTreeElement().getFirstChildNode();
            if (modifierListElement == null) {
                throw new AssertionError((Object)("No modifier list for \"" + text3 + '\"'));
            }
            return JavaTreeGenerator.markGeneratedIfNeeded(original, modifierListElement);
        }
        if (original instanceof PsiReferenceExpression) {
            TreeElement element = JavaTreeGenerator.createReferenceExpression(original.getProject(), original.getText(), original);
            PsiElement refElement = ((PsiJavaCodeReferenceElement)original).resolve();
            if (refElement instanceof PsiClass) {
                element.putCopyableUserData(REFERENCED_CLASS_KEY, (PsiClass)refElement);
            }
            return element;
        }
        if (original instanceof PsiJavaCodeReferenceElement) {
            boolean generated;
            PsiElement refElement = ((PsiJavaCodeReferenceElement)original).resolve();
            boolean bl = generated = refElement != null && CodeEditUtil.isNodeGenerated(refElement.getNode());
            if (refElement instanceof PsiClass) {
                if (refElement instanceof PsiAnonymousClass) {
                    PsiJavaCodeReferenceElement ref = ((PsiAnonymousClass)refElement).getBaseClassReference();
                    original = ref;
                    refElement = ref.resolve();
                }
                boolean isFQ = false;
                if (original instanceof PsiJavaCodeReferenceElementImpl) {
                    int kind = ((PsiJavaCodeReferenceElementImpl)original).getKind(original.getContainingFile());
                    switch (kind) {
                        case 1: 
                        case 3: 
                        case 6: {
                            isFQ = false;
                            break;
                        }
                        case 4: 
                        case 5: {
                            isFQ = true;
                            break;
                        }
                        default: {
                            LOG.assertTrue(false);
                        }
                    }
                }
                String text4 = isFQ ? ((PsiClass)refElement).getQualifiedName() : original.getText();
                TreeElement element = JavaTreeGenerator.createReference(original.getProject(), text4, generated);
                element.putCopyableUserData(REFERENCED_CLASS_KEY, (PsiClass)refElement);
                return element;
            }
            return JavaTreeGenerator.createReference(original.getProject(), original.getText(), generated);
        }
        if (original instanceof PsiCompiledElement) {
            PsiElement sourceVersion = original.getNavigationElement();
            if (sourceVersion != original) {
                return ChangeUtil.generateTreeElement(sourceVersion, table, manager);
            }
            PsiElement mirror = ((PsiCompiledElement)original).getMirror();
            return ChangeUtil.generateTreeElement(mirror, table, manager);
        }
        if (original instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)original;
            PsiType type2 = typeElement.getType();
            if (type2 instanceof PsiIntersectionType) {
                type2 = ((PsiIntersectionType)type2).getRepresentative();
            } else if (type2 instanceof PsiMethodReferenceType || type2 instanceof PsiLambdaExpressionType) {
                type2 = PsiType.getJavaLangObject(manager, GlobalSearchScope.projectScope(manager.getProject()));
            }
            String text5 = type2.getCanonicalText(true);
            PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(original.getProject()).getParserFacade();
            PsiTypeElement element = parserFacade.createTypeElementFromText(text5, original);
            TreeElement result2 = (TreeElement)element.getNode();
            JavaTreeGenerator.markGeneratedIfNeeded(original, result2);
            JavaTreeGenerator.encodeInfoInTypeElement(result2, type2);
            return result2;
        }
        return null;
    }

    private static LeafElement createLeafFromText(String text2, CharTable table, PsiManager manager, PsiElement original, IElementType type2) {
        return Factory.createSingleLeafElement(type2, (CharSequence)text2, 0, text2.length(), table, manager, CodeEditUtil.isNodeGenerated(original.getNode()));
    }

    private static TreeElement markGeneratedIfNeeded(@NotNull PsiElement original, @NotNull TreeElement copy) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaTreeGenerator", "markGeneratedIfNeeded"));
        }
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaTreeGenerator", "markGeneratedIfNeeded"));
        }
        if (CodeEditUtil.isNodeGenerated(original.getNode())) {
            copy.acceptTree(new GeneratedMarkerVisitor());
        }
        return copy;
    }

    private static TreeElement createReference(Project project, String text2, boolean mark) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(project).getParserFacade();
        TreeElement element = (TreeElement)parserFacade.createReferenceFromText(text2, null).getNode();
        if (mark) {
            element.acceptTree(new GeneratedMarkerVisitor());
        }
        return element;
    }

    private static TreeElement createReferenceExpression(Project project, String text2, PsiElement context) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(project).getParserFacade();
        PsiExpression expression2 = parserFacade.createExpressionFromText(text2, context);
        return (TreeElement)expression2.getNode();
    }

    private static void encodeInfoInTypeElement(ASTNode typeElement, PsiType type2) {
        if (type2 instanceof PsiPrimitiveType) {
            return;
        }
        LOG.assertTrue(typeElement.getElementType() == JavaElementType.TYPE);
        if (type2 instanceof PsiArrayType) {
            ASTNode firstChild = typeElement.getFirstChildNode();
            LOG.assertTrue(firstChild.getElementType() == JavaElementType.TYPE);
            JavaTreeGenerator.encodeInfoInTypeElement(firstChild, ((PsiArrayType)type2).getComponentType());
        } else if (type2 instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)type2).getBound();
            if (bound == null) {
                return;
            }
            ASTNode lastChild = typeElement.getLastChildNode();
            if (lastChild.getElementType() != JavaElementType.TYPE) {
                return;
            }
            JavaTreeGenerator.encodeInfoInTypeElement(lastChild, bound);
        } else if (type2 instanceof PsiCapturedWildcardType) {
            PsiType bound = ((PsiCapturedWildcardType)type2).getWildcard().getBound();
            if (bound == null) {
                return;
            }
            ASTNode lastChild = typeElement.getLastChildNode();
            if (lastChild.getElementType() != JavaElementType.TYPE) {
                return;
            }
            JavaTreeGenerator.encodeInfoInTypeElement(lastChild, bound);
        } else if (type2 instanceof PsiIntersectionType) {
            JavaTreeGenerator.encodeInfoInTypeElement(typeElement, ((PsiIntersectionType)type2).getRepresentative());
        } else if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass referencedClass = resolveResult.getElement();
            if (referencedClass == null) {
                return;
            }
            if (referencedClass instanceof PsiAnonymousClass) {
                JavaTreeGenerator.encodeInfoInTypeElement(typeElement, ((PsiAnonymousClass)referencedClass).getBaseClassType());
            } else {
                ASTNode reference = typeElement.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
                if (reference instanceof CompositeElement) {
                    JavaTreeGenerator.encodeClassTypeInfoInReference((CompositeElement)reference, resolveResult.getElement(), resolveResult.getSubstitutor());
                }
            }
        }
    }

    private static void encodeClassTypeInfoInReference(@NotNull CompositeElement reference, PsiClass referencedClass, PsiSubstitutor substitutor2) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaTreeGenerator", "encodeClassTypeInfoInReference"));
        }
        reference.putCopyableUserData(REFERENCED_CLASS_KEY, referencedClass);
        PsiTypeParameter[] typeParameters2 = referencedClass.getTypeParameters();
        if (typeParameters2.length == 0) {
            return;
        }
        ASTNode referenceParameterList = reference.findChildByRole(246);
        int index2 = 0;
        for (ASTNode child = referenceParameterList.getFirstChildNode(); child != null && index2 < typeParameters2.length; child = child.getTreeNext()) {
            if (child.getElementType() != JavaElementType.TYPE) continue;
            PsiType substitutedType = substitutor2.substitute(typeParameters2[index2]);
            if (substitutedType != null) {
                JavaTreeGenerator.encodeInfoInTypeElement(child, substitutedType);
            }
            ++index2;
        }
        ASTNode qualifier = reference.findChildByRole(54);
        if (qualifier != null) {
            if (referencedClass.hasModifierProperty("static")) {
                return;
            }
            PsiClass outerClass2 = referencedClass.getContainingClass();
            if (outerClass2 != null) {
                JavaTreeGenerator.encodeClassTypeInfoInReference((CompositeElement)qualifier, outerClass2, substitutor2);
            }
        }
    }
}

