/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public class PsiDeclarationStatementImpl
extends CompositePsiElement
implements PsiDeclarationStatement {
    private static final TokenSet DECLARED_ELEMENT_BIT_SET = TokenSet.create(JavaElementType.LOCAL_VARIABLE, JavaElementType.CLASS);

    public PsiDeclarationStatementImpl() {
        super(JavaElementType.DECLARATION_STATEMENT);
    }

    @Override
    @NotNull
    public PsiElement[] getDeclaredElements() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(DECLARED_ELEMENT_BIT_SET, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiDeclarationStatementImpl", "getDeclaredElements"));
        }
        return psiElementArray;
    }

    @Override
    public int getChildRole(ASTNode child) {
        if (child.getElementType() == JavaTokenType.COMMA) {
            return 23;
        }
        return super.getChildRole(child);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement[] declaredElements;
        int length;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiDeclarationStatementImpl", "deleteChildInternal"));
        }
        if (DECLARED_ELEMENT_BIT_SET.contains(child.getElementType()) && (length = (declaredElements = this.getDeclaredElements()).length) > 0) {
            if (length == 1) {
                this.getTreeParent().deleteChildInternal(this);
                return;
            }
            if (SourceTreeToPsiMap.psiElementToTree(declaredElements[length - 1]) == child) {
                this.removeCommaBefore(child);
                LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, SharedImplUtil.findCharTableByTree(this), this.getManager());
                SourceTreeToPsiMap.psiElementToTree(declaredElements[length - 2]).addChild(semicolon, null);
            } else if (SourceTreeToPsiMap.psiElementToTree(declaredElements[0]) == child) {
                CompositeElement next = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(declaredElements[1]);
                ASTNode copyChild = child.copyElement();
                ASTNode nameChild = ((CompositeElement)copyChild).findChildByRole(9);
                this.removeCommaBefore(next);
                next.addInternal((TreeElement)copyChild.getFirstChildNode(), nameChild.getTreePrev(), null, Boolean.FALSE);
            } else {
                this.removeCommaBefore(child);
            }
        }
        super.deleteChildInternal(child);
    }

    private void removeCommaBefore(ASTNode child) {
        ASTNode prev = child;
        while ((prev = prev.getTreePrev()) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(prev.getElementType())) {
        }
        if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
            this.deleteChildInternal(prev);
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiDeclarationStatementImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitDeclarationStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiDeclarationStatement";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        PsiElement[] decls;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiDeclarationStatementImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiDeclarationStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiDeclarationStatementImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        for (PsiElement decl : decls = this.getDeclaredElements()) {
            if (decl != lastParent) {
                if (processor.execute(decl, state2)) continue;
                return false;
            }
            ElementClassHint hint = processor.getHint(ElementClassHint.KEY);
            if (!(lastParent instanceof PsiClass) || hint != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS) || processor.execute(lastParent, state2)) continue;
            return false;
        }
        return true;
    }
}

