/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.collections;

import java.util.NoSuchElementException;
import org.multiverse.api.Stm;
import org.multiverse.api.Txn;
import org.multiverse.api.TxnThreadLocal;
import org.multiverse.api.collections.TxnDeque;
import org.multiverse.api.collections.TxnIterator;
import org.multiverse.api.collections.TxnList;
import org.multiverse.api.exceptions.TodoException;
import org.multiverse.api.references.TxnInteger;
import org.multiverse.api.references.TxnRef;
import org.multiverse.api.references.TxnRefFactory;
import org.multiverse.collections.AbstractTxnCollection;

public final class NaiveTxnLinkedList<E>
extends AbstractTxnCollection<E>
implements TxnDeque<E>,
TxnList<E> {
    private final int capacity;
    private final TxnInteger size;
    private final TxnRef<Entry<E>> head;
    private final TxnRef<Entry<E>> tail;

    public NaiveTxnLinkedList(Stm stm) {
        this(stm, Integer.MAX_VALUE);
    }

    public NaiveTxnLinkedList(Stm stm, int capacity) {
        super(stm);
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.size = stm.getDefaultRefFactory().newTxnInteger(0);
        this.head = stm.getDefaultRefFactory().newTxnRef(null);
        this.tail = stm.getDefaultRefFactory().newTxnRef(null);
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public E set(int index, E element) {
        return this.set(TxnThreadLocal.getThreadLocalTxn(), index, element);
    }

    @Override
    public E set(Txn tx, int index, E element) {
        return ((Entry)this.entry(tx, index)).value.getAndSet(tx, element);
    }

    @Override
    public int size(Txn tx) {
        return this.size.get(tx);
    }

    @Override
    public int indexOf(Object item) {
        return this.indexOf(TxnThreadLocal.getThreadLocalTxn(), item);
    }

    @Override
    public int indexOf(Txn tx, Object item) {
        if (item == null) {
            return -1;
        }
        int index = 0;
        Entry node = this.head.get(tx);
        while (node != null) {
            if (node.value.get(tx).equals(item)) {
                return index;
            }
            node = (Entry)node.next.get(tx);
            ++index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object item) {
        return this.lastIndexOf(TxnThreadLocal.getThreadLocalTxn(), item);
    }

    @Override
    public int lastIndexOf(Txn tx, Object item) {
        if (item == null) {
            return -1;
        }
        int index = this.size.get(tx) - 1;
        Entry node = this.tail.get(tx);
        while (node != null) {
            if (node.value.get(tx).equals(item)) {
                return index;
            }
            node = (Entry)node.previous.get(tx);
            --index;
        }
        return -1;
    }

    private Entry<E> entry(Txn tx, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int s = this.size.get(tx);
        if (index >= s) {
            throw new IndexOutOfBoundsException();
        }
        if (index < s >> 1) {
            int i = 0;
            Entry node = this.head.get(tx);
            while (true) {
                if (i == index) {
                    return node;
                }
                node = (Entry)node.next.get(tx);
                ++i;
            }
        }
        int i = s - 1;
        Entry node = this.tail.get(tx);
        while (i != index) {
            node = (Entry)node.previous.get(tx);
            --i;
        }
        return node;
    }

    @Override
    public boolean contains(Txn tx, Object o) {
        return this.indexOf(tx, o) != -1;
    }

    @Override
    public boolean remove(Txn tx, Object o) {
        return false;
    }

    @Override
    public void clear(Txn tx) {
        if (this.size.get(tx) == 0) {
            return;
        }
        this.size.set(tx, 0);
        this.head.set(tx, null);
        this.tail.set(tx, null);
    }

    @Override
    public E element() {
        return this.element(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E element(Txn tx) {
        return this.getFirst(tx);
    }

    @Override
    public E pop() {
        return this.pop(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E pop(Txn tx) {
        return this.removeFirst(tx);
    }

    @Override
    public void push(E e) {
        this.push(TxnThreadLocal.getThreadLocalTxn(), e);
    }

    @Override
    public void push(Txn tx, E e) {
        this.addFirst(tx, e);
    }

    @Override
    public E remove(int index) {
        return this.remove(TxnThreadLocal.getThreadLocalTxn(), index);
    }

    @Override
    public E remove(Txn tx, int index) {
        Entry<E> entry = this.entry(tx, index);
        throw new UnsupportedOperationException();
    }

    @Override
    public E removeFirst() {
        return this.removeFirst(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E removeFirst(Txn tx) {
        E element = this.pollFirst(tx);
        if (element == null) {
            throw new NoSuchElementException("NaiveTxnLinkedList is empty");
        }
        return element;
    }

    @Override
    public E removeLast() {
        return this.removeLast(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E removeLast(Txn tx) {
        E element = this.pollLast(tx);
        if (element == null) {
            throw new NoSuchElementException("NaiveTxnLinkedList is empty");
        }
        return element;
    }

    @Override
    public E remove() {
        return this.remove(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E remove(Txn tx) {
        return this.removeFirst(tx);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.removeFirstOccurrence(TxnThreadLocal.getThreadLocalTxn(), o);
    }

    @Override
    public boolean removeFirstOccurrence(Txn tx, Object o) {
        throw new TodoException();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.removeLastOccurrence(TxnThreadLocal.getThreadLocalTxn(), o);
    }

    @Override
    public boolean removeLastOccurrence(Txn tx, Object o) {
        throw new TodoException();
    }

    @Override
    public E getFirst() {
        return this.getFirst(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E getFirst(Txn tx) {
        E result = this.pollFirst(tx);
        if (result == null) {
            throw new NoSuchElementException("NaiveTxnLinkedList is empty");
        }
        return result;
    }

    @Override
    public E getLast() {
        return this.getLast(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E getLast(Txn tx) {
        E result = this.pollLast(tx);
        if (result == null) {
            throw new NoSuchElementException("NaiveTxnLinkedList is empty");
        }
        return result;
    }

    @Override
    public E get(int index) {
        return this.get(TxnThreadLocal.getThreadLocalTxn(), index);
    }

    @Override
    public E get(Txn tx, int index) {
        return ((Entry)this.entry(tx, index)).value.get(tx);
    }

    @Override
    public void addFirst(E e) {
        this.addFirst(TxnThreadLocal.getThreadLocalTxn(), e);
    }

    @Override
    public void addFirst(Txn tx, E e) {
        if (!this.offerFirst(tx, e)) {
            throw new IllegalStateException("NaiveTxnLinkedList full");
        }
    }

    @Override
    public void addLast(E e) {
        this.addLast(TxnThreadLocal.getThreadLocalTxn(), e);
    }

    @Override
    public void addLast(Txn tx, E e) {
        if (!this.offerLast(tx, e)) {
            throw new IllegalStateException("NaiveTxnLinkedList full");
        }
    }

    @Override
    public boolean add(Txn tx, E e) {
        if (!this.offer(tx, e)) {
            throw new IllegalStateException("NaiveTxnLinkedList full");
        }
        return true;
    }

    @Override
    public void putFirst(E item) {
        this.putFirst(TxnThreadLocal.getThreadLocalTxn(), item);
    }

    @Override
    public void putFirst(Txn tx, E item) {
        if (!this.offerFirst(tx, item)) {
            tx.retry();
        }
    }

    @Override
    public void put(E item) {
        this.put(TxnThreadLocal.getThreadLocalTxn(), item);
    }

    @Override
    public void put(Txn tx, E item) {
        this.putLast(tx, item);
    }

    @Override
    public void putLast(E item) {
        this.putLast(TxnThreadLocal.getRequiredThreadLocalTxn(), item);
    }

    @Override
    public void putLast(Txn tx, E item) {
        if (!this.offerLast(tx, item)) {
            tx.retry();
        }
    }

    @Override
    public E take() {
        return this.take(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E take(Txn tx) {
        return this.takeLast(tx);
    }

    @Override
    public E takeFirst() {
        return this.takeFirst(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E takeFirst(Txn tx) {
        E item = this.pollFirst(tx);
        if (item == null) {
            tx.retry();
        }
        return item;
    }

    @Override
    public E takeLast() {
        return this.takeLast(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E takeLast(Txn tx) {
        E item = this.pollLast(tx);
        if (item == null) {
            tx.retry();
        }
        return item;
    }

    @Override
    public boolean offerFirst(E e) {
        return this.offerFirst(TxnThreadLocal.getThreadLocalTxn(), e);
    }

    @Override
    public boolean offerFirst(Txn tx, E item) {
        if (item == null) {
            throw new NullPointerException();
        }
        int s = this.size.get(tx);
        if (s == this.capacity) {
            return false;
        }
        Entry<E> node = new Entry<E>(this.defaultRefFactory, item);
        if (s == 0) {
            this.head.set(tx, node);
            this.tail.set(tx, node);
        } else {
            ((Entry)node).next.set(tx, this.head.get(tx));
            ((Entry)this.head.get(tx)).previous.set(tx, node);
            this.head.set(tx, node);
        }
        this.size.increment(tx);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        return this.offerLast(TxnThreadLocal.getThreadLocalTxn(), e);
    }

    @Override
    public boolean offerLast(Txn tx, E item) {
        if (item == null) {
            throw new NullPointerException();
        }
        int s = this.size.get(tx);
        if (s == this.capacity) {
            return false;
        }
        Entry<E> node = new Entry<E>(this.defaultRefFactory, item);
        if (s == 0) {
            this.head.set(tx, node);
            this.tail.set(tx, node);
        } else {
            ((Entry)node).previous.set(tx, this.tail.get(tx));
            ((Entry)this.tail.get(tx)).next.set(tx, node);
            this.tail.set(tx, node);
        }
        this.size.increment(tx);
        return true;
    }

    @Override
    public boolean offer(E item) {
        return this.offer(TxnThreadLocal.getThreadLocalTxn(), item);
    }

    @Override
    public boolean offer(Txn tx, E item) {
        return this.offerLast(tx, item);
    }

    @Override
    public E pollFirst() {
        return this.pollFirst(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E pollFirst(Txn tx) {
        Object item;
        int s = this.size.get(tx);
        if (s == 0) {
            return null;
        }
        if (s == 1) {
            item = ((Entry)this.tail.get(tx)).value.get(tx);
            this.head.set(tx, null);
            this.tail.set(tx, null);
        } else {
            Entry<E> oldHead = this.head.get(tx);
            item = ((Entry)oldHead).value.get(tx);
            Entry newHead = (Entry)((Entry)oldHead).next.get(tx);
            this.head.set(tx, newHead);
            newHead.previous.set(tx, null);
        }
        this.size.decrement(tx);
        return item;
    }

    @Override
    public E pollLast() {
        return this.pollLast(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E pollLast(Txn tx) {
        Object item;
        int s = this.size.get(tx);
        if (s == 0) {
            return null;
        }
        if (s == 1) {
            item = ((Entry)this.head.get(tx)).value.get(tx);
            this.head.set(tx, null);
            this.tail.set(tx, null);
        } else {
            Entry<E> oldTail = this.tail.get(tx);
            item = ((Entry)oldTail).value.get(tx);
            Entry newTail = (Entry)((Entry)oldTail).previous.get(tx);
            this.tail.set(tx, newTail);
            newTail.next.set(tx, null);
        }
        this.size.decrement(tx);
        return item;
    }

    @Override
    public E poll() {
        return this.poll(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E poll(Txn tx) {
        return this.pollLast(tx);
    }

    @Override
    public E peekFirst() {
        return this.peekFirst(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E peekFirst(Txn tx) {
        Entry<E> h = this.head.get(tx);
        return h == null ? null : (E)((Entry)h).value.get(tx);
    }

    @Override
    public E peekLast() {
        return this.peekLast(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E peekLast(Txn tx) {
        Entry<E> t = this.tail.get(tx);
        return t == null ? null : (E)((Entry)t).value.get(tx);
    }

    @Override
    public E peek() {
        return this.peek(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public E peek(Txn tx) {
        return this.peekFirst(tx);
    }

    @Override
    public TxnIterator<E> iterator(Txn tx) {
        throw new TodoException();
    }

    @Override
    public TxnIterator<E> descendingIterator() {
        return this.descendingIterator(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public TxnIterator<E> descendingIterator(Txn tx) {
        throw new TodoException();
    }

    @Override
    public String toString(Txn tx) {
        int s = this.size(tx);
        if (s == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        Entry node = this.head.get(tx);
        do {
            sb.append(node.value.get(tx));
            node = (Entry)node.next.get(tx);
            if (node == null) continue;
            sb.append(", ");
        } while (node != null);
        sb.append(']');
        return sb.toString();
    }

    static class Entry<E> {
        private final TxnRef<Entry<E>> next;
        private final TxnRef<Entry<E>> previous;
        private final TxnRef<E> value;

        Entry(TxnRefFactory refFactory, E value) {
            this.next = refFactory.newTxnRef(null);
            this.previous = refFactory.newTxnRef(null);
            this.value = refFactory.newTxnRef(value);
        }
    }
}

