/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.AggregateTransformer;
import org.apache.tools.ant.taskdefs.optional.junit.DOMUtil;
import org.apache.tools.ant.taskdefs.optional.junit.XMLConstants;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLResultAggregator
extends Task
implements XMLConstants {
    protected Vector filesets = new Vector();
    protected String toFile;
    protected File toDir;
    protected Vector transformers = new Vector();
    public static final String DEFAULT_DIR = ".";
    public static final String DEFAULT_FILENAME = "TESTS-TestSuites.xml";
    protected int generatedId = 0;
    static final String WARNING_IS_POSSIBLY_CORRUPTED = " is not a valid XML document. It is possibly corrupted.";
    static final String WARNING_INVALID_ROOT_ELEMENT = " is not a valid testsuite XML document";
    static final String WARNING_EMPTY_FILE = " is empty.\nThis can be caused by the test JVM exiting unexpectedly";

    public AggregateTransformer createReport() {
        AggregateTransformer transformer = new AggregateTransformer(this);
        this.transformers.addElement(transformer);
        return transformer;
    }

    public void setTofile(String value) {
        this.toFile = value;
    }

    public void setTodir(File value) {
        this.toDir = value;
    }

    public void addFileSet(FileSet fs) {
        this.filesets.addElement(fs);
    }

    public void execute() throws BuildException {
        Element rootElement = this.createDocument();
        File destFile = this.getDestinationFile();
        try {
            this.writeDOMTree(rootElement.getOwnerDocument(), destFile);
        }
        catch (IOException e) {
            throw new BuildException("Unable to write test aggregate to '" + destFile + "'", (Throwable)e);
        }
        Enumeration e = this.transformers.elements();
        while (e.hasMoreElements()) {
            AggregateTransformer transformer = (AggregateTransformer)e.nextElement();
            transformer.setXmlDocument(rootElement.getOwnerDocument());
            transformer.transform();
        }
    }

    public File getDestinationFile() {
        if (this.toFile == null) {
            this.toFile = DEFAULT_FILENAME;
        }
        if (this.toDir == null) {
            this.toDir = this.getProject().resolveFile(DEFAULT_DIR);
        }
        return new File(this.toDir, this.toFile);
    }

    protected File[] getFiles() {
        Vector<File> v = new Vector<File>();
        int size = this.filesets.size();
        for (int i = 0; i < size; ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] f = ds.getIncludedFiles();
            for (int j = 0; j < f.length; ++j) {
                String pathname = f[j];
                if (!pathname.endsWith(".xml")) continue;
                File file = new File(ds.getBasedir(), pathname);
                file = this.getProject().resolveFile(file.getPath());
                v.addElement(file);
            }
        }
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDOMTree(Document doc, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            PrintWriter wri = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), "UTF8"));
            wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            new DOMElementWriter().write(doc.getDocumentElement(), (Writer)wri, 0, "  ");
            wri.flush();
            if (wri.checkError()) {
                throw new IOException("Error while writing DOM content");
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((OutputStream)os).close();
            throw throwable;
        }
        ((OutputStream)os).close();
    }

    protected Element createDocument() {
        DocumentBuilder builder = XMLResultAggregator.getDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("testsuites");
        doc.appendChild(rootElement);
        this.generatedId = 0;
        File[] files = this.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                this.log("Parsing file: '" + file + "'", 3);
                if (file.length() > 0L) {
                    Document testsuiteDoc = builder.parse(FileUtils.getFileUtils().toURI(files[i].getAbsolutePath()));
                    Element elem = testsuiteDoc.getDocumentElement();
                    if ("testsuite".equals(elem.getNodeName())) {
                        this.addTestSuite(rootElement, elem);
                        ++this.generatedId;
                        continue;
                    }
                    this.log("the file " + file + WARNING_INVALID_ROOT_ELEMENT, 1);
                    continue;
                }
                this.log("the file " + file + WARNING_EMPTY_FILE, 1);
                continue;
            }
            catch (SAXException e) {
                this.log("The file " + file + WARNING_IS_POSSIBLY_CORRUPTED, 1);
                this.log(StringUtils.getStackTrace((Throwable)e), 4);
                continue;
            }
            catch (IOException e) {
                this.log("Error while accessing file " + file + ": " + e.getMessage(), 0);
                this.log("Error while accessing file " + file + ": " + e.getMessage(), e, 3);
            }
        }
        return rootElement;
    }

    protected void addTestSuite(Element root, Element testsuite) {
        String fullclassname = testsuite.getAttribute("name");
        int pos = fullclassname.lastIndexOf(46);
        String pkgName = pos == -1 ? "" : fullclassname.substring(0, pos);
        String classname = pos == -1 ? fullclassname : fullclassname.substring(pos + 1);
        Element copy = (Element)DOMUtil.importNode(root, testsuite);
        copy.setAttribute("name", classname);
        copy.setAttribute("package", pkgName);
        copy.setAttribute("id", Integer.toString(this.generatedId));
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }
}

