#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: brick
version: 0.29.1
id: brick-0.29.1-2qyaRY6j1BEZL30J4uPI2
key: brick-0.29.1-2qyaRY6j1BEZL30J4uPI2
license: BSD3
copyright: (c) Jonathan Daugherty 2015-2016
maintainer: Jonathan Daugherty <cygnus@foobox.com>
homepage: https://github.com/jtdaugherty/brick/
synopsis: A declarative terminal user interface library
description:
    Write terminal applications painlessly with '\''brick'\''! You write an
    event handler and a drawing function and the library does the rest.
    .
    .
    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui
    .
    .
    To get started, see:
    .
    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>
    .
    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>
    .
    * The demonstration programs in the '\''programs'\'' directory
    .
    .
    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.
category: Graphics
author: Jonathan Daugherty <cygnus@foobox.com>
exposed: True
indefinite: False
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.Focus Brick.Main Brick.Markup
    Brick.Themes Brick.Types Brick.Util Brick.Widgets.Border
    Brick.Widgets.Border.Style Brick.Widgets.Center Brick.Widgets.Core
    Brick.Widgets.Dialog Brick.Widgets.Edit Brick.Widgets.List
    Brick.Widgets.ProgressBar Data.Text.Markup
hidden-modules: Brick.Types.TH Brick.Types.Internal
                Brick.Widgets.Internal
abi: e64f6ddb2f5be61edd32a74742bd157c
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/brick-0.29.1
library-dirs: /usr/lib/ghc-8.2.2/site-local/brick-0.29.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/brick-0.29.1
hs-libraries: HSbrick-0.29.1-2qyaRY6j1BEZL30J4uPI2
depends:
    base-4.10.1.0 vty-5.18.1-1ArmFyNsA4q47eJ7kNxO transformers-0.5.2.0
    data-clist-0.1.1.0-GTgxQ3fV2psCcWfrZtLEgz
    dlist-0.8.0.3-3sLvqWTqZxIC2tgTx4QBVJ containers-0.5.10.2
    microlens-0.4.8.1-7SYUbX7BsEv8bVxypsAUmf
    microlens-th-0.4.1.1-HZwVEq73HCOxGGKdEpftc
    microlens-mtl-0.1.11.0-I3xc8yNAKhRDow99zskwam
    config-ini-0.2.1.1-91CoYJyM9oPI0Z7oiQnnBX
    vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
    contravariant-1.4-7z11WOqE85DGeP9JdLBkE1
    stm-2.4.4.1-E6EjE1bszQZJ9orPdUNxjw
    text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj
    text-zipper-0.10.1-7tRfaZ2vxk4GyFrQcYO9Xp template-haskell-2.12.0.0
    deepseq-1.4.3.0 word-wrap-0.4.1-BiGv5lllxt86tmP6nlwLEI
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             vty-5.18.1-1ArmFyNsA4q47eJ7kNxO=15fd3d7aee30360d6215f6e34ef3966b
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             data-clist-0.1.1.0-GTgxQ3fV2psCcWfrZtLEgz=f662e1373618b30d0a636561a5a56e93
             dlist-0.8.0.3-3sLvqWTqZxIC2tgTx4QBVJ=478549693a66e61496f47353d337a8f9
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             microlens-0.4.8.1-7SYUbX7BsEv8bVxypsAUmf=4a2398c3f847dcb0d93febf5e9ae665a
             microlens-th-0.4.1.1-HZwVEq73HCOxGGKdEpftc=c38adc99f710ad60976790e1bdd28c3d
             microlens-mtl-0.1.11.0-I3xc8yNAKhRDow99zskwam=c58acf4ea4acdf12cb62f8e505c94b97
             config-ini-0.2.1.1-91CoYJyM9oPI0Z7oiQnnBX=66a68ca2ccbbeb6fac322b4703eb482d
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=d8375a46a4155c3f449ce3d319b3dbaa
             contravariant-1.4-7z11WOqE85DGeP9JdLBkE1=229249a7c431fe44ea9abf1ace1931a4
             stm-2.4.4.1-E6EjE1bszQZJ9orPdUNxjw=63c518eabfb1b430d925fb35cc544a7c
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             text-zipper-0.10.1-7tRfaZ2vxk4GyFrQcYO9Xp=9e00f649532a00ef322385b980fa1dd1
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             word-wrap-0.4.1-BiGv5lllxt86tmP6nlwLEI=1ef7862177f374982ab79984b82eb122
haddock-interfaces: /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html: /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

