#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.5.3
id: esqueleto-2.5.3-JCxNP1mQ0y0yJjT2zdzvy
key: esqueleto-2.5.3-JCxNP1mQ0y0yJjT2zdzvy
license: BSD3
copyright: (c) 2012-2016 Felipe Almeida Lessa
maintainer: cma@bitemyapp.com
homepage: https://github.com/bitemyapp/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries
    that works with unmodified @persistent@ SQL backends.  Its
    language closely resembles SQL, so you don'\''t have to learn
    new concepts, just new syntax, and it'\''s fairly easy to
    predict the generated SQL and optimize it for your backend.
    Most kinds of errors committed when writing SQL are caught as
    compile-time errors---although it is possible to write
    type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It
    has many kinds of backends, such as SQL backends
    (@persistent-mysql@, @persistent-postgresql@,
    @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@).
    While @persistent@ is a nice library for storing and retrieving
    records, including with filters, it does not try to support
    some of the features that are specific to SQL backends.  In
    particular, @esqueleto@ is the recommended library for
    type-safe @JOIN@s on @persistent@ SQL backends.  (The
    alternative is using raw SQL, but that'\''s error prone and does
    not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported.
    Not all SQL features are available, but most of them can be easily added
    (especially functions), so please open an issue or send a pull request if
    you need anything that is not covered by @esqueleto@ on
    <https://github.com/bitemyapp/esqueleto>.
    .
    The name of this library means \"skeleton\" in Portuguese and
    contains all three SQL letters in the correct order =).  It was
    inspired by Scala'\''s Squeryl but created from scratch.
category: Database
author: Felipe Lessa
exposed: True
indefinite: False
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql Database.Esqueleto.PostgreSQL
hidden-modules: Database.Esqueleto.Internal.PersistentImport
abi: 0f93f32b6bd032f7c490e28abe0b42cd
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/esqueleto-2.5.3
library-dirs: /usr/lib/ghc-8.2.2/site-local/esqueleto-2.5.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/esqueleto-2.5.3
hs-libraries: HSesqueleto-2.5.3-JCxNP1mQ0y0yJjT2zdzvy
depends:
    base-4.10.1.0 bytestring-0.10.8.2
    text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj
    persistent-2.7.1-Dn6FGgPi3aHAUYdov3568c transformers-0.5.2.0
    unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV
    tagged-0.8.5-BP06XmR1GLaIsvsOKwGst2
    monad-logger-0.3.26-2qUqy16RcpO3PSVfhjBDgd
    conduit-1.2.12.1-BcLGeTf7mkLAqHbUwhBWCt
    resourcet-1.1.10-9ZnD9eSbn8b2f4IrDnWp0t
    blaze-html-0.9.0.1-AJ5BYeepLwbHkN0LWWSQW
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             persistent-2.7.1-Dn6FGgPi3aHAUYdov3568c=64d4ddbe28b50f275a109b6e970731fd
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV=db9131d5548eea6d7a3eab9f0d172004
             tagged-0.8.5-BP06XmR1GLaIsvsOKwGst2=b5d07becd47ba21e20b584b61ad0f06d
             monad-logger-0.3.26-2qUqy16RcpO3PSVfhjBDgd=b40cc4654bf1317eea11e10f8aa354c7
             conduit-1.2.12.1-BcLGeTf7mkLAqHbUwhBWCt=11f5959f328c663d7ee883702af377dd
             resourcet-1.1.10-9ZnD9eSbn8b2f4IrDnWp0t=f535b5e5a897661c493ba14a3655526f
             blaze-html-0.9.0.1-AJ5BYeepLwbHkN0LWWSQW=149b27858c24c2fbb2a49b79255301b8
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

