#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: graphviz
version: 2999.19.0.0
id: graphviz-2999.19.0.0-HIqDgx9E4cD56gF10JOd6W
key: graphviz-2999.19.0.0-HIqDgx9E4cD56gF10JOd6W
license: BSD3
copyright: Matthew Sackman, Ivan Lazar Miljenovic
maintainer: Ivan.Miljenovic@gmail.com
stability: Beta
homepage: http://projects.haskell.org/graphviz/
synopsis: Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.
    .
    Main features of the graphviz library include:
    .
    * Almost complete coverage of all Graphviz attributes and syntax.
    .
    * Support for specifying clusters.
    .
    * The ability to use a custom node type.
    .
    * Functions for running a Graphviz layout tool with all specified
    output types.
    .
    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).
    .
    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.
    .
    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.
category: Graphs, Graphics
author: Matthew Sackman, Ivan Lazar Miljenovic
exposed: True
indefinite: False
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic
hidden-modules: Data.GraphViz.Algorithms.Clustering
                Data.GraphViz.Attributes.Arrows
                Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
                Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
                Data.GraphViz.Types.State
abi: f713d8ddd5ec27de6c9912e0fde7d88d
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/graphviz-2999.19.0.0
library-dirs: /usr/lib/ghc-8.2.2/site-local/graphviz-2999.19.0.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/graphviz-2999.19.0.0
hs-libraries: HSgraphviz-2999.19.0.0-HIqDgx9E4cD56gF10JOd6W
depends:
    base-4.10.1.0 containers-0.5.10.2 process-1.6.1.0 directory-1.3.0.2
    temporary-1.2.1.1-7a1ypWDsHB4EWhBxWwtUro
    fgl-5.5.4.0-9LmntGux65f56KmvEYc3VM filepath-1.4.1.2
    polyparse-1.12-8mKJaXtdEV4EFGuCY0PhtK bytestring-0.10.8.2
    colour-2.3.4-4FOR755TjbXCteGD5Oe26Q transformers-0.5.2.0
    text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj
    wl-pprint-text-1.1.1.0-H9VND1YBntSClVyesWzGf6
    dlist-0.8.0.3-3sLvqWTqZxIC2tgTx4QBVJ
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             temporary-1.2.1.1-7a1ypWDsHB4EWhBxWwtUro=b8bff4b84b25638f1f5ef8924bbd6e32
             fgl-5.5.4.0-9LmntGux65f56KmvEYc3VM=daf4705edeb832f8a70b64436c00a274
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             polyparse-1.12-8mKJaXtdEV4EFGuCY0PhtK=279fb5ca8e609f0afddb30f3461f7e00
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             colour-2.3.4-4FOR755TjbXCteGD5Oe26Q=5a3580e6fb04cd83bff9a9ebb80037e2
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             wl-pprint-text-1.1.1.0-H9VND1YBntSClVyesWzGf6=1efcb44e443dd6cda35ac8e62cb06ce9
             dlist-0.8.0.3-3sLvqWTqZxIC2tgTx4QBVJ=478549693a66e61496f47353d337a8f9
haddock-interfaces: /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html: /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

