#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: jose
version: 0.6.0.3
id: jose-0.6.0.3-KZEIupc6ahsCco1o215bdT
key: jose-0.6.0.3-KZEIupc6ahsCco1o215bdT
license: Apache-2.0
copyright: Copyright (C) 2013, 2014, 2015, 2016, 2017  Fraser Tweedale
maintainer: frase@frase.id.au
homepage: https://github.com/frasertweedale/hs-jose
synopsis: Javascript Object Signing and Encryption and JSON Web Token library
description:
    .
    An implementation of the Javascript Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519) formats.
    .
    The JSON Web Signature (JWS; RFC 7515) implementation is complete.
    .
    EdDSA signatures (RFC 8037) are supported (Ed25519 only).
    .
    JWK Thumbprint (RFC 7638) is supported (requires /aeson/ >= 0.10).
    .
    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.
    .
    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.
category: Cryptography
author: Fraser Tweedale
exposed: True
indefinite: False
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT
hidden-modules: Crypto.JOSE.TH Crypto.JOSE.Types.Internal
                Crypto.JOSE.Types.Orphans
abi: baf498815ea4bf1602f1dbcf5cbe9c77
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/jose-0.6.0.3
library-dirs: /usr/lib/ghc-8.2.2/site-local/jose-0.6.0.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/jose-0.6.0.3
hs-libraries: HSjose-0.6.0.3-KZEIupc6ahsCco1o215bdT
depends:
    base-4.10.1.0 attoparsec-0.13.2.0-1AORA640dG8HmlrlyiwzkH
    base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be
    concise-0.1.0.0-Excmm89Veo9IkexV1TpHQq containers-0.5.10.2
    cryptonite-0.24-EPbi0P2shFM6674a2VpBE9
    lens-4.15.4-GH6g8mH8MFUClTlMTyxH3q
    memory-0.14.9-AQUrr5dF0nV994F583HdFJ
    monad-time-0.2-LUGpLHgSHKFHCiGjsIZzVq
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    semigroups-0.18.3-3aCIuYG4ID286XaN6MuQu7 template-haskell-2.12.0.0
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    aeson-1.2.3.0-LNkLuLvRI8W9I8ocVQs80F
    unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV
    bytestring-0.10.8.2 text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj
    time-1.8.0.2 network-uri-2.6.1.0-LYYrYvUJy87zSaoB2hpvT
    QuickCheck-2.10.1-BUFYQzp5Pjm7JbQeTzW89l
    quickcheck-instances-0.3.16-3UD6wLZXdsRFW21IXRqVEU
    x509-1.7.2-3BTw6RFLwvUAEE2vpmDae6
    vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             attoparsec-0.13.2.0-1AORA640dG8HmlrlyiwzkH=166a433e56e808d42a86e30017dad920
             base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be=fd5db0dc9688093c1ac2c3223371478e
             concise-0.1.0.0-Excmm89Veo9IkexV1TpHQq=2a79b41102334b35b04b626f65c81968
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             cryptonite-0.24-EPbi0P2shFM6674a2VpBE9=ad6e802a541fc646db7950285912403a
             lens-4.15.4-GH6g8mH8MFUClTlMTyxH3q=8cf098094bd03d70b94ab1bdaacbff7c
             memory-0.14.9-AQUrr5dF0nV994F583HdFJ=008982010396ecb5861316ba65cfe759
             monad-time-0.2-LUGpLHgSHKFHCiGjsIZzVq=116f431f7921957b9b3eca4c6ee81af5
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             semigroups-0.18.3-3aCIuYG4ID286XaN6MuQu7=d64b81e3ed8022aca04423ee7b330679
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             aeson-1.2.3.0-LNkLuLvRI8W9I8ocVQs80F=4c58219744f0571919d1814f029cc115
             unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV=db9131d5548eea6d7a3eab9f0d172004
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             network-uri-2.6.1.0-LYYrYvUJy87zSaoB2hpvT=0b326ed8cea6aef4683ed7796a7691a6
             QuickCheck-2.10.1-BUFYQzp5Pjm7JbQeTzW89l=a871331a7e5e7b5c37818b7997512ddd
             quickcheck-instances-0.3.16-3UD6wLZXdsRFW21IXRqVEU=e1560c1f2b833683d0e6bc6bdfa252af
             x509-1.7.2-3BTw6RFLwvUAEE2vpmDae6=1b3c6fa43bdb9156755a2eda9f144c94
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=d8375a46a4155c3f449ce3d319b3dbaa
haddock-interfaces: /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html: /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

