#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: lens
version: 4.15.4
id: lens-4.15.4-6GPYoGX8D8oF6KL1aYwOV5
key: lens-4.15.4-6GPYoGX8D8oF6KL1aYwOV5
license: BSD2
copyright: Copyright (C) 2012-2016 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/lens/
synopsis: Lenses, Folds and Traversals
description:
    This package comes \"Batteries Included\" with many useful lenses for the types
    commonly used from the Haskell Platform, and with tools for automatically
    generating lenses and isomorphisms for user-supplied data types.
    .
    The combinators in @Control.Lens@ provide a highly generic toolbox for composing
    families of getters, folds, isomorphisms, traversals, setters and lenses and their
    indexed variants.
    .
    An overview, with a large number of examples can be found in the <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals README>.
    .
    An introductory video on the style of code used in this library by Simon Peyton Jones is available from <http://skillsmatter.com/podcast/scala/lenses-compositional-data-access-and-manipulation Skills Matter>.
    .
    A video on how to use lenses and how they are constructed is available on <http://youtu.be/cefnmjtAolY?hd=1 youtube>.
    .
    Slides for that second talk can be obtained from <http://comonad.com/haskell/Lenses-Folds-and-Traversals-NYC.pdf comonad.com>.
    .
    More information on the care and feeding of lenses, including a brief tutorial and motivation
    for their types can be found on the <https://github.com/ekmett/lens/wiki lens wiki>.
    .
    A small game of @pong@ and other more complex examples that manage their state using lenses can be found in the <https://github.com/ekmett/lens/blob/master/examples/ example folder>.
    .
    /Lenses, Folds and Traversals/
    .
    With some signatures simplified, the core of the hierarchy of lens-like constructions looks like:
    .
    .
    <<http://i.imgur.com/ALlbPRa.png>>
    .
    <Hierarchy.png (Local Copy)>
    .
    You can compose any two elements of the hierarchy above using @(.)@ from the @Prelude@, and you can
    use any element of the hierarchy as any type it linked to above it.
    .
    The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).
    .
    For instance:
    .
    * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.
    .
    * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.
    .
    /Minimizing Dependencies/
    .
    If you want to provide lenses and traversals for your own types in your own libraries, then you
    can do so without incurring a dependency on this (or any other) lens package at all.
    .
    /e.g./ for a data type:
    .
    > data Foo a = Foo Int Int a
    .
    You can define lenses such as
    .
    > -- bar :: Lens'\'' (Foo a) Int
    > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
    > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)
    .
    > -- quux :: Lens (Foo a) (Foo b) a b
    > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
    > quux f (Foo a b c) = fmap (Foo a b) (f c)
    .
    without the need to use any type that isn'\''t already defined in the @Prelude@.
    .
    And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':
    .
    > -- traverseBarAndBaz :: Traversal'\'' (Foo a) Int
    > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
    > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c
    .
    What is provided in this library is a number of stock lenses and traversals for
    common haskell types, a wide array of combinators for working them, and more
    exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).
category: Data, Lenses, Generics
author: Edward A. Kmett
exposed: True
indefinite: False
exposed-modules:
    Control.Exception.Lens Control.Lens Control.Lens.At
    Control.Lens.Combinators Control.Lens.Cons Control.Lens.Each
    Control.Lens.Empty Control.Lens.Equality Control.Lens.Extras
    Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
    Control.Lens.Internal Control.Lens.Internal.Bazaar
    Control.Lens.Internal.ByteString Control.Lens.Internal.CTypes
    Control.Lens.Internal.Coerce Control.Lens.Internal.Context
    Control.Lens.Internal.Deque Control.Lens.Internal.Exception
    Control.Lens.Internal.FieldTH Control.Lens.Internal.Fold
    Control.Lens.Internal.Getter Control.Lens.Internal.Indexed
    Control.Lens.Internal.Instances Control.Lens.Internal.Iso
    Control.Lens.Internal.Level Control.Lens.Internal.List
    Control.Lens.Internal.Magma Control.Lens.Internal.Prism
    Control.Lens.Internal.PrismTH Control.Lens.Internal.Review
    Control.Lens.Internal.Setter Control.Lens.Internal.TH
    Control.Lens.Internal.Zoom Control.Lens.Iso Control.Lens.Lens
    Control.Lens.Level Control.Lens.Operators Control.Lens.Plated
    Control.Lens.Prism Control.Lens.Reified Control.Lens.Review
    Control.Lens.Setter Control.Lens.TH Control.Lens.Traversal
    Control.Lens.Tuple Control.Lens.Type Control.Lens.Wrapped
    Control.Lens.Zoom Control.Monad.Error.Lens
    Control.Parallel.Strategies.Lens Control.Seq.Lens Data.Array.Lens
    Data.Bits.Lens Data.ByteString.Lazy.Lens Data.ByteString.Lens
    Data.ByteString.Strict.Lens Data.Complex.Lens Data.Data.Lens
    Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
    Data.Map.Lens Data.Sequence.Lens Data.Set.Lens Data.Text.Lazy.Lens
    Data.Text.Lens Data.Text.Strict.Lens Data.Tree.Lens
    Data.Typeable.Lens Data.Vector.Generic.Lens Data.Vector.Lens
    GHC.Generics.Lens Language.Haskell.TH.Lens Numeric.Lens
    System.Exit.Lens System.FilePath.Lens System.IO.Error.Lens
hidden-modules: Paths_lens
abi: 98054c78cdcb2d28679c87bc5edc7863
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/lens-4.15.4
library-dirs: /usr/lib/ghc-8.2.2/site-local/lens-4.15.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/lens-4.15.4
hs-libraries: HSlens-4.15.4-6GPYoGX8D8oF6KL1aYwOV5
depends:
    array-0.5.2.0 base-4.10.1.0 base-orphans-0.6-KoJqNefbvUAEuaR7CDOiu4
    bifunctors-5.5-GboNfSLJ1zC9Dfov5rQDF7 bytestring-0.10.8.2
    call-stack-0.1.0-BVjoAlBRe9FCSr5eFfllei
    comonad-5.0.2-5FGZALTgAAwCV8EmXasfw1
    contravariant-1.4-7z11WOqE85DGeP9JdLBkE1 containers-0.5.10.2
    distributive-0.5.3-3QQWO3yfOScASLf5zUz2JE filepath-1.4.1.2
    free-4.12.4-EvilIhNJNIrF3m3AD1vhvE ghc-prim-0.5.1.1
    hashable-1.2.6.1-9ZXmUmZR8Ja1wkFjzrwxTy
    kan-extensions-5.0.2-JE6QaPvhmgmFmHi1mDoNJD
    exceptions-0.8.3-KXvLXRbxEkO6vroqtRG1UV
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    parallel-3.2.1.1-6PIhrl6oqe7Af1Z2sa6T1
    profunctors-5.2.1-3RBMRXw3iASK8u62NP30RE
    reflection-2.1.2-C2CXGjPrlDWEm9x409Gv1U
    semigroupoids-5.2.1-79jkPalWVyGb7DjZeFx7j
    semigroups-0.18.3-3aCIuYG4ID286XaN6MuQu7
    tagged-0.8.5-BP06XmR1GLaIsvsOKwGst2 template-haskell-2.12.0.0
    th-abstraction-0.2.6.0-KdJUlqAwMfUIgxZVMgLLVd
    text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj transformers-0.5.2.0
    transformers-compat-0.5.1.4-EAh8Ccrgitz4vTZtbTPyCM
    unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV
    vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
    void-0.7.2-FiGeS4PZxPp8gUDrtvjFKC
abi-depends: array-0.5.2.0=567646df31883e5d21d17233cc6e3caf
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             base-orphans-0.6-KoJqNefbvUAEuaR7CDOiu4=fb09ffe63c021a5df200f5dd3f288699
             bifunctors-5.5-GboNfSLJ1zC9Dfov5rQDF7=a23bc8cb341fa6d1c849977cfff3c9c1
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             call-stack-0.1.0-BVjoAlBRe9FCSr5eFfllei=80879ea65722c5998aff02ea5d901642
             comonad-5.0.2-5FGZALTgAAwCV8EmXasfw1=c9494ddd8dca169177efbeae2d54ce78
             contravariant-1.4-7z11WOqE85DGeP9JdLBkE1=229249a7c431fe44ea9abf1ace1931a4
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             distributive-0.5.3-3QQWO3yfOScASLf5zUz2JE=4194008627baa63a29bcee90329e8d22
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             free-4.12.4-EvilIhNJNIrF3m3AD1vhvE=b07920c1bd11c802a9b2585b80624e55
             ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
             hashable-1.2.6.1-9ZXmUmZR8Ja1wkFjzrwxTy=6e4b4a70e10d525b7db51e3859aab169
             kan-extensions-5.0.2-JE6QaPvhmgmFmHi1mDoNJD=f5530919a2f14d758ed123e24c52508a
             exceptions-0.8.3-KXvLXRbxEkO6vroqtRG1UV=488626f806840161fa9e32c70677324e
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             parallel-3.2.1.1-6PIhrl6oqe7Af1Z2sa6T1=f329a0732f0d1ccfb717a7145bfd3a72
             profunctors-5.2.1-3RBMRXw3iASK8u62NP30RE=86070f5ceec2c3bf4486b37130d22ceb
             reflection-2.1.2-C2CXGjPrlDWEm9x409Gv1U=660955b15b9b2e723ad9368b50863425
             semigroupoids-5.2.1-79jkPalWVyGb7DjZeFx7j=c9b55a6a191c77fd98bceba152e5fa5d
             semigroups-0.18.3-3aCIuYG4ID286XaN6MuQu7=d64b81e3ed8022aca04423ee7b330679
             tagged-0.8.5-BP06XmR1GLaIsvsOKwGst2=b5d07becd47ba21e20b584b61ad0f06d
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             th-abstraction-0.2.6.0-KdJUlqAwMfUIgxZVMgLLVd=10ae769acb289f778901fba63fa6dabb
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             transformers-compat-0.5.1.4-EAh8Ccrgitz4vTZtbTPyCM=506de314acc216de1ce76634db1785eb
             unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV=db9131d5548eea6d7a3eab9f0d172004
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=d8375a46a4155c3f449ce3d319b3dbaa
             void-0.7.2-FiGeS4PZxPp8gUDrtvjFKC=a5672067c7a1184b41916f0fb2d0c330
haddock-interfaces: /usr/share/doc/haskell-lens/html/lens.haddock
haddock-html: /usr/share/doc/haskell-lens/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

