#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: sbv
version: 7.4
id: sbv-7.4-IA2xJcTM3O1KFsJBlFagN6
key: sbv-7.4-IA2xJcTM3O1KFsJBlFagN6
license: BSD3
copyright: Levent Erkok, 2010-2017
maintainer: Levent Erkok (erkokl@gmail.com)
stability: Experimental
homepage: http://leventerkok.github.com/sbv/
synopsis: SMT Based Verification: Symbolic Haskell theorem prover using SMT solving.
description:
    Express properties about Haskell programs and automatically prove them using SMT
    (Satisfiability Modulo Theories) solvers.
    .
    For details, please see: <http://leventerkok.github.com/sbv/>
category: Formal Methods, Theorem Provers, Bit vectors, Symbolic Computation, Math, SMT
author: Levent Erkok
exposed: True
indefinite: False
exposed-modules:
    Data.SBV Data.SBV.Control Data.SBV.Dynamic
    Data.SBV.Examples.BitPrecise.BitTricks
    Data.SBV.Examples.BitPrecise.Legato
    Data.SBV.Examples.BitPrecise.MergeSort
    Data.SBV.Examples.BitPrecise.MultMask
    Data.SBV.Examples.BitPrecise.PrefixSum
    Data.SBV.Examples.CodeGeneration.AddSub
    Data.SBV.Examples.CodeGeneration.CRC_USB5
    Data.SBV.Examples.CodeGeneration.Fibonacci
    Data.SBV.Examples.CodeGeneration.GCD
    Data.SBV.Examples.CodeGeneration.PopulationCount
    Data.SBV.Examples.CodeGeneration.Uninterpreted
    Data.SBV.Examples.Crypto.AES Data.SBV.Examples.Crypto.RC4
    Data.SBV.Examples.Existentials.CRCPolynomial
    Data.SBV.Examples.Existentials.Diophantine
    Data.SBV.Examples.Misc.Auxiliary Data.SBV.Examples.Misc.Enumerate
    Data.SBV.Examples.Misc.Floating Data.SBV.Examples.Misc.ModelExtract
    Data.SBV.Examples.Misc.NoDiv0 Data.SBV.Examples.Misc.Word4
    Data.SBV.Examples.Optimization.ExtField
    Data.SBV.Examples.Optimization.LinearOpt
    Data.SBV.Examples.Optimization.Production
    Data.SBV.Examples.Optimization.VM
    Data.SBV.Examples.Polynomials.Polynomials
    Data.SBV.Examples.Puzzles.Birthday Data.SBV.Examples.Puzzles.Coins
    Data.SBV.Examples.Puzzles.Counts
    Data.SBV.Examples.Puzzles.DogCatMouse
    Data.SBV.Examples.Puzzles.Euler185 Data.SBV.Examples.Puzzles.Fish
    Data.SBV.Examples.Puzzles.MagicSquare
    Data.SBV.Examples.Puzzles.NQueens
    Data.SBV.Examples.Puzzles.SendMoreMoney
    Data.SBV.Examples.Puzzles.Sudoku Data.SBV.Examples.Puzzles.U2Bridge
    Data.SBV.Examples.Queries.AllSat
    Data.SBV.Examples.Queries.CaseSplit Data.SBV.Examples.Queries.Enums
    Data.SBV.Examples.Queries.FourFours
    Data.SBV.Examples.Queries.GuessNumber
    Data.SBV.Examples.Queries.Interpolants
    Data.SBV.Examples.Queries.UnsatCore
    Data.SBV.Examples.Uninterpreted.AUF
    Data.SBV.Examples.Uninterpreted.Deduce
    Data.SBV.Examples.Uninterpreted.Function
    Data.SBV.Examples.Uninterpreted.Shannon
    Data.SBV.Examples.Uninterpreted.Sort
    Data.SBV.Examples.Uninterpreted.UISortAllSat Data.SBV.Internals
    Data.SBV.Tools.CodeGen Data.SBV.Tools.GenTest
    Data.SBV.Tools.Polynomial Data.SBV.Tools.STree
hidden-modules: Data.SBV.Core.AlgReals Data.SBV.Core.Concrete
                Data.SBV.Core.Data Data.SBV.Core.Kind Data.SBV.Core.Model
                Data.SBV.Core.Operations Data.SBV.Core.Floating
                Data.SBV.Core.Splittable Data.SBV.Core.Symbolic
                Data.SBV.Control.Query Data.SBV.Control.Types
                Data.SBV.Control.Utils Data.SBV.Compilers.C
                Data.SBV.Compilers.CodeGen Data.SBV.SMT.SMT Data.SBV.SMT.SMTLib
                Data.SBV.SMT.SMTLib2 Data.SBV.SMT.SMTLibNames Data.SBV.SMT.Utils
                Data.SBV.Provers.Prover Data.SBV.Provers.Boolector
                Data.SBV.Provers.CVC4 Data.SBV.Provers.Yices Data.SBV.Provers.Z3
                Data.SBV.Provers.MathSAT Data.SBV.Provers.ABC
                Data.SBV.Utils.Boolean Data.SBV.Utils.Numeric Data.SBV.Utils.TDiff
                Data.SBV.Utils.Lib Data.SBV.Utils.PrettyNum Data.SBV.Utils.SExpr
abi: a81322beb6a070d046dbb016203a69d4
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/sbv-7.4
library-dirs: /usr/lib/ghc-8.2.2/site-local/sbv-7.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/sbv-7.4
hs-libraries: HSsbv-7.4-IA2xJcTM3O1KFsJBlFagN6
depends:
    base-4.10.1.0 ghc-8.2.2 QuickCheck-2.10.1-BUFYQzp5Pjm7JbQeTzW89l
    crackNum-1.9-7H66uQXt6RcCbHwaNTjpSB template-haskell-2.12.0.0
    array-0.5.2.0 async-2.1.1.1-K5IvYqkVegLI7CBS6i3gtn
    containers-0.5.10.2 deepseq-1.4.3.0 directory-1.3.0.2
    filepath-1.4.1.2 time-1.8.0.2 pretty-1.1.3.3 process-1.6.1.0
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    syb-0.7-3Lq8MQxmYP07qktjI1jxu0
    data-binary-ieee754-0.4.4-F3YRhJd3kvlDf64vOl9RIA
    generic-deriving-1.12-8a2PXMbzwwpF63bxm1epxM
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             ghc-8.2.2=a5b8ae61d881d53b10e55af3743c7814
             QuickCheck-2.10.1-BUFYQzp5Pjm7JbQeTzW89l=a871331a7e5e7b5c37818b7997512ddd
             crackNum-1.9-7H66uQXt6RcCbHwaNTjpSB=b58b6e5f822d6a40b90227260e4f1849
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             array-0.5.2.0=567646df31883e5d21d17233cc6e3caf
             async-2.1.1.1-K5IvYqkVegLI7CBS6i3gtn=7d406f0044aa7af43d5b6fcf63e521db
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             pretty-1.1.3.3=229bcf5342145ac1755207fe83d29780
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             syb-0.7-3Lq8MQxmYP07qktjI1jxu0=f985ea42a9fa578e0f67572a93e19b5d
             data-binary-ieee754-0.4.4-F3YRhJd3kvlDf64vOl9RIA=7856b51c260098a50a024313d29e5883
             generic-deriving-1.12-8a2PXMbzwwpF63bxm1epxM=30f6f75ad134f2e05d57b048fc1877aa
haddock-interfaces: /usr/share/doc/haskell-sbv/html/sbv.haddock
haddock-html: /usr/share/doc/haskell-sbv/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

