#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tls
version: 1.4.0
id: tls-1.4.0-8ilYbcaiDRn7dAdlRweyZE
key: tls-1.4.0-8ilYbcaiDRn7dAdlRweyZE
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
synopsis: TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.
    .
    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.
    .
    Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.
    .
    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Extra Network.TLS.Extra.Cipher Network.TLS.Extra.FFDHE
    Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.Core
                Network.TLS.Context Network.TLS.Context.Internal
                Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
                Network.TLS.Crypto.DH Network.TLS.Crypto.IES
                Network.TLS.Crypto.Types Network.TLS.ErrT Network.TLS.Extension
                Network.TLS.Handshake Network.TLS.Handshake.Common
                Network.TLS.Handshake.Certificate Network.TLS.Handshake.Key
                Network.TLS.Handshake.Client Network.TLS.Handshake.Server
                Network.TLS.Handshake.Process Network.TLS.Handshake.Signature
                Network.TLS.Handshake.State Network.TLS.Hooks Network.TLS.IO
                Network.TLS.Imports Network.TLS.MAC Network.TLS.Measurement
                Network.TLS.Packet Network.TLS.Parameters Network.TLS.Record
                Network.TLS.Record.Types Network.TLS.Record.Engage
                Network.TLS.Record.Disengage Network.TLS.Record.State
                Network.TLS.RNG Network.TLS.State Network.TLS.Session
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Util.ASN1 Network.TLS.Util.Serialization
                Network.TLS.Types Network.TLS.Wire Network.TLS.X509
abi: 56f6839975e85c8b4ea9c9b3159d9710
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/tls-1.4.0
library-dirs: /usr/lib/ghc-8.2.2/site-local/tls-1.4.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/tls-1.4.0
hs-libraries: HStls-1.4.0-8ilYbcaiDRn7dAdlRweyZE
depends:
    base-4.10.1.0 mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH transformers-0.5.2.0
    cereal-0.5.4.0-HHG4trmDAey7tG5Rc3nyML bytestring-0.10.8.2
    data-default-class-0.1.2.0-ImBMrJK18PFLLtssITDnZ5
    memory-0.14.10-LwCYa6TFutlHfUbiGZd8KU
    cryptonite-0.24-3CGZ8QvILTqyKruD8P6KS
    asn1-types-0.3.2-1XxafSVRKapAPXlhM3qwMJ
    asn1-encoding-0.9.5-ErqvEafjeg8JJbCrRkDHpH
    x509-1.7.2-CcYBYJ1XerO95lXCpmxLJ0
    x509-store-1.6.5-JZJnX92mKHi93GDFGT5xfw
    x509-validation-1.6.9-7FuhXBAtC8FJjBnHhr8ZvR
    async-2.1.1.1-K5IvYqkVegLI7CBS6i3gtn
    network-2.6.3.2-Elf6Dxkfz0iKjb1zv5eBTP
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             cereal-0.5.4.0-HHG4trmDAey7tG5Rc3nyML=ed459ea038cbdb253abe2c011f65c556
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             data-default-class-0.1.2.0-ImBMrJK18PFLLtssITDnZ5=59d0190781dd74e9cf2161eb5998f2f1
             memory-0.14.10-LwCYa6TFutlHfUbiGZd8KU=ab92cc9732ca92f3c7dffc63e7dfa885
             cryptonite-0.24-3CGZ8QvILTqyKruD8P6KS=95b6b8339e4775b78724cd4e849ec62f
             asn1-types-0.3.2-1XxafSVRKapAPXlhM3qwMJ=2bf8dfd4818cb062fad6d87c298e41fd
             asn1-encoding-0.9.5-ErqvEafjeg8JJbCrRkDHpH=d5d249f0ad2874660fed0d6a35a70ed5
             x509-1.7.2-CcYBYJ1XerO95lXCpmxLJ0=5e3623d9c32cc1e7533bf744e7d93533
             x509-store-1.6.5-JZJnX92mKHi93GDFGT5xfw=a271aafd14da65e292394ad58bf9a7ca
             x509-validation-1.6.9-7FuhXBAtC8FJjBnHhr8ZvR=60e24258ef26376e00b5a1294486e631
             async-2.1.1.1-K5IvYqkVegLI7CBS6i3gtn=7d406f0044aa7af43d5b6fcf63e521db
             network-2.6.3.2-Elf6Dxkfz0iKjb1zv5eBTP=a333d9df3290e5924c2ef4f5f4b24781
haddock-interfaces: /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html: /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

