/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.search;

import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.codegen.CodeWriter;
import jadx.gui.treemodel.CodeNode;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.CodeLinesInfo;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.search.CodeIndex;
import jadx.gui.utils.search.SearchIndex;
import jadx.gui.utils.search.SimpleIndex;
import jadx.gui.utils.search.StringRef;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextSearchIndex {
    private static final Logger LOG = LoggerFactory.getLogger(TextSearchIndex.class);
    private final JNodeCache nodeCache;
    private SearchIndex<JNode> clsNamesIndex;
    private SearchIndex<JNode> mthNamesIndex;
    private SearchIndex<JNode> fldNamesIndex;
    private SearchIndex<CodeNode> codeIndex;
    private List<JavaClass> skippedClasses = new ArrayList<JavaClass>();

    public TextSearchIndex(JNodeCache nodeCache) {
        this.nodeCache = nodeCache;
        this.clsNamesIndex = new SimpleIndex<JNode>();
        this.mthNamesIndex = new SimpleIndex<JNode>();
        this.fldNamesIndex = new SimpleIndex<JNode>();
        this.codeIndex = new CodeIndex<CodeNode>();
    }

    public void indexNames(JavaClass cls) {
        this.clsNamesIndex.put(cls.getFullName(), this.nodeCache.makeFrom((JavaNode)cls));
        for (JavaMethod mth : cls.getMethods()) {
            this.mthNamesIndex.put(mth.getFullName(), this.nodeCache.makeFrom((JavaNode)mth));
        }
        for (JavaField fld : cls.getFields()) {
            this.fldNamesIndex.put(fld.getFullName(), this.nodeCache.makeFrom((JavaNode)fld));
        }
        for (JavaClass innerCls : cls.getInnerClasses()) {
            this.indexNames(innerCls);
        }
    }

    public void indexCode(JavaClass cls, CodeLinesInfo linesInfo, List<StringRef> lines) {
        try {
            boolean strRefSupported = this.codeIndex.isStringRefSupported();
            int count = lines.size();
            for (int i = 0; i < count; ++i) {
                StringRef line = lines.get(i);
                if (line.length() == 0 || line.charAt(0) == '}') continue;
                int lineNum = i + 1;
                JavaNode node = linesInfo.getJavaNodeByLine(lineNum);
                CodeNode codeNode = new CodeNode(this.nodeCache.makeFrom((JavaNode)(node == null ? cls : node)), lineNum, line);
                if (strRefSupported) {
                    this.codeIndex.put(line, codeNode);
                    continue;
                }
                this.codeIndex.put(line.toString(), codeNode);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to index class: {}", (Object)cls, (Object)e);
        }
    }

    public List<JNode> searchClsName(String text) {
        return this.clsNamesIndex.getValuesForKeysContaining(text);
    }

    public List<JNode> searchMthName(String text) {
        return this.mthNamesIndex.getValuesForKeysContaining(text);
    }

    public List<JNode> searchFldName(String text) {
        return this.fldNamesIndex.getValuesForKeysContaining(text);
    }

    public List<CodeNode> searchCode(String text) {
        ArrayList<CodeNode> items;
        if (this.codeIndex.size() > 0) {
            items = this.codeIndex.getValuesForKeysContaining(text);
            if (this.skippedClasses.isEmpty()) {
                return items;
            }
        } else {
            items = new ArrayList();
        }
        this.addSkippedClasses(items, text);
        return items;
    }

    private void addSkippedClasses(List<CodeNode> list, String text) {
        for (JavaClass javaClass : this.skippedClasses) {
            String code = javaClass.getCode();
            int pos = 0;
            while (pos != -1) {
                pos = this.searchNext(list, text, (JavaNode)javaClass, code, pos);
            }
            if (list.size() <= 100) continue;
            return;
        }
    }

    private int searchNext(List<CodeNode> list, String text, JavaNode javaClass, String code, int startPos) {
        int pos = code.indexOf(text, startPos);
        if (pos == -1) {
            return -1;
        }
        int lineStart = 1 + code.lastIndexOf(CodeWriter.NL, pos);
        int lineEnd = code.indexOf(CodeWriter.NL, pos + text.length());
        StringRef line = StringRef.subString(code, lineStart, lineEnd == -1 ? code.length() : lineEnd);
        list.add(new CodeNode(this.nodeCache.makeFrom(javaClass), -pos, line.trim()));
        return lineEnd;
    }

    public void classCodeIndexSkipped(JavaClass cls) {
        this.skippedClasses.add(cls);
    }

    public List<JavaClass> getSkippedClasses() {
        return this.skippedClasses;
    }

    public int getSkippedCount() {
        return this.skippedClasses.size();
    }
}

