/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes.parser;

import com.android.dex.Dex;
import jadx.core.dex.attributes.nodes.SourceFileAttr;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.parser.LocalVar;
import jadx.core.utils.exceptions.DecodeException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugInfoParser {
    private static final Logger LOG = LoggerFactory.getLogger(DebugInfoParser.class);
    private static final int DBG_END_SEQUENCE = 0;
    private static final int DBG_ADVANCE_PC = 1;
    private static final int DBG_ADVANCE_LINE = 2;
    private static final int DBG_START_LOCAL = 3;
    private static final int DBG_START_LOCAL_EXTENDED = 4;
    private static final int DBG_END_LOCAL = 5;
    private static final int DBG_RESTART_LOCAL = 6;
    private static final int DBG_SET_PROLOGUE_END = 7;
    private static final int DBG_SET_EPILOGUE_BEGIN = 8;
    private static final int DBG_SET_FILE = 9;
    private static final int DBG_FIRST_SPECIAL = 10;
    private static final int DBG_LINE_BASE = -4;
    private static final int DBG_LINE_RANGE = 15;
    private final MethodNode mth;
    private final Dex.Section section;
    private final DexNode dex;
    private final LocalVar[] locals;
    private final InsnArg[] activeRegisters;
    private final InsnNode[] insnByOffset;

    public DebugInfoParser(MethodNode mth, int debugOffset, InsnNode[] insnByOffset) {
        this.mth = mth;
        this.dex = mth.dex();
        this.section = this.dex.openSection(debugOffset);
        int regsCount = mth.getRegsCount();
        this.locals = new LocalVar[regsCount];
        this.activeRegisters = new InsnArg[regsCount];
        this.insnByOffset = insnByOffset;
    }

    public void process() throws DecodeException {
        int addr = 0;
        int line = this.section.readUleb128();
        int paramsCount = this.section.readUleb128();
        List<RegisterArg> mthArgs = this.mth.getArguments(false);
        for (int i = 0; i < paramsCount; ++i) {
            int id = this.section.readUleb128() - 1;
            if (id == -1) continue;
            String name = this.dex.getString(id);
            if (i >= mthArgs.size()) continue;
            mthArgs.get(i).setName(name);
        }
        for (RegisterArg arg : mthArgs) {
            int rn = arg.getRegNum();
            this.locals[rn] = new LocalVar(arg);
            this.activeRegisters[rn] = arg;
        }
        this.addrChange(-1, 1, line);
        this.setLine(addr, line);
        int c = this.section.readByte() & 0xFF;
        while (c != 0) {
            switch (c) {
                case 1: {
                    int addrInc = this.section.readUleb128();
                    addr = this.addrChange(addr, addrInc, line);
                    this.setLine(addr, line);
                    break;
                }
                case 2: {
                    line += this.section.readSleb128();
                    break;
                }
                case 3: {
                    int regNum = this.section.readUleb128();
                    int nameId = this.section.readUleb128() - 1;
                    int type = this.section.readUleb128() - 1;
                    LocalVar var = new LocalVar(this.dex, regNum, nameId, type, -1);
                    this.startVar(var, addr, line);
                    break;
                }
                case 4: {
                    int regNum = this.section.readUleb128();
                    int nameId = this.section.readUleb128() - 1;
                    int type = this.section.readUleb128() - 1;
                    int sign = this.section.readUleb128() - 1;
                    LocalVar var = new LocalVar(this.dex, regNum, nameId, type, sign);
                    this.startVar(var, addr, line);
                    break;
                }
                case 6: {
                    int regNum = this.section.readUleb128();
                    LocalVar var = this.locals[regNum];
                    if (var == null) break;
                    if (var.end(addr, line)) {
                        this.setVar(var);
                    }
                    var.start(addr, line);
                    break;
                }
                case 5: {
                    int regNum = this.section.readUleb128();
                    LocalVar var = this.locals[regNum];
                    if (var == null) break;
                    var.end(addr, line);
                    this.setVar(var);
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    int idx = this.section.readUleb128() - 1;
                    if (idx == -1) break;
                    String sourceFile = this.dex.getString(idx);
                    this.mth.addAttr(new SourceFileAttr(sourceFile));
                    break;
                }
                default: {
                    if (c >= 10) {
                        int adjustedOpcode = c - 10;
                        int addrInc = adjustedOpcode / 15;
                        addr = this.addrChange(addr, addrInc, line);
                        this.setLine(addr, line += -4 + adjustedOpcode % 15);
                        break;
                    }
                    throw new DecodeException("Unknown debug insn code: " + c);
                }
            }
            c = this.section.readByte() & 0xFF;
        }
        for (LocalVar var : this.locals) {
            if (var == null || var.isEnd()) continue;
            var.end(this.mth.getCodeSize() - 1, line);
            this.setVar(var);
        }
        this.setSourceLines(addr, this.insnByOffset.length, line);
    }

    private int addrChange(int addr, int addrInc, int line) {
        int newAddr = addr + addrInc;
        int maxAddr = this.insnByOffset.length - 1;
        newAddr = Math.min(newAddr, maxAddr);
        for (int i = addr + 1; i <= newAddr; ++i) {
            InsnNode insn = this.insnByOffset[i];
            if (insn == null) continue;
            for (InsnArg arg : insn.getArguments()) {
                if (!arg.isRegister()) continue;
                this.activeRegisters[((RegisterArg)arg).getRegNum()] = arg;
            }
            RegisterArg res = insn.getResult();
            if (res == null) continue;
            this.activeRegisters[res.getRegNum()] = res;
        }
        this.setSourceLines(addr, newAddr, line);
        return newAddr;
    }

    private void setSourceLines(int start, int end, int line) {
        for (int offset = start + 1; offset < end; ++offset) {
            this.setLine(offset, line);
        }
    }

    private void setLine(int offset, int line) {
        InsnNode insn = this.insnByOffset[offset];
        if (insn != null) {
            insn.setSourceLine(line);
        }
    }

    private void startVar(LocalVar var, int addr, int line) {
        InsnNode parentInsn;
        SSAVar ssaVar;
        InsnArg activeReg;
        int regNum = var.getRegNum();
        LocalVar prev = this.locals[regNum];
        if (prev != null && !prev.isEnd()) {
            prev.end(addr, line);
            this.setVar(prev);
        }
        if ((activeReg = this.activeRegisters[var.getRegNum()]) instanceof RegisterArg && (ssaVar = ((RegisterArg)activeReg).getSVar()) != null && ssaVar.getStartAddr() != -1 && (parentInsn = ssaVar.getAssign().getParentInsn()) != null && parentInsn.getOffset() >= 0) {
            addr = parentInsn.getOffset();
        }
        var.start(addr, line);
        this.locals[regNum] = var;
    }

    private void setVar(LocalVar var) {
        int start = var.getStartAddr();
        int end = var.getEndAddr();
        for (int i = start; i <= end; ++i) {
            InsnNode insn = this.insnByOffset[i];
            if (insn == null) continue;
            DebugInfoParser.fillLocals(insn, var);
        }
        DebugInfoParser.merge(this.activeRegisters[var.getRegNum()], var);
    }

    private static void fillLocals(InsnNode insn, LocalVar var) {
        DebugInfoParser.merge(insn.getResult(), var);
        for (InsnArg arg : insn.getArguments()) {
            DebugInfoParser.merge(arg, var);
        }
    }

    private static void merge(InsnArg arg, LocalVar var) {
        if (arg == null || !arg.isRegister()) {
            return;
        }
        RegisterArg reg = (RegisterArg)arg;
        if (var.getRegNum() != reg.getRegNum()) {
            return;
        }
        boolean mergeRequired = false;
        SSAVar ssaVar = reg.getSVar();
        if (ssaVar != null) {
            boolean isIntersected;
            int ssaEnd = ssaVar.getEndAddr();
            int ssaStart = ssaVar.getStartAddr();
            int localStart = var.getStartAddr();
            int localEnd = var.getEndAddr();
            boolean bl = isIntersected = localEnd >= ssaStart && ssaEnd >= localStart;
            if (isIntersected && ssaEnd <= localEnd) {
                mergeRequired = true;
            }
        } else {
            mergeRequired = true;
        }
        if (mergeRequired) {
            reg.mergeDebugInfo(var.getType(), var.getName());
        }
    }
}

