/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.script.SV;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class MMCifValidationParser {
    private boolean asResidues;
    private AtomSetCollectionReader reader;
    private Map<String, int[]> resMap;
    private Map<String, Integer> atomMap;

    public MMCifValidationParser set(AtomSetCollectionReader reader) {
        this.reader = reader;
        this.asResidues = reader.checkFilterKey("ASRES");
        return this;
    }

    public String finalizeValidations(Viewer vwr, Map<String, Integer> modelMap) {
        Map map = (Map)this.reader.dssr;
        if (map != null) {
            return vwr.getAnnotationParser(true).fixDSSRJSONMap(map);
        }
        this.mapAtomResIDs(modelMap);
        SV svMap = (SV)this.reader.validation;
        Lst<Object> retProps = this.reader.vwr.getAnnotationParser(false).catalogValidations(this.reader.vwr, svMap, this.getModelAtomIndices(), this.resMap, this.asResidues ? null : this.atomMap, modelMap);
        String note = retProps == null || retProps.size() == 0 ? null : this.setProperties(retProps);
        svMap.mapPut("_note", SV.newS(note));
        return note;
    }

    public String finalizeRna3d(Map<String, Integer> modelMap) {
        this.mapAtomResIDs(modelMap);
        SV svMap = this.getRna3dMap(this.reader.addedData);
        String note = this.reader.vwr.getAnnotationParser(false).catalogStructureUnits(this.reader.vwr, svMap, this.getModelAtomIndices(), this.resMap, null, modelMap);
        svMap.mapPut("_note", SV.newS(note));
        int i = this.reader.asc.atomSetCount;
        while (--i >= 0) {
            Map<String, Object> info = this.reader.asc.getAtomSetAuxiliaryInfo(i);
            info.put("rna3d", svMap);
        }
        return note;
    }

    private SV getRna3dMap(String addedData) {
        Hashtable map = new Hashtable();
        int[] next = new int[1];
        String id = "";
        block5: while ((id = PT.getQuotedStringNext(addedData, next)).length() > 0) {
            String units = PT.getQuotedStringNext(addedData, next);
            String type = "?";
            switch (id.charAt(0)) {
                case 'H': {
                    type = "hairpinLoops";
                    break;
                }
                case 'I': {
                    type = "internalLoops";
                    break;
                }
                case 'J': {
                    type = "junctions";
                    break;
                }
                default: {
                    Logger.error("MMCif could not read: " + id + " " + units);
                    continue block5;
                }
            }
            Lst<Hashtable<String, Object>> list = (Lst<Hashtable<String, Object>>)map.get(type);
            if (list == null) {
                list = new Lst<Hashtable<String, Object>>();
                map.put(type, list);
            }
            Hashtable<String, Object> m = new Hashtable<String, Object>();
            m.put("index", PT.parseInt(id.substring(id.lastIndexOf("_") + 1)));
            m.put("units", units);
            list.addLast(m);
        }
        return SV.getVariableMap(map);
    }

    private void mapAtomResIDs(Map<String, Integer> modelMap) {
        Atom[] atoms = this.reader.asc.atoms;
        this.resMap = new Hashtable<String, int[]>();
        this.atomMap = new Hashtable<String, Integer>();
        int iresLast = -1;
        int[] resLast = null;
        String smodel = "" + modelMap.get("_0");
        int model = 1;
        int i0 = 0;
        int n = this.reader.asc.getAtomSetAtomCount(0);
        for (int i = 0; i < n; ++i) {
            Atom a = atoms[i];
            int ires = a.sequenceNumber;
            String res = smodel + "_" + a.chainID + "_" + ires + "_" + (a.insertionCode == '\u0000' ? "" : "" + a.insertionCode);
            String atom = res + "_" + a.atomName.toUpperCase() + "_" + (a.altLoc == '\u0000' ? "" : "" + Character.toLowerCase(a.altLoc));
            Integer ia = i - i0;
            if (ires != iresLast) {
                iresLast = ires;
                if (resLast != null) {
                    resLast[1] = i - i0;
                }
                resLast = new int[]{i - i0, n};
                this.resMap.put(res, resLast);
            }
            this.atomMap.put(atom, ia);
            if (i != n - 1) continue;
            i0 += n;
            n = this.reader.asc.getAtomSetAtomCount(model++);
        }
    }

    private int[] getModelAtomIndices() {
        int[] indices = new int[this.reader.asc.atomSetCount + 1];
        int m = indices.length - 1;
        while (--m >= 0) {
            indices[m] = this.reader.baseAtomIndex + this.reader.asc.getAtomSetAtomIndex(m);
        }
        indices[indices.length - 1] = this.reader.asc.ac;
        return indices;
    }

    private String setProperties(Lst<Object> propList) {
        String note = "Validations loaded:";
        int i = 0;
        int n = propList.size();
        while (i < n) {
            String key = (String)propList.get(i++);
            float[] f = (float[])propList.get(i++);
            int model = (Integer)propList.get(i++);
            boolean isGroup = (Boolean)propList.get(i++);
            int count = 0;
            float max = 0.0f;
            int reslast = -1;
            int i0 = this.reader.asc.getAtomSetAtomIndex(model);
            int j = f.length;
            while (--j >= 0) {
                if (f[j] == 0.0f) continue;
                if (isGroup) {
                    int res = this.reader.asc.atoms[i0 + j].sequenceNumber;
                    if (res != reslast) {
                        reslast = res;
                        ++count;
                    }
                } else {
                    ++count;
                }
                max = Math.max(f[j], max);
            }
            note = note + "\n  property_" + key + " (" + (isGroup ? "residues: " : "atoms: ") + count + (max == 1.0f ? "" : ", max: " + (float)((int)(max * 100.0f)) / 100.0f) + ")";
            this.reader.asc.setAtomProperties(key, f, model, isGroup);
        }
        return note;
    }
}

