/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.Geometry;

public final class SelectByInternalPointAction {
    private SelectByInternalPointAction() {
    }

    public static Collection<OsmPrimitive> getSurroundingObjects(EastNorth internalPoint) {
        return SelectByInternalPointAction.getSurroundingObjects(MainApplication.getLayerManager().getEditDataSet(), internalPoint, false);
    }

    public static Collection<OsmPrimitive> getSurroundingObjects(DataSet ds, EastNorth internalPoint, boolean includeMultipolygonWays) {
        if (ds == null) {
            return Collections.emptySet();
        }
        Node n = new Node(internalPoint);
        TreeMap<Double, OsmPrimitive> found = new TreeMap<Double, OsmPrimitive>();
        for (Way w : ds.getWays()) {
            if (!w.isUsable() || !w.isClosed() || !w.isSelectable() || !Geometry.nodeInsidePolygon(n, w.getNodes())) continue;
            found.put(Geometry.closedWayArea(w), w);
        }
        Projection projection = MainApplication.getMap().mapView.getProjection();
        for (Relation r : ds.getRelations()) {
            if (!r.isUsable() || !r.isMultipolygon() || !r.isSelectable() || !Geometry.isNodeInsideMultiPolygon(n, r, null)) continue;
            if (!includeMultipolygonWays) {
                for (RelationMember m : r.getMembers()) {
                    if (!m.isWay() || !m.getWay().isClosed()) continue;
                    found.values().remove(m.getWay());
                }
            }
            BBox bBox = r.getBBox();
            EastNorth en1 = projection.latlon2eastNorth(bBox.getTopLeft());
            EastNorth en2 = projection.latlon2eastNorth(bBox.getBottomRight());
            double s = Math.abs((en1.east() - en2.east()) * (en1.north() - en2.north()));
            found.put(s <= 0.0 ? 1.0E8 : s, r);
        }
        return found.values();
    }

    public static OsmPrimitive getSmallestSurroundingObject(EastNorth internalPoint) {
        Collection<OsmPrimitive> surroundingObjects = SelectByInternalPointAction.getSurroundingObjects(internalPoint);
        return surroundingObjects.isEmpty() ? null : surroundingObjects.iterator().next();
    }

    public static void performSelection(EastNorth internalPoint, boolean doAdd, boolean doRemove) {
        Collection<OsmPrimitive> surroundingObjects = SelectByInternalPointAction.getSurroundingObjects(internalPoint);
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (surroundingObjects.isEmpty()) {
            return;
        }
        if (doRemove) {
            ArrayList<OsmPrimitive> newSelection = new ArrayList<OsmPrimitive>(ds.getSelected());
            newSelection.removeAll(surroundingObjects);
            ds.setSelected(newSelection);
        } else if (doAdd) {
            ArrayList<OsmPrimitive> newSelection = new ArrayList<OsmPrimitive>(ds.getSelected());
            newSelection.add(surroundingObjects.iterator().next());
            ds.setSelected(newSelection);
        } else {
            ds.setSelected(surroundingObjects.iterator().next());
        }
    }
}

